/*
 * Decompiled with CFR 0.152.
 */
package com.onpositive.richtexteditor.model.partitions;

import com.onpositive.richtexteditor.model.partitions.Change;
import com.onpositive.richtexteditor.model.partitions.ILineAttributeModel;
import com.onpositive.richtexteditor.model.partitions.PartitionDelta;
import com.onpositive.richtexteditor.model.partitions.SetAlignChange;

public class SetBulletChange
extends Change {
    private Object bullet;
    private int line;
    private int count;

    public SetBulletChange(int line, int count, Object bullet) {
        this.bullet = bullet;
        this.count = count;
        this.line = line;
    }

    protected int defineSumAlignStyle(ILineAttributeModel editor, int startLineNum, int endLineNum) {
        int align = editor.getLineAlign(startLineNum);
        return align;
    }

    @Override
    protected void apply(PartitionDelta delta) {
        int firstLineNum = this.line;
        int lastLineNum = this.line + this.count;
        final ILineAttributeModel lineAttributeModel = delta.getStorage().getLineAttributeModel();
        int defineSumAlignStyle = this.defineSumAlignStyle(lineAttributeModel, firstLineNum, lastLineNum);
        if (defineSumAlignStyle != 16384 && defineSumAlignStyle != 4) {
            new SetAlignChange(this.line, this.count, 16384).apply(delta);
        }
        final Object[] bullets = new Object[this.count];
        int a = this.line;
        while (a < this.line + this.count) {
            bullets[a - this.line] = lineAttributeModel.getBullet(a);
            ++a;
        }
        lineAttributeModel.setLineBullet(this.line, this.count, null);
        lineAttributeModel.setLineBullet(this.line, this.count, this.bullet);
        delta.getUndoChange().add(new Change(){

            @Override
            protected void apply(PartitionDelta delta) {
                lineAttributeModel.setLineBullet(SetBulletChange.this.line, SetBulletChange.this.count, null);
                int a = 0;
                while (a < bullets.length) {
                    lineAttributeModel.setLineBullet(a + SetBulletChange.this.line, 0, bullets[a]);
                    ++a;
                }
                delta.getUndoChange().add(SetBulletChange.this);
            }
        });
    }
}

