/*
 * Decompiled with CFR 0.152.
 */
package com.onpositive.richtexteditor.model.partitions;

import com.onpositive.richtexteditor.model.BasePartitionLayer;
import com.onpositive.richtexteditor.model.LayerManager;
import com.onpositive.richtexteditor.model.partitions.CompositeEditorWrapper;
import com.onpositive.richtexteditor.model.partitions.IDisposablePartion;
import com.onpositive.richtexteditor.model.partitions.IRegionCompositeWrapper;
import com.onpositive.richtexteditor.model.partitions.ObjectPartition;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;

public class RegionPartition
extends ObjectPartition
implements IDisposablePartion {
    protected static final int MARGIN = 5;
    protected IRegionCompositeWrapper wrapper;

    public RegionPartition(BasePartitionLayer layer, int offset, int length, Composite widget) {
        super(layer, offset, length);
        this.wrapper = new CompositeEditorWrapper(widget);
    }

    public Composite getTopLevelObject() {
        return this.wrapper.getTopLevelObject();
    }

    @Override
    public Object getObject() {
        return this.wrapper.getMainObject();
    }

    @Override
    public void setObject(Object object) {
        throw new RuntimeException("setObject() should not be called for instances of " + this.getClass().getCanonicalName() + " class.");
    }

    @Override
    public StyleRange getStyleRange(LayerManager manager) {
        StyleRange style = new StyleRange();
        style.start = this.offset;
        style.length = 1;
        Rectangle rect = this.wrapper.getBounds();
        int ascent = 2 * rect.height / 3;
        int descent = rect.height - ascent;
        style.metrics = new GlyphMetrics(ascent + 5, descent + 5, rect.width + 10);
        return style;
    }

    public int getComponentHeight() {
        return this.wrapper.getHeight();
    }

    @Override
    public void dispose() {
        this.wrapper.dispose();
    }

    @Override
    public boolean requiresSingleLine() {
        return true;
    }

    public int getInitialHeight() {
        return this.wrapper.getInitialHeight();
    }

    public Point getSize() {
        return this.wrapper.getSize();
    }

    @Override
    public boolean requiresFullDeletion() {
        return true;
    }

    @Override
    public boolean allowsInnerTyping() {
        return false;
    }

    public IRegionCompositeWrapper getWrapper() {
        return this.wrapper;
    }

    public void setSize(int width, int height) {
        this.wrapper.setSize(width, height);
    }

    public void setLocation(int x, int y) {
        this.wrapper.setLocation(x, y);
    }
}

