/*
 * Decompiled with CFR 0.152.
 */
package com.onpositive.richtexteditor.model.partitions;

import com.onpositive.richtexteditor.model.FontStyle;
import com.onpositive.richtexteditor.model.IPartition;
import com.onpositive.richtexteditor.model.partitions.AddRemovePartitionChange;
import com.onpositive.richtexteditor.model.partitions.AdjustPartitionChange;
import com.onpositive.richtexteditor.model.partitions.BasePartition;
import com.onpositive.richtexteditor.model.partitions.Change;
import com.onpositive.richtexteditor.model.partitions.PartitionDelta;
import com.onpositive.richtexteditor.model.partitions.PartitionStorage;
import com.onpositive.richtexteditor.model.partitions.PartitionStyleChange;
import com.onpositive.richtexteditor.model.partitions.ShiftPartitionAtPositionChange;
import java.util.ArrayList;
import java.util.List;

public class CompositeChange
extends Change {
    private ArrayList<Change> parts = new ArrayList();
    private PartitionStorage storage;
    private int newSize;

    public void applyStyleTo(int offset, int length, FontStyle style) {
        List<IPartition> extractChangedRegion = this.extractChangedRegion(offset, length);
        for (IPartition p : extractChangedRegion) {
            PartitionStyleChange partitionStyleChange = new PartitionStyleChange((BasePartition)p, style, true);
            this.add(partitionStyleChange);
        }
    }

    public void applyStyleToPartition(BasePartition partition, FontStyle style) {
        PartitionStyleChange partitionStyleChange = new PartitionStyleChange(partition, style, true);
        this.add(partitionStyleChange);
    }

    public void setStyleOn(int offset, int length, FontStyle style) {
        List<IPartition> extractChangedRegion = this.extractChangedRegion(offset, length);
        for (IPartition p : extractChangedRegion) {
            PartitionStyleChange partitionStyleChange = new PartitionStyleChange((BasePartition)p, style, false);
            partitionStyleChange.setSet(true);
            this.add(partitionStyleChange);
        }
    }

    public void removeStyleFrom(int offset, int length, FontStyle style) {
        List<IPartition> extractChangedRegion = this.extractChangedRegion(offset, length);
        for (IPartition p : extractChangedRegion) {
            PartitionStyleChange partitionStyleChange = new PartitionStyleChange((BasePartition)p, style, false);
            this.add(partitionStyleChange);
        }
    }

    public void removePartitionsFromTo(int offset, int length) {
        CompositeChange change = this;
        int end = offset + length;
        for (BasePartition p : this.storage.getPartitions()) {
            int newLength;
            int plength;
            int poffset = p.getOffset();
            int pend = poffset + (plength = p.getLength());
            if (pend < offset) continue;
            if (poffset >= end) break;
            if (poffset >= offset && pend <= end) {
                this.remove(p);
                continue;
            }
            if (poffset < offset) {
                newLength = poffset - offset;
                if (pend < end) {
                    change.setLength(p, -newLength);
                    continue;
                }
                BasePartition newPartition = this.storage.newPartition(poffset, offset - poffset, p);
                BasePartition newPartition2 = this.storage.newPartition(end, pend - end, p);
                if (newPartition.getLength() > 0) {
                    change.addPartition(p.getPosition() - 1, newPartition);
                }
                if (newPartition2.getLength() > 0) {
                    change.addPartition(p.getPosition() + 1, newPartition2);
                }
                change.remove(p);
                continue;
            }
            if (pend <= end) continue;
            newLength = pend - end;
            change.adjustPartition(p, end, newLength);
        }
    }

    public List<IPartition> extractChangedRegion(int offset, int length) {
        CompositeChange change = this;
        int end = offset + length;
        ArrayList<IPartition> result = new ArrayList<IPartition>();
        int shift = 0;
        for (BasePartition p : this.storage.getPartitions()) {
            BasePartition newPartition;
            int newLength;
            int plength;
            int poffset = p.getOffset();
            int pend = poffset + (plength = p.getLength());
            if (pend < offset) continue;
            if (poffset >= end) break;
            if (poffset >= offset && pend <= end) {
                result.add(p);
                continue;
            }
            if (poffset < offset) {
                newLength = poffset - offset;
                if (newLength > 0) {
                    newPartition = this.storage.newPartition(offset, pend - offset, p);
                    change.addPartition(p.getPosition() + shift++, newPartition);
                    change.setLength(p, newLength);
                    result.add(newPartition);
                    continue;
                }
                if (pend < end) {
                    newPartition = this.storage.newPartition(offset, pend - offset, p);
                    if (newPartition.getLength() > 0) {
                        change.addPartition(p.getPosition() + shift++, newPartition);
                        result.add(newPartition);
                    }
                    change.setLength(p, -newLength);
                    continue;
                }
                newPartition = this.storage.newPartition(poffset, offset - poffset, p);
                BasePartition newPartition2 = this.storage.newPartition(end, pend - end, p);
                if (newPartition.getLength() > 0) {
                    change.addPartition(p.getPosition() - 1, newPartition);
                }
                if (newPartition2.getLength() > 0) {
                    change.addPartition(p.getPosition() + 1, newPartition2);
                }
                change.adjustPartition(p, offset, length);
                result.add(p);
                continue;
            }
            if (pend <= end) continue;
            newLength = pend - end;
            newPartition = this.storage.newPartition(poffset, end - poffset, p);
            if (newPartition.getLength() > 0) {
                change.addPartition(p.getPosition() - 1 + shift++, newPartition);
                result.add(newPartition);
            }
            change.adjustPartition(p, end, newLength);
        }
        return result;
    }

    public int getNewStorageSize() {
        return this.newSize;
    }

    public CompositeChange(PartitionStorage storage) {
        this.storage = storage;
        this.newSize = storage.size();
    }

    public void addMergeChange(int partitionIdx) {
        BasePartition cur = this.storage.get(partitionIdx);
        BasePartition next = this.storage.get(partitionIdx + 1);
        this.setLength(cur, cur.getLength() + next.getLength());
        this.remove(partitionIdx + 1);
    }

    public void setLength(BasePartition startPartition, int length) {
        this.adjustPartition(startPartition, startPartition.getOffset(), length);
    }

    public void shiftOffsets(int startIndex, int amount) {
        if (startIndex < this.storage.size()) {
            int i = startIndex;
            while (i < this.storage.size()) {
                this.adjustPartition(this.storage.get(i), this.storage.get(i).getOffset() + amount, this.storage.get(i).getLength());
                ++i;
            }
        }
    }

    protected BasePartition getNextPartititon(BasePartition partition) {
        int n = partition.getPosition();
        if (n < this.storage.size() - 1) {
            return this.storage.get(n + 1);
        }
        return null;
    }

    @Override
    protected void apply(PartitionDelta delta) {
        for (Change c : this.parts) {
            c.apply(delta);
        }
    }

    public void add(Change change) {
        this.parts.add(change);
    }

    public void addPartition(BasePartition partition) {
        this.addPartition(this.newSize - 1, partition);
    }

    public void remove(int i) {
        this.add(new AddRemovePartitionChange(i, this.storage.get(i), false));
        --this.newSize;
    }

    public void addPartition(int i, BasePartition startPartition) {
        this.add(new AddRemovePartitionChange(i + 1, startPartition, true));
        ++this.newSize;
    }

    public void addPartitionAtOffset(final BasePartition startPartition, final int offset) {
        this.add(new Change(){

            @Override
            protected void apply(PartitionDelta delta) {
                BasePartition partitionAtOffset = CompositeChange.this.storage.getPartitionAtOffset(startPartition.getOffset() - 1);
                if (partitionAtOffset != null && startPartition.offset != 0) {
                    int offset2 = partitionAtOffset.getPosition() + 1;
                    BasePartition rightPartition = null;
                    if (offset2 < CompositeChange.this.storage.size()) {
                        rightPartition = CompositeChange.this.storage.get(offset2);
                    }
                    new AddRemovePartitionChange(offset2, startPartition, true).apply(delta);
                    if (rightPartition != null && startPartition.getLength() + startPartition.getOffset() != rightPartition.getOffset()) {
                        new ShiftPartitionAtPositionChange(startPartition.getPosition() + 1, startPartition.getLength() - offset2).apply(delta);
                    }
                } else {
                    new AddRemovePartitionChange(0, startPartition, true).apply(delta);
                    new ShiftPartitionAtPositionChange(1, startPartition.getLength() - offset).apply(delta);
                }
            }

            public String toString() {
                return "Add&shift (inner class) " + startPartition + " at index " + offset;
            }
        });
        ++this.newSize;
    }

    public void adjustPartition(BasePartition partition, int offset, int length) {
        this.add(new AdjustPartitionChange(partition, offset, length));
    }

    public void applyAttributes(BasePartition newPartition, BasePartition curPartition) {
    }

    public List<Change> getParts() {
        return this.parts;
    }

    public void addAll(List<Change> parts) {
        this.parts.addAll(parts);
    }

    public PartitionStorage getStorage() {
        return this.storage;
    }

    public void remove(BasePartition part) {
        this.add(new AddRemovePartitionChange(part.getPosition(), part, false));
    }

    public void addAll(int i, List<Change> parts) {
        this.parts.addAll(i, parts);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Composite: {\n");
        int size = this.parts.size();
        int i = 0;
        while (i < size) {
            builder.append(this.parts.get(i) + "\n");
            ++i;
        }
        builder.append("}");
        return builder.toString();
    }
}

