/*
 * Decompiled with CFR 0.152.
 */
package com.onpositive.richtexteditor.model;

import com.onpositive.richtexteditor.io.TextSerializer;
import com.onpositive.richtexteditor.io.html.DefaultHTMLLoader;
import com.onpositive.richtexteditor.io.html.HTMLSerializer;
import com.onpositive.richtexteditor.io.html.IHTMLLoader;
import com.onpositive.richtexteditor.io.html.IHTMLLoaderFactory;
import com.onpositive.richtexteditor.io.html.IHTMLSerializerFactory;
import com.onpositive.richtexteditor.model.BasePartitionLayer;
import com.onpositive.richtexteditor.model.BulletFactory;
import com.onpositive.richtexteditor.model.FontStyle;
import com.onpositive.richtexteditor.model.FontStylesChangeListener;
import com.onpositive.richtexteditor.model.IPartition;
import com.onpositive.richtexteditor.model.IPartitionListener;
import com.onpositive.richtexteditor.model.ISimpleRichTextModel;
import com.onpositive.richtexteditor.model.LayerEvent;
import com.onpositive.richtexteditor.model.Logger;
import com.onpositive.richtexteditor.model.PartitionEvent;
import com.onpositive.richtexteditor.model.RichSelectionState;
import com.onpositive.richtexteditor.model.partitions.BasePartition;
import com.onpositive.richtexteditor.model.partitions.Change;
import com.onpositive.richtexteditor.model.partitions.HRPartition;
import com.onpositive.richtexteditor.model.partitions.IHandlesSelection;
import com.onpositive.richtexteditor.model.partitions.ILineAttributeModel;
import com.onpositive.richtexteditor.model.partitions.IRegionCompositeWrapperListener;
import com.onpositive.richtexteditor.model.partitions.ImagePartition;
import com.onpositive.richtexteditor.model.partitions.LinkPartition;
import com.onpositive.richtexteditor.model.partitions.ObjectPartition;
import com.onpositive.richtexteditor.model.partitions.PartitionDelta;
import com.onpositive.richtexteditor.model.partitions.PartitionStorage;
import com.onpositive.richtexteditor.model.partitions.RegionCompositeEvent;
import com.onpositive.richtexteditor.model.partitions.RegionPartition;
import com.onpositive.richtexteditor.model.partitions.SetAlignChange;
import com.onpositive.richtexteditor.model.partitions.SetBulletChange;
import com.onpositive.richtexteditor.model.partitions.WorldChange;
import com.onpositive.richtexteditor.model.resources.ColorManager;
import com.onpositive.richtexteditor.model.resources.FontStyleManager;
import com.onpositive.richtexteditor.model.resources.ImageManager;
import com.onpositive.richtexteditor.registry.InnerWidgetRegistry;
import com.onpositive.richtexteditor.viewer.IRichDocumentAutoStylingStrategy;
import com.onpositive.richtexteditor.viewer.IRichDocumentListener;
import com.onpositive.richtexteditor.viewer.undo.RichDocumentChange;
import java.io.FileInputStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.custom.Bullet;
import org.eclipse.swt.custom.PaintObjectEvent;
import org.eclipse.swt.custom.PaintObjectListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.LineAttributes;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class LayerManager
implements IPartitionListener,
PaintObjectListener,
FontStylesChangeListener {
    private ArrayList<IRichDocumentAutoStylingStrategy> autoStylers = new ArrayList();
    public static final int MARGIN = 10;
    protected ColorManager colorManager;
    private HashSet<IRichDocumentListener> richDocumentlisteners = new HashSet();
    protected FontStyleManager fontStyleManager;
    protected ImageManager imageManager;
    protected StyledText editor;
    protected BasePartitionLayer layer;
    protected int currentAlign = -1;
    protected IDocument doc;
    protected BasePartition linkPrototypePartition;
    protected FontStyle boldFontStyle = new FontStyle(1);
    protected FontStyle italicFontStyle = new FontStyle(2);
    protected FontStyle underlineFontStyle = new FontStyle(4);
    protected FontStyle strikethroughFontStyle = new FontStyle(8);
    protected int hrWidth = 2;
    private IHTMLSerializerFactory serializerFactory;
    private IHTMLLoaderFactory loaderFactory;
    public static final int LEFT_ALIGN = 16384;
    public static final int RIGHT_ALIGN = 131072;
    public static final int CENTER_ALIGN = 0x1000000;
    public static final int FIT_ALIGN = 4;
    public static final int NONE_LIST = 0;
    public static final int BULLETED_LIST = 5;
    public static final int NUMBERED_LIST = 6;
    public static final int DEFAULT_INDENT = 0;
    protected Listener paintListener;
    protected Listener repaintListener;
    protected KeyListener editorKeyListener;
    protected MouseListener editorMouseListener;
    protected InnerWidgetRegistry innerWidgetRegistry;

    public IRichDocumentAutoStylingStrategy[] getAutoStylingStrategies() {
        return this.autoStylers.toArray(new IRichDocumentAutoStylingStrategy[this.autoStylers.size()]);
    }

    public void addAutoStylingStrategy(IRichDocumentAutoStylingStrategy str) {
        this.autoStylers.add(str);
    }

    public void removeAutoStylingStrategy(IRichDocumentAutoStylingStrategy str) {
        this.autoStylers.add(str);
    }

    public final IHTMLLoaderFactory getLoaderFactory() {
        return this.loaderFactory;
    }

    public final void setLoaderFactory(IHTMLLoaderFactory loaderFactory) {
        this.loaderFactory = loaderFactory;
    }

    public IHTMLSerializerFactory getSerializerFactory() {
        return this.serializerFactory;
    }

    public void setSerializerFactory(IHTMLSerializerFactory serializerFactory) {
        this.serializerFactory = serializerFactory;
    }

    protected void setLineIdentation(int offset, int length) {
        String str;
        if (length > 0) {
            return;
        }
        int firstLine = this.editor.getLineAtOffset(offset);
        int lineIndent = this.editor.getLineIndent(firstLine);
        int alignment = this.editor.getLineAlignment(firstLine);
        if (this.editor.getCharCount() == 0) {
            alignment = this.currentAlign;
        }
        if ((str = this.editor.getContent().getLine(firstLine)).equals("")) {
            if (alignment == 0x1000000) {
                int indent = this.editor.getClientArea().width / 2 - 10 + 1;
                if (lineIndent != indent) {
                    this.editor.setLineIndent(firstLine, 1, indent);
                }
            } else if (alignment == 131072) {
                int indent = this.editor.getClientArea().width - 10 - 1;
                if (lineIndent != indent) {
                    this.editor.setLineIndent(firstLine, 1, indent);
                }
            } else if (lineIndent != 0) {
                this.editor.setLineIndent(firstLine, 1, 0);
            }
        } else if (lineIndent != 0) {
            this.editor.setLineIndent(firstLine, 1, 0);
        }
    }

    public LayerManager(StyledText newEditor, IDocument newDoc) {
        this.editor = newEditor;
        this.innerWidgetRegistry = InnerWidgetRegistry.getInstanceFor((Composite)this.editor);
        this.doc = newDoc;
        this.paintListener = new Listener(){

            public void handleEvent(Event event) {
                LayerManager.this.setLineIdentation(LayerManager.this.editor.getCaretOffset(), 0);
            }
        };
        newEditor.addListener(9, this.paintListener);
        this.editorMouseListener = new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                LayerManager.this.validateCaretPos(0);
            }

            public void mouseUp(MouseEvent e) {
            }
        };
        newEditor.addMouseListener(this.editorMouseListener);
        this.repaintListener = new Listener(){

            public void handleEvent(Event event) {
                LayerManager.this.editor.redraw();
            }
        };
        newEditor.addListener(13, this.repaintListener);
        newEditor.getVerticalBar().addListener(13, this.repaintListener);
        this.editorKeyListener = new KeyListener(){

            public void keyPressed(KeyEvent e) {
                LayerManager.this.validateCaretPos(e.keyCode);
            }

            public void keyReleased(KeyEvent e) {
            }
        };
        newEditor.addKeyListener(this.editorKeyListener);
        this.editor.setLineSpacing(8);
        newEditor.addPaintObjectListener((PaintObjectListener)this);
        this.layer = this.createBasePartitionLayer();
        this.layer.connectToDocument(this.doc);
        this.layer.setManager(this);
        this.layer.addPartitionListener(this);
        this.colorManager = new ColorManager(this.editor.getDisplay());
        this.imageManager = new ImageManager(this.editor.getDisplay());
        this.fontStyleManager = this.createFontStyleManager();
        this.fontStyleManager.addFontStyleChangeListener(this);
        try {
            Method declaredMethod = StyledText.class.getDeclaredMethod("setMargins", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            declaredMethod.setAccessible(true);
            declaredMethod.invoke((Object)this.editor, 10, 10, 10, 10);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        this.linkPrototypePartition = new BasePartition(this.layer, 0, 0);
        this.linkPrototypePartition.setStyleMask(4);
        this.linkPrototypePartition.setColorRGB(this.editor.getDisplay().getSystemColor(9).getRGB());
    }

    protected BasePartitionLayer createBasePartitionLayer() {
        return new BasePartitionLayer();
    }

    protected FontStyleManager createFontStyleManager() {
        return new FontStyleManager(this.editor.getDisplay());
    }

    public void dispose() {
        this.editor.removeListener(9, this.paintListener);
        this.editor.removeListener(13, this.repaintListener);
        this.editor.getVerticalBar().removeListener(13, this.repaintListener);
        this.editor.removeKeyListener(this.editorKeyListener);
        this.editor.removeMouseListener(this.editorMouseListener);
        this.layer.disposeSpecialPartitionsData();
        this.layer.disconnectFromDocument();
        this.imageManager.dispose();
        this.colorManager.dispose();
        this.fontStyleManager.dispose();
    }

    public FontRegistry getFontRegistry() {
        return this.fontStyleManager.getFontRegistry();
    }

    public BasePartition getCurrentFontPartition() {
        return this.layer.getCurrentFontPartition();
    }

    public void setCurrentFontPartition(BasePartition currentFontPartition) {
        this.layer.setCurrentFontPartition(currentFontPartition);
    }

    public void boldCommand(int offset, int length, boolean apply) {
        this.layer.fontStyleCommand(this.boldFontStyle, offset, length, apply);
    }

    public void italicCommand(int offset, int length, boolean apply) {
        this.layer.fontStyleCommand(this.italicFontStyle, offset, length, apply);
    }

    public void strikethroughCommand(int offset, int length, boolean apply) {
        this.layer.fontStyleCommand(this.strikethroughFontStyle, offset, length, apply);
    }

    public void underlineCommand(int offset, int length, boolean apply) {
        this.layer.fontStyleCommand(this.underlineFontStyle, offset, length, apply);
    }

    public void changeFontCommand(String fontStyleDisplayName, int offset, int length) {
        if (length != 0) {
            FontStyle style = this.fontStyleManager.getFontStyle(fontStyleDisplayName);
            this.layer.changeFontCommand(style, offset, length);
        }
    }

    @Override
    public void layerChanged(LayerEvent event) {
        Collection<IPartition> partitions = event.getChangedPartitions();
        for (IPartition part : partitions) {
            StyleRange styleRange;
            ObjectPartition partition;
            BasePartition fpartition;
            if (!(part instanceof BasePartition) || (fpartition = (BasePartition)part).getPosition() == -1) continue;
            if (part instanceof ImagePartition) {
                partition = (ImagePartition)part;
                styleRange = ((ImagePartition)partition).getStyleRange(this);
                try {
                    this.editor.setStyleRange(styleRange);
                }
                catch (Exception e) {
                    Logger.log(e);
                }
            }
            if (part instanceof HRPartition) {
                partition = (HRPartition)part;
                styleRange = ((HRPartition)partition).getStyleRange(this);
                try {
                    this.editor.setStyleRange(styleRange);
                }
                catch (Exception e) {
                    Logger.log(e);
                }
                continue;
            }
            StyleRange styleRange2 = fpartition.getStyleRange(this);
            styleRange2.font = this.fontStyleManager.getFontForPartition(fpartition);
            try {
                this.editor.setStyleRange(styleRange2);
            }
            catch (Exception e) {
                Logger.log(e);
            }
        }
        if (this.currentAlign > -1) {
            this.editor.setLineAlignment(0, 1, this.currentAlign);
            this.currentAlign = -1;
        }
        this.editor.redraw();
    }

    @Override
    public void partitionChanged(PartitionEvent event) {
        BasePartition partition = (BasePartition)event.getPartition();
        StyleRange styleRange = partition.getStyleRange(this);
        styleRange.font = this.fontStyleManager.getFontForPartition(partition);
        try {
            this.editor.setStyleRange(styleRange);
        }
        catch (Exception e) {
            Logger.log(e);
        }
        this.editor.redraw();
    }

    public void setIntervalAlign(int offset, int length, int align) {
        int firstLineNum = 0;
        int lastLineNum = 0;
        if (this.editor.getCharCount() == 0) {
            this.currentAlign = align;
            this.editor.redraw();
            return;
        }
        try {
            firstLineNum = this.doc.getLineOfOffset(offset);
            lastLineNum = length == 0 ? firstLineNum : this.doc.getLineOfOffset(offset + length - 1);
        }
        catch (BadLocationException e) {
            Logger.log(e);
        }
        int count = lastLineNum - firstLineNum;
        this.layer.execute(new SetAlignChange(align, count, firstLineNum));
    }

    public void setIntervalList(int offset, int length, int listStyle) {
        int firstLineNum = 0;
        int lastLineNum = 0;
        try {
            firstLineNum = this.doc.getLineOfOffset(offset);
            lastLineNum = length == 0 ? firstLineNum : this.doc.getLineOfOffset(offset + length - 1);
        }
        catch (BadLocationException e) {
            Logger.log(e);
        }
        Bullet bullet = null;
        if (listStyle == 5) {
            bullet = BulletFactory.getNewBulletedListBulletInstance();
        } else if (listStyle == 6) {
            bullet = BulletFactory.getNewNumberedListBulletInstance();
        }
        this.layer.execute(new SetBulletChange(firstLineNum, lastLineNum - firstLineNum + 1, bullet));
    }

    public void setSelectedIntervalForegroundColor(RGB color) {
        int offset = this.editor.getSelectionRange().x;
        int length = this.editor.getSelectionRange().y;
        FontStyle colorStyle = new FontStyle(0, color);
        if (length == 0) {
            colorStyle.applyStyle(this.layer.getCurrentFontPartition());
        } else {
            this.layer.fontStyleCommand(colorStyle, offset, length, true);
        }
    }

    public void setSelectedIntervalBackgroundColor(RGB color) {
        int offset = this.editor.getSelectionRange().x;
        int length = this.editor.getSelectionRange().y;
        FontStyle colorStyle = new FontStyle(0);
        colorStyle.setBgColor(color);
        if (length == 0) {
            colorStyle.applyStyle(this.layer.getCurrentFontPartition());
        } else {
            this.layer.fontStyleCommand(colorStyle, offset, length, true);
        }
    }

    public BasePartitionLayer getLayer() {
        return this.layer;
    }

    public void insertLinkPartititon(Point point, String name, String url) {
        LinkPartition partition = new LinkPartition(this.layer, point.x, name.length(), url, this.linkPrototypePartition);
        this.layer.replacePartitions(point.x, point.y, name, partition);
    }

    public RichSelectionState defineSumStylePartition(int offset, int length) {
        List<BasePartition> parts = this.layer.getPartitions();
        BasePartition startPartition = (BasePartition)this.layer.getPartitionAtOffset(offset);
        if (startPartition == null) {
            startPartition = (BasePartition)this.layer.getPartitionAtOffset(offset - 1);
        }
        if (startPartition == null) {
            startPartition = this.layer.storage.newPartition();
        }
        if (length == 0) {
            if (offset == startPartition.getOffset() && offset > 0) {
                BasePartition basePartition = this.layer.getPartitions().get(startPartition.getPosition() - 1);
                return new RichSelectionState(Collections.singletonList(basePartition), basePartition);
            }
            return new RichSelectionState(Collections.singletonList(startPartition), startPartition);
        }
        BasePartition endPartition = (BasePartition)this.layer.getPartitionAtOffset(offset + length - 1);
        ArrayList<BasePartition> ps = new ArrayList<BasePartition>();
        while (startPartition instanceof ObjectPartition && startPartition != endPartition) {
            --length;
            startPartition = (BasePartition)this.layer.getPartitionAtOffset(++offset);
        }
        if (startPartition == endPartition) {
            return new RichSelectionState(Collections.singletonList(startPartition), startPartition);
        }
        String sumFontName = startPartition.getFontDataName();
        boolean isBold = startPartition.isBold();
        boolean isItalic = startPartition.isItalic();
        boolean isUnderlined = startPartition.isUnderlined();
        boolean isStrikeThrough = startPartition.isStrikethrough();
        RGB color = startPartition.getColorRGB();
        RGB bgColor = startPartition.getColorRGB();
        int startIdx = this.layer.getPartitions().indexOf(startPartition);
        int endIdx = this.layer.getPartitions().indexOf(endPartition);
        int i = startIdx + 1;
        while (i <= endIdx) {
            boolean b;
            BasePartition partition = parts.get(i);
            ps.add(partition);
            if (!sumFontName.equals(partition.getFontDataName())) {
                sumFontName = "";
            }
            if (!(partition instanceof ObjectPartition)) {
                if (!partition.isBold()) {
                    isBold &= partition.isBold();
                }
                if (!partition.isItalic()) {
                    isItalic = false;
                }
                if (!partition.isUnderlined()) {
                    isUnderlined = false;
                }
                if (!partition.isStrikethrough()) {
                    isStrikeThrough = false;
                }
            }
            boolean bl = b = color != null && partition.getColorRGB() != null && color.equals((Object)partition.getColorRGB());
            if (!b) {
                color = null;
            }
            boolean bl2 = b = bgColor != null && partition.getBgColorRGB() != null && bgColor.equals((Object)partition.getBgColorRGB());
            if (!b) {
                bgColor = null;
            }
            ++i;
        }
        if (bgColor == null) {
            bgColor = new RGB(255, 255, 255);
        }
        BasePartition res = new BasePartition(this.layer, 0, 0);
        res.setFontDataName(sumFontName);
        res.setBold(isBold);
        res.setItalic(isItalic);
        res.setUnderlined(isUnderlined);
        res.setStrikethrough(isStrikeThrough);
        res.setColorRGB(color);
        res.setBgColorRGB(bgColor);
        return new RichSelectionState(ps, res);
    }

    public int defineSumAlignStyle(int startLineNum, int endLineNum) {
        int align = this.editor.getLineAlignment(startLineNum);
        boolean justify = this.editor.getLineJustify(startLineNum);
        int i = startLineNum + 1;
        while (i <= endLineNum) {
            if (this.editor.getLineAlignment(i) != align || this.editor.getLineJustify(i) != justify) {
                return 0;
            }
            ++i;
        }
        if (justify) {
            return 4;
        }
        return align;
    }

    public int defineSumListStyle(int startLineNum, int endLineNum) {
        Bullet bullet = this.editor.getLineBullet(startLineNum);
        int i = startLineNum + 1;
        while (i <= endLineNum) {
            if (this.editor.getLineBullet(i) != bullet) {
                return 0;
            }
            ++i;
        }
        if (bullet != null) {
            if (bullet.type == 1) {
                return 5;
            }
            if ((bullet.type & 2) != 0) {
                return 6;
            }
        }
        return 0;
    }

    public StyledText getEditor() {
        return this.editor;
    }

    public void addNewImage(String filename) {
        Image image2 = this.imageManager.checkImage(filename);
        if (image2 == null) {
            try {
                image2 = new Image((Device)this.editor.getDisplay(), filename);
                this.imageManager.registerImage(filename, image2);
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error during attempt to insert image", (String)e.getMessage());
                return;
            }
        }
        int offset = this.editor.getCaretOffset();
        ImagePartition pa = new ImagePartition(this.layer, offset, 1, image2, filename);
        this.layer.replacePartitions(offset, 0, "?", pa);
    }

    public void addNewRegion() {
        StyledText widget = new StyledText((Composite)this.editor, 2048);
        this.addWidgetPartition((Composite)widget);
    }

    public void addWidgetPartition(Composite widget) {
        int offset = this.editor.getCaretOffset();
        int prevChar = 0;
        try {
            prevChar = this.doc.get(offset - 1, 1).charAt(0);
        }
        catch (BadLocationException badLocationException) {}
        if (offset > 0 && prevChar != 13 && prevChar != 10) {
            BasePartition part = new BasePartition(this.layer, offset, 1);
            this.layer.replacePartitions(offset, 0, "\n", part);
            ++offset;
        }
        String regionStr = "?\n";
        final RegionPartition partition = new RegionPartition(this.layer, offset, regionStr.length(), widget);
        partition.getWrapper().addRegionCompositeWrapperListener(new IRegionCompositeWrapperListener(){

            @Override
            public void handleEvent(RegionCompositeEvent event) {
                if (event.getType() == 1) {
                    LayerManager.this.editor.setStyleRange(partition.getStyleRange(LayerManager.this));
                } else if (event.getType() == 2) {
                    int y = ((Caret)event.getObject()).getLocation().y;
                    int globalY = partition.getTopLevelObject().getLocation().y + y;
                    if (globalY < 0) {
                        LayerManager.this.editor.setTopPixel(LayerManager.this.editor.getTopPixel() + globalY);
                    } else if (globalY > LayerManager.this.editor.getSize().y) {
                        LayerManager.this.editor.setTopPixel(LayerManager.this.editor.getTopPixel() + globalY - LayerManager.this.editor.getSize().y + LayerManager.this.editor.getLineHeight() + 10);
                    }
                }
            }
        });
        this.editor.setRedraw(false);
        this.layer.replacePartitions(offset, 0, regionStr, partition);
        partition.setSize(this.editor.getClientArea().width - 20, partition.getInitialHeight() + 10);
        this.editor.setStyleRange(partition.getStyleRange(this));
        this.innerWidgetRegistry.addRedrawedControl((Control)partition.getObject());
        this.editor.setRedraw(true);
        this.editor.redraw();
        this.validateCaretPos(0);
    }

    public void addNewHR() {
        int offset = this.editor.getCaretOffset();
        String hrStr = "\n?\n";
        HRPartition hrp = new HRPartition(this.layer, offset, hrStr.length());
        this.layer.replacePartitions(offset, 0, hrStr, hrp);
    }

    public boolean isHRLine(int offset) {
        return this.layer.getPartitionAtOffset(offset) instanceof HRPartition;
    }

    public void paintObject(PaintObjectEvent event) {
        int y;
        int x;
        ObjectPartition partition;
        GC gc = event.gc;
        StyleRange style = event.style;
        int start = style.start;
        IPartition partitionAtOffset = this.layer.getPartitionAtOffset(start);
        if (partitionAtOffset instanceof ImagePartition) {
            partition = (ImagePartition)partitionAtOffset;
            Image image = ((ImagePartition)partition).getImage();
            x = event.x;
            y = event.y + event.ascent - style.metrics.ascent;
            if (image != null) {
                gc.drawImage(image, x, y);
            } else {
                gc.drawText("?", x, y);
            }
        }
        if (partitionAtOffset instanceof RegionPartition) {
            partition = (RegionPartition)partitionAtOffset;
            Point pt = ((RegionPartition)partition).getSize();
            x = event.x + 5;
            y = event.y;
            if (pt.x == 0 || pt.y == 0) {
                ((RegionPartition)partition).setSize(this.editor.getClientArea().width - 20, ((RegionPartition)partition).getInitialHeight() + 10);
            }
            ((RegionPartition)partition).setLocation(x, y);
            this.innerWidgetRegistry.addRedrawedControl((Control)((RegionPartition)partition).getTopLevelObject());
        }
        if (partitionAtOffset instanceof HRPartition) {
            gc.setLineAttributes(new LineAttributes((float)this.hrWidth));
            if (((HRPartition)partitionAtOffset).getColor(this) != null) {
                gc.setForeground(((HRPartition)partitionAtOffset).getColor(this));
            }
            if (((HRPartition)partitionAtOffset).getBgColor(this) != null) {
                gc.setForeground(((HRPartition)partitionAtOffset).getBgColor(this));
            }
            gc.setLineStyle(1);
            gc.drawLine(event.x, event.y, this.editor.getClientArea().width, event.y);
        }
    }

    public void openHTMLFile(String filename) {
        int oldLength;
        ISimpleRichTextModel z = null;
        try {
            z = this.getTextHTMLLoader().parse(new FileInputStream(filename));
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.editor.getShell(), (String)"Unable to open file", (String)e.getMessage());
            return;
        }
        this.editor.setRedraw(false);
        try {
            this.layer.setIgnoreDocumentEvents(true);
            oldLength = this.doc.getLength();
            this.doc.set(z.getText());
            this.layer.setIgnoreDocumentEvents(false);
            List<BasePartition> partitions = z.getPartitions();
            this.layer.storage.setPartitions(partitions);
            int lineCount = z.getLineCount();
            int i = 0;
            while (i < lineCount) {
                int align = z.getAlign(i);
                if (align != 4) {
                    this.editor.setLineAlignment(i, 1, align);
                } else {
                    this.editor.setLineAlignment(i, 1, 16384);
                    this.editor.setLineJustify(i, 1, true);
                }
                Bullet bullet = (Bullet)z.getBullet(i);
                this.editor.setLineBullet(i, 1, bullet);
                ++i;
            }
            this.layerChanged(new LayerEvent(this.layer, new ArrayList<IPartition>(partitions)));
        }
        finally {
            this.editor.setRedraw(true);
        }
        this.fireRichDocumentEvent(new DocumentEvent(this.doc, 0, oldLength, z.getText()), new PartitionDelta(this.layer.getStorage()));
    }

    public void pasteHTML(String contents, int offset) {
        this.editor.setRedraw(false);
        try {
            try {
                ISimpleRichTextModel model = this.getTextHTMLLoader().parse(contents);
                this.paste(offset, model);
            }
            catch (BadLocationException badLocationException) {
                throw new RuntimeException();
            }
        }
        finally {
            this.editor.setRedraw(true);
        }
    }

    public void paste(int offset, ISimpleRichTextModel model) throws BadLocationException {
        PasteChange change = new PasteChange(model, offset);
        this.layer.execute(change);
    }

    public void set(ISimpleRichTextModel model) throws BadLocationException {
        SetContentChange change = new SetContentChange(model, this.getEditor().getCaretOffset());
        this.layer.execute(change);
    }

    public void serializeToFile(String fileName) {
        TextSerializer serializer = this.getTextSerializer();
        try {
            PrintWriter pw = new PrintWriter(fileName);
            serializer.serializeAll(pw);
            pw.close();
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.editor.getShell(), (String)"Error during HTML serialization", (String)e.getMessage());
        }
    }

    public String getSerializedString() {
        TextSerializer serializer = this.getTextSerializer();
        return serializer.serializeAllToStr();
    }

    public String getSerializedWikiString() {
        HTMLSerializer serializer = new HTMLSerializer(this);
        return serializer.serializeAllToStr();
    }

    protected TextSerializer getTextSerializer() {
        if (this.serializerFactory != null) {
            return this.serializerFactory.getNewSerializer(this);
        }
        HTMLSerializer serializer = new HTMLSerializer(this);
        return serializer;
    }

    protected IHTMLLoader getTextHTMLLoader() {
        if (this.loaderFactory == null) {
            return new DefaultHTMLLoader(this);
        }
        return this.loaderFactory.getHTMLLoader(this);
    }

    public String getSelectedHTML() {
        TextSerializer serializer = this.getTextSerializer();
        Point selection = this.editor.getSelection();
        if (selection.y - selection.x > 0) {
            try {
                return serializer.serializeToStr(selection);
            }
            catch (BadLocationException e) {
                Logger.log(e);
            }
        }
        return null;
    }

    public String getContentsHTML() {
        return this.getTextSerializer().serializeAllToStr();
    }

    public ImageManager getImageManager() {
        return this.imageManager;
    }

    public void addRichDocumentListener(IRichDocumentListener documentListener) {
        this.richDocumentlisteners.add(documentListener);
    }

    public void removeRichDocumentListener(IRichDocumentListener documentListener) {
        this.richDocumentlisteners.remove(documentListener);
    }

    public void fireDocumentGoingToChange(DocumentEvent event) {
        for (IRichDocumentListener l : this.richDocumentlisteners) {
            l.documentAboutToBeChanged(event);
        }
    }

    public void fireRichDocumentEvent(DocumentEvent event, PartitionDelta processChange) {
        for (IRichDocumentListener l : this.richDocumentlisteners) {
            l.documentChanged(event, new RichDocumentChange(processChange));
        }
    }

    public FontStyleManager getFontStyleManager() {
        return this.fontStyleManager;
    }

    public ColorManager getColorRegistry() {
        return this.colorManager;
    }

    public void validateCaretPos(int keyCode) {
        int offset = this.getEditor().getCaretOffset();
        BasePartition curPartition = (BasePartition)this.getLayer().getPartitionAtOffset(offset);
        if (curPartition != null && curPartition.requiresSingleLine()) {
            if (keyCode == 0x1000001 || keyCode == 0x1000003) {
                this.getEditor().setCaretOffset(curPartition.getOffset());
            } else {
                char charAt = 'a';
                try {
                    charAt = this.doc.get(offset, 1).charAt(0);
                }
                catch (BadLocationException badLocationException) {}
                if (curPartition.getOffset() != offset || !Character.isWhitespace(charAt)) {
                    this.getEditor().setCaretOffset(curPartition.getOffset() + curPartition.getLength());
                }
            }
        }
    }

    public IDocument getDocument() {
        return this.doc;
    }

    public BasePartition getLinkPrototype() {
        return this.linkPrototypePartition;
    }

    @Override
    public void stylesChanged(ArrayList<FontStyle> changedStyles) {
        LayerEvent event = new LayerEvent(this.layer);
        List<IPartition> partitions = this.layer.getStorage().getPartitions();
        for (FontStyle fontStyle : changedStyles) {
            for (BasePartition basePartition : partitions) {
                if (!basePartition.getFontDataName().equals(fontStyle.getFontDataName())) continue;
                fontStyle.applyStyle(basePartition);
                event.addChangedPartition(basePartition);
            }
        }
        this.layerChanged(new LayerEvent(this.layer, partitions));
    }

    public boolean isStyleUsed(FontStyle style) {
        int i = 0;
        while (i < this.layer.getStorage().getPartitions().size()) {
            if (this.layer.getStorage().getPartitions().get(i).getFontDataName().equals(style.getFontDataName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void removeStyleFromAllPartitions(FontStyle style) {
        LayerEvent event = new LayerEvent(this.layer);
        int i = 0;
        while (i < this.layer.getStorage().getPartitions().size()) {
            if (this.layer.getStorage().getPartitions().get(i).getFontDataName().equals(style.getFontDataName())) {
                this.fontStyleManager.getDefaultStyle().setStyle(this.layer.getStorage().getPartitions().get(i));
                event.addChangedPartition(this.layer.getStorage().getPartitions().get(i));
            }
            ++i;
        }
        this.layerChanged(event);
    }

    public void setRefreshVisibleState(boolean refresh) {
        this.editor.setRedraw(refresh);
    }

    public void addNewlinesIfNeeded(int offset, String selectedFontName) {
    }

    public int getLineDelimiterLength() {
        return 2;
    }

    public final class PasteChange
    extends Change
    implements IHandlesSelection {
        private final ISimpleRichTextModel model;
        private final int offset;

        private PasteChange(ISimpleRichTextModel listener, int offset) {
            this.model = listener;
            this.offset = offset;
        }

        @Override
        protected void apply(PartitionDelta delta) {
            try {
                int lineNumber = LayerManager.this.doc.getLineOfOffset(this.offset);
                String insertedText = this.model.getText();
                List<BasePartition> partitions = LayerManager.this.layer.getPartitions();
                ArrayList<Integer> oldAligns = new ArrayList<Integer>();
                ArrayList<Bullet> oldBullets = new ArrayList<Bullet>();
                int lineCount = LayerManager.this.editor.getLineCount();
                int a = 0;
                while (a < lineCount) {
                    oldAligns.add(LayerManager.this.editor.getLineAlignment(a));
                    oldBullets.add(LayerManager.this.editor.getLineBullet(a));
                    ++a;
                }
                List<BasePartition> clonePartitions = LayerManager.this.layer.getStorage().clonePartitions();
                String oldContent = LayerManager.this.doc.get();
                delta.getUndoChange().add(new SetContentChange(clonePartitions, oldAligns, oldBullets, oldContent, LayerManager.this.editor.getCaretOffset()));
                LayerManager.this.layer.disconnectFromDocument();
                LayerManager.this.doc.replace(this.offset, 0, insertedText);
                LayerManager.this.layer.connectToDocument(LayerManager.this.doc);
                List<BasePartition> newPartitions = this.model.getPartitions();
                for (BasePartition p : newPartitions) {
                    p.setOffset(p.getOffset() + this.offset);
                }
                ArrayList<BasePartition> resultPartitions = new ArrayList<BasePartition>(partitions.size() + newPartitions.size());
                BasePartition partitionTail = null;
                int insertionIndex = 0;
                while (insertionIndex < partitions.size()) {
                    BasePartition curPartition = partitions.get(insertionIndex);
                    if (curPartition.getOffset() >= this.offset) break;
                    resultPartitions.add(curPartition);
                    if (curPartition.getOffset() + curPartition.getLength() > this.offset) {
                        int oldLength = curPartition.getLength();
                        curPartition.setLength(this.offset - curPartition.getOffset());
                        partitionTail = new BasePartition(LayerManager.this.layer, curPartition.getOffset() + curPartition.getLength() + insertedText.length(), oldLength - curPartition.getLength());
                        partitionTail.applyAttributes(curPartition);
                    }
                    ++insertionIndex;
                }
                for (BasePartition p : newPartitions) {
                    resultPartitions.add(p);
                }
                if (partitionTail != null) {
                    resultPartitions.add(partitionTail);
                }
                while (insertionIndex < partitions.size()) {
                    BasePartition p;
                    p = partitions.get(insertionIndex);
                    p.setOffset(p.getOffset() + insertedText.length());
                    resultPartitions.add(p);
                    ++insertionIndex;
                }
                LayerManager.this.layer.storage.setPartitions(resultPartitions);
                int i = 0;
                while (i < this.model.getLineCount()) {
                    int align = this.model.getAlign(i);
                    if (align != 4) {
                        LayerManager.this.editor.setLineAlignment(i + lineNumber, 1, align);
                    } else {
                        LayerManager.this.editor.setLineAlignment(i + lineNumber, 1, 16384);
                        LayerManager.this.editor.setLineJustify(i + lineNumber, 1, true);
                    }
                    LayerManager.this.editor.setLineBullet(i + lineNumber, 1, (Bullet)this.model.getBullet(i));
                    ++i;
                }
                LayerManager.this.editor.setStyleRanges(new StyleRange[0]);
                for (BasePartition p : resultPartitions) {
                    delta.added(p);
                }
                LayerManager.this.editor.setCaretOffset(this.offset + insertedText.length());
                LayerManager.this.editor.setSelection(this.offset + insertedText.length());
            }
            catch (BadLocationException badLocationException) {
                throw new IllegalStateException();
            }
        }
    }

    public final class SetContentChange
    extends WorldChange
    implements IHandlesSelection {
        private final String oldContent;
        private int oldOffset;

        private SetContentChange(List<BasePartition> clonePartitions, List<Integer> oldAligns, List<Object> oldBullets, String oldContent, int oldOffset) {
            super(clonePartitions, oldAligns, oldBullets);
            this.oldContent = oldContent;
            this.oldOffset = oldOffset;
        }

        public SetContentChange(ISimpleRichTextModel model, int caretOffset) {
            super(model);
            this.oldContent = model.getText();
            this.oldOffset = caretOffset;
        }

        @Override
        protected void apply(PartitionDelta delta) {
            try {
                LayerManager.this.editor.setRedraw(false);
                delta.clearAdded();
                delta.clearChanged();
                delta.setOptimizeParitions(false);
                LayerManager.this.layer.disconnectFromDocument();
                ILineAttributeModel lineAttributeModel = delta.getStorage().getLineAttributeModel();
                int lineCount = lineAttributeModel.lineCount();
                ArrayList<Integer> aligns = new ArrayList<Integer>();
                ArrayList<Object> bullets = new ArrayList<Object>();
                int a = 0;
                while (a < lineCount) {
                    aligns.add(lineAttributeModel.getLineAlign(a));
                    bullets.add(lineAttributeModel.getBullet(a));
                    ++a;
                }
                int pos = LayerManager.this.editor.getCaretOffset();
                String old = LayerManager.this.doc.get();
                try {
                    LayerManager.this.doc.replace(0, LayerManager.this.doc.getLength(), this.oldContent);
                    LayerManager.this.layer.connectToDocument(LayerManager.this.doc);
                }
                catch (BadLocationException e) {
                    throw new IllegalStateException(e);
                }
                PartitionStorage storage = delta.getStorage();
                List<BasePartition> clonePartitions = storage.clonePartitions();
                for (BasePartition p : this.newPartitions) {
                    delta.added(p);
                }
                storage.setPartitions(this.newPartitions);
                int a2 = 0;
                while (a2 < this.aligns.length) {
                    try {
                        lineAttributeModel.setLineAlign(a2, 0, this.aligns[a2]);
                        Object bullet = this.bullets[a2];
                        if (bullet != null) {
                            lineAttributeModel.setLineBullet(a2, 1, bullet);
                        }
                    }
                    catch (Exception exception) {}
                    ++a2;
                }
                delta.getUndoChange().add(new SetContentChange(clonePartitions, aligns, bullets, old, pos));
                LayerManager.this.editor.setSelection(this.oldOffset);
            }
            catch (Exception e) {
                Logger.log(e);
            }
            LayerManager.this.editor.setRedraw(true);
            LayerManager.this.editor.redraw();
        }
    }

    public static final class SimpleRichTextModel
    implements ISimpleRichTextModel {
        private List<Integer> aligns;
        private List<Object> bullets;
        private List<BasePartition> styles;
        private String text;

        public SimpleRichTextModel(List<Integer> aligns, List<Object> bullets, List<BasePartition> styles, String text) {
            this.aligns = aligns;
            this.bullets = bullets;
            this.styles = styles;
            this.text = text;
        }

        @Override
        public int getAlign(int line) {
            return this.aligns.get(line);
        }

        @Override
        public Object getBullet(int line) {
            return this.bullets.get(line);
        }

        @Override
        public int getLineCount() {
            return this.aligns.size();
        }

        @Override
        public List<BasePartition> getPartitions() {
            return this.styles;
        }

        @Override
        public String getText() {
            return this.text;
        }
    }
}

