/*
 * Decompiled with CFR 0.152.
 */
package com.onpositive.richtexteditor.model;

import com.onpositive.richtexteditor.model.BasePartitionEvent;
import com.onpositive.richtexteditor.model.FontStyle;
import com.onpositive.richtexteditor.model.ILink;
import com.onpositive.richtexteditor.model.IPartition;
import com.onpositive.richtexteditor.model.IPartitionLayer;
import com.onpositive.richtexteditor.model.IPartitionListener;
import com.onpositive.richtexteditor.model.LayerEvent;
import com.onpositive.richtexteditor.model.LayerManager;
import com.onpositive.richtexteditor.model.Logger;
import com.onpositive.richtexteditor.model.partitions.AbstractModel;
import com.onpositive.richtexteditor.model.partitions.BasePartition;
import com.onpositive.richtexteditor.model.partitions.Change;
import com.onpositive.richtexteditor.model.partitions.CompositeChange;
import com.onpositive.richtexteditor.model.partitions.ExpandPartitionAtOffsetChange;
import com.onpositive.richtexteditor.model.partitions.IDisposablePartion;
import com.onpositive.richtexteditor.model.partitions.ILineAttributeModel;
import com.onpositive.richtexteditor.model.partitions.ObjectPartition;
import com.onpositive.richtexteditor.model.partitions.PartitionDelta;
import com.onpositive.richtexteditor.model.partitions.PartitionFactory;
import com.onpositive.richtexteditor.model.partitions.PartitionStorage;
import com.onpositive.richtexteditor.model.partitions.PartitionStyleChange;
import com.onpositive.richtexteditor.model.partitions.ShiftPartitionAtPositionChange;
import com.onpositive.richtexteditor.viewer.IRichDocumentAutoStylingStrategy;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.swt.custom.Bullet;
import org.eclipse.swt.custom.StyledText;

public class BasePartitionLayer
extends AbstractModel
implements IPartitionLayer,
IDocumentListener {
    private static final boolean debug = false;
    PartitionStorage storage = new PartitionStorage(this);
    ArrayList<IPartitionListener> listeners;
    protected IDocument doc = null;
    protected BasePartition linkPrototypePartition;
    protected LayerManager manager;
    protected PartitionDelta delayedPartitionDelta = null;
    protected DocumentEvent delayedEvent = null;
    protected boolean fireEvents = true;
    protected BasePartition currentFontPartition = null;
    ArrayList<Runnable> hooks = new ArrayList();
    private boolean ignoreEvents;
    protected CompositeChange preservingChange;

    public void fontStyleCommand(FontStyle fontStyle, int offset, int length, boolean apply) {
        CompositeChange ch = new CompositeChange(this.storage);
        List<IPartition> newPartitions = ch.extractChangedRegion(offset, length);
        for (BasePartition basePartition : newPartitions) {
            PartitionStyleChange sta = new PartitionStyleChange(basePartition, fontStyle, apply);
            ch.add(sta);
        }
        PartitionDelta apply2 = this.apply(ch);
        this.manager.fireRichDocumentEvent(null, apply2);
        this.handleEvent(new LayerEvent(this, new ArrayList<IPartition>(newPartitions)));
    }

    public BasePartition getCurrentFontPartition() {
        if (this.currentFontPartition == null) {
            int caretOffset = this.manager.getEditor().getCaretOffset();
            IPartition partitionAtOffset = this.getPartitionAtOffset(caretOffset);
            if (partitionAtOffset == null && caretOffset > 0) {
                partitionAtOffset = this.getPartitionAtOffset(caretOffset - 1);
            }
            this.currentFontPartition = partitionAtOffset != null && !(partitionAtOffset instanceof ObjectPartition) ? PartitionFactory.createAsSampleStyle((BasePartition)partitionAtOffset, this, 0, 0) : new BasePartition(this, 0, 0);
        }
        return this.currentFontPartition;
    }

    public void setCurrentFontPartition(BasePartition currentFontPartition) {
        this.currentFontPartition = currentFontPartition;
    }

    public IDocument getDoc() {
        return this.doc;
    }

    public BasePartitionLayer() {
        this.listeners = new ArrayList();
    }

    protected void handleEvent(LayerEvent event) {
        this.debugCheck();
        for (IPartitionListener listener : this.listeners) {
            listener.layerChanged(event);
        }
    }

    public void handlePartitionEvent(BasePartitionEvent event) {
        for (IPartitionListener listener : this.listeners) {
            listener.partitionChanged(event);
        }
    }

    public void printPartitions() {
    }

    @Override
    public void addPartitionListener(IPartitionListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void connectToDocument(IDocument doc) {
        this.doc = doc;
        if (doc != null) {
            doc.addDocumentListener((IDocumentListener)this);
        }
    }

    @Override
    public void disconnectFromDocument() {
        this.doc.removeDocumentListener((IDocumentListener)this);
        this.doc = null;
    }

    public void disposeSpecialPartitionsData() {
        List<BasePartition> partitions = this.storage.getPartitions();
        for (BasePartition basePartition : partitions) {
            if (!(basePartition instanceof IDisposablePartion)) continue;
            ((IDisposablePartion)((Object)basePartition)).dispose();
        }
    }

    @Override
    public IPartition getPartitionAtOffset(int offset) {
        int a = 0;
        while (a < this.storage.size()) {
            BasePartition partition = this.storage.get(a);
            if (partition.getOffset() + partition.getLength() > offset) {
                return partition;
            }
            ++a;
        }
        return null;
    }

    @Override
    public void removePartitionListener(IPartitionListener listener) {
        this.listeners.remove(listener);
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
        Bullet lineBullet;
        if (this.ignoreEvents) {
            return;
        }
        if (event.getOffset() == 0 && (lineBullet = this.manager.getEditor().getLineBullet(0)) != null) {
            this.hooks.add(new Runnable(){

                @Override
                public void run() {
                    BasePartitionLayer.this.manager.getEditor().setLineBullet(0, 1, lineBullet);
                }
            });
        }
        if (this.fireEvents) {
            this.manager.fireDocumentGoingToChange(event);
        }
        try {
            this.preservingChange = this.preserveDocumentStructureIfNeeded(event.fOffset, event.fLength);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public BasePartition deleteInterval(CompositeChange change, int offset, int length) {
        if (length == 0) {
            return null;
        }
        BasePartition resPartition = null;
        BasePartition startPartition = (BasePartition)this.getPartitionAtOffset(offset);
        int startIdx = startPartition.getPosition();
        BasePartition endPartition = (BasePartition)this.getPartitionAtOffset(offset + length);
        if (startPartition.getOffset() == offset) {
            if (length >= startPartition.getLength()) {
                --startIdx;
            } else {
                change.setLength(startPartition, startPartition.getLength() - length);
            }
            resPartition = startPartition;
        } else if (startPartition == endPartition) {
            change.setLength(startPartition, startPartition.getLength() - length);
        } else {
            int startLength = offset - startPartition.getOffset();
            change.setLength(startPartition, startLength);
        }
        if (endPartition != null) {
            int endIdx = endPartition.getPosition();
            if (endPartition != startPartition) {
                int endOffset = offset;
                int endLength = endPartition.getOffset() + endPartition.getLength() - endOffset - length;
                change.adjustPartition(endPartition, endOffset, endLength);
            }
            int p = endIdx;
            int i = p - 1;
            while (i >= startIdx + 1) {
                change.remove(i);
                --endIdx;
                --i;
            }
            change.add(new ShiftPartitionAtPositionChange(endIdx + 1, -length));
        } else {
            int a = this.storage.size() - 1;
            while (a >= startIdx + 1) {
                change.remove(a);
                --a;
            }
        }
        return resPartition;
    }

    protected CompositeChange preserveDocumentStructureIfNeeded(int offset, int length) throws BadLocationException {
        return null;
    }

    public void checkConsistency() {
        BasePartition basePartition;
        int i = 1;
        while (i < this.storage.size()) {
            BasePartition basePartition2 = this.storage.get(i);
            if (basePartition2.getOffset() != this.storage.get(i - 1).getOffset() + this.storage.get(i - 1).getLength()) {
                throw new RuntimeException("Consistency error - partition " + basePartition2.toString());
            }
            if (basePartition2.getPosition() != i) {
                throw new RuntimeException("Consistency error - partition " + basePartition2.toString());
            }
            ++i;
        }
        if (this.storage.size() > 0 && (basePartition = this.storage.get(this.storage.size() - 1)).getOffset() + basePartition.getLength() != this.doc.getLength()) {
            throw new RuntimeException("Consistency error -missed partitions ");
        }
    }

    public void documentChanged(DocumentEvent event) {
        if (this.ignoreEvents) {
            return;
        }
        int offset = event.getOffset();
        int length = event.getText().length();
        int removeLength = event.getLength();
        try {
            for (Runnable r : this.hooks) {
                r.run();
            }
        }
        finally {
            this.hooks.clear();
        }
        this.copyLineAttributes(offset, length);
        PartitionDelta processChange = this.processChange(event, offset, length, removeLength);
        if (this.fireEvents) {
            this.manager.fireRichDocumentEvent(event, processChange);
            this.handleEvent(new LayerEvent(this, processChange.getChanged()));
        } else {
            this.delayedPartitionDelta = processChange;
            this.delayedEvent = event;
        }
    }

    private PartitionDelta processChange(DocumentEvent event, int offset, int length, int removeLength) {
        int expand;
        BasePartition firstPartition;
        CompositeChange change = new CompositeChange(this.storage);
        PartitionDelta preservingApply = null;
        if (this.preservingChange != null) {
            this.manager.getEditor().setRedraw(false);
            preservingApply = this.storage.apply(this.preservingChange);
            this.manager.getEditor().setRedraw(true);
            this.preservingChange = null;
        }
        if ((firstPartition = this.deleteInterval(change, offset, removeLength)) == null) {
            firstPartition = this.currentFontPartition;
        }
        if (this.doc.getLength() > 0 && (expand = length - removeLength) >= 0) {
            change.add(new ExpandPartitionAtOffsetChange(offset, length, firstPartition));
        }
        PartitionDelta apply = this.processChange(offset, removeLength, change, event);
        this.debugCheck();
        if (preservingApply != null) {
            preservingApply.merge(apply);
            return preservingApply;
        }
        return apply;
    }

    protected void checkAfterDeletion(int offset, int length) {
    }

    public PartitionDelta processChange(int offset, int removeLength, CompositeChange change, DocumentEvent event) {
        this.manager.setRefreshVisibleState(false);
        PartitionDelta apply = this.storage.apply(change);
        IRichDocumentAutoStylingStrategy[] aytoStylingStrategies = this.manager.getAutoStylingStrategies();
        CompositeChange cm = new CompositeChange(this.storage);
        IRichDocumentAutoStylingStrategy[] iRichDocumentAutoStylingStrategyArray = aytoStylingStrategies;
        int n = aytoStylingStrategies.length;
        int n2 = 0;
        while (n2 < n) {
            IRichDocumentAutoStylingStrategy s = iRichDocumentAutoStylingStrategyArray[n2];
            s.customizeStyleChanges(event, cm, apply);
            ++n2;
        }
        PartitionDelta apply2 = this.storage.apply(cm);
        apply.merge(apply2);
        ArrayList<IPartition> changedPartitions = new ArrayList<IPartition>(apply.getChanged());
        if (this.storage.size() > 0) {
            BasePartition partitionAtOffset = this.storage.getPartitionAtOffset(offset);
            BasePartition lastDeletionPartition = this.storage.getPartitionAtOffset(offset + removeLength);
            if (lastDeletionPartition == null) {
                lastDeletionPartition = this.storage.getLastPartition();
            }
            if (partitionAtOffset == null) {
                partitionAtOffset = this.storage.getLastPartition();
            }
            int a = partitionAtOffset.getPosition();
            while (a <= lastDeletionPartition.getPosition()) {
                changedPartitions.add(this.storage.get(a));
                ++a;
            }
        }
        this.manager.setRefreshVisibleState(true);
        this.handleEvent(new LayerEvent(this, changedPartitions));
        return apply;
    }

    public void undoRedoHook(int offset, int length) {
    }

    public void processChanges(int offset, int removeLength, ArrayList<CompositeChange> changes, ArrayList<CompositeChange> toUndo) {
        ArrayList<IPartition> changedPartitions = new ArrayList<IPartition>();
        PartitionDelta merge = new PartitionDelta(this.storage);
        for (CompositeChange change : changes) {
            PartitionDelta apply = this.storage.apply(change);
            merge.merge(apply);
            changedPartitions.addAll(apply.getChanged());
            toUndo.add(apply.getUndoChange());
        }
        if (this.storage.size() > 0) {
            BasePartition partitionAtOffset = this.storage.getPartitionAtOffset(offset);
            BasePartition partitionAtOffset1 = this.storage.getPartitionAtOffset(offset + removeLength);
            if (partitionAtOffset1 == null) {
                partitionAtOffset1 = this.storage.getLastPartition();
            }
            if (partitionAtOffset == null) {
                partitionAtOffset = this.storage.getLastPartition();
            }
            int a = partitionAtOffset.getPosition();
            while (a <= partitionAtOffset1.getPosition()) {
                changedPartitions.add(this.storage.get(a));
                ++a;
            }
        }
        this.debugCheck();
        this.manager.fireRichDocumentEvent(null, merge);
        this.handleEvent(new LayerEvent(this, changedPartitions));
    }

    protected BasePartition addAsCurrentFontPartition(CompositeChange change, int offset, int length) {
        BasePartition partition = PartitionFactory.createAsSampleStyle(this.currentFontPartition, this, offset, length);
        BasePartition addedPartition = this.insertNewPartition(change, offset, length, partition);
        this.debugCheck();
        return addedPartition;
    }

    protected BasePartition insertNewPartition(CompositeChange change, int offset, int length, BasePartition partition) {
        change.addPartitionAtOffset(partition, 0);
        return partition;
    }

    protected void debugCheck() {
    }

    protected void copyLineAttributes(int offset, int length) {
        boolean justify;
        int align;
        if (length == 0) {
            return;
        }
        int firstLine = 0;
        int lastLine = 0;
        boolean inheritFromLast = false;
        try {
            firstLine = this.doc.getLineOfOffset(offset);
            lastLine = this.doc.getLineOfOffset(offset + length);
            if (this.isLineDelimiter(this.doc.get(offset, length)) && offset == this.doc.getLineOffset(firstLine) && length == this.doc.getLineLength(firstLine)) {
                inheritFromLast = true;
            }
        }
        catch (BadLocationException e) {
            Logger.log(e);
        }
        StyledText editor = this.manager.getEditor();
        if (inheritFromLast) {
            align = editor.getLineAlignment(lastLine);
            justify = editor.getLineJustify(lastLine);
        } else {
            align = editor.getLineAlignment(firstLine);
            justify = editor.getLineJustify(firstLine);
            int inheritAlignLineNum = firstLine;
            while (inheritAlignLineNum > 0 && editor.getContent().getLine(inheritAlignLineNum).equals("")) {
                align = editor.getLineAlignment(inheritAlignLineNum - 1);
                justify = editor.getLineJustify(inheritAlignLineNum - 1);
                --inheritAlignLineNum;
            }
        }
        if (this.manager.getEditor().getLineCount() > 1) {
            editor.setLineAlignment(firstLine + 1, lastLine - firstLine, align);
            editor.setLineJustify(firstLine + 1, lastLine - firstLine, justify);
            editor.setLineBullet(firstLine + 1, lastLine - firstLine, editor.getLineBullet(firstLine));
        }
    }

    protected BasePartition getNextPartititon(BasePartition partition) {
        int n = partition.getPosition();
        if (n < this.storage.size() - 1) {
            return this.storage.get(n + 1);
        }
        return null;
    }

    protected void changeOffset(CompositeChange change, int startIndex, int amount) {
        change.add(new ShiftPartitionAtPositionChange(startIndex, amount));
    }

    public boolean isBoldAtOffset(int offset) {
        return ((BasePartition)this.getPartitionAtOffset(offset)).isBold();
    }

    public boolean isItalicAtOffset(int offset) {
        return ((BasePartition)this.getPartitionAtOffset(offset)).isItalic();
    }

    protected void mergeWithNext(CompositeChange change, int partitionIdx) {
        change.addMergeChange(partitionIdx);
    }

    public int defineSumStyle(List<IPartition> parts) {
        int sumStyle = -1;
        for (BasePartition basePartition : parts) {
            sumStyle &= basePartition.getStyleMask();
        }
        return sumStyle;
    }

    public String defineSumFontName(List<IPartition> parts) {
        if (parts.isEmpty()) {
            return "";
        }
        String sumFontName = ((BasePartition)parts.get(0)).getFontDataName();
        int i = 1;
        while (i < parts.size()) {
            BasePartition partition = (BasePartition)parts.get(i);
            if (!sumFontName.equals(partition.getFontDataName())) {
                sumFontName = "";
            }
            ++i;
        }
        return sumFontName;
    }

    public String getSummaryUrl(int offset, int length) {
        BasePartition begPartition = (BasePartition)this.getPartitionAtOffset(offset);
        BasePartition endPartition = (BasePartition)this.getPartitionAtOffset(offset + length - 1);
        if (!(begPartition instanceof ILink) || !(endPartition instanceof ILink)) {
            return "";
        }
        if (begPartition == endPartition) {
            return ((ILink)((Object)begPartition)).getUrl();
        }
        int begIdx = begPartition.getPosition();
        int endIdx = endPartition.getPosition();
        String curUrl = ((ILink)((Object)begPartition)).getUrl();
        int i = begIdx + 1;
        while (i <= endIdx) {
            BasePartition fp = this.storage.get(i);
            if (!(fp instanceof ILink)) {
                return "";
            }
            if (!curUrl.equals(((ILink)((Object)fp)).getUrl())) {
                return "";
            }
            ++i;
        }
        return curUrl;
    }

    protected boolean isLineDelimiter(String string) {
        int i = 0;
        while (i < string.length()) {
            if (string.charAt(i) != '\r' && string.charAt(i) != '\n') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public BasePartition get(int i) {
        return this.storage.get(i);
    }

    public List<BasePartition> getPartitions() {
        return this.storage.getPartitions();
    }

    public PartitionDelta apply(CompositeChange ch) {
        return this.storage.apply(ch);
    }

    public void changeFontCommand(FontStyle style, int offset, int length) {
        boolean apply = true;
        CompositeChange change = new CompositeChange(this.storage);
        List<IPartition> newPartitions = change.extractChangedRegion(offset, length);
        String sumFontDataName = this.defineSumFontName(newPartitions);
        if (style.getFontDataName().equals(sumFontDataName)) {
            apply = false;
        }
        for (BasePartition basePartition : newPartitions) {
            change.add(new PartitionStyleChange(basePartition, style, apply));
        }
        PartitionDelta apply2 = this.apply(change);
        this.manager.fireRichDocumentEvent(null, apply2);
        this.handleEvent(new LayerEvent(this, new ArrayList<IPartition>(newPartitions)));
    }

    public void replacePartitions(int offset, int length, String name, BasePartition partition) {
        try {
            try {
                ArrayList<IPartition> changedPartitions = new ArrayList<IPartition>();
                changedPartitions.add(partition);
                PartitionDelta secondDelta = this.storage.apply(this.delayedReplacePartitions(offset, length, name, partition));
                this.debugCheck();
                if (this.delayedPartitionDelta != null) {
                    secondDelta.merge(this.delayedPartitionDelta);
                    this.delayedPartitionDelta = null;
                    this.manager.fireDocumentGoingToChange(this.delayedEvent);
                    this.manager.fireRichDocumentEvent(this.delayedEvent, secondDelta);
                    this.delayedEvent = null;
                }
                this.handleEvent(new LayerEvent(this, changedPartitions));
            }
            catch (BadLocationException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            this.fireEvents = true;
        }
    }

    public CompositeChange delayedReplacePartitions(int offset, int length, String name, BasePartition partition) throws BadLocationException {
        this.fireEvents = false;
        this.manager.getEditor().getLineCount();
        this.doc.replace(offset, length, name);
        this.fireEvents = true;
        CompositeChange change = new CompositeChange(this.storage);
        change.removePartitionsFromTo(offset, Math.max(name.length(), length));
        change.addPartitionAtOffset(partition, name.length());
        return change;
    }

    public void setManager(LayerManager layerManager) {
        this.manager = layerManager;
    }

    public PartitionStorage getStorage() {
        return this.storage;
    }

    @Override
    protected ILineAttributeModel getLineAttributeModel() {
        return new ILineAttributeModel(){

            @Override
            public int getLineAlign(int line) {
                int lineAlignment = BasePartitionLayer.this.manager.getEditor().getLineAlignment(line);
                boolean lineJustify = BasePartitionLayer.this.manager.getEditor().getLineJustify(line);
                if (lineJustify) {
                    return 4;
                }
                return lineAlignment;
            }

            @Override
            public void setLineAlign(int startLine, int count, int align) {
                StyledText editor = BasePartitionLayer.this.manager.getEditor();
                int firstLineNum = startLine;
                int lineCount = count + 1;
                if (align == 4) {
                    editor.setLineAlignment(firstLineNum, lineCount, 16384);
                    editor.setLineJustify(firstLineNum, lineCount, true);
                } else {
                    editor.setLineJustify(firstLineNum, lineCount, false);
                    if (align == 16384) {
                        editor.setLineAlignment(firstLineNum, lineCount, align);
                    } else {
                        int lastLine = startLine + count;
                        int i = firstLineNum;
                        while (i <= lastLine) {
                            if (editor.getLineBullet(i) == null) {
                                editor.setLineAlignment(i, 1, align);
                            }
                            ++i;
                        }
                    }
                }
                BasePartitionLayer.this.manager.getEditor().setLineAlignment(startLine, count, align);
            }

            @Override
            public Object getBullet(int line) {
                return BasePartitionLayer.this.manager.getEditor().getLineBullet(line);
            }

            @Override
            public void setLineBullet(int startLine, int count, Object bullet) {
                BasePartitionLayer.this.manager.getEditor().setLineBullet(startLine, count, null);
                BasePartitionLayer.this.manager.getEditor().setLineBullet(startLine, count, (Bullet)bullet);
            }

            @Override
            public int lineCount() {
                return BasePartitionLayer.this.manager.getEditor().getLineCount();
            }
        };
    }

    public void execute(Change setAlignChange) {
        PartitionDelta processChange = this.storage.apply(setAlignChange);
        if (this.fireEvents) {
            this.manager.fireRichDocumentEvent(null, processChange);
        }
        LayerEvent event = new LayerEvent(this, new HashSet<IPartition>(processChange.getChanged()));
        this.handleEvent(event);
    }

    public boolean isFireEvents() {
        return this.fireEvents;
    }

    public void setFireEvents(boolean fireEvents) {
        this.fireEvents = fireEvents;
    }

    public void setIgnoreDocumentEvents(boolean b) {
        this.ignoreEvents = b;
    }

    public int size() {
        return this.storage.size();
    }
}

