/*
 * Decompiled with CFR 0.152.
 */
package com.onpositive.richtexteditor.io.html;

import com.onpositive.richtexteditor.io.TextSerializer;
import com.onpositive.richtexteditor.io.html.ISerializationHelper;
import com.onpositive.richtexteditor.model.FontStyle;
import com.onpositive.richtexteditor.model.LayerManager;
import com.onpositive.richtexteditor.model.partitions.BasePartition;
import com.onpositive.richtexteditor.model.partitions.HRPartition;
import com.onpositive.richtexteditor.model.partitions.ImagePartition;
import com.onpositive.richtexteditor.model.partitions.LinkPartition;
import java.io.PrintWriter;
import java.util.HashMap;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;

public class HTMLSerializer
extends TextSerializer {
    protected static final String BOLD_CLOSE_TAG = "</b>";
    protected static final String ITALIC_CLOSE_TAG = "</i>";
    protected static final String UNDERLINE_CLOSE_TAG = "</u>";
    protected static final String STRIKE_CLOSE_TAG = "</STRIKE>";
    protected static final String STRIKE_OPEN_TAG = "<STRIKE>";
    protected static final String UNDERLINE_OPEN_TAG = "<u>";
    protected static final String ITALIC_OPEN_TAG = "<i>";
    protected static final String BOLD_OPEN_TAG = "<b>";
    protected ISerializationHelper helper;

    public ISerializationHelper getHelper() {
        return this.helper;
    }

    public void setHelper(ISerializationHelper helper) {
        this.helper = helper;
    }

    public HTMLSerializer(LayerManager manager) {
        this.numberedListsEnds = new HashMap();
        this.curLayer = manager.getLayer();
        this.fontRegistry = manager.getFontRegistry();
        this.editor = manager.getEditor();
        this.doc = manager.getDocument();
    }

    @Override
    public void serializeAll(PrintWriter pw) {
        pw.println("<html>");
        pw.println("<body >");
        int i = 0;
        while (i < this.doc.getNumberOfLines()) {
            pw.println(this.getSerializedLine(i));
            ++i;
        }
        pw.println("</body>");
        pw.println("</html>");
        pw.close();
    }

    @Override
    public String applyPartitionStyleToString(BasePartition partition, String partitionText) {
        String prefix;
        if (partition instanceof ImagePartition) {
            return this.getImageStr((ImagePartition)partition);
        }
        if (partition instanceof HRPartition && partitionText.trim().length() > 0) {
            return this.getHRString((HRPartition)partition);
        }
        StringBuilder str = new StringBuilder();
        boolean fontTag = false;
        boolean spanTag = false;
        if (!partition.getFontDataName().equals(FontStyle.NORMAL_FONT_NAME)) {
            str.append(this.getFontStyleOpeningTag(partition));
            spanTag = true;
        }
        if (partition.getColorRGB() != null && !partition.getColorRGB().equals((Object)black)) {
            if (!fontTag) {
                str.append(this.getFontColorTagOpenString());
                fontTag = true;
            }
            str.append(this.getColorStr(partition.getColorRGB()));
        }
        if (partition.getBgColorRGB() != null && !partition.getBgColorRGB().equals((Object)white)) {
            if (!fontTag) {
                str.append(this.getFontColorTagOpenString());
                fontTag = true;
            }
            str.append(this.getBgColorStr(partition.getBgColorRGB()));
        }
        if (fontTag) {
            str.append(this.getTagCloseString());
        }
        if (partition.isBold()) {
            str.append(this.getBoldStartString());
        }
        if (partition.isItalic()) {
            str.append(this.getItalicStartString());
        }
        if (partition.isUnderlined()) {
            str.append(this.getUnderlinedStartString());
        }
        if (partition.isStrikethrough()) {
            str.append(this.getStrikeStartString());
        }
        if (partition instanceof LinkPartition) {
            str.append(this.getLinkStartString((LinkPartition)partition));
        }
        if (this.helper != null && (prefix = this.helper.getAdditionPartitionPrefix(partition)) != null) {
            str.append(prefix);
        }
        str.append(this.encodeStrToHTML(partitionText));
        if (this.helper != null && (prefix = this.helper.getAdditionPartitionSuffix(partition)) != null) {
            str.append(prefix);
        }
        StringBuilder carriageReturn = new StringBuilder();
        int n = str.length() - 1;
        while (n > 0 && (str.charAt(n) == '\n' || str.charAt(n) == '\r')) {
            carriageReturn.append(str.charAt(n));
            str.deleteCharAt(n);
            --n;
        }
        carriageReturn.reverse();
        if (partition instanceof LinkPartition) {
            str.append(this.getLinkEndString());
        }
        if (partition.isStrikethrough()) {
            str.append(this.getStrikeEndString());
        }
        if (partition.isUnderlined()) {
            str.append(this.getUnderlinedEndString());
        }
        if (partition.isItalic()) {
            str.append(this.getItalicEndString());
        }
        if (partition.isBold()) {
            str.append(this.getBoldEndString());
        }
        if (fontTag) {
            str.append(this.getFontColorTagCloseString());
        }
        if (spanTag) {
            str.append(this.getFontStyleClosingTag(partition));
        }
        if (carriageReturn.length() > 0) {
            str.append((CharSequence)carriageReturn);
        }
        return str.toString();
    }

    @Override
    protected String getHRString(HRPartition partition) {
        String str = "<hr";
        if (partition.getColorRGB() != null) {
            str = String.valueOf(str) + this.getColorStr(partition.getColorRGB());
        }
        str = String.valueOf(str) + ">";
        return str;
    }

    protected String encodeStrToHTML(String str) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < str.length()) {
            if (builder.length() != 0 && Character.isWhitespace(builder.charAt(builder.length() - 1)) && str.charAt(i) == ' ') {
                builder.append("&nbsp;");
            } else {
                builder.append(str.charAt(i));
            }
            ++i;
        }
        String str2 = builder.toString();
        str2.replace(" ", "&nbsp;");
        str2.replace("<", "&lt;");
        str2.replace(">", "&gt;");
        str2.replace("&", "&amp;");
        return str2;
    }

    @Override
    protected String getImageStr(ImagePartition partition) {
        String imageFileName = partition.getImageFileName();
        if (this.helper != null) {
            imageFileName = this.helper.getImageLocation(partition);
        }
        return "<IMG src=\"" + imageFileName + "\">";
    }

    protected String getFontFaceStr(String fontDataName) {
        return " face = \"" + this.fontRegistry.get(fontDataName).getFontData()[0].getName() + "\" height = \"" + this.fontRegistry.get(fontDataName).getFontData()[0].getHeight() + "px\"";
    }

    protected String getFontCSSStr(String fontDataName) {
        return " font-family : " + this.fontRegistry.get(fontDataName).getFontData()[0].getName() + ";\n" + " font-size :" + this.fontRegistry.get(fontDataName).getFontData()[0].getHeight() + "px;";
    }

    protected String getBodyFontParametersStr() {
        String str = "<style type=\"text/css\">\n";
        str = String.valueOf(str) + "body\n{\n";
        str = String.valueOf(str) + this.getFontCSSStr(FontStyle.NORMAL_FONT_NAME);
        str = String.valueOf(str) + "}\n</style>\n";
        return str;
    }

    protected String getColorStr(RGB color) {
        return " color = \"" + this.getRGBColorHexStr(color) + "\"";
    }

    protected String getBgColorStr(RGB color) {
        return " style=\"background-color:" + this.getRGBColorHexStr(color) + "\"";
    }

    protected String getRGBColorHexStr(RGB color) {
        String b;
        String g;
        String r = Integer.toHexString(color.red);
        if (r.length() == 1) {
            r = "0" + r;
        }
        if ((g = Integer.toHexString(color.green)).length() == 1) {
            g = "0" + g;
        }
        if ((b = Integer.toHexString(color.blue)).length() == 1) {
            b = "0" + b;
        }
        return "#" + r + g + b;
    }

    @Override
    protected String getCenterAlignAttributeString() {
        return "align = \"center\"";
    }

    @Override
    protected String getFileEndString() {
        return "</body></html>";
    }

    @Override
    protected String getFileStartString() {
        return "<html>\n<body>\n";
    }

    @Override
    protected String getJustifyAlignAttributeString() {
        return "align = \"justify\"";
    }

    @Override
    protected String getLeftAlignAttributeString() {
        return "align = \"left\"";
    }

    @Override
    protected String getLineBreakString() {
        return "<br>";
    }

    @Override
    protected String getParagraphEndString() {
        return "</P>";
    }

    @Override
    protected String getParagraphStartString() {
        return "<P  style=\"margin: 4;\"";
    }

    @Override
    protected String getRightAlignAttributeString() {
        return "align = \"right\"";
    }

    @Override
    protected String getTagCloseString() {
        return ">";
    }

    @Override
    protected String getBulletedListCloseString() {
        return "</ul>";
    }

    @Override
    protected String getBulletedListOpenString() {
        return "<ul>";
    }

    @Override
    protected String getBulletedListElementStartString() {
        return "<li>";
    }

    @Override
    protected String getNumberedListCloseString() {
        return "</ol>";
    }

    @Override
    protected String getNumberedListOpenString() {
        return "<ol>";
    }

    @Override
    protected String getNumberedListElementStartString(String bulletText) {
        return this.getBulletedListElementStartString();
    }

    @Override
    protected String getLinkEndString() {
        return "</A>";
    }

    @Override
    protected String getLinkStartString(LinkPartition partition) {
        LinkPartition linkPartition = partition;
        String url = linkPartition.getUrl();
        if (this.helper != null) {
            url = this.helper.getLinkURL(linkPartition);
        }
        return "<A href = \"" + url + "\">";
    }

    @Override
    protected String getBoldEndString() {
        return BOLD_CLOSE_TAG;
    }

    @Override
    protected String getBoldStartString() {
        return BOLD_OPEN_TAG;
    }

    @Override
    protected String getItalicEndString() {
        return ITALIC_CLOSE_TAG;
    }

    @Override
    protected String getItalicStartString() {
        return ITALIC_OPEN_TAG;
    }

    @Override
    protected String getStrikeEndString() {
        return STRIKE_CLOSE_TAG;
    }

    @Override
    protected String getStrikeStartString() {
        return STRIKE_OPEN_TAG;
    }

    @Override
    protected String getUnderlinedEndString() {
        return UNDERLINE_CLOSE_TAG;
    }

    @Override
    protected String getUnderlinedStartString() {
        return UNDERLINE_OPEN_TAG;
    }

    @Override
    protected String getFontStyleClosingTag(BasePartition partition) {
        return "</span>";
    }

    @Override
    protected String getFontStyleOpeningTag(BasePartition partition) {
        FontData fd = this.fontRegistry.get(partition.getFontDataName()).getFontData()[0];
        return "<span style='font-family:" + fd.getName() + "; font-weight: normal; font-size: " + fd.getHeight() + "pt;' >";
    }

    @Override
    protected String getFontColorTagOpenString() {
        return "<font ";
    }

    @Override
    protected String getFontColorTagCloseString() {
        return "</font>";
    }
}

