/*
 * Decompiled with CFR 0.152.
 */
package com.onpositive.richtexteditor.io;

import com.onpositive.richtexteditor.model.BasePartitionLayer;
import com.onpositive.richtexteditor.model.Logger;
import com.onpositive.richtexteditor.model.partitions.BasePartition;
import com.onpositive.richtexteditor.model.partitions.HRPartition;
import com.onpositive.richtexteditor.model.partitions.ImagePartition;
import com.onpositive.richtexteditor.model.partitions.LinkPartition;
import java.io.PrintWriter;
import java.util.HashMap;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.swt.custom.Bullet;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;

public abstract class TextSerializer {
    protected BasePartitionLayer curLayer = null;
    protected FontRegistry fontRegistry;
    protected StyledText editor;
    protected IDocument doc;
    boolean optimizeParagraphs = false;
    boolean isBulletedList = false;
    boolean isNumberedList = false;
    protected HashMap<Integer, Bullet> numberedListsEnds;
    protected static RGB black = new RGB(0, 0, 0);
    protected static RGB white = new RGB(255, 255, 255);

    public String serializeAllToStr() {
        this.defineNumberedListsEnds();
        String str = "";
        int i = 0;
        while (i < this.doc.getNumberOfLines()) {
            str = String.valueOf(str) + this.getSerializedLine(i) + "\n";
            ++i;
        }
        if (this.isBulletedList) {
            str = String.valueOf(str) + this.getBulletedListCloseString() + " &nbsp;\n";
        }
        if (this.isNumberedList) {
            str = String.valueOf(str) + this.getNumberedListCloseString() + " &nbsp;\n";
        }
        return String.valueOf(this.getFileStartString()) + str + this.getFileEndString();
    }

    public String serializeToStr(Point selection) throws BadLocationException {
        this.defineNumberedListsEnds();
        String str = "";
        int startingPosition = selection.x;
        int endingPosition = selection.y;
        int startLine = this.doc.getLineOfOffset(startingPosition);
        int endLine = this.doc.getLineOfOffset(endingPosition);
        IRegion lineInformation = this.doc.getLineInformation(startLine);
        int length = lineInformation.getOffset() + lineInformation.getLength() - startingPosition;
        if (startLine == endLine) {
            str = String.valueOf(str) + this.getSerializedPartOfLine(startLine, selection.x, selection.y - selection.x, false);
        } else {
            if (length > 0) {
                str = String.valueOf(str) + this.getSerializedPartOfLine(startLine, startingPosition, length, false);
            }
            int i = startLine + 1;
            while (i < endLine) {
                str = String.valueOf(str) + this.getSerializedLine(i) + "\n";
                ++i;
            }
            lineInformation = this.doc.getLineInformation(endLine);
            length = endingPosition - lineInformation.getOffset();
            if (length > 0) {
                str = String.valueOf(str) + this.getSerializedPartOfLine(endLine, lineInformation.getOffset(), length, false);
            }
        }
        return String.valueOf(this.getFileStartString()) + str + this.getFileEndString();
    }

    protected void defineNumberedListsEnds() {
        int i = 0;
        while (i < this.doc.getNumberOfLines()) {
            if (this.editor.getLineBullet(i) != null && this.editor.getLineBullet((int)i).type == 18) {
                Bullet curBullet = this.editor.getLineBullet(i);
                int j = i;
                while (++i < this.doc.getNumberOfLines()) {
                    if (this.editor.getLineBullet(i) != curBullet) continue;
                    j = i;
                }
                i = j + 1;
                this.numberedListsEnds.put(j, curBullet);
            }
            ++i;
        }
    }

    public String getSerializedLine(int lineNum) {
        int offset = 0;
        int length = 0;
        try {
            length = this.doc.getLineLength(lineNum);
            offset = this.doc.getLineOffset(lineNum);
        }
        catch (BadLocationException e) {
            Logger.log(e);
        }
        if (length > 0) {
            return this.getSerializedPartOfLine(lineNum, offset, length, true);
        }
        return "";
    }

    protected String getSerializedPartOfLine(int lineNum, int offset, int length, boolean appendParagraphs) {
        boolean wasBullet = false;
        StringBuilder sb = new StringBuilder();
        if (this.editor.getLineBullet(lineNum) != null) {
            if (this.editor.getLineBullet((int)lineNum).type == 1) {
                if (!this.isBulletedList) {
                    this.isBulletedList = true;
                    sb.append(this.getBulletedListOpenString());
                    if (this.insertNewlinesAfterListStart()) {
                        sb.append("\n");
                    }
                }
                sb.append(this.getBulletedListElementStartString());
                wasBullet = true;
            } else if (this.editor.getLineBullet((int)lineNum).type == 18) {
                if (!this.isNumberedList) {
                    this.isNumberedList = true;
                    sb.append(this.getNumberedListOpenString());
                    if (this.insertNewlinesAfterListStart()) {
                        sb.append("\n");
                    }
                }
                sb.append(this.getNumberedListElementStartString(this.editor.getLineBullet(lineNum).toString()));
                wasBullet = true;
            }
        } else if (this.isBulletedList) {
            if (this.insertNewlinesAfterListStart()) {
                sb.append("\n");
            }
            sb.append(this.getBulletedListCloseString());
            this.isBulletedList = false;
        } else if (this.isNumberedList && this.numberedListsEnds.get(lineNum - 1) != null && this.numberedListsEnds.get((Object)Integer.valueOf((int)(lineNum - 1))).type == 18) {
            if (this.insertNewlinesAfterListStart()) {
                sb.append("\n");
            }
            sb.append(this.getNumberedListCloseString());
            this.isNumberedList = false;
        }
        try {
            if (this.doc.get(this.doc.getLineOffset(lineNum), this.doc.getLineLength(lineNum)).trim().length() == 0) {
                return sb.append(this.getLineBreakString()).toString();
            }
            if (!(!appendParagraphs || this.optimizeParagraphs && lineNum > 0 && this.linesEqualsByParagraphStyle(lineNum, lineNum - 1))) {
                int align = this.editor.getLineAlignment(lineNum);
                sb.append(this.getParagraphStartString());
                if (align == 16384) {
                    if (this.editor.getLineJustify(lineNum)) {
                        sb.append(this.getJustifyAlignAttributeString());
                    } else {
                        sb.append(this.getLeftAlignAttributeString());
                    }
                } else if (align == 131072) {
                    sb.append(this.getRightAlignAttributeString());
                } else if (align == 0x1000000) {
                    sb.append(this.getCenterAlignAttributeString());
                }
                sb.append(this.getTagCloseString());
            }
        }
        catch (BadLocationException e) {
            Logger.log(e);
        }
        BasePartition startPartition = (BasePartition)this.curLayer.getPartitionAtOffset(offset);
        BasePartition endPartition = (BasePartition)this.curLayer.getPartitionAtOffset(offset + length - 1);
        if (startPartition == null) {
            return sb.toString();
        }
        if (startPartition == endPartition) {
            sb.append(this.applyPartitionStyleToString(startPartition, startPartition.getTextRegion(offset, length)));
        } else {
            sb.append(this.applyPartitionStyleToString(startPartition, startPartition.getTextFromOffset(offset)));
            int i = startPartition.getPosition() + 1;
            while (i < endPartition.getPosition()) {
                BasePartition curPartition = this.curLayer.get(i);
                sb.append(this.applyPartitionStyleToString(curPartition, curPartition.getText()));
                ++i;
            }
            sb.append(this.applyPartitionStyleToString(endPartition, endPartition.getTextUpToOffset(offset + length)));
        }
        if (this.optimizeParagraphs && lineNum < this.doc.getNumberOfLines() - 1 && this.editor.getLineAlignment(lineNum) == this.editor.getLineAlignment(lineNum + 1)) {
            sb.append(this.getLineBreakString());
        } else if (appendParagraphs) {
            sb.append(this.getParagraphEndString());
        }
        if (this.deleteExtraNewlinesBeforeListItem() && wasBullet) {
            this.deleteExtraNewlines(sb);
        }
        return sb.toString();
    }

    protected void deleteExtraNewlines(StringBuilder sb) {
        int lastCharIdx;
        int i = lastCharIdx = sb.length() - 1;
        while (i > lastCharIdx - 2 && i > 0 && (sb.charAt(i) == '\n' || sb.charAt(i) == '\r')) {
            sb.deleteCharAt(i);
            --i;
        }
    }

    protected boolean insertNewlinesAfterListStart() {
        return true;
    }

    protected boolean deleteExtraNewlinesBeforeListItem() {
        return false;
    }

    protected abstract String applyPartitionStyleToString(BasePartition var1, String var2);

    protected abstract String getFileStartString();

    protected abstract String getFileEndString();

    protected abstract String getLineBreakString();

    protected abstract String getParagraphStartString();

    protected abstract String getParagraphEndString();

    protected abstract String getLeftAlignAttributeString();

    protected abstract String getRightAlignAttributeString();

    protected abstract String getCenterAlignAttributeString();

    protected abstract String getJustifyAlignAttributeString();

    protected abstract String getTagCloseString();

    protected abstract String getBulletedListOpenString();

    protected abstract String getBulletedListCloseString();

    protected abstract String getNumberedListOpenString();

    protected abstract String getNumberedListCloseString();

    protected abstract String getBulletedListElementStartString();

    protected abstract String getNumberedListElementStartString(String var1);

    protected abstract String getLinkStartString(LinkPartition var1);

    protected abstract String getLinkEndString();

    protected abstract String getBoldStartString();

    protected abstract String getBoldEndString();

    protected abstract String getItalicStartString();

    protected abstract String getItalicEndString();

    protected abstract String getUnderlinedStartString();

    protected abstract String getUnderlinedEndString();

    protected abstract String getStrikeStartString();

    protected abstract String getStrikeEndString();

    protected abstract String getFontColorTagOpenString();

    protected abstract String getFontColorTagCloseString();

    protected abstract String getFontStyleOpeningTag(BasePartition var1);

    protected abstract String getFontStyleClosingTag(BasePartition var1);

    public boolean linesEqualsByParagraphStyle(int line1, int line2) {
        return this.editor.getLineAlignment(line1) == this.editor.getLineAlignment(line2) && this.editor.getLineJustify(line1) == this.editor.getLineJustify(line2);
    }

    public abstract void serializeAll(PrintWriter var1);

    protected abstract String getHRString(HRPartition var1);

    protected abstract String getImageStr(ImagePartition var1);
}

