/*
 * Decompiled with CFR 0.152.
 */
package com.onpositive.richtexteditor.dialogs;

import com.onpositive.richtexteditor.dialogs.NameDialog;
import com.onpositive.richtexteditor.model.FontStyle;
import com.onpositive.richtexteditor.model.resources.ColorManager;
import com.onpositive.richtexteditor.model.resources.DisposableFontRegistry;
import com.onpositive.richtexteditor.model.resources.FontStyleData;
import com.onpositive.richtexteditor.model.resources.FontStyleManager;
import java.util.Iterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class FontConfigurationDialog
extends Dialog
implements SelectionListener,
ISelectionChangedListener,
IPropertyChangeListener {
    protected String dialogTitle = "Customize Font Styles";
    ColorSelector foregroundColorSelector;
    ColorSelector backgroundColorSelector;
    Label foregroundColorLabel;
    Label backgroundColorLabel;
    Label fontFaceLabel;
    protected Button \u00f1olorCheckbox;
    protected Button backgroundColorCheckbox;
    protected Button fontFaceCheckBox;
    protected Button fontFaceSelectButton;
    protected ToolItem addButton;
    protected ToolItem deleteButton;
    protected ToolItem renameButton;
    protected ImageRegistry toolImageRegistry;
    StyledText preview;
    FontStyleData data;
    protected static final RGB RGB_BLACK = new RGB(0, 0, 0);
    protected String addImageString = "ADD_IMAGE";
    protected String deleteImageString = "DELETE_IMAGE";
    protected String renameImageString = "RENAME_IMAGE";
    DisposableFontRegistry fontRegistry;
    ColorManager colorManager;
    protected TableViewer viewer;

    public void create() {
        super.create();
        this.preview.setText("Aa");
        this.preview.setEditable(false);
    }

    protected void fillRegistry() {
        for (FontStyle style : this.data.getFontStyles()) {
            this.fontRegistry.put(style.getFontDataName(), this.data.getParentFontRegistry().get(style.getFontDataName()).getFontData());
        }
    }

    public FontConfigurationDialog(Shell parent, FontStyleManager manager) {
        super(parent);
        this.data = new FontStyleData(manager.getFontStylesList(), (DisposableFontRegistry)manager.getFontRegistry());
        this.colorManager = new ColorManager(parent.getDisplay());
        this.fontRegistry = new DisposableFontRegistry(parent.getDisplay());
        this.fillRegistry();
        this.toolImageRegistry = new ImageRegistry(this.createShell().getDisplay());
        this.toolImageRegistry.put(this.addImageString, new Image((Device)this.createShell().getDisplay(), FontConfigurationDialog.class.getResourceAsStream("add.gif")));
        this.toolImageRegistry.put(this.deleteImageString, new Image((Device)this.createShell().getDisplay(), FontConfigurationDialog.class.getResourceAsStream("delete.gif")));
        this.toolImageRegistry.put(this.renameImageString, new Image((Device)this.createShell().getDisplay(), FontConfigurationDialog.class.getResourceAsStream("rename.gif")));
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(this.dialogTitle);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(4, true);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Composite leftPanel = new Composite(composite, 0);
        leftPanel.setLayout((Layout)new GridLayout(1, true));
        ToolBar bar = new ToolBar(leftPanel, 256);
        this.addButton = this.createToolItem(bar, 8, "", this.toolImageRegistry.get(this.addImageString), this);
        this.deleteButton = this.createToolItem(bar, 8, "", this.toolImageRegistry.get(this.deleteImageString), this);
        this.renameButton = this.createToolItem(bar, 8, "", this.toolImageRegistry.get(this.renameImageString), this);
        this.viewer = new TableViewer(leftPanel, 2048);
        this.viewer.getTable().setLayoutData((Object)new GridData(130, 200));
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.viewer.setContentProvider((IContentProvider)new ViewerContentProvider());
        this.viewer.setInput(this.data.getFontStyles());
        this.viewer.refresh(false, true);
        Group rightPanel = new Group(composite, 32);
        rightPanel.setText("Current style");
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        gridData.verticalAlignment = 1;
        gridData.heightHint = 240;
        rightPanel.setLayoutData((Object)gridData);
        rightPanel.setLayout((Layout)new GridLayout(6, false));
        GridData rGridData = new GridData(768);
        rGridData.horizontalSpan = 4;
        this.createLabel((Composite)rightPanel, "Use colors");
        this.\u00f1olorCheckbox = this.createCheckBox((Composite)rightPanel);
        this.\u00f1olorCheckbox.addSelectionListener((SelectionListener)this);
        Label stub = new Label((Composite)rightPanel, 0);
        stub.setLayoutData((Object)this.getGridDataForHorizontalSpan(4));
        this.foregroundColorLabel = this.createLabel((Composite)rightPanel, "Foreground Color: ");
        this.foregroundColorSelector = new ColorSelector((Composite)rightPanel);
        this.foregroundColorSelector.getButton().setLayoutData((Object)rGridData);
        this.foregroundColorSelector.setColorValue(new RGB(0, 0, 0));
        this.foregroundColorSelector.addListener((IPropertyChangeListener)this);
        new Label((Composite)rightPanel, 0);
        this.backgroundColorLabel = this.createLabel((Composite)rightPanel, "Background Color: ");
        this.backgroundColorSelector = new ColorSelector((Composite)rightPanel);
        this.backgroundColorSelector.getButton().setLayoutData((Object)rGridData);
        this.backgroundColorSelector.setColorValue(new RGB(255, 255, 255));
        this.backgroundColorSelector.addListener((IPropertyChangeListener)this);
        new Label((Composite)rightPanel, 0);
        this.fontFaceLabel = this.createLabel((Composite)rightPanel, "Font Face: ");
        this.fontFaceSelectButton = new Button((Composite)rightPanel, 8);
        this.fontFaceSelectButton.setText("Select...");
        this.fontFaceSelectButton.setLayoutData((Object)rGridData);
        this.fontFaceSelectButton.addSelectionListener((SelectionListener)this);
        new Label((Composite)rightPanel, 0);
        new Label((Composite)rightPanel, 0);
        Group previewGroup = new Group((Composite)rightPanel, 32);
        previewGroup.setLayout((Layout)new GridLayout());
        GridData gd1 = new GridData(470, 90);
        gd1.horizontalSpan = 6;
        previewGroup.setLayoutData((Object)gd1);
        previewGroup.setText("Preview");
        this.preview = new StyledText((Composite)previewGroup, 2048);
        GridData displayData = new GridData(450, 70);
        displayData.horizontalSpan = 6;
        displayData.horizontalAlignment = 0x1000000;
        this.preview.setLayoutData((Object)displayData);
        return composite;
    }

    protected GridData getGridDataForHorizontalSpan(int span) {
        GridData gd = new GridData();
        gd.horizontalSpan = span;
        return gd;
    }

    public boolean close() {
        this.colorManager.dispose();
        this.fontRegistry.dispose();
        return super.close();
    }

    public Button addContentsButton(Composite parent, int style, String text, SelectionListener listener) {
        Button button = new Button(parent, style);
        button.setText(text);
        if (listener != null) {
            button.addSelectionListener(listener);
        }
        return button;
    }

    protected ToolItem createToolItem(ToolBar bar, int style, String text, Image image, SelectionListener listener) {
        ToolItem item = new ToolItem(bar, style);
        item.setText(text);
        if (image != null) {
            item.setImage(image);
        }
        if (listener != null) {
            item.addSelectionListener(listener);
        }
        return item;
    }

    protected Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setText(text);
        return label;
    }

    protected Button createCheckBox(Composite parent) {
        Button checkBox = new Button(parent, 32);
        return checkBox;
    }

    public FontStyleData getData() {
        return this.data;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (event.getSource() == this.viewer) {
            int idx = this.viewer.getTable().getSelectionIndex();
            if (idx == -1 && this.viewer.getTable().getItemCount() > 0) {
                idx = 0;
                this.viewer.getTable().select(idx);
            }
            String selectedName = this.data.getFontStyles().get(idx).getFontDataName();
            this.fontFaceSelectButton.setText(this.fontRegistry.get(selectedName).getFontData()[0].getName());
            FontStyle selectedStyle = this.getSelectedStyle();
            this.\u00f1olorCheckbox.setSelection(false);
            if (selectedStyle.getColor() != null) {
                this.\u00f1olorCheckbox.setSelection(true);
                this.foregroundColorSelector.setColorValue(selectedStyle.getColor());
                this.colorManager.getColor(selectedStyle.getColor());
            } else {
                this.foregroundColorSelector.setColorValue(new RGB(0, 0, 0));
            }
            if (selectedStyle.getBgColor() != null) {
                this.\u00f1olorCheckbox.setSelection(true);
                this.backgroundColorSelector.setColorValue(selectedStyle.getBgColor());
                this.colorManager.getColor(selectedStyle.getBgColor());
            } else {
                this.backgroundColorSelector.setColorValue(new RGB(255, 255, 255));
            }
            this.foregroundColorSelector.setEnabled(this.\u00f1olorCheckbox.getSelection());
            this.backgroundColorSelector.setEnabled(this.\u00f1olorCheckbox.getSelection());
            this.updatePreview();
        }
    }

    protected FontStyle getSelectedStyle() {
        int idx = this.viewer.getTable().getSelectionIndex();
        return this.data.getFontStyles().get(idx);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        String newName;
        if (e.getSource() == this.\u00f1olorCheckbox) {
            this.foregroundColorSelector.setEnabled(this.\u00f1olorCheckbox.getSelection());
            this.backgroundColorSelector.setEnabled(this.\u00f1olorCheckbox.getSelection());
            if (!this.\u00f1olorCheckbox.getSelection()) {
                this.getSelectedStyle().setColor(null);
                this.getSelectedStyle().setBgColor(null);
                this.updatePreview();
            }
        } else if (e.getSource() == this.fontFaceSelectButton) {
            FontDialog dialog = new FontDialog(this.createShell());
            dialog.setFontList(this.fontRegistry.getFontData(this.getSelectedStyle().getFontDataName()));
            dialog.setRGB(this.getSelectedStyle().getColor());
            dialog.open();
            if (dialog.getFontList() != null && !this.fontRegistry.getFontData(this.getSelectedStyle().getFontDataName()).equals(dialog.getFontList())) {
                this.fontRegistry.put(this.getSelectedStyle().getFontDataName(), dialog.getFontList());
                this.fontFaceSelectButton.setText(dialog.getFontList()[0].getName());
                this.data.addChangedStyle(this.getSelectedStyle());
            }
            if (dialog.getRGB() != null && !dialog.getRGB().equals((Object)this.getSelectedStyle().getColor())) {
                this.\u00f1olorCheckbox.setSelection(true);
                this.foregroundColorSelector.setEnabled(true);
                this.foregroundColorSelector.setColorValue(dialog.getRGB());
                this.backgroundColorSelector.setEnabled(true);
                this.getSelectedStyle().setColor(dialog.getRGB());
                this.data.addChangedStyle(this.getSelectedStyle());
            }
            this.updatePreview();
        } else if (e.getSource() == this.addButton) {
            String str = NameDialog.openNameDialog("New style name:", "New style", this.createShell(), null);
            if (str != null) {
                String newIdent = this.getCorrectStyleName(str);
                FontStyle fs = new FontStyle(0, newIdent, str);
                this.data.getFontStyles().add(fs);
                this.fontRegistry.put(newIdent, new FontData[]{new FontData("Times New Roman", 12, 0)});
                this.viewer.setInput(this.data.getFontStyles());
                this.viewer.getTable().select(this.viewer.getTable().getItemCount() - 1);
                this.data.getAddedStyles().add(fs);
                this.updatePreview();
            }
        } else if (e.getSource() == this.deleteButton) {
            if (this.getSelectedStyle().getFontDataName().equals(FontStyleManager.NORMAL_FONT_NAME)) {
                ErrorDialog.openError((Shell)this.createShell(), (String)"Cant delete this style", (String)"Cant delete this style.", (IStatus)new Status(1, "richtexteditor", "Default style cannot be deleted."));
                return;
            }
            this.data.getDeletedStyles().add(this.getSelectedStyle());
            this.data.getFontStyles().remove(this.getSelectedStyle());
            this.viewer.setInput(this.data.getFontStyles());
            this.viewer.getTable().select(this.viewer.getTable().getItemCount() - 1);
            this.updatePreview();
        } else if (e.getSource() == this.renameButton && (newName = NameDialog.openNameDialog("New style name:", "Rename style", this.createShell(), this.getSelectedStyle().getDisplayName())) != null && !newName.trim().equals("")) {
            this.getSelectedStyle().setDisplayName(newName.trim());
            this.data.getAddedStyles().add(this.getSelectedStyle());
            this.viewer.setInput(this.data.getFontStyles());
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getSource() == this.foregroundColorSelector && this.foregroundColorSelector.getColorValue() != null && !this.foregroundColorSelector.getColorValue().equals((Object)this.getSelectedStyle().getColor())) {
            RGB color = this.foregroundColorSelector.getColorValue();
            this.\u00f1olorCheckbox.setSelection(true);
            this.getSelectedStyle().setColor(color);
            this.data.addChangedStyle(this.getSelectedStyle());
            this.updatePreview();
        } else if (event.getSource() == this.backgroundColorSelector && this.backgroundColorSelector.getColorValue() != null && !this.backgroundColorSelector.getColorValue().equals((Object)this.getSelectedStyle().getBgColor())) {
            RGB color = this.backgroundColorSelector.getColorValue();
            this.\u00f1olorCheckbox.setSelection(true);
            this.getSelectedStyle().setBgColor(color);
            this.data.addChangedStyle(this.getSelectedStyle());
            this.updatePreview();
        }
    }

    protected void updatePreview() {
        this.preview.setLineAlignment(0, 1, 0x1000000);
        FontStyle selectedStyle = this.getSelectedStyle();
        Color fgColor = null;
        Color bgColor = null;
        if (selectedStyle.getColor() != null) {
            fgColor = this.colorManager.getColor(selectedStyle.getColor());
        }
        if (selectedStyle.getBgColor() != null) {
            bgColor = this.colorManager.getColor(selectedStyle.getBgColor());
        }
        StyleRange range = new StyleRange(0, 2, fgColor, bgColor);
        range.font = this.fontRegistry.get(selectedStyle.getFontDataName());
        this.preview.setStyleRange(range);
        this.preview.redraw();
    }

    protected String getCorrectStyleName(String displayName) {
        String resStr = "";
        resStr = Character.isJavaIdentifierStart((displayName = displayName.trim()).charAt(0)) ? String.valueOf(resStr) + displayName.charAt(0) : String.valueOf(resStr) + "_";
        int i = 1;
        while (i < displayName.length()) {
            if (Character.isJavaIdentifierPart(displayName.charAt(i))) {
                resStr = String.valueOf(resStr) + displayName.charAt(i);
            }
            ++i;
        }
        if (resStr.length() < 2) {
            resStr = String.valueOf(resStr) + "style";
        }
        return this.checkForEqualStyleNames(resStr);
    }

    protected String checkForEqualStyleNames(String resStr) {
        boolean needToBeChanged = false;
        do {
            needToBeChanged = false;
            Iterator<FontStyle> iterator = this.data.getFontStyles().iterator();
            while (iterator.hasNext()) {
                String name = iterator.next().getFontDataName();
                if (!name.equals(resStr)) continue;
                needToBeChanged = true;
            }
            if (!needToBeChanged) continue;
            resStr = String.valueOf(resStr) + "1";
        } while (needToBeChanged);
        return resStr;
    }

    protected void okPressed() {
        this.data.setResultFontRegistry(this.fontRegistry);
        super.okPressed();
    }

    public int open() {
        this.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this.viewer, new ISelection(){

            public boolean isEmpty() {
                return true;
            }
        }));
        return super.open();
    }

    protected class ViewerContentProvider
    implements IStructuredContentProvider {
        protected ViewerContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return FontConfigurationDialog.this.data.getFontStyles().toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

