/*
 * Decompiled with CFR 0.152.
 */
package com.onpositive.richtexteditor.actions;

import com.onpositive.richtexteditor.actions.BackGroundColorAction;
import com.onpositive.richtexteditor.actions.ForeGroundColorAction;
import com.onpositive.richtexteditor.dialogs.FontConfigurationDialog;
import com.onpositive.richtexteditor.dialogs.HyperlinkDialog;
import com.onpositive.richtexteditor.model.FontStyle;
import com.onpositive.richtexteditor.model.FontStylesChangeListener;
import com.onpositive.richtexteditor.model.LayerManager;
import com.onpositive.richtexteditor.model.RichSelectionState;
import com.onpositive.richtexteditor.model.partitions.BasePartition;
import com.onpositive.richtexteditor.model.resources.FontStyleData;
import com.onpositive.richtexteditor.viewer.IRichDocumentListener;
import com.onpositive.richtexteditor.viewer.undo.RichDocumentChange;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.ToolBar;

public class ActionFactory
implements ISelectionChangedListener,
IRichDocumentListener {
    private static final String FULL_JUSTIFY_IMAGE = "full-justify";
    private static final String RIGHT_JUSTIFY_IMAGE = "right-justify";
    private static final String CENTER_JUSTIFY_IMAGE = "center-justify";
    private static final String LEFT_JUSTIFY_IMAGE = "left-justify";
    private static final String LINK_IMAGE = "link";
    private static final String UNDERLINE_IMAGE = "underline";
    private static final String ITALIC_IMAGE = "italic";
    private static final String BOLD_IMAGE = "bold";
    private static final String BULLETS_IMAGE = "bullets";
    private static final String NUMBERS_IMAGE = "numbers";
    private static final String STRIKE_IMAGE = "strike";
    private static final String ADD_IMAGE_IMAGE = "image";
    private static final String ADD_REGION_IMAGE = "region";
    private static final String ADD_JAVA_REGION_IMAGE = "java_region";
    private static final String OPEN_IMAGE_IMAGE = "open";
    private static final String ADD_HR_IMAGE = "hr";
    private static final String CUSTOMIZE_FONT_STYLES_IMAGE = "customize_font";
    private IAction boldAction;
    private IAction italicAction;
    private CCombo combo;
    protected LayerManager manager;
    protected ITextViewer viewer;
    private IAction underlineAction;
    private IAction strikeThroughAction;
    private IAction linkAction;
    private IAction leftAlignAction;
    private AlignAction rightAlignAction;
    private IAction centerAlignAction;
    private IAction fillAlignAction;
    private IAction bulletedListAction;
    private IAction numberedListAction;
    private IAction foregroundColorAction;
    private IAction backgroundColorAction;
    private IAction addImageAction;
    private IAction addRegionAction;
    private IAction addJavaRegionAction;
    private IAction openFileAction;
    private IAction addHRAction;
    private IAction customizeFontStyleAction;
    private ControlContribution controlContribution;

    public IAction getForegroundColorAction() {
        if (this.foregroundColorAction == null) {
            this.foregroundColorAction = new ForeGroundColorAction(this.manager);
        }
        return this.foregroundColorAction;
    }

    public IAction getBackgroundColorAction() {
        if (this.backgroundColorAction == null) {
            this.backgroundColorAction = new BackGroundColorAction(this.manager);
        }
        return this.backgroundColorAction;
    }

    public ActionFactory(LayerManager manager, ITextViewer viewer) {
        this.manager = manager;
        this.viewer = viewer;
        TextViewer tv = (TextViewer)viewer;
        tv.addPostSelectionChangedListener((ISelectionChangedListener)this);
    }

    public ActionFactory() {
    }

    public void delayedConfigure(LayerManager manager, ITextViewer viewer) {
        this.manager = manager;
        this.viewer = viewer;
        TextViewer tv = (TextViewer)viewer;
        tv.addPostSelectionChangedListener((ISelectionChangedListener)this);
    }

    public LayerManager getManager() {
        return this.manager;
    }

    public void setManager(LayerManager manager) {
        this.manager = manager;
    }

    public IAction getBoldAction() {
        if (this.boldAction == null) {
            this.boldAction = new Action("", 2){

                public void run() {
                    if (ActionFactory.this.viewer.getSelectedRange().y > 0) {
                        ActionFactory.this.manager.boldCommand(ActionFactory.this.viewer.getSelectedRange().x, ActionFactory.this.viewer.getSelectedRange().y, this.isChecked());
                    } else {
                        ActionFactory.this.setCurrentBasePartitionState();
                    }
                }
            };
            this.boldAction.setText("Bold");
            this.boldAction.setImageDescriptor(this.getImageDescriptor(BOLD_IMAGE));
        }
        return this.boldAction;
    }

    public IAction getItalicAction() {
        if (this.italicAction == null) {
            this.italicAction = new Action("", 2){

                public void run() {
                    if (ActionFactory.this.viewer.getSelectedRange().y > 0) {
                        ActionFactory.this.manager.italicCommand(ActionFactory.this.viewer.getSelectedRange().x, ActionFactory.this.viewer.getSelectedRange().y, this.isChecked());
                    } else {
                        ActionFactory.this.setCurrentBasePartitionState();
                    }
                }
            };
            this.italicAction.setText("Italic");
            this.italicAction.setImageDescriptor(this.getImageDescriptor(ITALIC_IMAGE));
        }
        return this.italicAction;
    }

    public IAction getUnderlineAction() {
        if (this.underlineAction == null) {
            this.underlineAction = new Action("", 2){

                public void run() {
                    if (ActionFactory.this.viewer.getSelectedRange().y > 0) {
                        ActionFactory.this.manager.underlineCommand(ActionFactory.this.viewer.getSelectedRange().x, ActionFactory.this.viewer.getSelectedRange().y, this.isChecked());
                    } else {
                        ActionFactory.this.setCurrentBasePartitionState();
                    }
                }
            };
            this.underlineAction.setText("Underline");
            this.underlineAction.setImageDescriptor(this.getImageDescriptor(UNDERLINE_IMAGE));
        }
        return this.underlineAction;
    }

    public IAction getAddImageAction() {
        if (this.addImageAction == null) {
            this.addImageAction = new Action(){

                public void run() {
                    FileDialog dialog = new FileDialog(ActionFactory.this.viewer.getTextWidget().getShell());
                    dialog.setFilterExtensions(new String[]{"*.gif", "*.jpg", "*.png", "*.bmp"});
                    String filename = dialog.open();
                    if (filename != null) {
                        ActionFactory.this.manager.addNewImage(filename);
                    }
                }
            };
            this.addImageAction.setText("insert image");
            this.addImageAction.setImageDescriptor(this.getImageDescriptor(ADD_IMAGE_IMAGE));
        }
        return this.addImageAction;
    }

    public IAction getAddRegionAction() {
        if (this.addRegionAction == null) {
            this.addRegionAction = new Action(){

                public void run() {
                    ActionFactory.this.manager.addNewRegion();
                }
            };
            this.addRegionAction.setText("insert text region");
            this.addRegionAction.setImageDescriptor(this.getImageDescriptor(ADD_REGION_IMAGE));
        }
        return this.addRegionAction;
    }

    public IAction getAddHRAction() {
        if (this.addHRAction == null) {
            this.addHRAction = new Action(){

                public void run() {
                    ActionFactory.this.manager.addNewHR();
                }
            };
            this.addHRAction.setText("insert hr");
            this.addHRAction.setImageDescriptor(this.getImageDescriptor(ADD_HR_IMAGE));
        }
        return this.addHRAction;
    }

    public IAction getOpenFileAction() {
        if (this.openFileAction == null) {
            this.openFileAction = new Action(){

                public void run() {
                    FileDialog dialog = new FileDialog(ActionFactory.this.viewer.getTextWidget().getShell());
                    dialog.setFilterExtensions(new String[]{"*.html", "*.htm"});
                    String filename = dialog.open();
                    if (filename != null) {
                        ActionFactory.this.manager.openHTMLFile(filename);
                    }
                }
            };
            this.openFileAction.setImageDescriptor(this.getImageDescriptor(OPEN_IMAGE_IMAGE));
            this.openFileAction.setText("Open");
        }
        return this.openFileAction;
    }

    public IAction getNewLinkAction() {
        if (this.linkAction == null) {
            this.linkAction = new Action("", 2){

                public void run() {
                    int offset = ActionFactory.this.viewer.getSelectedRange().x;
                    int length = ActionFactory.this.viewer.getSelectedRange().y;
                    if (ActionFactory.this.viewer.getTextWidget().getText().length() > 0 && ActionFactory.this.manager.defineSumStylePartition(offset, length).isHasLinks()) {
                        this.setChecked(true);
                        return;
                    }
                    HyperlinkDialog hyperlinkDialog = new HyperlinkDialog(ActionFactory.this.viewer.getTextWidget().getShell());
                    hyperlinkDialog.create();
                    String name = ActionFactory.this.viewer.getTextWidget().getSelectionText();
                    int selOffset = ActionFactory.this.viewer.getTextWidget().getSelection().x;
                    String url = ActionFactory.this.manager.getLayer().getSummaryUrl(ActionFactory.this.viewer.getSelectedRange().x, ActionFactory.this.viewer.getSelectedRange().y);
                    hyperlinkDialog.setName(name);
                    hyperlinkDialog.setUrl(url);
                    this.setChecked(false);
                    int retCode = hyperlinkDialog.open();
                    if (retCode == 0) {
                        if (!name.equals(hyperlinkDialog.getName())) {
                            ActionFactory.this.viewer.getTextWidget().setFocus();
                        }
                        ActionFactory.this.manager.insertLinkPartititon(ActionFactory.this.viewer.getSelectedRange(), hyperlinkDialog.getName(), hyperlinkDialog.getUrl());
                        ActionFactory.this.viewer.setSelectedRange(selOffset, hyperlinkDialog.getName().length());
                    }
                }
            };
            this.linkAction.setText("New Hyperlink");
            this.linkAction.setImageDescriptor(this.getImageDescriptor(LINK_IMAGE));
        }
        return this.linkAction;
    }

    public IAction getCustomizeFontStyleAction() {
        if (this.customizeFontStyleAction == null) {
            this.customizeFontStyleAction = new Action("", 1){

                public void run() {
                    FontConfigurationDialog configurationDialog = new FontConfigurationDialog(ActionFactory.this.viewer.getTextWidget().getShell(), ActionFactory.this.manager.getFontStyleManager());
                    configurationDialog.create();
                    int retCode = configurationDialog.open();
                    if (retCode == 0) {
                        ArrayList<FontStyle> changedStylesList;
                        FontStyleData data = configurationDialog.getData();
                        if (data.getDeletedStyles().size() > 0) {
                            ArrayList<FontStyle> usedStyles = new ArrayList<FontStyle>();
                            for (FontStyle deletedStyle : data.getDeletedStyles()) {
                                if (!ActionFactory.this.manager.isStyleUsed(deletedStyle)) continue;
                                usedStyles.add(deletedStyle);
                            }
                            if (usedStyles.size() > 0) {
                                String namesList = "";
                                Iterator iterator = usedStyles.iterator();
                                while (iterator.hasNext()) {
                                    namesList = String.valueOf(namesList) + ((FontStyle)iterator.next()).getDisplayName() + ",";
                                }
                                boolean res = MessageDialog.openQuestion(null, (String)"Styles is in use", (String)("Foolowing styles is in use: " + namesList + ". Delete them and replace with default style in text?"));
                                if (res) {
                                    Iterator iterator2 = usedStyles.iterator();
                                    while (iterator2.hasNext()) {
                                        ActionFactory.this.manager.removeStyleFromAllPartitions((FontStyle)iterator2.next());
                                    }
                                } else {
                                    data.getFontStyles().addAll(usedStyles);
                                }
                            }
                        }
                        if ((changedStylesList = data.validateChangedStyles(ActionFactory.this.manager.getFontStyleManager())).size() > 0 || data.getAddedStyles().size() > 0 || data.getDeletedStyles().size() > 0) {
                            ActionFactory.this.manager.getFontStyleManager().reinit(data.getFontStyles(), data.getResultFontRegistry(), changedStylesList);
                        }
                    }
                }
            };
            this.manager.getFontStyleManager().addFontStyleChangeListener(new FontStylesChangeListener(){

                @Override
                public void stylesChanged(ArrayList<FontStyle> changedStyles) {
                    ActionFactory.this.combo.setItems(ActionFactory.this.manager.getFontStyleManager().getFontStyleDisplayNames());
                    ActionFactory.this.combo.setText(ActionFactory.this.manager.getFontStyleManager().getDefaultStyle().getDisplayName());
                }
            });
            this.customizeFontStyleAction.setText("Customize Font Styles");
            this.customizeFontStyleAction.setImageDescriptor(this.getImageDescriptor(CUSTOMIZE_FONT_STYLES_IMAGE));
        }
        return this.customizeFontStyleAction;
    }

    public IContributionItem getStyleContributionItem() {
        if (this.controlContribution == null) {
            this.controlContribution = new ControlContribution("style"){

                protected Control createControl(Composite parent) {
                    ActionFactory.this.combo = new CCombo(parent, 2056);
                    ActionFactory.this.combo.setItems(ActionFactory.this.manager.getFontStyleManager().getFontStyleDisplayNames());
                    ActionFactory.this.combo.setText(ActionFactory.this.manager.getFontStyleManager().getDefaultStyle().getDisplayName());
                    ActionFactory.this.combo.addSelectionListener(new SelectionListener(){

                        public void widgetDefaultSelected(SelectionEvent e) {
                        }

                        public void widgetSelected(SelectionEvent e) {
                            if (ActionFactory.this.combo.getSelectionIndex() > -1) {
                                if ((this).ActionFactory.this.viewer.getSelectedRange().y > 0) {
                                    (this).ActionFactory.this.manager.changeFontCommand(ActionFactory.this.combo.getItem(ActionFactory.this.combo.getSelectionIndex()), (this).ActionFactory.this.viewer.getSelectedRange().x, (this).ActionFactory.this.viewer.getSelectedRange().y);
                                    (this).ActionFactory.this.viewer.getTextWidget().setFocus();
                                } else {
                                    ActionFactory.this.setCurrentBasePartitionState();
                                    (this).ActionFactory.this.viewer.getTextWidget().setFocus();
                                }
                            }
                        }
                    });
                    return ActionFactory.this.combo;
                }
            };
        }
        return this.controlContribution;
    }

    public IAction getAlignLeftAction() {
        if (this.leftAlignAction == null) {
            this.leftAlignAction = new AlignAction(16384);
            this.leftAlignAction.setText("Align Left");
            this.leftAlignAction.setImageDescriptor(this.getImageDescriptor(LEFT_JUSTIFY_IMAGE));
        }
        return this.leftAlignAction;
    }

    public IAction getAlignRightAction() {
        if (this.rightAlignAction == null) {
            this.rightAlignAction = new AlignAction(131072);
            this.rightAlignAction.setText("Align Right");
            this.rightAlignAction.setImageDescriptor(this.getImageDescriptor(RIGHT_JUSTIFY_IMAGE));
        }
        return this.rightAlignAction;
    }

    public IAction getAlignCenterAction() {
        if (this.centerAlignAction == null) {
            this.centerAlignAction = new AlignAction(0x1000000);
            this.centerAlignAction.setText("Align Center");
            this.centerAlignAction.setImageDescriptor(this.getImageDescriptor(CENTER_JUSTIFY_IMAGE));
        }
        return this.centerAlignAction;
    }

    public IAction getAlignJustifyAction() {
        if (this.fillAlignAction == null) {
            this.fillAlignAction = new AlignAction(4);
            this.fillAlignAction.setText("Align Justify");
            this.fillAlignAction.setImageDescriptor(this.getImageDescriptor(FULL_JUSTIFY_IMAGE));
        }
        return this.fillAlignAction;
    }

    public IAction getBulletedListAction() {
        if (this.bulletedListAction == null) {
            this.bulletedListAction = new ListAction(5);
            this.bulletedListAction.setText("Bulleted List");
            this.bulletedListAction.setImageDescriptor(this.getImageDescriptor(BULLETS_IMAGE));
        }
        return this.bulletedListAction;
    }

    public IAction getNumberedListAction() {
        if (this.numberedListAction == null) {
            this.numberedListAction = new ListAction(6);
            this.numberedListAction.setText("numbered List");
            this.numberedListAction.setImageDescriptor(this.getImageDescriptor(NUMBERS_IMAGE));
        }
        return this.numberedListAction;
    }

    public void fillToolbarManager(IContributionManager toolbarManager) {
        ArrayList<IContributionItem> itemsList = this.createActionsList();
        for (IContributionItem contributionItem : itemsList) {
            toolbarManager.add(contributionItem);
        }
    }

    public ArrayList<IContributionItem> createActionsList() {
        ArrayList<IContributionItem> resList = new ArrayList<IContributionItem>();
        resList.add((IContributionItem)new ActionContributionItem(this.getBoldAction()));
        resList.add((IContributionItem)new ActionContributionItem(this.getItalicAction()));
        resList.add((IContributionItem)new ActionContributionItem(this.getUnderlineAction()));
        resList.add((IContributionItem)new ActionContributionItem(this.getStrikeThroughAction()));
        resList.add((IContributionItem)new Separator());
        resList.add(this.getStyleContributionItem());
        resList.add((IContributionItem)new Separator());
        resList.add((IContributionItem)new ActionContributionItem(this.getAlignLeftAction()));
        resList.add((IContributionItem)new ActionContributionItem(this.getAlignRightAction()));
        resList.add((IContributionItem)new ActionContributionItem(this.getAlignCenterAction()));
        resList.add((IContributionItem)new ActionContributionItem(this.getAlignJustifyAction()));
        resList.add((IContributionItem)new Separator());
        resList.add((IContributionItem)new ActionContributionItem(this.getNewLinkAction()));
        resList.add((IContributionItem)new Separator());
        resList.add((IContributionItem)new ActionContributionItem(this.getBulletedListAction()));
        resList.add((IContributionItem)new ActionContributionItem(this.getNumberedListAction()));
        resList.add((IContributionItem)new Separator());
        resList.add((IContributionItem)new ControlContribution(""){

            protected Control createControl(Composite parent) {
                ToolBar toolbar = new ToolBar(parent, 0);
                ToolBarManager ma = new ToolBarManager(toolbar);
                ma.add(ActionFactory.this.getForegroundColorAction());
                ma.add((IContributionItem)new Separator());
                ma.add(ActionFactory.this.getBackgroundColorAction());
                ma.update(true);
                return ma.getControl();
            }
        });
        resList.add((IContributionItem)new Separator());
        resList.add((IContributionItem)new ActionContributionItem(this.getAddImageAction()));
        resList.add((IContributionItem)new ActionContributionItem(this.getAddRegionAction()));
        resList.add((IContributionItem)new Separator());
        resList.add((IContributionItem)new ActionContributionItem(this.getOpenFileAction()));
        resList.add((IContributionItem)new Separator());
        resList.add((IContributionItem)new ActionContributionItem(this.getAddHRAction()));
        resList.add((IContributionItem)new ActionContributionItem(this.getCustomizeFontStyleAction()));
        return resList;
    }

    public void customFillToolbarManager(IContributionManager toolbarManager, List<IContributionItem> items) {
        for (IContributionItem item : items) {
            toolbarManager.add(item);
        }
    }

    public IAction getStrikeThroughAction() {
        if (this.strikeThroughAction == null) {
            this.strikeThroughAction = new Action("", 2){

                public void run() {
                    if (ActionFactory.this.viewer.getSelectedRange().y > 0) {
                        ActionFactory.this.manager.strikethroughCommand(ActionFactory.this.viewer.getSelectedRange().x, ActionFactory.this.viewer.getSelectedRange().y, this.isChecked());
                    } else {
                        ActionFactory.this.setCurrentBasePartitionState();
                    }
                }
            };
            this.strikeThroughAction.setText("Strike through");
            this.strikeThroughAction.setImageDescriptor(this.getImageDescriptor(STRIKE_IMAGE));
        }
        return this.strikeThroughAction;
    }

    protected ImageDescriptor getImageDescriptor(String strikeImage) {
        return null;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        int offset = this.manager.getEditor().getCaretOffset();
        BasePartition curPartition = (BasePartition)this.manager.getLayer().getPartitionAtOffset(offset);
        if (curPartition != null && curPartition.requiresSingleLine() && offset > curPartition.getOffset()) {
            this.manager.getEditor().setCaretOffset(curPartition.getOffset() + curPartition.getLength());
        }
        this.manager.setCurrentFontPartition(null);
        this.update();
    }

    private void update() {
        if (this.viewer.getTextWidget().getText().length() < 1) {
            return;
        }
        int offset = this.viewer.getSelectedRange().x;
        int length = this.viewer.getSelectedRange().y;
        int firstLine = this.viewer.getTextWidget().getLineAtOffset(offset);
        int lastLine = length == 0 ? firstLine : this.viewer.getTextWidget().getLineAtOffset(offset + length - 1);
        RichSelectionState sumPartition = this.manager.defineSumStylePartition(offset, length);
        this.setFontStyleControlsStates(sumPartition);
        int align = this.manager.defineSumAlignStyle(firstLine, lastLine);
        this.setAlignButtonsStates(align);
        this.setListButtonsStates(this.manager.defineSumListStyle(firstLine, lastLine));
    }

    protected void setCurrentBasePartitionState() {
        BasePartition partition = this.manager.getCurrentFontPartition();
        partition.setBold(this.getBoldAction().isChecked());
        partition.setItalic(this.getItalicAction().isChecked());
        partition.setUnderlined(this.getUnderlineAction().isChecked());
        partition.setStrikethrough(this.getStrikeThroughAction().isChecked());
        int selectionIndex = this.combo.getSelectionIndex();
        if (selectionIndex > -1) {
            String item = this.combo.getItem(selectionIndex);
            this.manager.addNewlinesIfNeeded(this.viewer.getTextWidget().getCaretOffset(), item);
            this.manager.getFontStyleManager().getFontStyleByFontDataName(partition.getFontDataName()).removeStyle(partition);
            this.manager.getFontStyleManager().getFontStyle(item).applyStyle(partition);
            this.combo.select(selectionIndex);
        }
    }

    protected void setCurrentBasePartitionFontStyleState() {
    }

    protected void setAlignButtonsStates(int align) {
        if (this.centerAlignAction != null) {
            this.getAlignCenterAction().setChecked(align == 0x1000000);
        }
        if (this.leftAlignAction != null) {
            this.getAlignLeftAction().setChecked(align == 16384);
        }
        if (this.rightAlignAction != null) {
            this.getAlignRightAction().setChecked(align == 131072);
        }
        if (this.fillAlignAction != null) {
            this.getAlignJustifyAction().setChecked(align == 4);
        }
    }

    protected void setListButtonsStates(int style) {
        boolean wasChecked = false;
        if (this.bulletedListAction != null) {
            this.bulletedListAction.setChecked(style == 5);
            if (this.bulletedListAction.isChecked()) {
                wasChecked = true;
            }
        }
        if (this.numberedListAction != null) {
            this.numberedListAction.setChecked(style == 6);
            if (this.numberedListAction.isChecked()) {
                wasChecked = true;
            }
        }
        this.enableProhibitedAligns(!wasChecked);
    }

    protected void setFontStyleControlsStates(RichSelectionState state) {
        BasePartition sumPartition = state.getSumPartition();
        if (this.boldAction != null) {
            this.getBoldAction().setChecked(sumPartition.isBold());
        }
        if (this.italicAction != null) {
            this.getItalicAction().setChecked(sumPartition.isItalic());
        }
        if (this.underlineAction != null) {
            this.getUnderlineAction().setChecked(sumPartition.isUnderlined());
        }
        if (this.strikeThroughAction != null) {
            this.getStrikeThroughAction().setChecked(sumPartition.isStrikethrough());
        }
        if (this.foregroundColorAction != null) {
            ((ForeGroundColorAction)this.getForegroundColorAction()).setColor(sumPartition.getColorRGB());
        }
        if (this.backgroundColorAction != null) {
            ((BackGroundColorAction)this.getBackgroundColorAction()).setColor(sumPartition.getBgColorRGB());
        }
        if (this.linkAction != null) {
            this.linkAction.setChecked(state.isHasLinks());
        }
        if (this.controlContribution != null) {
            if (sumPartition.getFontDataName().length() > 0) {
                String[] fontStyleNames = this.manager.getFontStyleManager().getFontStyleDataNames();
                boolean wasSelected = false;
                int i = 0;
                while (i < fontStyleNames.length) {
                    if (fontStyleNames[i].equals(sumPartition.getFontDataName())) {
                        this.combo.select(i);
                        i = fontStyleNames.length;
                        wasSelected = true;
                    }
                    ++i;
                }
                if (!wasSelected) {
                    this.combo.select(-1);
                }
            } else {
                this.combo.select(-1);
            }
        }
    }

    protected void enableProhibitedAligns(boolean enable) {
        if (this.centerAlignAction != null) {
            this.centerAlignAction.setEnabled(enable);
        }
        if (this.rightAlignAction != null) {
            this.rightAlignAction.setEnabled(enable);
        }
    }

    @Override
    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    @Override
    public void documentChanged(DocumentEvent event, RichDocumentChange change) {
        this.update();
    }

    private final class AlignAction
    extends Action {
        private int style;

        public AlignAction(int style) {
            super("", 8);
            this.style = style;
        }

        public void run() {
            this.disableAllOther();
            ActionFactory.this.manager.setIntervalAlign(ActionFactory.this.viewer.getSelectedRange().x, ActionFactory.this.viewer.getSelectedRange().y, this.style);
        }

        protected void disableAllOther() {
            if (ActionFactory.this.centerAlignAction != null && ActionFactory.this.centerAlignAction != this) {
                ActionFactory.this.centerAlignAction.setChecked(false);
            }
            if (ActionFactory.this.leftAlignAction != null && ActionFactory.this.leftAlignAction != this) {
                ActionFactory.this.leftAlignAction.setChecked(false);
            }
            if (ActionFactory.this.rightAlignAction != null && ActionFactory.this.rightAlignAction != this) {
                ActionFactory.this.rightAlignAction.setChecked(false);
            }
            if (ActionFactory.this.fillAlignAction != null && ActionFactory.this.fillAlignAction != this) {
                ActionFactory.this.fillAlignAction.setChecked(false);
            }
        }
    }

    private final class ListAction
    extends Action {
        protected int style;

        public ListAction(int style) {
            super("", 2);
            this.style = style;
        }

        public void run() {
            this.disableAllOtherListButtons();
            if (this.isChecked()) {
                ActionFactory.this.manager.setIntervalList(ActionFactory.this.viewer.getSelectedRange().x, ActionFactory.this.viewer.getSelectedRange().y, this.style);
                ActionFactory.this.enableProhibitedAligns(false);
            } else {
                ActionFactory.this.manager.setIntervalList(ActionFactory.this.viewer.getSelectedRange().x, ActionFactory.this.viewer.getSelectedRange().y, 0);
                ActionFactory.this.enableProhibitedAligns(true);
            }
        }

        protected void disableAllOtherListButtons() {
            if (ActionFactory.this.bulletedListAction != null && ActionFactory.this.bulletedListAction != this) {
                ActionFactory.this.bulletedListAction.setChecked(false);
            }
            if (ActionFactory.this.numberedListAction != null && ActionFactory.this.numberedListAction != this) {
                ActionFactory.this.numberedListAction.setChecked(false);
            }
        }
    }
}

