/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import org.hsqldb.Database;
import org.hsqldb.error.Error;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.DataFileBlockManager;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.ScaledRAFile;

public class DataFileCacheSession
extends DataFileCache {
    public int storeCount;

    public DataFileCacheSession(Database db, String baseFileName) {
        super(db, baseFileName);
    }

    @Override
    protected void initParams(Database database, String baseFileName) {
        this.dataFileName = baseFileName + ".data.tmp";
        this.database = database;
        this.fa = FileUtil.getFileUtil();
        int cacheSizeScale = 10;
        this.cacheFileScale = 8;
        Error.printSystemOut("cache_size_scale: " + cacheSizeScale);
        this.maxCacheRows = 2048;
        int avgRowBytes = 1 << cacheSizeScale;
        this.maxCacheBytes = this.maxCacheRows * avgRowBytes;
        this.maxDataFileSize = 0x1FFFFFFFCL;
        this.dataFile = null;
    }

    @Override
    public void open(boolean readonly) {
        try {
            this.dataFile = ScaledRAFile.newScaledRAFile(this.database, this.dataFileName, false, 0, null, null);
            this.fileFreePosition = 32L;
            this.initBuffers();
            this.freeBlocks = new DataFileBlockManager(0, this.cacheFileScale, 0L);
        }
        catch (Throwable t) {
            this.database.logger.logWarningEvent("Failed to open RA file", t);
            this.close(false);
            throw Error.error(t, 29, 210, new Object[]{t.getMessage(), this.dataFileName});
        }
    }

    @Override
    public synchronized void add(CachedObject object) {
        super.add(object);
    }

    @Override
    public synchronized void close(boolean write) {
        try {
            if (this.dataFile != null) {
                this.dataFile.close();
                this.dataFile = null;
                this.fa.removeElement(this.dataFileName);
            }
        }
        catch (Throwable t) {
            this.database.logger.logWarningEvent("Failed to close RA file", t);
            throw Error.error(t, 29, 211, new Object[]{t.getMessage(), this.dataFileName});
        }
    }

    void postClose(boolean keep) {
    }

    public void clear() {
        this.cache.clear();
        this.fileFreePosition = 32L;
    }

    public void deleteAll() {
        this.cache.clear();
        this.fileFreePosition = 32L;
        this.initBuffers();
    }
}

