/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.util.NoSuchElementException;

public class LongDeque {
    private long[] list = new long[10];
    private int firstindex = 0;
    private int endindex = 0;
    protected int elementCount;
    private static final int DEFAULT_INITIAL_CAPACITY = 10;

    public int size() {
        return this.elementCount;
    }

    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    public long getFirst() throws NoSuchElementException {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.list[this.firstindex];
    }

    public long getLast() throws NoSuchElementException {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.list[this.endindex - 1];
    }

    public long get(int i) throws IndexOutOfBoundsException {
        int index = this.getInternalIndex(i);
        return this.list[index];
    }

    public long removeFirst() throws NoSuchElementException {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        long value = this.list[this.firstindex];
        this.list[this.firstindex] = 0L;
        ++this.firstindex;
        --this.elementCount;
        if (this.elementCount == 0) {
            this.endindex = 0;
            this.firstindex = 0;
        } else if (this.firstindex == this.list.length) {
            this.firstindex = 0;
        }
        return value;
    }

    public long removeLast() throws NoSuchElementException {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        --this.endindex;
        long value = this.list[this.endindex];
        this.list[this.endindex] = 0L;
        --this.elementCount;
        if (this.elementCount == 0) {
            this.endindex = 0;
            this.firstindex = 0;
        } else if (this.endindex == 0) {
            this.endindex = this.list.length;
        }
        return value;
    }

    public boolean add(long value) {
        this.resetCapacity();
        if (this.endindex == this.list.length) {
            this.endindex = 0;
        }
        this.list[this.endindex] = value;
        ++this.elementCount;
        ++this.endindex;
        return true;
    }

    public boolean addLast(long value) {
        return this.add(value);
    }

    public boolean addFirst(long value) {
        this.resetCapacity();
        --this.firstindex;
        if (this.firstindex < 0) {
            this.firstindex = this.list.length - 1;
            if (this.endindex == 0) {
                this.endindex = this.list.length;
            }
        }
        this.list[this.firstindex] = value;
        ++this.elementCount;
        return true;
    }

    public void clear() {
        if (this.elementCount == 0) {
            return;
        }
        this.elementCount = 0;
        this.endindex = 0;
        this.firstindex = 0;
        for (int i = 0; i < this.list.length; ++i) {
            this.list[i] = 0L;
        }
    }

    public int indexOf(long value) {
        for (int i = 0; i < this.elementCount; ++i) {
            int index = this.firstindex + i;
            if (index >= this.list.length) {
                index -= this.list.length;
            }
            if (this.list[index] != value) continue;
            return i;
        }
        return -1;
    }

    public long remove(int index) {
        int target = this.getInternalIndex(index);
        long value = this.list[target];
        if (target == this.firstindex) {
            this.list[this.firstindex] = 0L;
            ++this.firstindex;
            if (this.firstindex == this.list.length) {
                this.firstindex = 0;
            }
        } else if (target > this.firstindex) {
            System.arraycopy(this.list, this.firstindex, this.list, this.firstindex + 1, target - this.firstindex);
            this.list[this.firstindex] = 0L;
            ++this.firstindex;
            if (this.firstindex == this.list.length) {
                this.firstindex = 0;
            }
        } else {
            System.arraycopy(this.list, target + 1, this.list, target, this.endindex - target - 1);
            --this.endindex;
            this.list[this.endindex] = 0L;
            if (this.endindex == 0) {
                this.endindex = this.list.length;
            }
        }
        --this.elementCount;
        if (this.elementCount == 0) {
            this.endindex = 0;
            this.firstindex = 0;
        }
        return value;
    }

    private int getInternalIndex(int i) throws IndexOutOfBoundsException {
        if (i < 0 || i >= this.elementCount) {
            throw new IndexOutOfBoundsException();
        }
        int index = this.firstindex + i;
        if (index >= this.list.length) {
            index -= this.list.length;
        }
        return index;
    }

    private void resetCapacity() {
        if (this.elementCount < this.list.length) {
            return;
        }
        long[] newList = new long[this.list.length * 2];
        System.arraycopy(this.list, this.firstindex, newList, this.firstindex, this.list.length - this.firstindex);
        if (this.endindex <= this.firstindex) {
            System.arraycopy(this.list, 0, newList, this.list.length, this.endindex);
            this.endindex = this.list.length + this.endindex;
        }
        this.list = newList;
    }
}

