/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.index;

import org.hsqldb.index.Index;
import org.hsqldb.index.NodeAVL;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.rowio.RowOutputInterface;

abstract class NodeAVLBaseMemory
extends NodeAVL {
    protected NodeAVL nLeft;
    protected NodeAVL nRight;
    protected NodeAVL nParent;

    NodeAVLBaseMemory() {
    }

    @Override
    public void delete() {
        this.iBalance = 0;
        this.nParent = null;
        this.nRight = null;
        this.nLeft = null;
    }

    @Override
    NodeAVL getLeft(PersistentStore store) {
        return this.nLeft;
    }

    @Override
    NodeAVL setLeft(PersistentStore persistentStore, NodeAVL n) {
        this.nLeft = n;
        return this;
    }

    @Override
    public int getBalance(PersistentStore store) {
        return this.iBalance;
    }

    @Override
    boolean isLeft(NodeAVL node) {
        return this.nLeft == node;
    }

    @Override
    boolean isRight(NodeAVL node) {
        return this.nRight == node;
    }

    @Override
    NodeAVL getRight(PersistentStore persistentStore) {
        return this.nRight;
    }

    @Override
    NodeAVL setRight(PersistentStore persistentStore, NodeAVL n) {
        this.nRight = n;
        return this;
    }

    @Override
    NodeAVL getParent(PersistentStore store) {
        return this.nParent;
    }

    @Override
    boolean isRoot(PersistentStore store) {
        return this.nParent == null;
    }

    @Override
    NodeAVL setParent(PersistentStore persistentStore, NodeAVL n) {
        this.nParent = n;
        return this;
    }

    @Override
    public NodeAVL setBalance(PersistentStore store, int b) {
        this.iBalance = b;
        return this;
    }

    @Override
    boolean isFromLeft(PersistentStore store) {
        if (this.isRoot(store)) {
            return true;
        }
        NodeAVL parent = this.getParent(store);
        return this.equals(parent.getLeft(store));
    }

    @Override
    public NodeAVL set(PersistentStore store, boolean isLeft, NodeAVL n) {
        if (isLeft) {
            this.nLeft = n;
        } else {
            this.nRight = n;
        }
        if (n != null) {
            ((NodeAVLBaseMemory)n).nParent = this;
        }
        return this;
    }

    @Override
    public void replace(PersistentStore store, Index index, NodeAVL n) {
        if (this.nParent == null) {
            if (n != null) {
                n = n.setParent(store, null);
            }
            store.setAccessor(index, n);
        } else {
            this.getParent(store).set(store, this.isFromLeft(store), n);
        }
    }

    @Override
    boolean equals(NodeAVL n) {
        return n == this;
    }

    @Override
    public void setInMemory(boolean in) {
    }

    @Override
    public void write(RowOutputInterface out) {
    }
}

