/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Row;
import org.hsqldb.RowAction;
import org.hsqldb.Session;
import org.hsqldb.SqlInvariants;
import org.hsqldb.Statement;
import org.hsqldb.Table;
import org.hsqldb.TransactionManager;
import org.hsqldb.TransactionManager2PL;
import org.hsqldb.TransactionManagerMVCC;
import org.hsqldb.error.Error;
import org.hsqldb.lib.DoubleIntIndex;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HsqlDeque;
import org.hsqldb.lib.IntKeyHashMapConcurrent;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.LongDeque;
import org.hsqldb.lib.MultiValueHashMap;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.store.ValuePool;

public class TransactionManagerMV2PL
implements TransactionManager {
    Database database;
    ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
    LongDeque liveTransactionTimestamps = new LongDeque();
    AtomicLong globalChangeTimestamp = new AtomicLong();
    HsqlDeque committedTransactions = new HsqlDeque();
    LongDeque committedTransactionTimestamps = new LongDeque();
    HsqlNameManager.HsqlName[] catalogNameList;
    public IntKeyHashMapConcurrent rowActionMap = new IntKeyHashMapConcurrent(10000);
    HashMap tableWriteLocks = new HashMap();
    MultiValueHashMap tableReadLocks = new MultiValueHashMap();

    public TransactionManagerMV2PL(Database db) {
        this.database = db;
        this.catalogNameList = new HsqlNameManager.HsqlName[]{this.database.getCatalogName()};
    }

    @Override
    public long getGlobalChangeTimestamp() {
        return this.globalChangeTimestamp.get();
    }

    @Override
    public boolean isMVRows() {
        return true;
    }

    @Override
    public int getTransactionControl() {
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTransactionControl(Session session, int mode) {
        this.writeLock.lock();
        try {
            LongDeque longDeque = this.liveTransactionTimestamps;
            synchronized (longDeque) {
                block13: {
                    if (this.liveTransactionTimestamps.size() != 1) break block13;
                    switch (mode) {
                        case 2: {
                            TransactionManagerMVCC manager = new TransactionManagerMVCC(this.database);
                            manager.globalChangeTimestamp.set(this.globalChangeTimestamp.get());
                            manager.liveTransactionTimestamps.addLast(session.transactionTimestamp);
                            this.database.txManager = manager;
                            break;
                        }
                        case 1: {
                            break;
                        }
                        case 0: {
                            TransactionManager2PL manager = new TransactionManager2PL(this.database);
                            manager.globalChangeTimestamp.set(this.globalChangeTimestamp.get());
                            this.database.txManager = manager;
                            break;
                        }
                    }
                    return;
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
        throw Error.error(3701);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void completeActions(Session session) {
        Object[] list = session.rowActionList.getArray();
        int limit = session.rowActionList.size();
        boolean canComplete = true;
        this.writeLock.lock();
        try {
            int i;
            for (i = session.actionIndex; i < limit; ++i) {
                RowAction rowact = (RowAction)list[i];
                if (rowact.complete(session, session.tempSet)) continue;
                canComplete = false;
                if (session.isolationMode != 4 && session.isolationMode != 8) continue;
                session.abortTransaction = true;
                break;
            }
            for (i = session.actionIndex; canComplete && i < limit; ++i) {
                RowAction action = (RowAction)list[i];
                if (!action.table.isLogged) continue;
                Row row = action.memoryRow;
                if (row == null) {
                    PersistentStore store = session.sessionData.getRowStore(action.table);
                    row = (Row)store.get(action.getPos(), false);
                }
                Object[] data = row.getData();
                try {
                    int actionType = action.getActionType(session.actionTimestamp);
                    if (actionType == 1) {
                        this.database.logger.writeInsertStatement(session, action.table, data);
                        continue;
                    }
                    if (actionType == 2) {
                        this.database.logger.writeDeleteStatement(session, action.table, data);
                        continue;
                    }
                    if (actionType == 0) continue;
                    throw Error.runtimeError(401, "TransactionManager");
                }
                catch (HsqlException e) {
                    // empty catch block
                }
            }
            if (!canComplete && !session.abortTransaction) {
                session.redoAction = true;
                this.rollbackAction(session);
                if (!session.tempSet.isEmpty()) {
                    session.latch.setCount(session.tempSet.size());
                    for (i = 0; i < session.tempSet.size(); ++i) {
                        Session current = (Session)session.tempSet.get(i);
                        current.waitingSessions.add(session);
                    }
                }
            }
        }
        finally {
            this.writeLock.unlock();
            session.tempSet.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean prepareCommitActions(Session session) {
        Object[] list = session.rowActionList.getArray();
        int limit = session.rowActionList.size();
        if (session.abortTransaction) {
            return false;
        }
        try {
            int i;
            this.writeLock.lock();
            for (i = 0; i < limit; ++i) {
                RowAction rowact = (RowAction)list[i];
                if (rowact.canCommit(session, session.tempSet)) continue;
                boolean bl = false;
                return bl;
            }
            session.actionTimestamp = this.nextChangeTimestamp();
            for (i = 0; i < limit; ++i) {
                RowAction action = (RowAction)list[i];
                action.prepareCommit(session);
            }
            for (i = 0; i < session.tempSet.size(); ++i) {
                Session current = (Session)session.tempSet.get(i);
                current.abortTransaction = true;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.writeLock.unlock();
            session.tempSet.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean commitTransaction(Session session) {
        if (session.abortTransaction) {
            return false;
        }
        int limit = session.rowActionList.size();
        Object[] list = limit == 0 ? ValuePool.emptyObjectArray : session.rowActionList.getArray();
        try {
            RowAction action;
            int i;
            this.writeLock.lock();
            this.endTransaction(session);
            if (limit == 0) {
                this.endTransactionTPL(session);
                try {
                    session.logSequences();
                }
                catch (HsqlException e) {
                    // empty catch block
                }
                boolean e = true;
                return e;
            }
            session.actionTimestamp = this.nextChangeTimestamp();
            for (i = 0; i < limit; ++i) {
                action = (RowAction)list[i];
                action.commit(session);
            }
            block16: for (i = 0; i < limit; ++i) {
                action = (RowAction)list[i];
                if (action.type == 0) continue;
                int type = action.getCommitType(session.actionTimestamp);
                PersistentStore store = session.sessionData.getRowStore(action.table);
                Row row = action.memoryRow;
                if (row == null) {
                    row = (Row)store.get(action.getPos(), false);
                }
                if (action.table.hasLobColumn) {
                    switch (type) {
                        case 1: {
                            action.table.addLobUsageCount(session, row.getData());
                            break;
                        }
                    }
                }
                if (action.table.tableType != 6) continue;
                switch (type) {
                    case 2: {
                        store.removePersistence(action.getPos());
                        continue block16;
                    }
                    case 1: {
                        store.commitPersistence(row);
                        continue block16;
                    }
                }
            }
            if (this.getFirstLiveTransactionTimestamp() > session.actionTimestamp) {
                this.mergeTransaction(session, list, 0, limit, session.actionTimestamp);
                this.rowActionMapRemoveTransaction(list, 0, limit, true);
            } else {
                list = session.rowActionList.toArray();
                this.addToCommittedQueue(session, list);
            }
            try {
                session.logSequences();
                this.database.logger.writeCommitStatement(session);
            }
            catch (HsqlException e) {
                // empty catch block
            }
            this.endTransactionTPL(session);
            boolean bl = true;
            return bl;
        }
        finally {
            this.writeLock.unlock();
            session.tempSet.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(Session session) {
        session.abortTransaction = false;
        session.actionTimestamp = this.nextChangeTimestamp();
        this.rollbackPartial(session, 0, session.transactionTimestamp);
        this.endTransaction(session);
        try {
            this.writeLock.lock();
            this.endTransactionTPL(session);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void rollbackSavepoint(Session session, int index) {
        long timestamp = session.sessionContext.savepointTimestamps.get(index);
        Integer oi = (Integer)session.sessionContext.savepoints.get(index);
        int start = oi;
        while (session.sessionContext.savepoints.size() > index + 1) {
            session.sessionContext.savepoints.remove(session.sessionContext.savepoints.size() - 1);
            session.sessionContext.savepointTimestamps.removeLast();
        }
        this.rollbackPartial(session, start, timestamp);
    }

    @Override
    public void rollbackAction(Session session) {
        this.rollbackPartial(session, session.actionIndex, session.actionTimestamp);
    }

    void rollbackPartial(Session session, int start, long timestamp) {
        Object[] list = session.rowActionList.getArray();
        int limit = session.rowActionList.size();
        if (start == limit) {
            return;
        }
        for (int i = start; i < limit; ++i) {
            RowAction action = (RowAction)list[i];
            if (action != null) {
                action.rollback(session, timestamp);
                continue;
            }
            System.out.println("null action in rollback " + start);
        }
        this.mergeRolledBackTransaction(session.rowActionList.getArray(), start, limit);
        this.rowActionMapRemoveTransaction(session.rowActionList.getArray(), start, limit, false);
        session.rowActionList.setSize(start);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RowAction addDeleteAction(Session session, Table table, Row row) {
        RowAction action;
        Row row2 = row;
        synchronized (row2) {
            action = RowAction.addAction(session, (byte)2, table, row);
        }
        session.rowActionList.add(action);
        if (!row.isMemory()) {
            this.rowActionMap.put(action.getPos(), action);
        }
        return action;
    }

    @Override
    public void addInsertAction(Session session, Table table, Row row) {
        RowAction action = row.rowAction;
        if (action == null) {
            System.out.println("null insert action " + session + " " + session.actionTimestamp);
        }
        session.rowActionList.add(action);
        if (!row.isMemory()) {
            this.rowActionMap.put(action.getPos(), action);
        }
    }

    int compareRowForInsert(Row newRow, Row existingRow) {
        if (newRow.rowAction != null && !this.canRead(newRow.rowAction.session, existingRow)) {
            return newRow.getPos() - existingRow.getPos();
        }
        return 0;
    }

    @Override
    public boolean canRead(Session session, Row row) {
        RowAction action = row.rowAction;
        if (action == null) {
            return true;
        }
        return action.canRead(session);
    }

    @Override
    public boolean isDeleted(Session session, Row row) {
        RowAction action = row.rowAction;
        if (action == null) {
            return false;
        }
        return !action.canRead(session);
    }

    @Override
    public boolean canRead(Session session, int id) {
        RowAction action = (RowAction)this.rowActionMap.get(id);
        return action == null ? true : action.canRead(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rowActionMapRemoveTransaction(Object[] list, int start, int limit, boolean commit) {
        for (int i = start; i < limit; ++i) {
            RowAction rowact = (RowAction)list[i];
            if (rowact.isMemory) continue;
            RowAction rowAction = rowact;
            synchronized (rowAction) {
                if (rowact.type == 0 || rowact.type == 3) {
                    int pos = rowact.getPos();
                    this.rowActionMap.remove(pos);
                }
                continue;
            }
        }
        this.deleteRows(list, start, limit, commit);
    }

    void deleteRows(Object[] list, int start, int limit, boolean commit) {
        for (int i = start; i < limit; ++i) {
            RowAction rowact = (RowAction)list[i];
            if (rowact.type != 3) continue;
            try {
                rowact.type = (byte)4;
                PersistentStore store = rowact.session.sessionData.getRowStore(rowact.table);
                Row row = rowact.memoryRow;
                if (row == null) {
                    row = (Row)store.get(rowact.getPos(), false);
                }
                if (commit && rowact.table.hasLobColumn) {
                    Object[] data = row.getData();
                    rowact.table.removeLobUsageCount(rowact.session, data);
                }
                store.delete(row);
                store.remove(row.getPos());
                continue;
            }
            catch (HsqlException e) {
                // empty catch block
            }
        }
    }

    @Override
    public void setTransactionInfo(CachedObject object) {
        RowAction rowact;
        Row row = (Row)object;
        if (row.rowAction != null) {
            return;
        }
        row.rowAction = rowact = (RowAction)this.rowActionMap.get(row.position);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mergeRolledBackTransaction(Object[] list, int start, int limit) {
        for (int i = start; i < limit; ++i) {
            RowAction rowact = (RowAction)list[i];
            if (rowact == null || rowact.type == 0 || rowact.type == 3) continue;
            Row row = rowact.memoryRow;
            if (row == null) {
                Session session = rowact.session;
                if (session == null) {
                    return;
                }
                PersistentStore store = rowact.session.sessionData.getRowStore(rowact.table);
                row = (Row)store.get(rowact.getPos(), false);
            }
            if (row == null) continue;
            Row row2 = row;
            synchronized (row2) {
                rowact.mergeRollback(row);
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToCommittedQueue(Session session, Object[] list) {
        LongDeque longDeque = this.committedTransactionTimestamps;
        synchronized (longDeque) {
            this.committedTransactions.addLast(list);
            this.committedTransactionTimestamps.addLast(session.actionTimestamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mergeExpiredTransactions(Session session) {
        long timestamp = this.getFirstLiveTransactionTimestamp();
        while (true) {
            long commitTimestamp = 0L;
            Object[] actions = null;
            LongDeque longDeque = this.committedTransactionTimestamps;
            synchronized (longDeque) {
                if (this.committedTransactionTimestamps.isEmpty()) {
                    break;
                }
                commitTimestamp = this.committedTransactionTimestamps.getFirst();
                if (commitTimestamp >= timestamp) {
                    break;
                }
                this.committedTransactionTimestamps.removeFirst();
                actions = (Object[])this.committedTransactions.removeFirst();
            }
            this.mergeTransaction(session, actions, 0, actions.length, commitTimestamp);
            this.rowActionMapRemoveTransaction(actions, 0, actions.length, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mergeTransaction(Session session, Object[] list, int start, int limit, long timestamp) {
        for (int i = start; i < limit; ++i) {
            RowAction rowact = (RowAction)list[i];
            if (rowact == null || rowact.type == 0 || rowact.type == 3) continue;
            Row row = rowact.memoryRow;
            if (row == null) {
                PersistentStore store = rowact.session.sessionData.getRowStore(rowact.table);
                row = (Row)store.get(rowact.getPos(), false);
            }
            if (row == null) continue;
            Row row2 = row;
            synchronized (row2) {
                rowact.mergeToTimestamp(row, timestamp);
                continue;
            }
        }
    }

    long nextChangeTimestamp() {
        return this.globalChangeTimestamp.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beginTransaction(Session session) {
        LongDeque longDeque = this.liveTransactionTimestamps;
        synchronized (longDeque) {
            session.transactionTimestamp = session.actionTimestamp = this.nextChangeTimestamp();
            session.isTransaction = true;
            this.liveTransactionTimestamps.addLast(session.transactionTimestamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beginAction(Session session, Statement cs) {
        LongDeque longDeque = this.liveTransactionTimestamps;
        synchronized (longDeque) {
            session.actionTimestamp = this.nextChangeTimestamp();
            if (!session.isTransaction) {
                session.transactionTimestamp = session.actionTimestamp;
                session.isTransaction = true;
                this.liveTransactionTimestamps.addLast(session.actionTimestamp);
            }
        }
        if (session.hasLocks()) {
            return;
        }
        try {
            this.writeLock.lock();
            boolean canProceed = this.beginActionTPL(session, cs);
            if (!canProceed) {
                session.abortTransaction = true;
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    void endTransactionTPL(Session session) {
        Session current;
        int i;
        int unlockedCount = 0;
        this.unlockTablesTPL(session);
        int waitingCount = session.waitingSessions.size();
        if (waitingCount == 0) {
            return;
        }
        for (i = 0; i < waitingCount; ++i) {
            current = (Session)session.waitingSessions.get(i);
            current.tempUnlocked = false;
            long count = current.latch.getCount();
            if (count != 1L) continue;
            boolean canProceed = this.setWaitedSessionsTPL(current, current.currentStatement);
            if (!canProceed) {
                current.abortTransaction = true;
            }
            if (!current.tempSet.isEmpty()) continue;
            this.lockTablesTPL(current, current.currentStatement);
            current.tempUnlocked = true;
            ++unlockedCount;
        }
        for (i = 0; i < waitingCount; ++i) {
            boolean canProceed;
            current = (Session)session.waitingSessions.get(i);
            if (current.tempUnlocked || (canProceed = this.setWaitedSessionsTPL(current, current.currentStatement))) continue;
            current.abortTransaction = true;
        }
        for (i = 0; i < waitingCount; ++i) {
            current = (Session)session.waitingSessions.get(i);
            this.setWaitingSessionTPL(current);
        }
        session.tempSet.clear();
        session.waitingSessions.clear();
    }

    boolean beginActionTPL(Session session, Statement cs) {
        boolean canProceed = this.setWaitedSessionsTPL(session, cs);
        if (canProceed) {
            if (session.tempSet.isEmpty()) {
                this.lockTablesTPL(session, cs);
            } else {
                this.setWaitingSessionTPL(session);
            }
            return true;
        }
        return false;
    }

    boolean setWaitedSessionsTPL(Session session, Statement cs) {
        Session holder;
        HsqlNameManager.HsqlName name;
        int i;
        session.tempSet.clear();
        if (cs == null || session.abortTransaction) {
            return true;
        }
        HsqlNameManager.HsqlName[] nameList = cs.getTableNamesForWrite();
        for (i = 0; i < nameList.length; ++i) {
            name = nameList[i];
            if (name.schema == SqlInvariants.SYSTEM_SCHEMA_HSQLNAME) continue;
            holder = (Session)this.tableWriteLocks.get(name);
            if (holder != null && holder != session) {
                session.tempSet.add(holder);
            }
            Iterator it = this.tableReadLocks.get(name);
            while (it.hasNext()) {
                holder = (Session)it.next();
                if (holder == session) continue;
                session.tempSet.add(holder);
            }
        }
        nameList = cs.getTableNamesForRead();
        if (session.isReadOnly()) {
            nameList = this.catalogNameList;
        }
        for (i = 0; i < nameList.length; ++i) {
            name = nameList[i];
            if (name.schema == SqlInvariants.SYSTEM_SCHEMA_HSQLNAME || (holder = (Session)this.tableWriteLocks.get(name)) == null || holder == session) continue;
            session.tempSet.add(holder);
        }
        for (i = 0; i < session.waitingSessions.size(); ++i) {
            Session current = (Session)session.waitingSessions.get(i);
            if (!session.tempSet.contains(current)) continue;
            session.tempSet.clear();
            return false;
        }
        return true;
    }

    void setWaitingSessionTPL(Session session) {
        int count = session.tempSet.size();
        for (int i = 0; i < count; ++i) {
            Session current = (Session)session.tempSet.get(i);
            current.waitingSessions.add(session);
        }
        session.tempSet.clear();
        session.latch.setCount(count);
    }

    void lockTablesTPL(Session session, Statement cs) {
        HsqlNameManager.HsqlName name;
        int i;
        if (cs == null || session.abortTransaction) {
            return;
        }
        HsqlNameManager.HsqlName[] nameList = cs.getTableNamesForWrite();
        for (i = 0; i < nameList.length; ++i) {
            name = nameList[i];
            if (name.schema == SqlInvariants.SYSTEM_SCHEMA_HSQLNAME) continue;
            this.tableWriteLocks.put(name, session);
        }
        nameList = cs.getTableNamesForRead();
        for (i = 0; i < nameList.length; ++i) {
            name = nameList[i];
            if (name.schema == SqlInvariants.SYSTEM_SCHEMA_HSQLNAME) continue;
            this.tableReadLocks.put(name, session);
        }
    }

    void unlockTablesTPL(Session session) {
        Session s;
        Iterator it = this.tableWriteLocks.values().iterator();
        while (it.hasNext()) {
            s = (Session)it.next();
            if (s != session) continue;
            it.setValue(null);
        }
        it = this.tableReadLocks.values().iterator();
        while (it.hasNext()) {
            s = (Session)it.next();
            if (s != session) continue;
            it.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void endTransaction(Session session) {
        try {
            this.writeLock.lock();
            long timestamp = session.transactionTimestamp;
            LongDeque longDeque = this.liveTransactionTimestamps;
            synchronized (longDeque) {
                session.isTransaction = false;
                int index = this.liveTransactionTimestamps.indexOf(timestamp);
                this.liveTransactionTimestamps.remove(index);
            }
            this.mergeExpiredTransactions(session);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getFirstLiveTransactionTimestamp() {
        LongDeque longDeque = this.liveTransactionTimestamps;
        synchronized (longDeque) {
            if (this.liveTransactionTimestamps.isEmpty()) {
                return Long.MAX_VALUE;
            }
            return this.liveTransactionTimestamps.get(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    RowAction[] getRowActionList() {
        try {
            this.writeLock.lock();
            sessions = this.database.sessionManager.getAllSessions();
            tIndex = new int[sessions.length];
            rowActionCount = 0;
            actioncount = 0;
            for (i = 0; i < sessions.length; ++i) {
                actioncount += sessions[i].getTransactionSize();
            }
            rowActions = new RowAction[actioncount];
            block4: while (true) {
                found = false;
                minChangeNo = 0x7FFFFFFFFFFFFFFFL;
                sessionIndex = 0;
                for (i = 0; i < sessions.length; ++i) {
                    tSize = sessions[i].getTransactionSize();
                    if (tIndex[i] >= tSize) continue;
                    current = (RowAction)sessions[i].rowActionList.get(tIndex[i]);
                    if (current.actionTimestamp < minChangeNo) {
                        minChangeNo = current.actionTimestamp;
                        sessionIndex = i;
                    }
                    found = true;
                }
                if (!found) break;
                currentList = sessions[sessionIndex].rowActionList;
                while (true) {
                    if (tIndex[sessionIndex] >= currentList.size()) continue block4;
                    current = (RowAction)currentList.get(tIndex[sessionIndex]);
                    if (current.actionTimestamp == minChangeNo + 1L) {
                        ++minChangeNo;
                    }
                    if (current.actionTimestamp == minChangeNo) ** break;
                    continue block4;
                    rowActions[rowActionCount++] = current;
                    v0 = sessionIndex;
                    tIndex[v0] = tIndex[v0] + 1;
                }
                break;
            }
            var5_5 = rowActions;
            return var5_5;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DoubleIntIndex getTransactionIDList() {
        this.writeLock.lock();
        try {
            int size = this.rowActionMap.size();
            DoubleIntIndex lookup = new DoubleIntIndex(size, false);
            lookup.setKeysSearchTarget();
            Iterator it = this.rowActionMap.keySet().iterator();
            while (it.hasNext()) {
                lookup.addUnique(it.nextInt(), 0);
            }
            DoubleIntIndex doubleIntIndex = lookup;
            return doubleIntIndex;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void convertTransactionIDs(DoubleIntIndex lookup) {
        this.writeLock.lock();
        try {
            RowAction[] list = new RowAction[this.rowActionMap.size()];
            Iterator it = this.rowActionMap.values().iterator();
            int i = 0;
            while (it.hasNext()) {
                list[i] = (RowAction)it.next();
                ++i;
            }
            this.rowActionMap.clear();
            for (i = 0; i < list.length; ++i) {
                int pos = lookup.lookupFirstEqual(list[i].getPos());
                list[i].setPos(pos);
                this.rowActionMap.put(pos, list[i]);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }
}

