/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Database;
import org.hsqldb.Expression;
import org.hsqldb.QueryExpression;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.TableDerived;
import org.hsqldb.TableUtil;
import org.hsqldb.View;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ObjectComparator;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.navigator.RowSetNavigatorData;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.result.Result;

class SubQuery
implements ObjectComparator {
    int level;
    private boolean isCorrelated;
    private boolean isExistsPredicate;
    private boolean uniqueRows;
    private boolean isUniquePredicate;
    QueryExpression queryExpression;
    Database database;
    private TableDerived table;
    View view;
    View parentView;
    Expression dataExpression;
    boolean isDataExpression;
    public static final SubQuery[] emptySubqueryArray = new SubQuery[0];

    SubQuery(Database database, int level, QueryExpression queryExpression, int mode) {
        this.level = level;
        this.queryExpression = queryExpression;
        this.database = database;
        switch (mode) {
            case 55: {
                this.isExistsPredicate = true;
                break;
            }
            case 54: {
                this.uniqueRows = true;
                if (queryExpression == null) break;
                queryExpression.setFullOrder();
                break;
            }
            case 57: {
                this.isUniquePredicate = true;
                if (queryExpression == null) break;
                queryExpression.setFullOrder();
            }
        }
    }

    SubQuery(Database database, int level, QueryExpression queryExpression, View view) {
        this.level = level;
        this.queryExpression = queryExpression;
        this.database = database;
        this.view = view;
    }

    SubQuery(Database database, int level, Expression dataExpression, int mode) {
        this.level = level;
        this.database = database;
        this.dataExpression = dataExpression;
        dataExpression.subQuery = this;
        this.isDataExpression = true;
        switch (mode) {
            case 54: {
                this.uniqueRows = true;
            }
        }
    }

    public boolean isCorrelated() {
        return this.isCorrelated;
    }

    public void setCorrelated() {
        this.isCorrelated = true;
    }

    public TableDerived getTable() {
        return this.table;
    }

    public void prepareTable(Session session) {
        if (this.table != null) {
            return;
        }
        if (this.view == null) {
            this.table = TableUtil.newSubqueryTable(this.database, null);
            if (this.isDataExpression) {
                TableUtil.setTableColumnsForSubquery((Table)this.table, this.dataExpression.nodeDataTypes, this.uniqueRows || this.isUniquePredicate);
            } else {
                TableUtil.setTableColumnsForSubquery((Table)this.table, this.queryExpression, this.uniqueRows || this.isUniquePredicate);
            }
        } else {
            this.table = new TableDerived(this.database, this.view.getName(), 7, this.queryExpression);
            this.table.columnList = this.view.columnList;
            this.table.columnCount = this.table.columnList.size();
            this.table.createPrimaryKey();
        }
    }

    public void materialiseCorrelated(Session session) {
        if (this.isCorrelated) {
            this.materialise(session);
        }
    }

    public void materialise(Session session) {
        if (this.isDataExpression) {
            PersistentStore store = session.sessionData.getSubqueryRowStore(this.table);
            this.dataExpression.insertValuesIntoSubqueryTable(session, store);
            return;
        }
        Result result = this.queryExpression.getResult(session, this.isExistsPredicate ? 1 : 0);
        if (this.uniqueRows) {
            RowSetNavigatorData navigator = (RowSetNavigatorData)result.getNavigator();
            navigator.removeDuplicates();
        }
        PersistentStore store = session.sessionData.getSubqueryRowStore(this.table);
        this.table.insertResult(store, result);
        result.getNavigator().close();
    }

    public boolean hasUniqueNotNullRows(Session session) {
        RowSetNavigatorData navigator = new RowSetNavigatorData(session, this.table);
        boolean result = navigator.hasUniqueNotNullRows();
        return result;
    }

    public Object[] getValues(Session session) {
        RowIterator it = this.table.rowIterator(session);
        if (it.hasNext()) {
            Row row = it.getNextRow();
            if (it.hasNext()) {
                throw Error.error(3201);
            }
            return row.getData();
        }
        return new Object[this.table.getColumnCount()];
    }

    public Object getValue(Session session) {
        Object[] data = this.getValues(session);
        return data[0];
    }

    @Override
    public int compare(Object a, Object b) {
        SubQuery sqa = (SubQuery)a;
        SubQuery sqb = (SubQuery)b;
        if (sqa.parentView == null && sqb.parentView == null) {
            return sqb.level - sqa.level;
        }
        if (sqa.parentView != null && sqb.parentView != null) {
            int diff;
            int ia = this.database.schemaManager.getTableIndex(sqa.parentView);
            int ib = this.database.schemaManager.getTableIndex(sqb.parentView);
            if (ia == -1) {
                ia = this.database.schemaManager.getTables(sqa.parentView.getSchemaName().name).size();
            }
            if (ib == -1) {
                ib = this.database.schemaManager.getTables(sqb.parentView.getSchemaName().name).size();
            }
            return (diff = ia - ib) == 0 ? sqb.level - sqa.level : diff;
        }
        return sqa.parentView == null ? 1 : -1;
    }
}

