/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Constraint;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.ParserDDL;
import org.hsqldb.Routine;
import org.hsqldb.Schema;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.Statement;
import org.hsqldb.StatementDMQL;
import org.hsqldb.Table;
import org.hsqldb.TableWorks;
import org.hsqldb.Token;
import org.hsqldb.TriggerDef;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.result.Result;
import org.hsqldb.rights.Grantee;
import org.hsqldb.rights.GranteeManager;
import org.hsqldb.rights.Right;
import org.hsqldb.rights.User;
import org.hsqldb.types.Charset;
import org.hsqldb.types.Type;

public class StatementSchema
extends Statement {
    int order;
    Object[] arguments;
    boolean isSchemaDefinition;
    Token[] statementTokens;

    StatementSchema() {
        super(64, 2001);
        this.isTransactionStatement = true;
    }

    StatementSchema(String sql, int type, HsqlNameManager.HsqlName readName, HsqlNameManager.HsqlName writeName) {
        super(type);
        this.isTransactionStatement = true;
        this.group = 2002;
        this.sql = sql;
        if (readName != null) {
            this.readTableNames = new HsqlNameManager.HsqlName[]{readName};
        }
        if (writeName != null) {
            this.writeTableNames = new HsqlNameManager.HsqlName[]{writeName};
        }
    }

    StatementSchema(String sql, int type, Object[] args, HsqlNameManager.HsqlName readName, HsqlNameManager.HsqlName writeName) {
        super(type);
        this.isTransactionStatement = true;
        this.sql = sql;
        this.arguments = args;
        if (readName != null) {
            this.readTableNames = new HsqlNameManager.HsqlName[]{readName};
        }
        if (writeName != null) {
            this.writeTableNames = new HsqlNameManager.HsqlName[]{writeName};
        }
        switch (type) {
            case 1064: {
                this.group = 2002;
                break;
            }
            case 3: 
            case 4: 
            case 17: 
            case 60: 
            case 127: 
            case 134: {
                this.group = 2002;
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 78: 
            case 115: 
            case 116: 
            case 135: 
            case 1057: 
            case 1058: 
            case 1059: 
            case 1062: {
                this.group = 2002;
                break;
            }
            case 48: {
                this.group = 2002;
                this.order = 10;
                break;
            }
            case 49: {
                this.group = 2002;
                this.order = 10;
                break;
            }
            case 59: 
            case 129: {
                this.group = 2002;
                break;
            }
            case 64: {
                this.group = 2001;
                break;
            }
            case 61: {
                this.group = 2001;
                this.order = 1;
                break;
            }
            case 14: {
                this.group = 2001;
                this.order = 7;
                break;
            }
            case 133: {
                this.group = 2001;
                this.order = 1;
                break;
            }
            case 77: {
                this.group = 2001;
                this.order = 2;
                break;
            }
            case 117: {
                this.group = 2001;
                this.order = 1;
                break;
            }
            case 79: {
                this.group = 2001;
                this.order = 1;
                break;
            }
            case 80: {
                this.group = 2001;
                this.order = 7;
                break;
            }
            case 52: {
                this.group = 2001;
                this.order = 2;
                break;
            }
            case 83: {
                this.group = 2001;
                this.order = 1;
                break;
            }
            case 114: {
                this.group = 2001;
                this.order = 1;
                break;
            }
            case 84: {
                this.group = 2001;
                this.order = 5;
                break;
            }
            case 1053: {
                this.group = 2001;
                this.order = 1;
                break;
            }
            case 6: {
                this.group = 2001;
                this.order = 9;
                break;
            }
            case 8: {
                this.group = 2001;
                this.order = 1;
                break;
            }
            case 10: {
                this.group = 2001;
                this.order = 1;
                break;
            }
            case 23: {
                this.group = 2001;
                this.order = 1;
                break;
            }
            case 1051: {
                this.group = 2001;
                this.order = 8;
                break;
            }
            case 1052: {
                this.group = 2002;
                this.order = 4;
                break;
            }
            case 1104: {
                this.group = 2002;
                this.statementTokens = (Token[])args[0];
                break;
            }
            default: {
                throw Error.runtimeError(401, "StatemntSchema");
            }
        }
    }

    @Override
    public Result execute(Session session) {
        Result result;
        try {
            result = this.getResult(session);
        }
        catch (Throwable t) {
            result = Result.newErrorResult(t, null);
        }
        if (result.isError()) {
            result.getException().setStatementType(this.group, this.type);
            return result;
        }
        session.database.setMetaDirty(true);
        session.database.schemaManager.setSchemaChangeTimestamp();
        try {
            if (this.isLogged) {
                session.database.logger.writeToLog(session, this.sql);
            }
        }
        catch (Throwable e) {
            return Result.newErrorResult(e, this.sql);
        }
        return result;
    }

    Result getResult(Session session) {
        if (this.isExplain) {
            return Result.newSingleColumnStringResult("OPERATION", this.describe(session));
        }
        block22 : switch (this.type) {
            case 1064: {
                HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)this.arguments[0];
                HsqlNameManager.HsqlName newName = (HsqlNameManager.HsqlName)this.arguments[1];
                if (name.type == 1) {
                    try {
                        session.checkAdmin();
                        session.checkDDLWrite();
                        name.rename(newName);
                        break;
                    }
                    catch (HsqlException e) {
                        return Result.newErrorResult(e, this.sql);
                    }
                }
                if (name.type == 2) {
                    this.checkSchemaUpdateAuthorisation(session, name);
                    session.database.schemaManager.checkSchemaNameCanChange(name);
                    session.database.schemaManager.renameSchema(name, newName);
                    break;
                }
                try {
                    SchemaObject object;
                    name.setSchemaIfNull(session.getCurrentSchemaHsqlName());
                    if (name.type == 9) {
                        Table table = session.database.schemaManager.getUserTable(session, name.parent);
                        int index = table.getColumnIndex(name.name);
                        object = table.getColumn(index);
                    } else {
                        object = session.database.schemaManager.getSchemaObject(name);
                        if (object == null) {
                            throw Error.error(5501, name.name);
                        }
                        name = object.getName();
                    }
                    this.checkSchemaUpdateAuthorisation(session, name.schema);
                    newName.setSchemaIfNull(name.schema);
                    if (name.schema != newName.schema) {
                        HsqlException e = Error.error(5505);
                        return Result.newErrorResult(e, this.sql);
                    }
                    newName.parent = name.parent;
                    switch (object.getType()) {
                        case 9: {
                            HsqlNameManager.HsqlName parent = object.getName().parent;
                            session.database.schemaManager.checkColumnIsReferenced(parent, object.getName());
                            Table table = session.database.schemaManager.getUserTable(session, parent);
                            table.renameColumn((ColumnSchema)object, newName);
                            break block22;
                        }
                    }
                    session.database.schemaManager.renameSchemaObject(name, newName);
                    break;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 134: {
                try {
                    NumberSequence sequence = (NumberSequence)this.arguments[0];
                    NumberSequence settings = (NumberSequence)this.arguments[1];
                    this.checkSchemaUpdateAuthorisation(session, sequence.getSchemaName());
                    sequence.reset(settings);
                    break;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 3: 
            case 4: 
            case 17: 
            case 60: 
            case 127: {
                try {
                    session.parser.reset(this.sql);
                    session.parser.read();
                    session.parser.processAlter();
                    break;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1057: {
                try {
                    HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)this.arguments[0];
                    int objectType = (Integer)this.arguments[1];
                    boolean cascade = (Boolean)this.arguments[2];
                    boolean ifExists = (Boolean)this.arguments[3];
                    Table table = session.database.schemaManager.getUserTable(session, name.parent);
                    int colindex = table.getColumnIndex(name.name);
                    if (table.getColumnCount() == 1) {
                        throw Error.error(5591);
                    }
                    this.checkSchemaUpdateAuthorisation(session, table.getSchemaName());
                    session.commit(false);
                    TableWorks tableWorks = new TableWorks(session, table);
                    tableWorks.dropColumn(colindex, cascade);
                    break;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 78: 
            case 115: 
            case 116: 
            case 135: 
            case 1058: 
            case 1059: 
            case 1062: {
                try {
                    HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)this.arguments[0];
                    int objectType = (Integer)this.arguments[1];
                    boolean cascade = (Boolean)this.arguments[2];
                    boolean ifExists = (Boolean)this.arguments[3];
                    switch (this.type) {
                        case 29: 
                        case 1062: {
                            session.checkAdmin();
                            session.checkDDLWrite();
                            break;
                        }
                        case 31: {
                            this.checkSchemaUpdateAuthorisation(session, name);
                            if (session.database.schemaManager.schemaExists(name.name) || !ifExists) break;
                            return Result.updateZeroResult;
                        }
                        default: {
                            if (name.schema == null) {
                                name.schema = session.getCurrentSchemaHsqlName();
                            } else if (!session.database.schemaManager.schemaExists(name.schema.name) && ifExists) {
                                return Result.updateZeroResult;
                            }
                            name.schema = session.database.schemaManager.getUserSchemaHsqlName(name.schema.name);
                            this.checkSchemaUpdateAuthorisation(session, name.schema);
                            SchemaObject object = session.database.schemaManager.getSchemaObject(name);
                            if (object == null) {
                                if (ifExists) {
                                    return Result.updateZeroResult;
                                }
                                throw Error.error(5501, name.name);
                            }
                            name = name.type == 24 ? ((Routine)object).getSpecificName() : object.getName();
                        }
                    }
                    if (!cascade) {
                        session.database.schemaManager.checkObjectIsReferenced(name);
                    }
                    switch (this.type) {
                        case 29: {
                            StatementSchema.dropRole(session, name, cascade);
                            break;
                        }
                        case 1062: {
                            StatementSchema.dropUser(session, name, cascade);
                            break;
                        }
                        case 31: {
                            this.dropSchema(session, name, cascade);
                            break;
                        }
                        case 24: {
                            break;
                        }
                        case 25: 
                        case 26: 
                        case 34: 
                        case 135: {
                            this.dropObject(session, name, cascade);
                            break;
                        }
                        case 35: {
                            this.dropType(session, name, cascade);
                            break;
                        }
                        case 27: {
                            StatementSchema.dropDomain(session, name, cascade);
                            break;
                        }
                        case 30: {
                            this.dropRoutine(session, name, cascade);
                            break;
                        }
                        case 32: 
                        case 36: {
                            this.dropTable(session, name, cascade);
                            break;
                        }
                        case 33: 
                        case 78: 
                        case 115: 
                        case 116: {
                            break;
                        }
                        case 1058: {
                            this.checkSchemaUpdateAuthorisation(session, name.schema);
                            session.database.schemaManager.dropIndex(session, name);
                            break;
                        }
                        case 1059: {
                            this.checkSchemaUpdateAuthorisation(session, name.schema);
                            session.database.schemaManager.dropConstraint(session, name, cascade);
                        }
                    }
                    break;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 48: 
            case 59: {
                try {
                    boolean grant = this.type == 48;
                    OrderedHashSet granteeList = (OrderedHashSet)this.arguments[0];
                    HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)this.arguments[1];
                    this.setSchemaName(session, null, name);
                    name = session.database.schemaManager.getSchemaObjectName(name.schema, name.name, name.type, true);
                    SchemaObject schemaObject = session.database.schemaManager.getSchemaObject(name);
                    Right right = (Right)this.arguments[2];
                    Grantee grantor = (Grantee)this.arguments[3];
                    boolean cascade = (Boolean)this.arguments[4];
                    boolean isGrantOption = (Boolean)this.arguments[5];
                    if (grantor == null) {
                        grantor = this.isSchemaDefinition ? this.schemaName.owner : session.getGrantee();
                    }
                    GranteeManager gm = session.database.granteeManager;
                    switch (schemaObject.getType()) {
                        case 14: {
                            System.out.println("grant charset!");
                            break;
                        }
                        case 3: 
                        case 4: {
                            Table t = (Table)schemaObject;
                            right.setColumns(t);
                            if (t.getTableType() != 2 || right.isFull()) break;
                            return Result.newErrorResult(Error.error(5595), this.sql);
                        }
                    }
                    if (grant) {
                        gm.grant(granteeList, schemaObject, right, grantor, isGrantOption);
                        break;
                    }
                    gm.revoke(granteeList, schemaObject, right, grantor, isGrantOption, cascade);
                    break;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 49: 
            case 129: {
                try {
                    String grantee;
                    int i;
                    boolean grant = this.type == 49;
                    OrderedHashSet granteeList = (OrderedHashSet)this.arguments[0];
                    OrderedHashSet roleList = (OrderedHashSet)this.arguments[1];
                    Grantee grantor = (Grantee)this.arguments[2];
                    boolean cascade = (Boolean)this.arguments[3];
                    GranteeManager gm = session.database.granteeManager;
                    gm.checkGranteeList(granteeList);
                    for (i = 0; i < granteeList.size(); ++i) {
                        grantee = (String)granteeList.get(i);
                        gm.checkRoleList(grantee, roleList, grantor, grant);
                    }
                    if (grant) {
                        for (i = 0; i < granteeList.size(); ++i) {
                            grantee = (String)granteeList.get(i);
                            for (int j = 0; j < roleList.size(); ++j) {
                                String roleName = (String)roleList.get(j);
                                gm.grant(grantee, roleName, grantor);
                            }
                        }
                    } else {
                        for (i = 0; i < granteeList.size(); ++i) {
                            grantee = (String)granteeList.get(i);
                            for (int j = 0; j < roleList.size(); ++j) {
                                gm.revoke(grantee, (String)roleList.get(j), grantor);
                            }
                        }
                    }
                    break;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 6: {
                return Result.updateZeroResult;
            }
            case 8: {
                Charset charset = (Charset)this.arguments[0];
                try {
                    this.setOrCheckObjectName(session, null, charset.getName(), true);
                    session.database.schemaManager.addSchemaObject(charset);
                    break;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 10: {
                return Result.updateZeroResult;
            }
            case 61: {
                try {
                    session.checkAdmin();
                    session.checkDDLWrite();
                    HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)this.arguments[0];
                    session.database.getGranteeManager().addRole(name);
                    break;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1053: {
                HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)this.arguments[0];
                String password = (String)this.arguments[1];
                Grantee grantor = (Grantee)this.arguments[2];
                boolean admin = (Boolean)this.arguments[3];
                try {
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.database.getUserManager().createUser(name, password);
                    if (!admin) break;
                    session.database.getGranteeManager().grant(name.name, "DBA", grantor);
                    break;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 64: {
                HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)this.arguments[0];
                Grantee owner = (Grantee)this.arguments[1];
                try {
                    session.checkDDLWrite();
                    if (session.database.schemaManager.schemaExists(name.name)) {
                        if (session.isProcessingScript && "PUBLIC".equals(name.name)) break;
                        throw Error.error(5504, name.name);
                    }
                    session.database.schemaManager.createSchema(name, owner);
                    break;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 14: {
                Routine routine = (Routine)this.arguments[0];
                try {
                    routine.resolve();
                    this.setOrCheckObjectName(session, null, routine.getName(), false);
                    session.database.schemaManager.addSchemaObject(routine);
                    break;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1051: {
                HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)this.arguments[0];
                Routine[] routines = (Routine[])this.arguments[1];
                try {
                    session.checkAdmin();
                    session.checkDDLWrite();
                    if (name == null) break;
                    for (int i = 0; i < routines.length; ++i) {
                        routines[i].setName(name);
                        session.database.schemaManager.addSchemaObject(routines[i]);
                    }
                    break;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 133: {
                NumberSequence sequence = (NumberSequence)this.arguments[0];
                try {
                    this.setOrCheckObjectName(session, null, sequence.getName(), true);
                    session.database.schemaManager.addSchemaObject(sequence);
                    break;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 23: {
                Type type = (Type)this.arguments[0];
                Constraint[] constraints = type.userTypeModifier.getConstraints();
                try {
                    this.setOrCheckObjectName(session, null, type.getName(), true);
                    for (int i = 0; i < constraints.length; ++i) {
                        Constraint c = constraints[i];
                        this.setOrCheckObjectName(session, type.getName(), c.getName(), true);
                        session.database.schemaManager.addSchemaObject(c);
                    }
                    session.database.schemaManager.addSchemaObject(type);
                    break;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 77: {
                Table table = (Table)this.arguments[0];
                HsqlArrayList tempConstraints = (HsqlArrayList)this.arguments[1];
                StatementDMQL statement = (StatementDMQL)this.arguments[2];
                HsqlArrayList foreignConstraints = null;
                try {
                    this.setOrCheckObjectName(session, null, table.getName(), true);
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
                try {
                    if (this.isSchemaDefinition) {
                        foreignConstraints = new HsqlArrayList();
                    }
                    if (tempConstraints != null) {
                        table = ParserDDL.addTableConstraintDefinitions(session, table, tempConstraints, foreignConstraints);
                        this.arguments[1] = foreignConstraints;
                    }
                    table.compile(session, null);
                    session.database.schemaManager.addSchemaObject(table);
                    if (statement != null) {
                        Result result = statement.execute(session);
                        table.insertIntoTable(session, result);
                    }
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    session.database.schemaManager.removeExportedKeys(table);
                    session.database.schemaManager.removeDependentObjects(table.getName());
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 117: {
                return Result.updateZeroResult;
            }
            case 79: {
                return Result.updateZeroResult;
            }
            case 80: {
                TriggerDef trigger = (TriggerDef)this.arguments[0];
                HsqlNameManager.HsqlName otherName = (HsqlNameManager.HsqlName)this.arguments[1];
                try {
                    this.checkSchemaUpdateAuthorisation(session, trigger.getSchemaName());
                    session.database.schemaManager.checkSchemaObjectNotExists(trigger.getName());
                    if (otherName != null && session.database.schemaManager.getSchemaObject(otherName) == null) {
                        throw Error.error(5501, otherName.name);
                    }
                    trigger.table.addTrigger(trigger, otherName);
                    session.database.schemaManager.addSchemaObject(trigger);
                    break;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 52: {
                return Result.updateZeroResult;
            }
            case 83: {
                Type type = (Type)this.arguments[0];
                try {
                    this.setOrCheckObjectName(session, null, type.getName(), true);
                    session.database.schemaManager.addSchemaObject(type);
                    break;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 114: {
                return Result.updateZeroResult;
            }
            case 84: {
                try {
                    session.parser.reset(this.sql);
                    session.parser.read();
                    session.parser.read();
                    session.parser.processCreateView();
                    break;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1052: {
                Table table = (Table)this.arguments[0];
                int[] indexColumns = (int[])this.arguments[1];
                HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)this.arguments[2];
                boolean unique = (Boolean)this.arguments[3];
                try {
                    this.setOrCheckObjectName(session, table.getName(), name, true);
                    TableWorks tableWorks = new TableWorks(session, table);
                    tableWorks.addIndex(indexColumns, name, unique);
                    break;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            default: {
                throw Error.runtimeError(401, "CompiledStateemntSchema");
            }
        }
        return Result.updateZeroResult;
    }

    private void dropType(Session session, HsqlNameManager.HsqlName name, boolean cascade) {
        this.checkSchemaUpdateAuthorisation(session, name.schema);
        Type distinct = (Type)session.database.schemaManager.getSchemaObject(name);
        session.database.schemaManager.removeSchemaObject(name, cascade);
        distinct.userTypeModifier = null;
    }

    private static void dropDomain(Session session, HsqlNameManager.HsqlName name, boolean cascade) {
        Type domain = (Type)session.database.schemaManager.getSchemaObject(name);
        OrderedHashSet set = session.database.schemaManager.getReferencingObjects(domain.getName());
        if (!cascade && set.size() > 0) {
            HsqlNameManager.HsqlName objectName = (HsqlNameManager.HsqlName)set.get(0);
            throw Error.error(5502, objectName.getSchemaQualifiedStatementName());
        }
        Constraint[] constraints = domain.userTypeModifier.getConstraints();
        set.clear();
        for (int i = 0; i < constraints.length; ++i) {
            set.add(constraints[i].getName());
        }
        session.database.schemaManager.removeSchemaObjects(set);
        session.database.schemaManager.removeSchemaObject(domain.getName(), cascade);
        domain.userTypeModifier = null;
    }

    private static void dropRole(Session session, HsqlNameManager.HsqlName name, boolean cascade) {
        Grantee role = session.database.getGranteeManager().getRole(name.name);
        if (!cascade && session.database.schemaManager.hasSchemas(role)) {
            HsqlArrayList list = session.database.schemaManager.getSchemas(role);
            Schema schema = (Schema)list.get(0);
            throw Error.error(5502, schema.getName().statementName);
        }
        session.database.schemaManager.dropSchemas(role, cascade);
        session.database.getGranteeManager().dropRole(name.name);
    }

    private static void dropUser(Session session, HsqlNameManager.HsqlName name, boolean cascade) {
        User grantee = session.database.getUserManager().get(name.name);
        if (session.database.getSessionManager().isUserActive(name.name)) {
            throw Error.error(5539);
        }
        if (!cascade && session.database.schemaManager.hasSchemas(grantee)) {
            HsqlArrayList list = session.database.schemaManager.getSchemas(grantee);
            Schema schema = (Schema)list.get(0);
            throw Error.error(5502, schema.getName().statementName);
        }
        session.database.schemaManager.dropSchemas(grantee, cascade);
        session.database.getUserManager().dropUser(name.name);
    }

    private void dropSchema(Session session, HsqlNameManager.HsqlName name, boolean cascade) {
        HsqlNameManager.HsqlName schema = session.database.schemaManager.getUserSchemaHsqlName(name.name);
        this.checkSchemaUpdateAuthorisation(session, schema);
        session.database.schemaManager.dropSchema(name.name, cascade);
    }

    private void dropRoutine(Session session, HsqlNameManager.HsqlName name, boolean cascade) {
        this.checkSchemaUpdateAuthorisation(session, name.schema);
        session.database.schemaManager.removeSchemaObject(name, cascade);
    }

    private void dropObject(Session session, HsqlNameManager.HsqlName name, boolean cascade) {
        name = session.database.schemaManager.getSchemaObjectName(name.schema, name.name, name.type, true);
        session.database.schemaManager.removeSchemaObject(name, cascade);
    }

    private void dropTable(Session session, HsqlNameManager.HsqlName name, boolean cascade) {
        Table table = session.database.schemaManager.findUserTable(session, name.name, name.schema.name);
        session.database.schemaManager.dropTableOrView(session, table, cascade);
    }

    void checkSchemaUpdateAuthorisation(Session session, HsqlNameManager.HsqlName schema) {
        if (session.isProcessingLog) {
            return;
        }
        if (session.database.schemaManager.isSystemSchema(schema.name)) {
            throw Error.error(5503);
        }
        if (session.parser.isSchemaDefinition) {
            if (schema == session.getCurrentSchemaHsqlName()) {
                return;
            }
            Error.error(5505, schema.name);
        }
        session.getGrantee().checkSchemaUpdateOrGrantRights(schema.name);
        session.checkDDLWrite();
    }

    void setOrCheckObjectName(Session session, HsqlNameManager.HsqlName parent, HsqlNameManager.HsqlName name, boolean check) {
        if (name.schema == null) {
            name.schema = this.schemaName == null ? session.getCurrentSchemaHsqlName() : this.schemaName;
        } else {
            name.schema = session.getSchemaHsqlName(name.schema.name);
            if (name.schema == null) {
                throw Error.error(5505);
            }
            if (this.isSchemaDefinition && this.schemaName != name.schema) {
                throw Error.error(5505);
            }
        }
        name.parent = parent;
        if (!this.isSchemaDefinition) {
            this.checkSchemaUpdateAuthorisation(session, name.schema);
        }
        if (check) {
            session.database.schemaManager.checkSchemaObjectNotExists(name);
        }
    }

    void setSchemaName(Session session, HsqlNameManager.HsqlName parent, HsqlNameManager.HsqlName name) {
        if (name.schema == null) {
            name.schema = this.schemaName == null ? session.getCurrentSchemaHsqlName() : this.schemaName;
        } else {
            name.schema = session.getSchemaHsqlName(name.schema.name);
            if (name.schema == null) {
                throw Error.error(5505);
            }
            if (this.isSchemaDefinition && this.schemaName != name.schema) {
                throw Error.error(5505);
            }
        }
    }

    @Override
    public boolean isAutoCommitStatement() {
        return true;
    }

    @Override
    public String describe(Session session) {
        return this.sql;
    }
}

