/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Collation;
import org.hsqldb.DatabaseManager;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.SchemaManager;
import org.hsqldb.Session;
import org.hsqldb.SessionManager;
import org.hsqldb.TransactionManager;
import org.hsqldb.TransactionManager2PL;
import org.hsqldb.dbinfo.DatabaseInformation;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.persist.HsqlDatabaseProperties;
import org.hsqldb.persist.HsqlProperties;
import org.hsqldb.persist.LobManager;
import org.hsqldb.persist.Logger;
import org.hsqldb.persist.PersistentStoreCollectionDatabase;
import org.hsqldb.result.Result;
import org.hsqldb.rights.GranteeManager;
import org.hsqldb.rights.User;
import org.hsqldb.rights.UserManager;
import org.hsqldb.types.Type;

public class Database {
    int databaseID;
    String databaseUniqueName;
    String databaseType;
    private final String canonicalPath;
    public HsqlProperties urlProperties;
    private final String path;
    DatabaseInformation dbInfo;
    private int dbState;
    public Logger logger;
    boolean databaseReadOnly;
    private boolean filesReadOnly;
    private boolean filesInJar;
    public boolean sqlEnforceSize;
    public boolean sqlEnforceNames;
    private boolean bIgnoreCase;
    private boolean isReferentialIntegrity;
    public HsqlDatabaseProperties databaseProperties;
    private final boolean shutdownOnNoConnection;
    int resultMaxMemoryRows;
    public UserManager userManager;
    public GranteeManager granteeManager;
    public HsqlNameManager nameManager;
    public SessionManager sessionManager;
    public TransactionManager txManager;
    public SchemaManager schemaManager;
    public PersistentStoreCollectionDatabase persistentStoreCollection;
    public LobManager lobManager;
    public Collation collation;
    public static final int DATABASE_ONLINE = 1;
    public static final int DATABASE_OPENING = 4;
    public static final int DATABASE_CLOSING = 8;
    public static final int DATABASE_SHUTDOWN = 16;
    public static final int CLOSEMODE_IMMEDIATELY = -1;
    public static final int CLOSEMODE_NORMAL = 0;
    public static final int CLOSEMODE_COMPACT = 1;
    public static final int CLOSEMODE_SCRIPT = 2;
    public static final int LOCKS = 0;
    public static final int MVLOCKS = 1;
    public static final int MVCC = 2;

    Database(String type, String path, String canonicalPath, HsqlProperties props) {
        this.setState(16);
        this.databaseType = type;
        this.path = path;
        this.canonicalPath = canonicalPath;
        this.urlProperties = props;
        if (this.databaseType == "res:") {
            this.filesInJar = true;
            this.filesReadOnly = true;
        }
        this.logger = new Logger(this);
        this.shutdownOnNoConnection = this.urlProperties.isPropertyTrue("shutdown");
        this.lobManager = new LobManager(this);
    }

    synchronized void open() {
        if (!this.isShutdown()) {
            return;
        }
        this.reopen();
    }

    void reopen() {
        boolean isNew = false;
        this.setState(4);
        try {
            this.nameManager = new HsqlNameManager(this);
            this.granteeManager = new GranteeManager(this);
            this.userManager = new UserManager(this);
            this.schemaManager = new SchemaManager(this);
            this.persistentStoreCollection = new PersistentStoreCollectionDatabase();
            this.isReferentialIntegrity = true;
            this.sessionManager = new SessionManager(this);
            Database database = this;
            this.collation = database.collation.getDefaultInstance();
            this.dbInfo = DatabaseInformation.newDatabaseInformation(this);
            this.txManager = new TransactionManager2PL(this);
            this.lobManager.createSchema();
            this.logger.openPersistence();
            isNew = this.logger.isNewDatabase;
            if (isNew) {
                this.userManager.createSAUser();
                this.schemaManager.createPublicSchema();
                this.lobManager.initialiseLobSpace();
                this.logger.checkpoint(false);
            }
            this.lobManager.open();
            this.dbInfo.setWithContent(true);
        }
        catch (Throwable e2) {
            HsqlException e2;
            this.logger.closePersistence(-1);
            this.logger.releaseLock();
            this.setState(16);
            this.clearStructures();
            DatabaseManager.removeDatabase(this);
            if (!(e2 instanceof HsqlException)) {
                e2 = Error.error(40, e2);
            }
            this.logger.logSevereEvent("could not reopen database", e2);
            throw e2;
        }
        this.setState(1);
    }

    void clearStructures() {
        if (this.schemaManager != null) {
            this.schemaManager.clearStructures();
        }
        this.granteeManager = null;
        this.userManager = null;
        this.nameManager = null;
        this.schemaManager = null;
        this.sessionManager = null;
        this.dbInfo = null;
    }

    public int getDatabaseID() {
        return this.databaseID;
    }

    public String getUniqueName() {
        return this.databaseUniqueName;
    }

    public void setUniqueName(String name) {
        this.databaseUniqueName = name;
    }

    public String getType() {
        return this.databaseType;
    }

    public String getPath() {
        return this.path;
    }

    public HsqlNameManager.HsqlName getCatalogName() {
        return this.nameManager.getCatalogName();
    }

    public HsqlDatabaseProperties getProperties() {
        return this.databaseProperties;
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public boolean isReadOnly() {
        return this.databaseReadOnly;
    }

    synchronized boolean isShutdown() {
        return this.dbState == 16;
    }

    synchronized Session connect(String username, String password, String zoneString, int timeZoneSeconds) {
        if (username.equalsIgnoreCase("SA")) {
            username = "SA";
        }
        User user = this.userManager.getUser(username, password);
        Session session = this.sessionManager.newSession(this, user, this.databaseReadOnly, false, zoneString, timeZoneSeconds);
        return session;
    }

    public void setReadOnly() {
        this.databaseReadOnly = true;
        this.filesReadOnly = true;
    }

    public void setFilesReadOnly() {
        this.filesReadOnly = true;
    }

    public boolean isFilesReadOnly() {
        return this.filesReadOnly;
    }

    public boolean isFilesInJar() {
        return this.filesInJar;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public GranteeManager getGranteeManager() {
        return this.granteeManager;
    }

    public void setReferentialIntegrity(boolean ref) {
        this.isReferentialIntegrity = ref;
    }

    public boolean isReferentialIntegrity() {
        return this.isReferentialIntegrity;
    }

    void setIgnoreCase(boolean b) {
        this.bIgnoreCase = b;
    }

    public boolean isIgnoreCase() {
        return this.bIgnoreCase;
    }

    public int getResultMaxMemoryRows() {
        return this.resultMaxMemoryRows;
    }

    public void setResultMaxMemoryRows(int size) {
        this.resultMaxMemoryRows = size;
    }

    public void setStrictNames(boolean mode) {
        this.sqlEnforceNames = mode;
    }

    public void setStrictColumnSize(boolean mode) {
        this.sqlEnforceSize = mode;
    }

    protected void finalize() {
        if (this.getState() != 1) {
            return;
        }
        try {
            this.close(-1);
        }
        catch (HsqlException hsqlException) {
            // empty catch block
        }
    }

    void closeIfLast() {
        if (this.shutdownOnNoConnection && this.sessionManager.isEmpty()) {
            if (this.dbState == 1) {
                try {
                    this.close(0);
                }
                catch (HsqlException hsqlException) {
                    // empty catch block
                }
            }
        }
    }

    public void close(int closemode) {
        HsqlException he = null;
        this.setState(8);
        this.sessionManager.closeAllSessions();
        this.sessionManager.clearAll();
        if (this.filesReadOnly) {
            closemode = -1;
        }
        this.logger.closePersistence(closemode);
        this.lobManager.close();
        try {
            if (closemode == 1) {
                this.clearStructures();
                this.reopen();
                this.setState(8);
                this.logger.closePersistence(0);
            }
        }
        catch (Throwable t) {
            he = t instanceof HsqlException ? (HsqlException)t : Error.error(40, t.toString());
        }
        this.logger.releaseLock();
        this.setState(16);
        this.clearStructures();
        DatabaseManager.removeDatabase(this);
        if (he != null) {
            throw he;
        }
    }

    public void setMetaDirty(boolean resetPrepared) {
        if (this.dbInfo != null) {
            this.dbInfo.setDirty();
        }
    }

    private synchronized void setState(int state) {
        this.dbState = state;
    }

    synchronized int getState() {
        return this.dbState;
    }

    String getStateString() {
        int state = this.getState();
        switch (state) {
            case 8: {
                return "DATABASE_CLOSING";
            }
            case 1: {
                return "DATABASE_ONLINE";
            }
            case 4: {
                return "DATABASE_OPENING";
            }
            case 16: {
                return "DATABASE_SHUTDOWN";
            }
        }
        return "UNKNOWN";
    }

    public String[] getSettingsSQL() {
        String name;
        HsqlArrayList list = new HsqlArrayList();
        if (!this.getCatalogName().name.equals("PUBLIC")) {
            name = this.getCatalogName().statementName;
            list.add("ALTER CATALOG PUBLIC RENAME TO " + name);
        }
        if (this.collation.collator != null) {
            name = this.collation.getName().statementName;
            list.add("SET DATABASE COLLATION " + name);
        }
        String[] array = new String[list.size()];
        list.toArray(array);
        return array;
    }

    public Result getScript(boolean indexRoots) {
        Result r = Result.newSingleColumnResult("COMMAND", Type.SQL_VARCHAR);
        String[] list = this.logger.getPropertiesSQL();
        Database.addRows(r, list);
        list = this.getSettingsSQL();
        Database.addRows(r, list);
        list = this.getGranteeManager().getSQL();
        Database.addRows(r, list);
        list = this.schemaManager.getSQLArray();
        Database.addRows(r, list);
        list = this.getUserManager().getInitialSchemaSQL();
        Database.addRows(r, list);
        list = this.getGranteeManager().getRightstSQL();
        Database.addRows(r, list);
        if (indexRoots) {
            list = this.schemaManager.getIndexRootsSQL();
            Database.addRows(r, list);
        }
        list = this.schemaManager.getTextTableSQL(!indexRoots);
        Database.addRows(r, list);
        return r;
    }

    private static void addRows(Result r, String[] sql) {
        if (sql == null) {
            return;
        }
        for (int i = 0; i < sql.length; ++i) {
            String[] s = new String[]{sql[i]};
            r.initialiseNavigator().add(s);
        }
    }

    public String getURI() {
        return this.databaseType + this.canonicalPath;
    }

    public String getCanonicalPath() {
        return this.canonicalPath;
    }

    public HsqlProperties getURLProperties() {
        return this.urlProperties;
    }
}

