/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnBase;
import org.hsqldb.Expression;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.rights.Grantee;
import org.hsqldb.types.Type;
import org.hsqldb.types.Types;

public final class ColumnSchema
extends ColumnBase
implements SchemaObject {
    public static final ColumnSchema[] emptyArray = new ColumnSchema[0];
    private HsqlNameManager.HsqlName columnName;
    private boolean isPrimaryKey;
    private Expression defaultExpression;
    private Expression generatingExpression;
    private NumberSequence sequence;

    public ColumnSchema(HsqlNameManager.HsqlName name, Type type, boolean isNullable, boolean isPrimaryKey, Expression defaultExpression) {
        this.columnName = name;
        this.nullability = isNullable ? (byte)1 : 0;
        this.dataType = type;
        this.isPrimaryKey = isPrimaryKey;
        this.defaultExpression = defaultExpression;
    }

    @Override
    public int getType() {
        return this.columnName.type;
    }

    @Override
    public HsqlNameManager.HsqlName getName() {
        return this.columnName;
    }

    @Override
    public String getNameString() {
        return this.columnName.name;
    }

    @Override
    public String getTableNameString() {
        return this.columnName.parent == null ? null : this.columnName.parent.name;
    }

    @Override
    public HsqlNameManager.HsqlName getSchemaName() {
        return this.columnName.schema;
    }

    @Override
    public String getSchemaNameString() {
        return this.columnName.schema == null ? null : this.columnName.schema.name;
    }

    @Override
    public HsqlNameManager.HsqlName getCatalogName() {
        return this.columnName.schema == null ? null : this.columnName.schema.schema;
    }

    @Override
    public String getCatalogNameString() {
        return this.columnName.schema == null ? null : (this.columnName.schema.schema == null ? null : this.columnName.schema.schema.name);
    }

    @Override
    public Grantee getOwner() {
        return this.columnName.schema == null ? null : this.columnName.schema.owner;
    }

    @Override
    public OrderedHashSet getReferences() {
        return new OrderedHashSet();
    }

    @Override
    public OrderedHashSet getComponents() {
        return null;
    }

    @Override
    public void compile(Session session, SchemaObject table) {
        if (this.generatingExpression == null) {
            return;
        }
        Expression.resolveGenerationExpression(session, (Table)table, this.generatingExpression);
        if (this.dataType.typeComparisonGroup != this.generatingExpression.getDataType().typeComparisonGroup) {
            throw Error.error(5561);
        }
    }

    @Override
    public String getSQL() {
        StringBuffer sb = new StringBuffer();
        switch (this.parameterMode) {
            case 1: {
                sb.append("IN").append(' ');
                break;
            }
            case 4: {
                sb.append("OUT").append(' ');
                break;
            }
            case 2: {
                sb.append("INOUT").append(' ');
            }
        }
        if (this.columnName != null) {
            sb.append(this.columnName.statementName);
            sb.append(' ');
        }
        sb.append(this.dataType.getTypeDefinition());
        return sb.toString();
    }

    @Override
    public void setType(Type type) {
        this.dataType = type;
    }

    public void setName(HsqlNameManager.HsqlName name) {
        this.columnName = name;
    }

    void setIdentity(NumberSequence sequence) {
        this.sequence = sequence;
        this.isIdentity = sequence != null;
    }

    void setType(ColumnSchema other) {
        this.nullability = other.nullability;
        this.dataType = other.dataType;
    }

    public NumberSequence getIdentitySequence() {
        return this.sequence;
    }

    @Override
    public boolean isNullable() {
        boolean isNullable = super.isNullable();
        if (isNullable && this.dataType.isDomainType()) {
            return this.dataType.userTypeModifier.isNullable();
        }
        return isNullable;
    }

    @Override
    public byte getNullability() {
        return this.isPrimaryKey ? (byte)0 : super.getNullability();
    }

    public boolean isGenerated() {
        return this.generatingExpression != null;
    }

    public boolean hasDefault() {
        return this.getDefaultExpression() != null;
    }

    @Override
    public boolean isWriteable() {
        return !this.isGenerated();
    }

    @Override
    public void setWriteable(boolean value) {
        throw Error.runtimeError(401, "ColumnSchema");
    }

    @Override
    public boolean isSearchable() {
        return Types.isSearchable(this.dataType.typeCode);
    }

    public boolean isPrimaryKey() {
        return this.isPrimaryKey;
    }

    void setPrimaryKey(boolean value) {
        this.isPrimaryKey = value;
    }

    Object getDefaultValue(Session session) {
        return this.defaultExpression == null ? null : this.defaultExpression.getValue(session, this.dataType);
    }

    Object getGeneratedValue(Session session) {
        return this.generatingExpression == null ? null : this.generatingExpression.getValue(session, this.dataType);
    }

    public String getDefaultSQL() {
        String ddl = null;
        ddl = this.defaultExpression == null ? null : this.defaultExpression.getSQL();
        return ddl;
    }

    Expression getDefaultExpression() {
        if (this.defaultExpression == null) {
            if (this.dataType.isDomainType()) {
                return this.dataType.userTypeModifier.getDefaultClause();
            }
            return null;
        }
        return this.defaultExpression;
    }

    void setDefaultExpression(Expression expr) {
        this.defaultExpression = expr;
    }

    Expression getGeneratingExpression() {
        return this.generatingExpression;
    }

    void setGeneratingExpression(Expression expr) {
        this.generatingExpression = expr;
    }

    public ColumnSchema duplicate() {
        ColumnSchema copy = new ColumnSchema(this.columnName, this.dataType, this.isNullable(), this.isPrimaryKey, this.defaultExpression);
        copy.setGeneratingExpression(this.generatingExpression);
        copy.setIdentity(this.sequence);
        return copy;
    }
}

