/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.datechooser;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;

public class DateChooserTheme {
    public static final DateChooserTheme GRAY = new DateChooserTheme();
    public static final DateChooserTheme BLUE = DateChooserTheme.createBlueTheme();
    public static final DateChooserTheme YELLOW = DateChooserTheme.createYellowTheme();
    protected static DateChooserTheme defaultTheme = GRAY;
    Color headerBackground;
    Color headerForeground;
    Color gridHeaderBackground;
    Color gridHeaderForeground;
    Color gridLinesColor;
    Color dayCellBackground;
    Color dayCellForeground;
    Color selectedBackground;
    Color selectedForeground;
    Color todayBackground;
    Color todayForeground;
    Color extraMonthForeground;
    Color weekendForeground;
    Color focusColor;
    boolean gridVisible = true;
    int cellPadding = 2;
    Font font = null;

    public DateChooserTheme() {
        Display display = Display.getCurrent();
        this.headerBackground = display.getSystemColor(22);
        this.headerForeground = display.getSystemColor(21);
        this.gridHeaderBackground = this.headerBackground;
        this.gridHeaderForeground = this.headerForeground;
        this.gridLinesColor = display.getSystemColor(15);
        this.dayCellBackground = display.getSystemColor(1);
        this.dayCellForeground = this.headerForeground;
        this.selectedBackground = display.getSystemColor(7);
        this.selectedForeground = this.headerForeground;
        this.todayBackground = this.headerBackground;
        this.todayForeground = this.headerForeground;
        this.extraMonthForeground = this.gridLinesColor;
        this.weekendForeground = display.getSystemColor(4);
        this.focusColor = display.getSystemColor(3);
    }

    private static DateChooserTheme createBlueTheme() {
        Display display = Display.getCurrent();
        DateChooserTheme theme = new DateChooserTheme();
        theme.gridHeaderBackground = theme.headerBackground = new Color((Device)display, 170, 190, 220);
        theme.dayCellBackground = new Color((Device)display, 190, 220, 240);
        theme.extraMonthForeground = display.getSystemColor(16);
        theme.weekendForeground = display.getSystemColor(3);
        theme.todayBackground = display.getSystemColor(1);
        return theme;
    }

    private static DateChooserTheme createYellowTheme() {
        Display display = Display.getCurrent();
        DateChooserTheme theme = new DateChooserTheme();
        theme.gridHeaderBackground = theme.headerBackground = new Color((Device)display, 190, 180, 60);
        theme.dayCellBackground = new Color((Device)display, 255, 255, 170);
        theme.extraMonthForeground = display.getSystemColor(16);
        theme.weekendForeground = display.getSystemColor(3);
        theme.todayBackground = display.getSystemColor(15);
        theme.selectedBackground = display.getSystemColor(6);
        theme.selectedForeground = display.getSystemColor(1);
        return theme;
    }

    public static DateChooserTheme getDefaultTheme() {
        return defaultTheme;
    }

    public static void setDefaultTheme(DateChooserTheme defaultTheme) {
        DateChooserTheme.defaultTheme = defaultTheme;
    }

    public void setDayCellBackground(Color dayCellBackground) {
        this.dayCellBackground = dayCellBackground;
    }

    public void setDayCellBackground(int dayCellBackground) {
        this.dayCellBackground = Display.getCurrent().getSystemColor(dayCellBackground);
    }

    public void setDayCellForeground(Color dayCellForeground) {
        this.dayCellForeground = dayCellForeground;
    }

    public void setDayCellForeground(int dayCellForeground) {
        this.dayCellForeground = Display.getCurrent().getSystemColor(dayCellForeground);
    }

    public void setGridHeaderBackground(Color gridHeaderBackground) {
        this.gridHeaderBackground = gridHeaderBackground;
    }

    public void setGridHeaderBackground(int gridHeaderBackground) {
        this.gridHeaderBackground = Display.getCurrent().getSystemColor(gridHeaderBackground);
    }

    public void setGridHeaderForeground(Color gridHeaderForeground) {
        this.gridHeaderForeground = gridHeaderForeground;
    }

    public void setGridHeaderForeground(int gridHeaderForeground) {
        this.gridHeaderForeground = Display.getCurrent().getSystemColor(gridHeaderForeground);
    }

    public void setGridLinesColor(Color gridLinesColor) {
        this.gridLinesColor = gridLinesColor;
    }

    public void setGridLinesColor(int gridLinesColor) {
        this.gridLinesColor = Display.getCurrent().getSystemColor(gridLinesColor);
    }

    public void setHeaderBack(Color headerBackground) {
        this.headerBackground = headerBackground;
    }

    public void setHeaderBack(int headerBackground) {
        this.headerBackground = Display.getCurrent().getSystemColor(headerBackground);
    }

    public void setHeaderForg(Color headerForeground) {
        this.headerForeground = headerForeground;
    }

    public void setHeaderForg(int headerForeground) {
        this.headerForeground = Display.getCurrent().getSystemColor(headerForeground);
    }

    public void setSelectedBackground(Color selectedBackground) {
        this.selectedBackground = selectedBackground;
    }

    public void setSelectedBackground(int selectedBackground) {
        this.selectedBackground = Display.getCurrent().getSystemColor(selectedBackground);
    }

    public void setSelectedForeground(Color selectedForeground) {
        this.selectedForeground = selectedForeground;
    }

    public void setSelectedForeground(int selectedForeground) {
        this.selectedForeground = Display.getCurrent().getSystemColor(selectedForeground);
    }

    public void setTodayBackground(Color todayBackground) {
        this.todayBackground = todayBackground;
    }

    public void setTodayBackground(int todayBackground) {
        this.todayBackground = Display.getCurrent().getSystemColor(todayBackground);
    }

    public void setTodayForeground(Color todayForeground) {
        this.todayForeground = todayForeground;
    }

    public void setTodayForeground(int todayForeground) {
        this.todayForeground = Display.getCurrent().getSystemColor(todayForeground);
    }

    public void setExtraMonthForeground(Color extraMonthForeground) {
        this.extraMonthForeground = extraMonthForeground;
    }

    public void setAdjascentForeground(int extraMonthForeground) {
        this.extraMonthForeground = Display.getCurrent().getSystemColor(extraMonthForeground);
    }

    public void setWeekendForeground(Color weekendForeground) {
        this.weekendForeground = weekendForeground;
    }

    public void setWeekendForeground(int weekendForeground) {
        this.weekendForeground = Display.getCurrent().getSystemColor(weekendForeground);
    }

    public void setFocusColor(Color focusColor) {
        this.focusColor = focusColor;
    }

    public void setFocusColor(int focusColor) {
        this.focusColor = Display.getCurrent().getSystemColor(focusColor);
    }

    public void setGridVisible(boolean gridVisible) {
        this.gridVisible = gridVisible;
    }

    public void setCellPadding(int cellPadding) {
        this.cellPadding = cellPadding;
    }

    public void setFont(Font font) {
        this.font = font;
    }
}

