/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.datechooser;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TypedListener;

public abstract class AbstractCombo
extends Composite {
    public static final boolean GTK = "gtk".equals(SWT.getPlatform());
    public static final boolean WIN32 = "win32".equals(SWT.getPlatform());
    protected Text text;
    protected Shell popup;
    protected Button button;
    protected Control popupContent;
    protected Listener listener;
    protected Listener filter;
    protected boolean hasFocus;
    protected boolean showButtonOnFocus = false;

    public AbstractCombo(Composite parent, int style) {
        super(parent, style);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        super.setLayout((Layout)layout);
        int textStyle = 4;
        if ((style & 8) != 0) {
            textStyle |= 8;
        }
        if ((style & 0x800000) != 0) {
            textStyle |= 0x800000;
        }
        this.createTextControl(textStyle);
        GridData data = new GridData(1808);
        this.text.setLayoutData((Object)data);
        int buttonStyle = 1028;
        if ((style & 0x800000) != 0) {
            buttonStyle |= 0x800000;
        }
        this.createButtonControl(buttonStyle);
        this.button.setLayoutData((Object)new GridData(1040));
        this.listener = new Listener(){

            public void handleEvent(Event event) {
                if (AbstractCombo.this.popup == event.widget) {
                    AbstractCombo.this.popupEvent(event);
                    return;
                }
                if (AbstractCombo.this.text == event.widget) {
                    AbstractCombo.this.textEvent(event);
                    return;
                }
                if (AbstractCombo.this.popupContent == event.widget) {
                    AbstractCombo.this.contentEvent(event);
                    return;
                }
                if (AbstractCombo.this.button == event.widget) {
                    AbstractCombo.this.buttonEvent(event);
                    return;
                }
                if (AbstractCombo.this == event.widget) {
                    AbstractCombo.this.comboEvent(event);
                    return;
                }
                if (AbstractCombo.this.getShell() == event.widget) {
                    AbstractCombo.this.handleFocus(16);
                }
            }
        };
        this.filter = new Listener(){

            public void handleEvent(Event event) {
                Shell shell = ((Control)event.widget).getShell();
                if (shell == AbstractCombo.this.getShell()) {
                    AbstractCombo.this.handleFocus(16);
                }
            }
        };
        this.addListener(12, this.listener);
        this.addListener(10, this.listener);
        this.text.addListener(24, this.listener);
        this.text.addListener(15, this.listener);
        this.button.addListener(13, this.listener);
        this.button.addListener(15, this.listener);
    }

    public void addModifyListener(ModifyListener lsnr) {
        this.checkWidget();
        if (lsnr == null) {
            SWT.error((int)4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)lsnr);
        this.addListener(24, (Listener)typedListener);
    }

    public void addSelectionListener(SelectionListener lsnr) {
        this.checkWidget();
        if (lsnr == null) {
            SWT.error((int)4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)lsnr);
        this.addListener(13, (Listener)typedListener);
        this.addListener(14, (Listener)typedListener);
    }

    protected void beforeDrop() {
    }

    protected void buttonEvent(Event event) {
        switch (event.type) {
            case 15: {
                this.handleFocus(15);
                break;
            }
            case 13: {
                this.dropDown(!this.isDropped());
            }
        }
    }

    protected void comboEvent(Event event) {
        switch (event.type) {
            case 12: {
                if (this.popup != null && !this.popup.isDisposed()) {
                    this.popupContent.removeListener(12, this.listener);
                    this.popup.dispose();
                }
                this.getShell().removeListener(27, this.listener);
                this.getDisplay().removeFilter(15, this.filter);
                this.popup = null;
                this.text = null;
                this.popupContent = null;
                this.button = null;
                break;
            }
            case 10: {
                this.dropDown(false);
            }
        }
    }

    protected void contentEvent(Event event) {
        switch (event.type) {
            case 13: {
                Event e = new Event();
                e.time = event.time;
                e.stateMask = event.stateMask;
                e.doit = event.doit;
                e.data = event.data;
                this.notifyListeners(13, e);
                event.doit = e.doit;
            }
        }
    }

    protected void createButtonControl(int style) {
        this.button = new Button((Composite)this, style);
    }

    protected abstract void createPopupContent();

    protected void createTextControl(int style) {
        this.text = new Text((Composite)this, style);
    }

    public void dispose() {
        if (this.popupContent != null && !this.popupContent.isDisposed()) {
            this.popupContent.removeListener(12, this.listener);
            this.popupContent.dispose();
        }
        if (this.popup != null && !this.popup.isDisposed()) {
            this.popup.dispose();
        }
        super.dispose();
    }

    protected void dropDown(boolean drop) {
        if (drop == this.isDropped()) {
            return;
        }
        if (drop) {
            this.popup = new Shell(this.getShell(), 16388);
            this.popup.setLayout((Layout)new FillLayout());
            this.createPopupContent();
            this.popupContent.setFont(this.text.getFont());
            this.popupContent.setForeground(this.text.getForeground());
            this.popup.pack();
            this.popup.addListener(27, this.listener);
            this.popup.addListener(21, this.listener);
            this.popupContent.addListener(13, this.listener);
            this.setPopupLocation();
            this.beforeDrop();
            this.popup.setVisible(true);
            this.popupContent.forceFocus();
        } else {
            this.popupContent.removeListener(12, this.listener);
            this.popupContent.dispose();
            this.popup.dispose();
            this.popupContent = null;
            this.popup = null;
            if (!this.isDisposed() && this.button.isFocusControl()) {
                this.text.setFocus();
            }
        }
    }

    public boolean getEditable() {
        this.checkWidget();
        return this.text.getEditable();
    }

    public Point getSelection() {
        this.checkWidget();
        return this.text.getSelection();
    }

    public int getStyle() {
        int style = super.getStyle();
        style &= 0xFFFFFFF7;
        if (!this.text.getEditable()) {
            style |= 8;
        }
        return style;
    }

    public String getText() {
        this.checkWidget();
        return this.text.getText();
    }

    public int getTextHeight() {
        this.checkWidget();
        return this.text.getLineHeight();
    }

    protected void handleFocus(int type) {
        if (this.isDisposed()) {
            return;
        }
        switch (type) {
            case 15: {
                if (this.hasFocus) {
                    return;
                }
                this.hasFocus = true;
                this.updateButtonDisplay();
                Shell shell = this.getShell();
                shell.removeListener(27, this.listener);
                shell.addListener(27, this.listener);
                Display display = this.getDisplay();
                display.removeFilter(15, this.filter);
                this.notifyListeners(15, new Event());
                display.addFilter(15, this.filter);
                break;
            }
            case 16: {
                if (!this.hasFocus) {
                    return;
                }
                Control focusControl = this.getDisplay().getFocusControl();
                if (focusControl == this.button || this.popupContent != null && this.popupContent.isFocusControl() || focusControl == this.text) {
                    return;
                }
                this.hasFocus = false;
                this.updateButtonDisplay();
                Shell shell = this.getShell();
                shell.removeListener(27, this.listener);
                this.getDisplay().removeFilter(15, this.filter);
                this.notifyListeners(16, new Event());
            }
        }
    }

    protected boolean isDropped() {
        return this.popup != null;
    }

    public boolean isFocusControl() {
        this.checkWidget();
        if (this.text.isFocusControl() || this.button.isFocusControl() || this.popupContent != null && this.popupContent.isFocusControl() || this.popup != null && this.popup.isFocusControl()) {
            return true;
        }
        return super.isFocusControl();
    }

    public boolean isShowButtonOnFocus() {
        return this.showButtonOnFocus;
    }

    protected void popupEvent(Event event) {
        switch (event.type) {
            case 27: {
                this.dropDown(false);
                break;
            }
            case 21: {
                event.doit = false;
                this.dropDown(false);
                this.text.setFocus();
            }
        }
    }

    public void removeModifyListener(ModifyListener lsnr) {
        this.checkWidget();
        if (lsnr == null) {
            SWT.error((int)4);
        }
        this.removeListener(24, (SWTEventListener)lsnr);
    }

    public void removeSelectionListener(SelectionListener lsnr) {
        this.checkWidget();
        if (lsnr == null) {
            SWT.error((int)4);
        }
        this.removeListener(13, (SWTEventListener)lsnr);
        this.removeListener(14, (SWTEventListener)lsnr);
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.text != null) {
            this.text.setBackground(color);
        }
        if (this.popupContent != null) {
            this.popupContent.setBackground(color);
        }
        if (this.button != null) {
            this.button.setBackground(color);
        }
    }

    public void setEditable(boolean editable) {
        this.checkWidget();
        this.text.setEditable(editable);
        this.button.setEnabled(editable);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.text != null) {
            this.text.setEnabled(enabled);
        }
        if (this.button != null) {
            this.button.setEnabled(enabled);
        }
    }

    public boolean setFocus() {
        this.checkWidget();
        return this.text.setFocus();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.text.setFont(font);
        this.pack();
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.text != null) {
            this.text.setForeground(color);
        }
        if (this.button != null) {
            this.button.setForeground(color);
        }
    }

    public void setLayout(Layout layout) {
        this.checkWidget();
    }

    protected void setPopupLocation() {
        Display display = Display.getCurrent();
        Rectangle r = this.getBounds();
        Point p = display.map((Control)this, null, 0, r.height);
        Rectangle sb = display.getBounds();
        if (p.y + this.popup.getSize().y > sb.height) {
            p.y -= r.height + this.popup.getSize().y + this.getBorderWidth();
        }
        if (p.x + this.popup.getSize().x > sb.width) {
            p.x -= this.popup.getSize().x - r.width + this.getBorderWidth();
        }
        this.popup.setLocation(p.x, p.y);
    }

    public void setSelection(Point selection) {
        this.checkWidget();
        if (selection == null) {
            SWT.error((int)4);
        }
        this.text.setSelection(selection.x, selection.y);
    }

    public void setShowButtonOnFocus(boolean showButtonOnFocus) {
        this.showButtonOnFocus = showButtonOnFocus;
        this.updateButtonDisplay();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this.isDisposed()) {
            return;
        }
        if (!visible) {
            this.dropDown(false);
        }
    }

    protected void textEvent(Event event) {
        switch (event.type) {
            case 15: {
                this.handleFocus(15);
                break;
            }
            case 24: {
                Event e = new Event();
                e.time = event.time;
                this.notifyListeners(24, e);
            }
        }
    }

    protected void updateButtonDisplay() {
        if (this.showButtonOnFocus) {
            GridData data = (GridData)this.button.getLayoutData();
            data.exclude = !this.hasFocus;
            this.button.setVisible(this.hasFocus);
            super.layout(false);
        }
    }
}

