/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util.preprocessor;

import java.util.Hashtable;
import org.hsqldb.util.preprocessor.Parser;
import org.hsqldb.util.preprocessor.PreprocessorException;
import org.hsqldb.util.preprocessor.Tokenizer;

class Defines {
    private Hashtable symbols = new Hashtable();

    public Defines() {
    }

    public Defines(String csvExpressions) throws PreprocessorException {
        this.defineCSV(csvExpressions);
    }

    public void clear() {
        this.symbols.clear();
    }

    public void defineCSV(String csvExpressions) throws PreprocessorException {
        if (csvExpressions != null) {
            csvExpressions = csvExpressions + ',';
            int start = 0;
            int len = csvExpressions.length();
            while (start < len) {
                int end = csvExpressions.indexOf(44, start);
                String expr = csvExpressions.substring(start, end).trim();
                if (expr.length() > 0) {
                    this.defineSingle(expr);
                }
                start = end + 1;
            }
        }
    }

    public void defineSingle(String expression) throws PreprocessorException {
        Tokenizer tokenizer = new Tokenizer(expression);
        tokenizer.next();
        if (!tokenizer.isToken(1)) {
            throw new PreprocessorException("IDENT token required at position: " + tokenizer.getStartIndex() + " in [" + expression + "]");
        }
        String ident = tokenizer.getIdent();
        int tokenType = tokenizer.next();
        switch (tokenType) {
            case -1: {
                this.symbols.put(ident, ident);
                return;
            }
            case 61: {
                tokenType = tokenizer.next();
                break;
            }
        }
        switch (tokenType) {
            case 2: {
                Number number = tokenizer.getNumber();
                this.symbols.put(ident, number);
                break;
            }
            case 3: {
                String string = tokenizer.getString();
                this.symbols.put(ident, string);
                break;
            }
            case 1: {
                String rhsIdent = tokenizer.getIdent();
                if (!this.isDefined(rhsIdent)) {
                    throw new PreprocessorException("Right hand sideIDENT token [" + rhsIdent + "] at position: " + tokenizer.getStartIndex() + " is undefined in [" + expression + "]");
                }
                Object value = this.symbols.get(rhsIdent);
                this.symbols.put(ident, value);
                break;
            }
            default: {
                throw new PreprocessorException("Right hand side NUMBER,STRING or IDENT token required at position: " + tokenizer.getStartIndex() + " in [" + expression + "]");
            }
        }
        tokenizer.next();
        if (!tokenizer.isToken(-1)) {
            throw new PreprocessorException("Illegal trailing characters at position: " + tokenizer.getStartIndex() + " in [" + expression + "]");
        }
    }

    public void undefine(String symbol) {
        this.symbols.remove(symbol);
    }

    public boolean isDefined(String symbol) {
        return this.symbols.containsKey(symbol);
    }

    public Object getDefintion(String symbol) {
        return this.symbols.get(symbol);
    }

    public boolean evaluate(String expression) throws PreprocessorException {
        Tokenizer tokenizer = new Tokenizer(expression);
        tokenizer.next();
        Parser parser = new Parser(this, tokenizer);
        boolean result = parser.parseExpression();
        if (!tokenizer.isToken(-1)) {
            throw new PreprocessorException("Illegal trailing characters at position: " + tokenizer.getStartIndex() + " in [" + expression + "]");
        }
        return result;
    }

    public String toString() {
        return super.toString() + this.symbols.toString();
    }
}

