/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

import org.hsqldb.error.Error;
import org.hsqldb.types.IntervalType;

public class IntervalMonthData {
    public final long units;

    public static IntervalMonthData newIntervalYear(long years, IntervalType type) {
        return new IntervalMonthData(years * 12L, type);
    }

    public static IntervalMonthData newIntervalMonth(long months, IntervalType type) {
        return new IntervalMonthData(months, type);
    }

    public IntervalMonthData(long months, IntervalType type) {
        if (months >= type.getIntervalValueLimit()) {
            throw Error.error(3406);
        }
        if (type.typeCode == 101) {
            months -= months % 12L;
        }
        this.units = months;
    }

    public IntervalMonthData(long months) {
        this.units = months;
    }

    public boolean equals(Object other) {
        if (other instanceof IntervalMonthData) {
            return this.units == ((IntervalMonthData)other).units;
        }
        return false;
    }

    public int hashCode() {
        return (int)this.units;
    }

    public int compareTo(IntervalMonthData b) {
        long diff = this.units - b.units;
        if (diff == 0L) {
            return 0;
        }
        return diff > 0L ? 1 : -1;
    }

    public String toString() {
        throw Error.runtimeError(401, "IntervalMonthData");
    }
}

