/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.HsqlException;
import org.hsqldb.Session;
import org.hsqldb.SessionInterface;
import org.hsqldb.error.Error;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.types.DTIType;
import org.hsqldb.types.IntervalMonthData;
import org.hsqldb.types.IntervalSecondData;
import org.hsqldb.types.IntervalType;
import org.hsqldb.types.TimeData;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;

public final class DateTimeType
extends DTIType {
    public final boolean withTimeZone;

    public DateTimeType(int typeGroup, int type, int scale) {
        super(typeGroup, type, 0L, scale);
        this.withTimeZone = type == 94 || type == 95;
    }

    @Override
    public int displaySize() {
        switch (this.typeCode) {
            case 91: {
                return 10;
            }
            case 92: {
                return 8 + (this.scale == 0 ? 0 : this.scale + 1);
            }
            case 94: {
                return 8 + (this.scale == 0 ? 0 : this.scale + 1) + 6;
            }
            case 93: {
                return 19 + (this.scale == 0 ? 0 : this.scale + 1);
            }
            case 95: {
                return 19 + (this.scale == 0 ? 0 : this.scale + 1) + 6;
            }
        }
        throw Error.runtimeError(401, "DateTimeType");
    }

    @Override
    public int getJDBCTypeCode() {
        return this.typeCode;
    }

    @Override
    public String getJDBCClassName() {
        switch (this.typeCode) {
            case 91: {
                return "java.sql.Date";
            }
            case 92: 
            case 94: {
                return "java.sql.Time";
            }
            case 93: 
            case 95: {
                return "java.sql.Timestamp";
            }
        }
        throw Error.runtimeError(401, "DateTimeType");
    }

    @Override
    public int getJDBCPrecision() {
        return this.displaySize();
    }

    @Override
    public int getSQLGenericTypeCode() {
        return 9;
    }

    @Override
    public String getNameString() {
        switch (this.typeCode) {
            case 91: {
                return "DATE";
            }
            case 92: {
                return "TIME";
            }
            case 94: {
                return "TIME WITH TIME ZONE";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case 95: {
                return "TIMESTAMP WITH TIME ZONE";
            }
        }
        throw Error.runtimeError(401, "DateTimeType");
    }

    @Override
    public String getDefinition() {
        String token;
        if (this.scale == 0) {
            return this.getNameString();
        }
        switch (this.typeCode) {
            case 91: {
                return "DATE";
            }
            case 92: 
            case 94: {
                if (this.scale == 0) {
                    return this.getNameString();
                }
                token = "TIME";
                break;
            }
            case 93: 
            case 95: {
                if (this.scale == 6) {
                    return this.getNameString();
                }
                token = "TIMESTAMP";
                break;
            }
            default: {
                throw Error.runtimeError(401, "DateTimeType");
            }
        }
        StringBuffer sb = new StringBuffer(16);
        sb.append(token);
        sb.append('(');
        sb.append(this.scale);
        sb.append(')');
        if (this.withTimeZone) {
            sb.append(" WITH TIME ZONE");
        }
        return sb.toString();
    }

    @Override
    public boolean isDateTimeType() {
        return true;
    }

    @Override
    public boolean isDateTimeTypeWithZone() {
        return this.withTimeZone;
    }

    @Override
    public boolean acceptsFractionalPrecision() {
        return this.typeCode != 91;
    }

    @Override
    public Type getAggregateType(Type other) {
        int startType;
        if (this.typeCode == other.typeCode) {
            return this.scale >= other.scale ? this : other;
        }
        if (other.typeCode == 0) {
            return this;
        }
        if (other.isCharacterType()) {
            return other.getAggregateType(this);
        }
        if (!other.isDateTimeType()) {
            throw Error.error(5562);
        }
        DateTimeType otherType = (DateTimeType)other;
        if (otherType.startIntervalType > this.endIntervalType || this.startIntervalType > otherType.endIntervalType) {
            throw Error.error(5562);
        }
        int newType = this.typeCode;
        int scale = this.scale > otherType.scale ? this.scale : otherType.scale;
        boolean zone = this.withTimeZone || otherType.withTimeZone;
        int n = startType = otherType.startIntervalType > this.startIntervalType ? this.startIntervalType : otherType.startIntervalType;
        newType = startType == 104 ? (zone ? 94 : 92) : (zone ? 95 : 93);
        return DateTimeType.getDateTimeType(newType, scale);
    }

    @Override
    public Type getCombinedType(Type other, int operation) {
        switch (operation) {
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                int startType;
                if (this.typeCode == other.typeCode) {
                    return this;
                }
                if (other.typeCode == 0) {
                    return this;
                }
                if (!other.isDateTimeType()) {
                    throw Error.error(5562);
                }
                DateTimeType otherType = (DateTimeType)other;
                if (otherType.startIntervalType > this.endIntervalType || this.startIntervalType > otherType.endIntervalType) {
                    throw Error.error(5562);
                }
                int newType = this.typeCode;
                int scale = this.scale > otherType.scale ? this.scale : otherType.scale;
                boolean zone = this.withTimeZone || otherType.withTimeZone;
                int n = startType = otherType.startIntervalType > this.startIntervalType ? this.startIntervalType : otherType.startIntervalType;
                newType = startType == 104 ? (zone ? 94 : 92) : (zone ? 95 : 93);
                return DateTimeType.getDateTimeType(newType, scale);
            }
            case 32: 
            case 33: {
                if (!other.isIntervalType()) break;
                if (this.typeCode != 91 && other.scale > this.scale) {
                    return DateTimeType.getDateTimeType(this.typeCode, other.scale);
                }
                return this;
            }
        }
        throw Error.error(5562);
    }

    @Override
    public int compare(Session session, Object a, Object b) {
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        switch (this.typeCode) {
            case 92: 
            case 94: {
                long diff = ((TimeData)a).getSeconds() - ((TimeData)b).getSeconds();
                if (diff == 0L) {
                    diff = ((TimeData)a).getNanos() - ((TimeData)b).getNanos();
                }
                return diff == 0L ? 0 : (diff > 0L ? 1 : -1);
            }
            case 91: 
            case 93: 
            case 95: {
                long diff = ((TimestampData)a).getSeconds() - ((TimestampData)b).getSeconds();
                if (diff == 0L) {
                    diff = ((TimestampData)a).getNanos() - ((TimestampData)b).getNanos();
                }
                return diff == 0L ? 0 : (diff > 0L ? 1 : -1);
            }
        }
        throw Error.runtimeError(401, "DateTimeType");
    }

    @Override
    public Object convertToTypeLimits(SessionInterface session, Object a) {
        if (a == null) {
            return null;
        }
        if (this.scale == 9) {
            return a;
        }
        switch (this.typeCode) {
            case 91: {
                return a;
            }
            case 92: 
            case 94: {
                TimeData ti = (TimeData)a;
                int nanos = ti.getNanos();
                int newNanos = this.scaleNanos(nanos);
                if (newNanos == nanos) {
                    return ti;
                }
                return new TimeData(ti.getSeconds(), newNanos, ti.getZone());
            }
            case 93: 
            case 95: {
                TimestampData ts = (TimestampData)a;
                int nanos = ts.getNanos();
                int newNanos = this.scaleNanos(nanos);
                if (newNanos == nanos) {
                    return ts;
                }
                return new TimestampData(ts.getSeconds(), newNanos, ts.getZone());
            }
        }
        throw Error.runtimeError(401, "DateTimeType");
    }

    int scaleNanos(int nanos) {
        int divisor = nanoScaleFactors[this.scale];
        return nanos / divisor * divisor;
    }

    @Override
    public Object convertToType(SessionInterface session, Object a, Type otherType) {
        if (a == null) {
            return a;
        }
        switch (otherType.typeCode) {
            case 40: {
                a = a.toString();
            }
            case 1: 
            case 12: 
            case 100: {
                switch (this.typeCode) {
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: {
                        return session.getScanner().convertToDatetimeInterval(session, (String)a, this);
                    }
                }
                break;
            }
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: {
                break;
            }
            default: {
                throw Error.error(5561);
            }
        }
        switch (this.typeCode) {
            case 91: {
                switch (otherType.typeCode) {
                    case 91: {
                        return a;
                    }
                    case 95: {
                        long seconds = ((TimestampData)a).getSeconds() + (long)((TimestampData)a).getZone();
                        long l = HsqlDateTime.getNormalisedDate(seconds * 1000L);
                        return new TimestampData(l / 1000L);
                    }
                    case 93: {
                        long l = HsqlDateTime.getNormalisedDate(((TimestampData)a).getSeconds() * 1000L);
                        return new TimestampData(l / 1000L);
                    }
                }
                throw Error.error(5561);
            }
            case 94: {
                switch (otherType.typeCode) {
                    case 94: {
                        return this.convertToTypeLimits(session, a);
                    }
                    case 92: {
                        TimeData ti = (TimeData)a;
                        return new TimeData(ti.getSeconds() - session.getZoneSeconds(), this.scaleNanos(ti.getNanos()), session.getZoneSeconds());
                    }
                    case 95: {
                        TimestampData ts = (TimestampData)a;
                        long seconds = HsqlDateTime.convertToNormalisedTime(ts.getSeconds() * 1000L) / 1000L;
                        return new TimeData((int)seconds, this.scaleNanos(ts.getNanos()), ts.getZone());
                    }
                    case 93: {
                        TimestampData ts = (TimestampData)a;
                        long seconds = ts.getSeconds() - (long)session.getZoneSeconds();
                        seconds = HsqlDateTime.convertToNormalisedTime(seconds * 1000L) / 1000L;
                        return new TimeData((int)seconds, this.scaleNanos(ts.getNanos()), session.getZoneSeconds());
                    }
                }
                throw Error.error(5561);
            }
            case 92: {
                switch (otherType.typeCode) {
                    case 94: {
                        TimeData ti = (TimeData)a;
                        return new TimeData(ti.getSeconds() + ti.getZone(), this.scaleNanos(ti.getNanos()), 0);
                    }
                    case 92: {
                        return this.convertToTypeLimits(session, a);
                    }
                    case 95: {
                        TimestampData ts = (TimestampData)a;
                        long seconds = ts.getSeconds() + (long)ts.getZone();
                        seconds = HsqlDateTime.convertToNormalisedTime(seconds * 1000L) / 1000L;
                        return new TimeData((int)seconds, this.scaleNanos(ts.getNanos()), 0);
                    }
                    case 93: {
                        TimestampData ts = (TimestampData)a;
                        long seconds = HsqlDateTime.convertToNormalisedTime(ts.getSeconds() * 1000L) / 1000L;
                        return new TimeData((int)seconds, this.scaleNanos(ts.getNanos()));
                    }
                }
                throw Error.error(5561);
            }
            case 95: {
                switch (otherType.typeCode) {
                    case 94: {
                        TimeData ti = (TimeData)a;
                        long seconds = session.getCurrentDate().getSeconds() + (long)ti.getSeconds();
                        return new TimestampData(seconds, this.scaleNanos(ti.getNanos()), ti.getZone());
                    }
                    case 92: {
                        TimeData ti = (TimeData)a;
                        long seconds = session.getCurrentDate().getSeconds() + (long)ti.getSeconds() - (long)session.getZoneSeconds();
                        return new TimestampData(seconds, this.scaleNanos(ti.getNanos()), session.getZoneSeconds());
                    }
                    case 95: {
                        return this.convertToTypeLimits(session, a);
                    }
                    case 93: {
                        TimestampData ts = (TimestampData)a;
                        long seconds = ts.getSeconds() - (long)session.getZoneSeconds();
                        return new TimestampData(seconds, this.scaleNanos(ts.getNanos()), session.getZoneSeconds());
                    }
                    case 91: {
                        TimestampData ts = (TimestampData)a;
                        return new TimestampData(ts.getSeconds(), 0, session.getZoneSeconds());
                    }
                }
                throw Error.error(5561);
            }
            case 93: {
                switch (otherType.typeCode) {
                    case 94: {
                        TimeData ti = (TimeData)a;
                        long seconds = session.getCurrentDate().getSeconds() + (long)ti.getSeconds() - (long)session.getZoneSeconds();
                        return new TimestampData(seconds, this.scaleNanos(ti.getNanos()), session.getZoneSeconds());
                    }
                    case 92: {
                        TimeData ti = (TimeData)a;
                        long seconds = session.getCurrentDate().getSeconds() + (long)ti.getSeconds();
                        return new TimestampData(seconds, this.scaleNanos(ti.getNanos()));
                    }
                    case 95: {
                        TimestampData ts = (TimestampData)a;
                        long seconds = ts.getSeconds() + (long)ts.getZone();
                        return new TimestampData(seconds, this.scaleNanos(ts.getNanos()));
                    }
                    case 93: {
                        return this.convertToTypeLimits(session, a);
                    }
                    case 91: {
                        return a;
                    }
                }
                throw Error.error(5561);
            }
        }
        throw Error.runtimeError(401, "DateTimeType");
    }

    @Override
    public Object convertToDefaultType(SessionInterface session, Object a) {
        throw Error.error(5561);
    }

    @Override
    public Object convertJavaToSQL(SessionInterface session, Object a) {
        switch (this.typeCode) {
            case 92: 
            case 94: {
                long millis;
                if (a instanceof Date || !(a instanceof java.util.Date)) break;
                int nanos = 0;
                int zoneSeconds = 0;
                if (this.typeCode == 92) {
                    millis = HsqlDateTime.convertMillisFromCalendar(session.getCalendar(), ((java.util.Date)a).getTime());
                } else {
                    millis = ((java.util.Date)a).getTime();
                    zoneSeconds = session.getZoneSeconds();
                }
                millis = HsqlDateTime.getNormalisedTime(millis);
                if (a instanceof Timestamp) {
                    nanos = ((Timestamp)a).getNanos();
                    nanos = DateTimeType.normaliseFraction(nanos, this.scale);
                }
                return new TimeData((int)millis / 1000, nanos, zoneSeconds);
            }
            case 91: {
                if (a instanceof Time || !(a instanceof java.util.Date)) break;
                long millis = HsqlDateTime.convertMillisFromCalendar(session.getCalendar(), ((java.util.Date)a).getTime());
                millis = HsqlDateTime.getNormalisedDate(millis);
                return new TimestampData(millis / 1000L);
            }
            case 93: 
            case 95: {
                long millis;
                if (a instanceof Time || !(a instanceof java.util.Date)) break;
                int nanos = 0;
                int zoneSeconds = 0;
                if (this.typeCode == 93) {
                    millis = HsqlDateTime.convertMillisFromCalendar(session.getCalendar(), ((java.util.Date)a).getTime());
                } else {
                    millis = ((java.util.Date)a).getTime();
                    zoneSeconds = session.getZoneSeconds();
                }
                if (a instanceof Timestamp) {
                    nanos = ((Timestamp)a).getNanos();
                    nanos = DateTimeType.normaliseFraction(nanos, this.scale);
                }
                return new TimestampData(millis / 1000L, nanos, zoneSeconds);
            }
        }
        throw Error.error(5561);
    }

    public Object convertSQLToJavaGMT(SessionInterface session, Object a) {
        switch (this.typeCode) {
            case 92: 
            case 94: {
                long millis = ((TimeData)a).getSeconds() * 1000;
                return new Time(millis);
            }
            case 91: {
                long millis = ((TimestampData)a).getSeconds() * 1000L;
                return new Date(millis);
            }
            case 93: 
            case 95: {
                long millis = ((TimestampData)a).getSeconds() * 1000L;
                Timestamp value = new Timestamp(millis);
                value.setNanos(((TimestampData)a).getNanos());
                return value;
            }
        }
        throw Error.runtimeError(401, "DateTimeType");
    }

    @Override
    public Object convertSQLToJava(SessionInterface session, Object a) {
        switch (this.typeCode) {
            case 92: {
                Calendar cal = session.getCalendar();
                long millis = HsqlDateTime.convertMillisToCalendar(cal, ((TimeData)a).getSeconds() * 1000);
                millis = HsqlDateTime.getNormalisedTime(cal, millis);
                Time value = new Time(millis);
                return value;
            }
            case 94: {
                int seconds = ((TimeData)a).getSeconds();
                return new Time(seconds * 1000);
            }
            case 91: {
                Calendar cal = session.getCalendar();
                long millis = HsqlDateTime.convertMillisToCalendar(cal, ((TimestampData)a).getSeconds() * 1000L);
                Date value = new Date(millis);
                return value;
            }
            case 93: {
                Calendar cal = session.getCalendar();
                long millis = HsqlDateTime.convertMillisToCalendar(cal, ((TimestampData)a).getSeconds() * 1000L);
                Timestamp value = new Timestamp(millis);
                value.setNanos(((TimestampData)a).getNanos());
                return value;
            }
            case 95: {
                long seconds = ((TimestampData)a).getSeconds();
                Timestamp value = new Timestamp(seconds * 1000L);
                value.setNanos(((TimestampData)a).getNanos());
                return value;
            }
        }
        throw Error.runtimeError(401, "DateTimeType");
    }

    public static int normaliseTime(int seconds) {
        while (seconds < 0) {
            seconds += 86400;
        }
        if (seconds > 86400) {
            seconds %= 86400;
        }
        return seconds;
    }

    @Override
    public String convertToString(Object a) {
        boolean zone = false;
        if (a == null) {
            return null;
        }
        switch (this.typeCode) {
            case 91: {
                return HsqlDateTime.getDateString(((TimestampData)a).getSeconds());
            }
            case 92: 
            case 94: {
                TimeData t = (TimeData)a;
                int seconds = DateTimeType.normaliseTime(t.getSeconds() + t.getZone());
                String s = this.intervalSecondToString(seconds, t.getNanos(), false);
                if (!this.withTimeZone) {
                    return s;
                }
                StringBuffer sb = new StringBuffer(s);
                s = Type.SQL_INTERVAL_HOUR_TO_MINUTE.intervalSecondToString(((TimeData)a).getZone(), 0, true);
                sb.append(s);
                return sb.toString();
            }
            case 93: 
            case 95: {
                TimestampData ts = (TimestampData)a;
                StringBuffer sb = new StringBuffer();
                HsqlDateTime.getTimestampString(sb, ts.getSeconds() + (long)ts.getZone(), ts.getNanos(), this.scale);
                if (!this.withTimeZone) {
                    return sb.toString();
                }
                String s = Type.SQL_INTERVAL_HOUR_TO_MINUTE.intervalSecondToString(((TimestampData)a).getZone(), 0, true);
                sb.append(s);
                return sb.toString();
            }
        }
        throw Error.runtimeError(401, "DateTimeType");
    }

    @Override
    public String convertToSQLString(Object a) {
        if (a == null) {
            return "NULL";
        }
        StringBuffer sb = new StringBuffer(32);
        switch (this.typeCode) {
            case 91: {
                sb.append("DATE");
                break;
            }
            case 92: 
            case 94: {
                sb.append("TIME");
                break;
            }
            case 93: 
            case 95: {
                sb.append("TIMESTAMP");
            }
        }
        sb.append(StringConverter.toQuotedString(this.convertToString(a), '\'', false));
        return sb.toString();
    }

    @Override
    public boolean canConvertFrom(Type otherType) {
        if (otherType.typeCode == 0) {
            return true;
        }
        if (otherType.isCharacterType()) {
            return true;
        }
        if (!otherType.isDateTimeType()) {
            return false;
        }
        if (otherType.typeCode == 91) {
            return this.typeCode != 92;
        }
        if (otherType.typeCode == 92) {
            return this.typeCode != 91;
        }
        return true;
    }

    @Override
    public Object add(Object a, Object b, Type otherType) {
        if (a == null || b == null) {
            return null;
        }
        switch (this.typeCode) {
            case 92: 
            case 94: {
                if (b instanceof IntervalMonthData) {
                    throw Error.runtimeError(401, "DateTimeType");
                }
                if (!(b instanceof IntervalSecondData)) break;
                return DateTimeType.addSeconds((TimeData)a, (int)((IntervalSecondData)b).units, ((IntervalSecondData)b).nanos);
            }
            case 91: 
            case 93: 
            case 95: {
                if (b instanceof IntervalMonthData) {
                    return DateTimeType.addMonths((TimestampData)a, (int)((IntervalMonthData)b).units);
                }
                if (!(b instanceof IntervalSecondData)) break;
                return DateTimeType.addSeconds((TimestampData)a, (int)((IntervalSecondData)b).units, ((IntervalSecondData)b).nanos);
            }
        }
        throw Error.runtimeError(401, "DateTimeType");
    }

    @Override
    public Object subtract(Object a, Object b, Type otherType) {
        if (a == null || b == null) {
            return null;
        }
        switch (this.typeCode) {
            case 92: 
            case 94: {
                if (b instanceof IntervalMonthData) {
                    throw Error.runtimeError(401, "DateTimeType");
                }
                if (!(b instanceof IntervalSecondData)) break;
                return DateTimeType.addSeconds((TimeData)a, -((int)((IntervalSecondData)b).units), -((IntervalSecondData)b).nanos);
            }
            case 91: 
            case 93: 
            case 95: {
                if (b instanceof IntervalMonthData) {
                    return DateTimeType.addMonths((TimestampData)a, -((int)((IntervalMonthData)b).units));
                }
                if (!(b instanceof IntervalSecondData)) break;
                return DateTimeType.addSeconds((TimestampData)a, -((int)((IntervalSecondData)b).units), -((IntervalSecondData)b).nanos);
            }
        }
        throw Error.runtimeError(401, "DateTimeType");
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof Type) {
            return super.equals(other) && ((DateTimeType)other).withTimeZone == this.withTimeZone;
        }
        return false;
    }

    @Override
    public int getPart(Session session, Object dateTime, int part) {
        int calendarPart;
        int increment = 0;
        int divisor = 1;
        switch (part) {
            case 101: {
                calendarPart = 1;
                break;
            }
            case 102: {
                increment = 1;
                calendarPart = 2;
                break;
            }
            case 103: 
            case 260: {
                calendarPart = 5;
                break;
            }
            case 104: {
                calendarPart = 11;
                break;
            }
            case 105: {
                calendarPart = 12;
                break;
            }
            case 106: {
                calendarPart = 13;
                break;
            }
            case 259: {
                calendarPart = 7;
                break;
            }
            case 262: {
                calendarPart = 3;
                break;
            }
            case 266: {
                if (this.typeCode != 92 && this.typeCode != 94) {
                    try {
                        DateTimeType target = this.withTimeZone ? Type.SQL_TIME_WITH_TIME_ZONE : Type.SQL_TIME;
                        dateTime = target.castToType(session, dateTime, this);
                    }
                    catch (HsqlException e) {
                        // empty catch block
                    }
                }
                return ((TimeData)dateTime).getSeconds();
            }
            case 257: {
                if (this.typeCode == 95) {
                    return ((TimestampData)dateTime).getZone() / 3600;
                }
                return ((TimeData)dateTime).getZone() / 3600;
            }
            case 258: {
                if (this.typeCode == 95) {
                    return ((TimestampData)dateTime).getZone() / 60 % 60;
                }
                return ((TimeData)dateTime).getZone() / 60 % 60;
            }
            case 263: {
                increment = 1;
                divisor = 3;
                calendarPart = 2;
                break;
            }
            case 261: {
                calendarPart = 6;
                break;
            }
            default: {
                throw Error.runtimeError(401, "DateTimeType - " + part);
            }
        }
        long millis = this.typeCode == 92 || this.typeCode == 94 ? (long)((((TimeData)dateTime).getSeconds() + ((TimeData)dateTime).getZone()) * 1000) : (((TimestampData)dateTime).getSeconds() + (long)((TimestampData)dateTime).getZone()) * 1000L;
        return HsqlDateTime.getDateTimePart(millis, calendarPart) / divisor + increment;
    }

    @Override
    public BigDecimal getSecondPart(Object dateTime) {
        long seconds = this.getPart(null, dateTime, 106);
        int nanos = 0;
        if (this.typeCode == 93) {
            nanos = ((TimestampData)dateTime).getNanos();
        } else if (this.typeCode == 92) {
            nanos = ((TimeData)dateTime).getNanos();
        }
        return this.getSecondPart(seconds, nanos);
    }

    public String getPartString(Session session, Object dateTime, int part) {
        String javaPattern = "";
        switch (part) {
            case 264: {
                javaPattern = "EEEE";
                break;
            }
            case 265: {
                javaPattern = "MMMM";
            }
        }
        SimpleDateFormat format = session.getSimpleDateFormatGMT();
        try {
            format.applyPattern(javaPattern);
        }
        catch (Exception e) {
            // empty catch block
        }
        java.util.Date date = (java.util.Date)this.convertSQLToJavaGMT(session, dateTime);
        return format.format(date);
    }

    public Object getValue(long seconds, int nanos, int zoneSeconds) {
        switch (this.typeCode) {
            case 91: {
                seconds = HsqlDateTime.getNormalisedDate((seconds + (long)zoneSeconds) * 1000L) / 1000L;
                return new TimestampData(seconds);
            }
            case 94: {
                seconds = HsqlDateTime.getNormalisedDate(seconds * 1000L) / 1000L;
                return new TimeData((int)seconds, nanos, zoneSeconds);
            }
            case 92: {
                seconds = HsqlDateTime.getNormalisedTime((seconds + (long)zoneSeconds) * 1000L) / 1000L;
                return new TimeData((int)seconds, nanos);
            }
            case 95: {
                return new TimestampData(seconds, nanos, zoneSeconds);
            }
            case 93: {
                return new TimestampData(seconds + (long)zoneSeconds, nanos);
            }
        }
        throw Error.runtimeError(401, "DateTimeType");
    }

    public static DateTimeType getDateTimeType(int type, int scale) {
        if (scale > 9) {
            throw Error.error(5592);
        }
        switch (type) {
            case 91: {
                return SQL_DATE;
            }
            case 92: {
                if (scale != 0) {
                    return new DateTimeType(92, type, scale);
                }
                return SQL_TIME;
            }
            case 94: {
                if (scale != 0) {
                    return new DateTimeType(92, type, scale);
                }
                return SQL_TIME_WITH_TIME_ZONE;
            }
            case 93: {
                if (scale != 6) {
                    return new DateTimeType(93, type, scale);
                }
                return SQL_TIMESTAMP;
            }
            case 95: {
                if (scale != 6) {
                    return new DateTimeType(93, type, scale);
                }
                return SQL_TIMESTAMP_WITH_TIME_ZONE;
            }
        }
        throw Error.runtimeError(401, "DateTimeType");
    }

    public Object changeZone(Object a, Type otherType, int targetZone, int localZone) {
        if (a == null) {
            return null;
        }
        if (otherType.typeCode == 95 || otherType.typeCode == 94) {
            localZone = 0;
        }
        if (targetZone > 50400 || -targetZone > 50400) {
            throw Error.error(3409);
        }
        switch (this.typeCode) {
            case 94: {
                TimeData value = (TimeData)a;
                if (localZone == 0 && value.zone == targetZone) break;
                return new TimeData(value.getSeconds() - localZone, value.getNanos(), targetZone);
            }
            case 95: {
                TimestampData value = (TimestampData)a;
                if (localZone == 0 && value.zone == targetZone) break;
                return new TimestampData(value.getSeconds() - (long)localZone, value.getNanos(), targetZone);
            }
        }
        return a;
    }

    public boolean canAdd(IntervalType other) {
        return other.startPartIndex >= this.startPartIndex && other.endPartIndex <= this.endPartIndex;
    }

    public static Boolean overlaps(Session session, Object[] a, Type[] ta, Object[] b, Type[] tb) {
        Object[] temp;
        if (a == null || b == null) {
            return null;
        }
        if (a[0] == null || b[0] == null) {
            return null;
        }
        if (a[1] == null) {
            a[1] = a[0];
        }
        if (b[1] == null) {
            b[1] = b[0];
        }
        Type commonType = ta[0].getCombinedType(tb[0], 41);
        a[0] = commonType.castToType(session, a[0], ta[0]);
        b[0] = commonType.castToType(session, b[0], tb[0]);
        a[1] = ta[1].isIntervalType() ? commonType.add(a[0], a[1], ta[1]) : commonType.castToType(session, a[1], ta[1]);
        b[1] = tb[1].isIntervalType() ? commonType.add(b[0], b[1], tb[1]) : commonType.castToType(session, b[1], tb[1]);
        if (commonType.compare(session, a[0], a[1]) > 0) {
            temp = a[0];
            a[0] = a[1];
            a[1] = temp;
        }
        if (commonType.compare(session, b[0], b[1]) > 0) {
            temp = b[0];
            b[0] = b[1];
            b[1] = temp;
        }
        if (commonType.compare(session, a[0], b[0]) > 0) {
            temp = a;
            a = b;
            b = temp;
        }
        if (commonType.compare(session, a[1], b[0]) > 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int subtractMonths(TimestampData a, TimestampData b, boolean isYear) {
        Calendar calendar = HsqlDateTime.tempCalGMT;
        synchronized (calendar) {
            boolean negate = false;
            if (b.getSeconds() > a.getSeconds()) {
                negate = true;
                TimestampData temp = a;
                a = b;
                b = temp;
            }
            HsqlDateTime.setTimeInMillis(HsqlDateTime.tempCalGMT, a.getSeconds() * 1000L);
            int months = HsqlDateTime.tempCalGMT.get(2);
            int years = HsqlDateTime.tempCalGMT.get(1);
            HsqlDateTime.setTimeInMillis(HsqlDateTime.tempCalGMT, b.getSeconds() * 1000L);
            months -= HsqlDateTime.tempCalGMT.get(2);
            years -= HsqlDateTime.tempCalGMT.get(1);
            if (isYear) {
                months = years * 12;
            } else {
                if (months < 0) {
                    months += 12;
                    --years;
                }
                months += years * 12;
                if (negate) {
                    months = -months;
                }
            }
            return months;
        }
    }

    public static TimeData addSeconds(TimeData source, int seconds, int nanos) {
        seconds += (nanos += source.getNanos()) / 1000000000;
        if ((nanos %= 1000000000) < 0) {
            nanos += 1000000000;
            --seconds;
        }
        seconds += source.getSeconds();
        TimeData ti = new TimeData(seconds %= 86400, nanos, source.getZone());
        return ti;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TimestampData addMonths(TimestampData source, int months) {
        int n = source.getNanos();
        Calendar calendar = HsqlDateTime.tempCalGMT;
        synchronized (calendar) {
            HsqlDateTime.setTimeInMillis(HsqlDateTime.tempCalGMT, source.getSeconds() * 1000L);
            HsqlDateTime.tempCalGMT.add(2, months);
            TimestampData ts = new TimestampData(HsqlDateTime.tempCalGMT.getTimeInMillis() / 1000L, n, source.getZone());
            return ts;
        }
    }

    public static TimestampData addSeconds(TimestampData source, int seconds, int nanos) {
        seconds += (nanos += source.getNanos()) / 1000000000;
        if ((nanos %= 1000000000) < 0) {
            nanos += 1000000000;
            --seconds;
        }
        long newSeconds = source.getSeconds() + (long)seconds;
        TimestampData ts = new TimestampData(newSeconds, nanos, source.getZone());
        return ts;
    }
}

