/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

import java.io.Reader;
import org.hsqldb.SessionInterface;
import org.hsqldb.error.Error;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultLob;
import org.hsqldb.types.ClobData;

public class ClobDataID
implements ClobData {
    long id;

    public ClobDataID(long id) {
        this.id = id;
    }

    @Override
    public char[] getChars(SessionInterface session, long position, int length) {
        ResultLob resultOut = ResultLob.newLobGetCharsRequest(this.id, position, length);
        Result resultIn = session.execute(resultOut);
        if (resultIn.isError()) {
            throw resultIn.getException();
        }
        return ((ResultLob)resultIn).getCharArray();
    }

    @Override
    public long length(SessionInterface session) {
        ResultLob resultOut = ResultLob.newLobGetLengthRequest(this.id);
        Result resultIn = session.execute(resultOut);
        if (resultIn.isError()) {
            throw resultIn.getException();
        }
        return ((ResultLob)resultIn).getBlockLength();
    }

    @Override
    public String getSubString(SessionInterface session, long pos, int length) {
        char[] chars = this.getChars(session, pos, length);
        return new String(chars);
    }

    @Override
    public ClobData getClob(SessionInterface session, long position, long length) {
        ResultLob resultOut = ResultLob.newLobGetRequest(this.id, position, length);
        Result resultIn = session.execute(resultOut);
        if (resultIn.isError()) {
            throw resultIn.getException();
        }
        return new ClobDataID(((ResultLob)resultIn).getLobID());
    }

    @Override
    public void truncate(SessionInterface session, long len) {
    }

    @Override
    public Reader getCharacterStream(SessionInterface session) {
        return null;
    }

    @Override
    public long setCharacterStream(SessionInterface session, long pos, Reader in) {
        return 0L;
    }

    @Override
    public int setString(SessionInterface session, long pos, String str) {
        ResultLob resultOut = ResultLob.newLobSetCharsRequest(this.id, pos, str.toCharArray());
        Result resultIn = session.execute(resultOut);
        if (resultIn.isError()) {
            throw resultIn.getException();
        }
        return str.length();
    }

    @Override
    public int setString(SessionInterface session, long pos, String str, int offset, int len) {
        if (!ClobDataID.isInLimits(str.length(), offset, len)) {
            throw Error.error(3401);
        }
        ResultLob resultOut = ResultLob.newLobSetCharsRequest(this.id, pos, str.substring(offset, len).toCharArray());
        Result resultIn = session.execute(resultOut);
        if (resultIn.isError()) {
            throw resultIn.getException();
        }
        return str.length();
    }

    @Override
    public int setChars(SessionInterface session, long pos, char[] chars, int offset, int len) {
        if (!ClobDataID.isInLimits(chars.length, offset, len)) {
            throw Error.error(3401);
        }
        char[] newChars = new char[len];
        System.arraycopy(chars, offset, newChars, 0, len);
        ResultLob resultOut = ResultLob.newLobSetCharsRequest(this.id, pos, chars);
        Result resultIn = session.execute(resultOut);
        if (resultIn.isError()) {
            throw resultIn.getException();
        }
        return len;
    }

    @Override
    public long position(SessionInterface session, String searchstr, long start) {
        ResultLob resultOut = ResultLob.newLobGetCharPatternPositionRequest(this.id, searchstr.toCharArray(), start);
        Result resultIn = session.execute(resultOut);
        if (resultIn.isError()) {
            throw resultIn.getException();
        }
        return ((ResultLob)resultIn).getOffset();
    }

    @Override
    public long position(SessionInterface session, ClobData searchstr, long start) {
        return 0L;
    }

    @Override
    public long nonSpaceLength(SessionInterface session) {
        return 0L;
    }

    @Override
    public Reader getCharacterStream(SessionInterface session, long pos, long length) {
        return null;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public long getRightTrimSize(SessionInterface session) {
        return 0L;
    }

    static boolean isInLimits(long fullLength, long pos, long len) {
        return pos >= 0L && len >= 0L && pos + len <= fullLength;
    }

    @Override
    public void setSession(SessionInterface session) {
    }

    @Override
    public boolean isBinary() {
        return false;
    }
}

