/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

import org.hsqldb.Session;
import org.hsqldb.SessionInterface;
import org.hsqldb.error.Error;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.BinaryType;
import org.hsqldb.types.BlobData;
import org.hsqldb.types.Type;

public final class BlobType
extends BinaryType {
    public static final long maxBlobPrecision = 0x10000000000L;
    public static final int defaultBlobSize = 0x1000000;

    public BlobType() {
        super(30, 0x1000000L);
    }

    public BlobType(long precision) {
        super(30, precision);
    }

    @Override
    public int displaySize() {
        return this.precision > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.precision;
    }

    @Override
    public int getJDBCTypeCode() {
        return 2004;
    }

    @Override
    public String getJDBCClassName() {
        return "java.sql.Blob";
    }

    @Override
    public String getNameString() {
        return "BLOB";
    }

    @Override
    public String getFullNameString() {
        return "BINARY LARGE OBJECT";
    }

    @Override
    public String getDefinition() {
        long factor = this.precision;
        String multiplier = null;
        if (this.precision % 0x40000000L == 0L) {
            factor = this.precision / 0x40000000L;
            multiplier = "G";
        } else if (this.precision % 0x100000L == 0L) {
            factor = this.precision / 0x100000L;
            multiplier = "M";
        } else if (this.precision % 1024L == 0L) {
            factor = this.precision / 1024L;
            multiplier = "K";
        }
        StringBuffer sb = new StringBuffer(16);
        sb.append(this.getNameString());
        sb.append('(');
        sb.append(factor);
        if (multiplier != null) {
            sb.append(multiplier);
        }
        sb.append(')');
        return sb.toString();
    }

    @Override
    public boolean acceptsPrecision() {
        return true;
    }

    @Override
    public boolean requiresPrecision() {
        return false;
    }

    @Override
    public long getMaxPrecision() {
        return 0x10000000000L;
    }

    @Override
    public boolean isBinaryType() {
        return true;
    }

    @Override
    public boolean isLobType() {
        return true;
    }

    @Override
    public int compare(Session session, Object a, Object b) {
        long bId;
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        long aId = ((BlobData)a).getId();
        return aId > (bId = ((BlobData)b).getId()) ? 1 : (bId > aId ? -1 : 0);
    }

    @Override
    public Object convertToTypeLimits(SessionInterface session, Object a) {
        return a;
    }

    @Override
    public Object convertToType(SessionInterface session, Object a, Type otherType) {
        if (a == null) {
            return null;
        }
        if (otherType.typeCode == 30) {
            return a;
        }
        if (otherType.typeCode == 60 || otherType.typeCode == 61) {
            return new BinaryData(((BinaryData)a).data, false);
        }
        throw Error.error(5561);
    }

    @Override
    public Object convertToDefaultType(SessionInterface session, Object a) {
        if (a == null) {
            return a;
        }
        if (a instanceof byte[]) {
            return new BinaryData((byte[])a, false);
        }
        throw Error.error(5561);
    }

    @Override
    public String convertToString(Object a) {
        if (a == null) {
            return null;
        }
        byte[] bytes = ((BlobData)a).getBytes();
        return StringConverter.byteArrayToHexString(bytes);
    }

    @Override
    public String convertToSQLString(Object a) {
        if (a == null) {
            return "NULL";
        }
        byte[] bytes = ((BlobData)a).getBytes();
        return StringConverter.byteArrayToSQLHexString(bytes);
    }
}

