/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.server;

import java.io.DataInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hsqldb.DatabaseManager;
import org.hsqldb.DatabaseURL;
import org.hsqldb.HsqlException;
import org.hsqldb.Session;
import org.hsqldb.lib.DataOutputStream;
import org.hsqldb.persist.HsqlProperties;
import org.hsqldb.result.Result;
import org.hsqldb.rowio.RowInputBinary;
import org.hsqldb.rowio.RowOutputBinary;

public class Servlet
extends HttpServlet {
    private static final int BUFFER_SIZE = 256;
    private String dbType;
    private String dbPath;
    private String errorStr;
    private RowOutputBinary rowOut;
    private RowInputBinary rowIn;
    private int iQueries;
    private static long lModified = 0L;

    public void init(ServletConfig config) {
        try {
            super.init(config);
            this.rowOut = new RowOutputBinary(256, 1);
            this.rowIn = new RowInputBinary(this.rowOut);
        }
        catch (ServletException e) {
            this.log(e.toString());
        }
        String dbStr = this.getInitParameter("hsqldb.server.database");
        if (dbStr == null) {
            dbStr = ".";
        }
        String useWebInfStr = this.getInitParameter("hsqldb.server.use_web-inf_path");
        if (!dbStr.equals(".") && "true".equalsIgnoreCase(useWebInfStr)) {
            dbStr = this.getServletContext().getRealPath("/") + "WEB-INF/" + dbStr;
        }
        HsqlProperties dbURL = DatabaseURL.parseURL(dbStr, false, false);
        this.log("Database filename = " + dbStr);
        if (dbURL == null) {
            this.errorStr = "Bad Database name";
        } else {
            this.dbPath = dbURL.getProperty("database");
            this.dbType = dbURL.getProperty("connection_type");
            try {
                DatabaseManager.getDatabase(this.dbType, this.dbPath, dbURL);
            }
            catch (HsqlException e) {
                this.errorStr = e.getMessage();
            }
        }
        this.log(this.errorStr);
        this.log("Initialization completed.");
    }

    protected long getLastModified(HttpServletRequest req) {
        return lModified++;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String query = request.getQueryString();
        if (query == null || query.length() == 0) {
            response.setContentType("text/html");
            response.setHeader("Pragma", "no-cache");
            PrintWriter out = response.getWriter();
            out.println("<html><head><title>HSQL Database Engine Servlet</title>");
            out.println("</head><body><h1>HSQL Database Engine Servlet</h1>");
            out.println("The servlet is running.<p>");
            if (this.errorStr == null) {
                out.println("The database is also running.<p>");
                out.println("Database name: " + this.dbType + this.dbPath + "<p>");
                out.println("Queries processed: " + this.iQueries + "<p>");
            } else {
                out.println("<h2>The database is not running!</h2>");
                out.println("The error message is:<p>");
                out.println(this.errorStr);
            }
            out.println("</body></html>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Servlet servlet = this;
        synchronized (servlet) {
            DataInputStream inStream = null;
            FilterOutputStream dataOut = null;
            try {
                Result resultOut;
                inStream = new DataInputStream((InputStream)request.getInputStream());
                int databaseID = inStream.readInt();
                long sessionID = inStream.readLong();
                byte mode = inStream.readByte();
                Session session = DatabaseManager.getSession(databaseID, sessionID);
                Result resultIn = Result.newResult(session, mode, inStream, this.rowIn);
                resultIn.setDatabaseId(databaseID);
                resultIn.setSessionId(sessionID);
                if (resultIn.getType() == 31) {
                    try {
                        session = DatabaseManager.newSession(this.dbType, this.dbPath, resultIn.getMainString(), resultIn.getSubString(), new HsqlProperties(), resultIn.getZoneString(), resultIn.getUpdateCount());
                        resultIn.readAdditionalResults(null, inStream, this.rowIn);
                        resultOut = Result.newConnectionAcknowledgeResponse(session.getId(), session.getDatabase().getDatabaseID());
                    }
                    catch (HsqlException e) {
                        resultOut = Result.newErrorResult(e);
                    }
                } else {
                    int dbId = resultIn.getDatabaseId();
                    long sessionId = resultIn.getSessionId();
                    session = DatabaseManager.getSession(dbId, sessionId);
                    resultIn.readAdditionalResults(session, inStream, this.rowIn);
                    resultOut = session.execute(resultIn);
                }
                response.setContentType("application/octet-stream");
                response.setContentLength(this.rowOut.size());
                dataOut = new DataOutputStream((OutputStream)response.getOutputStream());
                resultOut.write((DataOutputStream)dataOut, this.rowOut);
                ++this.iQueries;
            }
            catch (HsqlException e) {
            }
            finally {
                if (dataOut != null) {
                    dataOut.close();
                }
                if (inStream != null) {
                    inStream.close();
                }
            }
        }
    }
}

