/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.server;

import java.sql.SQLException;
import org.hsqldb.HsqlException;
import org.hsqldb.Session;
import org.hsqldb.jdbc.Util;
import org.hsqldb.server.OdbcUtil;
import org.hsqldb.server.RecoverableOdbcFailure;
import org.hsqldb.types.Type;

public class PgType {
    private int oid;
    private int typeWidth = -1;
    private int lpConstraint = -1;
    private Type hType;
    public static final int TYPE_BOOL = 16;
    public static final int TYPE_BYTEA = 17;
    public static final int TYPE_CHAR = 18;
    public static final int TYPE_NAME = 19;
    public static final int TYPE_INT8 = 20;
    public static final int TYPE_INT2 = 21;
    public static final int TYPE_INT2VECTOR = 22;
    public static final int TYPE_INT4 = 23;
    public static final int TYPE_REGPROC = 24;
    public static final int TYPE_TEXT = 25;
    public static final int TYPE_OID = 26;
    public static final int TYPE_TID = 27;
    public static final int TYPE_XID = 28;
    public static final int TYPE_CID = 29;
    public static final int TYPE_OIDVECTOR = 30;
    public static final int TYPE_SET = 32;
    public static final int TYPE_XML = 142;
    public static final int TYPE_XMLARRAY = 143;
    public static final int TYPE_CHAR2 = 409;
    public static final int TYPE_CHAR4 = 410;
    public static final int TYPE_CHAR8 = 411;
    public static final int TYPE_POINT = 600;
    public static final int TYPE_LSEG = 601;
    public static final int TYPE_PATH = 602;
    public static final int TYPE_BOX = 603;
    public static final int TYPE_POLYGON = 604;
    public static final int TYPE_FILENAME = 605;
    public static final int TYPE_CIDR = 650;
    public static final int TYPE_FLOAT4 = 700;
    public static final int TYPE_FLOAT8 = 701;
    public static final int TYPE_ABSTIME = 702;
    public static final int TYPE_RELTIME = 703;
    public static final int TYPE_TINTERVAL = 704;
    public static final int TYPE_UNKNOWN = 705;
    public static final int TYPE_MONEY = 790;
    public static final int TYPE_OIDINT2 = 810;
    public static final int TYPE_MACADDR = 829;
    public static final int TYPE_INET = 869;
    public static final int TYPE_OIDINT4 = 910;
    public static final int TYPE_OIDNAME = 911;
    public static final int TYPE_TEXTARRAY = 1009;
    public static final int TYPE_BPCHARARRAY = 1014;
    public static final int TYPE_VARCHARARRAY = 1015;
    public static final int TYPE_BPCHAR = 1042;
    public static final int TYPE_VARCHAR = 1043;
    public static final int TYPE_DATE = 1082;
    public static final int TYPE_TIME = 1083;
    public static final int TYPE_TIMESTAMP_NO_TMZONE = 1114;
    public static final int TYPE_DATETIME = 1184;
    public static final int TYPE_TIME_WITH_TMZONE = 1266;
    public static final int TYPE_TIMESTAMP = 1296;
    public static final int TYPE_NUMERIC = 1700;
    public static final int TYPE_RECORD = 2249;
    public static final int TYPE_VOID = 2278;
    public static final int TYPE_UUID = 2950;
    public static final int TYPE_BLOB = 9998;
    public static final int TYPE_TINYINT = 9999;
    public static final int TYPE_BIT = 1560;
    public static final int TYPE_VARBIT = 1562;
    protected static final PgType tinyIntSingleton = new PgType(Type.TINYINT, 9999, 1);
    protected static final PgType int2singleton = new PgType(Type.SQL_SMALLINT, 21, 2);
    protected static final PgType int4singleton = new PgType(Type.SQL_INTEGER, 23, 4);
    protected static final PgType int8singleton = new PgType(Type.SQL_BIGINT, 20, 8);
    protected static final PgType doubleSingleton = new PgType(Type.SQL_DOUBLE, 701, 8);
    protected static final PgType boolSingleton = new PgType(Type.SQL_BOOLEAN, 16, 1);
    protected static final PgType textSingleton = new PgType(Type.SQL_VARCHAR, 25);
    protected static final PgType dateSingleton = new PgType(Type.SQL_DATE, 1082, 4);
    protected static final PgType unknownSingleton = new PgType(Type.SQL_CHAR_DEFAULT, 705, -2);
    protected static final PgType bitSingleton = new PgType(Type.SQL_BIT, 1560);
    protected static final PgType bitVaryingSingleton = new PgType(Type.SQL_BIT_VARYING, 1562);
    protected static final PgType daySecIntervalSingleton = new PgType(Type.SQL_INTERVAL_DAY_TO_SECOND, 704, 16);
    protected static final PgType hourSecIntervalSingleton = new PgType(Type.SQL_INTERVAL_HOUR_TO_SECOND, 704, 16);
    protected static final PgType minSecIntervalSingleton = new PgType(Type.SQL_INTERVAL_MINUTE_TO_SECOND, 704, 16);
    protected static final PgType secIntervalSingleton = new PgType(Type.SQL_INTERVAL_SECOND, 704, 16);

    public int getOid() {
        return this.oid;
    }

    public int getTypeWidth() {
        return this.typeWidth;
    }

    public int getLPConstraint() {
        return this.lpConstraint;
    }

    protected PgType(Type hType, int oid) {
        this(hType, oid, null, null);
    }

    protected PgType(Type hType, int oid, int typeWidth) {
        this(hType, oid, new Integer(typeWidth), null);
    }

    protected PgType(Type hType, int oid, Integer dummy, long lpConstraint) throws RecoverableOdbcFailure {
        this(hType, oid, dummy, new Integer((int)lpConstraint));
        if (lpConstraint < 0L) {
            throw new RecoverableOdbcFailure("Length/Precision value is below minimum value of 0");
        }
        if (lpConstraint > Integer.MAX_VALUE) {
            throw new RecoverableOdbcFailure("Length/Precision value is above maximum value of 2147483647");
        }
    }

    protected PgType(Type hType, int oid, Integer typeWidthObject, Integer lpConstraintObject) {
        this.hType = hType;
        this.oid = oid;
        this.typeWidth = typeWidthObject == null ? -1 : typeWidthObject;
        this.lpConstraint = lpConstraintObject == null ? -1 : lpConstraintObject;
    }

    public static PgType getPgType(Type hType, boolean directColumn) throws RecoverableOdbcFailure {
        switch (hType.typeCode) {
            case -6: {
                return tinyIntSingleton;
            }
            case 5: {
                return int2singleton;
            }
            case 4: {
                return int4singleton;
            }
            case 25: {
                return int8singleton;
            }
            case 2: 
            case 3: {
                return new PgType(hType, 1700, null, (hType.precision << 16) + (long)hType.scale + 4L);
            }
            case 6: 
            case 7: 
            case 8: {
                return doubleSingleton;
            }
            case 16: {
                return boolSingleton;
            }
            case 1: {
                if (directColumn) {
                    return new PgType(hType, 1042, null, hType.precision + 4L);
                }
                return unknownSingleton;
            }
            case 12: 
            case 100: {
                if (hType.precision < 0L) {
                    throw new RecoverableOdbcFailure("Length/Precision value is below minimum value of 0");
                }
                if (hType.precision > Integer.MAX_VALUE) {
                    throw new RecoverableOdbcFailure("Length/Precision value is above maximum value of 2147483647");
                }
                return hType.precision != 0L && directColumn ? new PgType(hType, 1043, null, hType.precision + 4L) : textSingleton;
            }
            case 40: {
                throw new RecoverableOdbcFailure("Driver doesn't support type 'CLOB' yet");
            }
            case 30: {
                return new PgType(hType, 9998, null, hType.precision);
            }
            case 60: 
            case 61: {
                return new PgType(hType, 17, null, hType.precision);
            }
            case 1111: {
                throw new RecoverableOdbcFailure("Driver doesn't support type 'OTHER' yet");
            }
            case 14: {
                return bitSingleton;
            }
            case 15: {
                return bitVaryingSingleton;
            }
            case 91: {
                return dateSingleton;
            }
            case 92: {
                return new PgType(hType, 1083, (Integer)8, hType.precision);
            }
            case 94: {
                return new PgType(hType, 1266, (Integer)12, hType.precision);
            }
            case 93: {
                return new PgType(hType, 1114, (Integer)8, hType.precision);
            }
            case 95: {
                return new PgType(hType, 1296, (Integer)8, hType.precision);
            }
            case 101: 
            case 102: 
            case 107: {
                throw new RecoverableOdbcFailure("Driver doesn't support month-resolution 'INTERVAL's yet");
            }
            case 103: 
            case 104: 
            case 105: 
            case 108: 
            case 109: 
            case 111: {
                throw new RecoverableOdbcFailure("Driver doesn't support non-second-resolution 'INTERVAL's yet");
            }
            case 110: {
                PgType.ignoredConstraintWarning(hType);
                return daySecIntervalSingleton;
            }
            case 112: {
                PgType.ignoredConstraintWarning(hType);
                return hourSecIntervalSingleton;
            }
            case 113: {
                PgType.ignoredConstraintWarning(hType);
                return minSecIntervalSingleton;
            }
            case 106: {
                PgType.ignoredConstraintWarning(hType);
                return secIntervalSingleton;
            }
        }
        throw new RecoverableOdbcFailure("Unsupported type: " + hType.getNameString());
    }

    public Object getParameter(String inString, Session session) throws SQLException, RecoverableOdbcFailure {
        if (inString == null) {
            return null;
        }
        Object o = inString;
        switch (this.hType.typeCode) {
            case 16: {
                if (inString.length() == 1) {
                    switch (inString.charAt(0)) {
                        case '1': 
                        case 'T': 
                        case 'Y': 
                        case 't': 
                        case 'y': {
                            return Boolean.TRUE;
                        }
                    }
                    return Boolean.FALSE;
                }
                return Boolean.valueOf(inString);
            }
            case 30: 
            case 60: 
            case 61: {
                throw new RecoverableOdbcFailure("This data type should be transmitted to server in binary format: " + this.hType.getNameString());
            }
            case 40: 
            case 1111: {
                throw new RecoverableOdbcFailure("Type not supported yet: " + this.hType.getNameString());
            }
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: {
                try {
                    o = this.hType.convertToType(session, o, Type.SQL_VARCHAR);
                }
                catch (HsqlException e) {
                    PgType.throwError(e);
                }
                break;
            }
            case -6: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 25: {
                try {
                    o = this.hType.convertToType(session, o, Type.SQL_VARCHAR);
                }
                catch (HsqlException e) {
                    PgType.throwError(e);
                }
                break;
            }
            default: {
                try {
                    o = this.hType.convertToDefaultType(session, o);
                    break;
                }
                catch (HsqlException e) {
                    PgType.throwError(e);
                }
            }
        }
        return o;
    }

    public String valueString(Object datum) {
        String dataString = this.hType.convertToString(datum);
        switch (this.hType.typeCode) {
            case 16: {
                return String.valueOf((Boolean)datum != false ? (char)'t' : 'f');
            }
            case 60: 
            case 61: {
                dataString = OdbcUtil.hexCharsToOctalOctets(dataString);
            }
        }
        return dataString;
    }

    static final void throwError(HsqlException e) throws SQLException {
        throw Util.sqlException(e.getMessage(), e.getSQLState(), e.getErrorCode(), e);
    }

    private static void ignoredConstraintWarning(Type hsqldbType) {
        if (hsqldbType.precision == 0L && hsqldbType.scale == 0) {
            return;
        }
    }
}

