/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.scriptio;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import org.hsqldb.Database;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HsqlByteArrayOutputStream;
import org.hsqldb.persist.Crypto;
import org.hsqldb.scriptio.ScriptWriterText;

public class ScriptWriterEncode
extends ScriptWriterText {
    Crypto crypto;
    HsqlByteArrayOutputStream byteOut;

    public ScriptWriterEncode(Database db, String file, boolean includeCached, Crypto crypto) {
        super(db, file, includeCached, true, false);
        try {
            this.fileStreamOut = crypto.getOutputStream(this.fileStreamOut);
            this.fileStreamOut = new GZIPOutputStream(this.fileStreamOut);
        }
        catch (IOException e) {
            throw Error.error(e, 29, 115, new Object[]{e.getMessage(), this.outFile});
        }
    }

    public ScriptWriterEncode(Database db, String file, Crypto crypto) {
        super(db, file, false, true, false);
        this.crypto = crypto;
        this.byteOut = new HsqlByteArrayOutputStream();
    }

    @Override
    protected void finishStream() throws IOException {
        if (this.fileStreamOut instanceof GZIPOutputStream) {
            ((GZIPOutputStream)this.fileStreamOut).finish();
        }
        this.fileStreamOut.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void writeRowOutToFile() throws IOException {
        OutputStream outputStream = this.fileStreamOut;
        synchronized (outputStream) {
            if (this.byteOut == null) {
                super.writeRowOutToFile();
                return;
            }
            int count = this.crypto.getEncodedSize(this.rowOut.size());
            this.byteOut.ensureRoom(count + 4);
            count = this.crypto.encode(this.rowOut.getBuffer(), 0, this.rowOut.size(), this.byteOut.getBuffer(), 4);
            this.byteOut.setPosition(0);
            this.byteOut.writeInt(count);
            this.fileStreamOut.write(this.byteOut.getBuffer(), 0, count + 4);
        }
    }
}

