/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.scriptio;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Session;
import org.hsqldb.Statement;
import org.hsqldb.error.Error;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.result.Result;
import org.hsqldb.rowio.RowInputTextLog;
import org.hsqldb.scriptio.ScriptReaderBase;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.Type;

public class ScriptReaderText
extends ScriptReaderBase {
    BufferedReader dataStreamIn;
    RowInputTextLog rowIn;
    boolean isInsert;

    public ScriptReaderText(Database db) {
        super(db);
    }

    public ScriptReaderText(Database db, String fileName) throws IOException {
        super(db);
        InputStream d = this.database.logger.getFileAccess().openInputStreamElement(fileName);
        this.dataStreamIn = new BufferedReader(new InputStreamReader(new BufferedInputStream(d)));
        this.rowIn = new RowInputTextLog();
    }

    @Override
    protected void readDDL(Session session) throws IOException {
        while (this.readLoggedStatement(session)) {
            Statement cs = null;
            Result result = null;
            if (this.rowIn.getStatementType() == 3) {
                this.isInsert = true;
                break;
            }
            try {
                cs = session.compileStatement(this.statement);
                result = session.executeCompiledStatement(cs, ValuePool.emptyObjectArray);
                if (cs.getType() == 64) {
                    HsqlNameManager.HsqlName name = cs.getSchemalName();
                    session.setSchema(name.name);
                }
            }
            catch (HsqlException e) {
                result = Result.newErrorResult(e);
            }
            if (result.isError() && cs != null && cs.getType() == 48 || !result.isError()) continue;
            this.database.logger.logWarningEvent(result.getMainString(), result.getException());
            throw Error.error(null, 78, 113, new Object[]{new Integer(this.lineCount), result.getMainString()});
        }
    }

    @Override
    protected void readExistingData(Session session) throws IOException {
        try {
            String tablename = null;
            this.database.setReferentialIntegrity(false);
            while (this.isInsert || this.readLoggedStatement(session)) {
                if (this.statementType == 6) {
                    session.setSchema(this.currentSchema);
                } else if (this.statementType == 3) {
                    if (!this.rowIn.getTableName().equals(tablename)) {
                        tablename = this.rowIn.getTableName();
                        String schema = session.getSchemaName(this.currentSchema);
                        this.currentTable = this.database.schemaManager.getUserTable(session, tablename, schema);
                        this.currentStore = this.database.persistentStoreCollection.getStore(this.currentTable);
                    }
                    this.currentTable.insertFromScript(this.currentStore, this.rowData);
                }
                this.isInsert = false;
            }
            this.database.setReferentialIntegrity(true);
        }
        catch (Throwable t) {
            this.database.logger.logSevereEvent("readExistingData failed", t);
            throw Error.error(t, 78, 114, new Object[]{t.getMessage(), new Integer(this.lineCount)});
        }
    }

    @Override
    public boolean readLoggedStatement(Session session) throws IOException {
        String s = this.dataStreamIn.readLine();
        ++this.lineCount;
        this.statement = StringConverter.unicodeStringToString(s);
        if (this.statement == null) {
            return false;
        }
        this.processStatement(session);
        return true;
    }

    void processStatement(Session session) throws IOException {
        try {
            if (this.statement.startsWith("/*C")) {
                int endid = this.statement.indexOf(42, 4);
                this.sessionNumber = Integer.parseInt(this.statement.substring(3, endid));
                this.statement = this.statement.substring(endid + 2);
            }
            this.rowIn.setSource(this.statement);
            this.statementType = this.rowIn.getStatementType();
            if (this.statementType == 1) {
                this.rowData = null;
                this.currentTable = null;
                return;
            }
            if (this.statementType == 4) {
                this.rowData = null;
                this.currentTable = null;
                return;
            }
            if (this.statementType == 6) {
                this.rowData = null;
                this.currentTable = null;
                this.currentSchema = this.rowIn.getSchemaName();
                return;
            }
            String name = this.rowIn.getTableName();
            String schema = session.getCurrentSchemaHsqlName().name;
            this.currentTable = this.database.schemaManager.getUserTable(session, name, schema);
            this.currentStore = this.database.persistentStoreCollection.getStore(this.currentTable);
            Type[] colTypes = this.statementType == 3 ? this.currentTable.getColumnTypes() : (this.currentTable.hasPrimaryKey() ? this.currentTable.getPrimaryKeyTypes() : this.currentTable.getColumnTypes());
            this.rowData = this.rowIn.readData(colTypes);
        }
        catch (Exception e) {
            throw new IOException(e.toString());
        }
    }

    @Override
    public void close() {
        try {
            this.dataStreamIn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

