/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.rowio;

import java.math.BigDecimal;
import org.hsqldb.ColumnSchema;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HsqlByteArrayOutputStream;
import org.hsqldb.rowio.RowOutputInterface;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.BlobData;
import org.hsqldb.types.ClobData;
import org.hsqldb.types.IntervalMonthData;
import org.hsqldb.types.IntervalSecondData;
import org.hsqldb.types.JavaObjectData;
import org.hsqldb.types.TimeData;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;

abstract class RowOutputBase
extends HsqlByteArrayOutputStream
implements RowOutputInterface {
    public static final int CACHED_ROW_160 = 0;
    public static final int CACHED_ROW_170 = 1;
    protected boolean skipSystemId = false;

    public RowOutputBase() {
    }

    public RowOutputBase(int initialSize) {
        super(initialSize);
    }

    public RowOutputBase(byte[] buffer) {
        super(buffer);
    }

    @Override
    public abstract void writeEnd();

    @Override
    public abstract void writeSize(int var1);

    @Override
    public abstract void writeType(int var1);

    @Override
    public abstract void writeIntData(int var1, int var2);

    @Override
    public abstract void writeString(String var1);

    protected void writeFieldPrefix() {
    }

    protected abstract void writeFieldType(Type var1);

    protected abstract void writeNull(Type var1);

    protected abstract void writeChar(String var1, Type var2);

    protected abstract void writeSmallint(Number var1);

    protected abstract void writeInteger(Number var1);

    protected abstract void writeBigint(Number var1);

    protected abstract void writeReal(Double var1);

    protected abstract void writeDecimal(BigDecimal var1, Type var2);

    protected abstract void writeBoolean(Boolean var1);

    protected abstract void writeDate(TimestampData var1, Type var2);

    protected abstract void writeTime(TimeData var1, Type var2);

    protected abstract void writeTimestamp(TimestampData var1, Type var2);

    protected abstract void writeYearMonthInterval(IntervalMonthData var1, Type var2);

    protected abstract void writeDaySecondInterval(IntervalSecondData var1, Type var2);

    protected abstract void writeOther(JavaObjectData var1);

    protected abstract void writeBit(BinaryData var1);

    protected abstract void writeBinary(BinaryData var1);

    protected abstract void writeClob(ClobData var1, Type var2);

    protected abstract void writeBlob(BlobData var1, Type var2);

    @Override
    public void writeData(Object[] data, Type[] types) {
        this.writeData(types.length, types, data, null, null);
    }

    @Override
    public void writeData(int l, Type[] types, Object[] data, HashMappedList cols, int[] primaryKeys) {
        boolean hasPK = primaryKeys != null && primaryKeys.length != 0;
        int limit = hasPK ? primaryKeys.length : l;
        block20: for (int i = 0; i < limit; ++i) {
            int j = hasPK ? primaryKeys[i] : i;
            Object o = data[j];
            Type t = types[j];
            if (cols != null) {
                ColumnSchema col = (ColumnSchema)cols.get(j);
                this.writeFieldPrefix();
                this.writeString(col.getName().statementName);
            }
            if (o == null) {
                this.writeNull(t);
                continue;
            }
            this.writeFieldType(t);
            switch (t.typeCode) {
                case 0: {
                    throw Error.runtimeError(401, "RowOutputBase");
                }
                case 1: 
                case 12: 
                case 100: {
                    this.writeChar((String)o, t);
                    continue block20;
                }
                case -6: 
                case 5: {
                    this.writeSmallint((Number)o);
                    continue block20;
                }
                case 4: {
                    this.writeInteger((Number)o);
                    continue block20;
                }
                case 25: {
                    this.writeBigint((Number)o);
                    continue block20;
                }
                case 6: 
                case 7: 
                case 8: {
                    this.writeReal((Double)o);
                    continue block20;
                }
                case 2: 
                case 3: {
                    this.writeDecimal((BigDecimal)o, t);
                    continue block20;
                }
                case 16: {
                    this.writeBoolean((Boolean)o);
                    continue block20;
                }
                case 91: {
                    this.writeDate((TimestampData)o, t);
                    continue block20;
                }
                case 92: 
                case 94: {
                    this.writeTime((TimeData)o, t);
                    continue block20;
                }
                case 93: 
                case 95: {
                    this.writeTimestamp((TimestampData)o, t);
                    continue block20;
                }
                case 101: 
                case 102: 
                case 107: {
                    this.writeYearMonthInterval((IntervalMonthData)o, t);
                    continue block20;
                }
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: {
                    this.writeDaySecondInterval((IntervalSecondData)o, t);
                    continue block20;
                }
                case 1111: {
                    this.writeOther((JavaObjectData)o);
                    continue block20;
                }
                case 30: {
                    this.writeBlob((BlobData)o, t);
                    continue block20;
                }
                case 40: {
                    this.writeClob((ClobData)o, t);
                    continue block20;
                }
                case 60: 
                case 61: {
                    this.writeBinary((BinaryData)o);
                    continue block20;
                }
                case 14: 
                case 15: {
                    this.writeBit((BinaryData)o);
                    continue block20;
                }
                default: {
                    throw Error.runtimeError(401, "RowOutputBase - " + t.getNameString());
                }
            }
        }
    }

    @Override
    public HsqlByteArrayOutputStream getOutputStream() {
        return this;
    }

    @Override
    public RowOutputInterface clone() {
        try {
            return (RowOutputInterface)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }
}

