/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.rowio;

import java.io.IOException;
import java.math.BigDecimal;
import org.hsqldb.Scanner;
import org.hsqldb.error.Error;
import org.hsqldb.rowio.RowInputBase;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.BlobData;
import org.hsqldb.types.BlobDataID;
import org.hsqldb.types.ClobData;
import org.hsqldb.types.ClobDataID;
import org.hsqldb.types.IntervalMonthData;
import org.hsqldb.types.IntervalSecondData;
import org.hsqldb.types.IntervalType;
import org.hsqldb.types.JavaObjectData;
import org.hsqldb.types.TimeData;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;

public class RowInputText
extends RowInputBase
implements RowInputInterface {
    private String fieldSep;
    private String varSep;
    private String longvarSep;
    private int fieldSepLen;
    private int varSepLen;
    private int longvarSepLen;
    private boolean fieldSepEnd;
    private boolean varSepEnd;
    private boolean longvarSepEnd;
    private int textLen;
    protected String text;
    protected int line;
    protected int field;
    protected int next = 0;
    protected boolean allQuoted;
    protected Scanner scanner = new Scanner();

    public RowInputText(String fieldSep, String varSep, String longvarSep, boolean allQuoted) {
        super(new byte[0]);
        if (fieldSep.endsWith("\n")) {
            this.fieldSepEnd = true;
            fieldSep = fieldSep.substring(0, fieldSep.length() - 1);
        }
        if (varSep.endsWith("\n")) {
            this.varSepEnd = true;
            varSep = varSep.substring(0, varSep.length() - 1);
        }
        if (longvarSep.endsWith("\n")) {
            this.longvarSepEnd = true;
            longvarSep = longvarSep.substring(0, longvarSep.length() - 1);
        }
        this.allQuoted = allQuoted;
        this.fieldSep = fieldSep;
        this.varSep = varSep;
        this.longvarSep = longvarSep;
        this.fieldSepLen = fieldSep.length();
        this.varSepLen = varSep.length();
        this.longvarSepLen = longvarSep.length();
    }

    public void setSource(String text, int pos, int byteSize) {
        this.size = byteSize;
        this.text = text;
        this.textLen = text.length();
        this.filePos = pos;
        this.next = 0;
        ++this.line;
        this.field = 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String getField(String sep, int sepLen, boolean isEnd) throws IOException {
        String s = null;
        try {
            int start = this.next;
            ++this.field;
            if (isEnd) {
                if (this.next >= this.textLen && sepLen > 0) {
                    throw Error.error(183);
                }
                if (!this.text.endsWith(sep)) throw Error.error(183);
                this.next = this.textLen - sepLen;
            } else {
                this.next = this.text.indexOf(sep, start);
                if (this.next == -1) {
                    this.next = this.textLen;
                }
            }
            if (start > this.next) {
                start = this.next;
            }
            s = this.text.substring(start, this.next);
            this.next += sepLen;
            if ((s = s.trim()).length() != 0) return s;
            return null;
        }
        catch (Exception e) {
            throw new IOException(Error.getMessage(184, 0, new Object[]{new Integer(this.field), e.toString()}));
        }
    }

    @Override
    public String readString() throws IOException {
        return this.getField(this.fieldSep, this.fieldSepLen, this.fieldSepEnd);
    }

    private String readVarString() throws IOException {
        return this.getField(this.varSep, this.varSepLen, this.varSepEnd);
    }

    private String readLongVarString() throws IOException {
        return this.getField(this.longvarSep, this.longvarSepLen, this.longvarSepEnd);
    }

    @Override
    public short readShort() throws IOException {
        return (short)this.readInt();
    }

    @Override
    public int readInt() throws IOException {
        String s = this.readString();
        if (s == null) {
            return 0;
        }
        if ((s = s.trim()).length() == 0) {
            return 0;
        }
        return Integer.parseInt(s);
    }

    @Override
    public long readLong() throws IOException {
        throw Error.runtimeError(401, "RowInputText");
    }

    @Override
    public int readType() throws IOException {
        return 0;
    }

    @Override
    protected boolean checkNull() {
        return false;
    }

    @Override
    protected String readChar(Type type) throws IOException {
        switch (type.typeCode) {
            case 1: {
                return this.readString();
            }
            case 12: 
            case 100: {
                return this.readVarString();
            }
        }
        return this.readLongVarString();
    }

    @Override
    protected Integer readSmallint() throws IOException {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        return Integer.valueOf(s);
    }

    @Override
    protected Integer readInteger() throws IOException {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        return Integer.valueOf(s);
    }

    @Override
    protected Long readBigint() throws IOException {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        return Long.valueOf(s);
    }

    @Override
    protected Double readReal() throws IOException {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        return Double.valueOf(s);
    }

    @Override
    protected BigDecimal readDecimal(Type type) throws IOException {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        return new BigDecimal(s);
    }

    @Override
    protected TimeData readTime(Type type) throws IOException {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        return this.scanner.newTime(s);
    }

    @Override
    protected TimestampData readDate(Type type) throws IOException {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        return this.scanner.newDate(s);
    }

    @Override
    protected TimestampData readTimestamp(Type type) throws IOException {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        return this.scanner.newTimestamp(s);
    }

    @Override
    protected IntervalMonthData readYearMonthInterval(Type type) throws IOException {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        return (IntervalMonthData)this.scanner.newInterval(s, (IntervalType)type);
    }

    @Override
    protected IntervalSecondData readDaySecondInterval(Type type) throws IOException {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        return (IntervalSecondData)this.scanner.newInterval(s, (IntervalType)type);
    }

    @Override
    protected Boolean readBoole() throws IOException {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        return s.equalsIgnoreCase("TRUE") ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    protected Object readOther() throws IOException {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        BinaryData data = this.scanner.convertToBinary(s);
        if (data.length(null) == 0L) {
            return null;
        }
        return new JavaObjectData(data.getBytes());
    }

    @Override
    protected BinaryData readBit() throws IOException {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        BinaryData data = this.scanner.convertToBit(s);
        return data;
    }

    @Override
    protected BinaryData readBinary() throws IOException {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        BinaryData data = this.scanner.convertToBinary(s);
        return data;
    }

    @Override
    protected ClobData readClob() throws IOException {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        long id = Long.parseLong(s);
        return new ClobDataID(id);
    }

    @Override
    protected BlobData readBlob() throws IOException {
        String s = this.readString();
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        long id = Long.parseLong(s);
        return new BlobDataID(id);
    }

    public int getLineNumber() {
        return this.line;
    }

    public void skippedLine() {
        ++this.line;
    }

    @Override
    public void reset() {
        this.text = "";
        this.textLen = 0;
        this.filePos = 0;
        this.next = 0;
        this.field = 0;
        this.line = 0;
    }
}

