/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.rights;

import org.hsqldb.HsqlNameManager;
import org.hsqldb.error.Error;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.rights.Grantee;
import org.hsqldb.rights.GranteeManager;

public class User
extends Grantee {
    private String password;
    private HsqlNameManager.HsqlName initialSchema = null;

    User(HsqlNameManager.HsqlName name, GranteeManager manager) {
        super(name, manager);
        if (manager != null) {
            this.updateAllRights();
        }
    }

    @Override
    public String getSQL() {
        StringBuffer sb = new StringBuffer();
        sb.append("CREATE").append(' ').append("USER");
        sb.append(' ').append(this.granteeName.statementName).append(' ');
        sb.append("PASSWORD").append(' ');
        sb.append('\'').append(this.password).append('\'');
        return sb.toString();
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void checkPassword(String value) {
        if (!value.equals(this.password)) {
            throw Error.error(4000);
        }
    }

    public HsqlNameManager.HsqlName getInitialSchema() {
        return this.initialSchema;
    }

    public HsqlNameManager.HsqlName getInitialOrDefaultSchema() {
        if (this.initialSchema != null) {
            return this.initialSchema;
        }
        HsqlNameManager.HsqlName schema = this.granteeManager.database.schemaManager.findSchemaHsqlName(this.getNameString());
        if (schema == null) {
            return this.granteeManager.database.schemaManager.getDefaultSchemaHsqlName();
        }
        return schema;
    }

    public void setInitialSchema(HsqlNameManager.HsqlName schema) {
        this.initialSchema = schema;
    }

    public String getAlterUserSQL() {
        StringBuffer sb = new StringBuffer();
        sb.append("ALTER").append(' ');
        sb.append("USER").append(' ');
        sb.append(this.getStatementName()).append(' ');
        sb.append("SET").append(' ');
        sb.append("PASSWORD").append(' ');
        sb.append('\"').append(this.password).append('\"');
        return sb.toString();
    }

    public String getInitialSchemaSQL() {
        StringBuffer sb = new StringBuffer();
        sb.append("ALTER").append(' ');
        sb.append("USER").append(' ');
        sb.append(this.getStatementName()).append(' ');
        sb.append("SET").append(' ');
        sb.append("INITIAL").append(' ');
        sb.append("SCHEMA").append(' ');
        sb.append(this.initialSchema.statementName);
        return sb.toString();
    }

    public String getCreateUserSQL() {
        StringBuffer sb = new StringBuffer(64);
        sb.append("CREATE").append(' ');
        sb.append("USER").append(' ');
        sb.append(this.getStatementName()).append(' ');
        sb.append("PASSWORD").append(' ');
        sb.append(StringConverter.toQuotedString(this.password, '\"', true));
        return sb.toString();
    }

    public String getConnectUserSQL() {
        StringBuffer sb = new StringBuffer();
        sb.append("SET").append(' ');
        sb.append("SESSION").append(' ');
        sb.append("AUTHORIZATION").append(' ');
        sb.append(StringConverter.toQuotedString(this.getNameString(), '\'', true));
        return sb.toString();
    }
}

