/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.RandomAccessFile;
import org.hsqldb.Database;
import org.hsqldb.error.Error;
import org.hsqldb.persist.LobStore;

public class LobStoreRAFile
implements LobStore {
    int lobBlockSize = 32768;
    RandomAccessFile file;
    Database database;

    public LobStoreRAFile(Database database, int lobBlockSize) {
        this.lobBlockSize = lobBlockSize;
        this.database = database;
        try {
            String name = database.getPath() + ".lobs";
            boolean exists = database.logger.getFileAccess().isStreamElement(name);
            if (exists) {
                this.openFile();
            }
        }
        catch (Throwable t) {
            throw Error.error(129, t);
        }
    }

    private void openFile() {
        try {
            String name = this.database.getPath() + ".lobs";
            boolean readonly = this.database.isReadOnly();
            this.file = new RandomAccessFile(name, readonly ? "r" : "rwd");
        }
        catch (Throwable t) {
            throw Error.error(129, t);
        }
    }

    @Override
    public byte[] getBlockBytes(int blockAddress, int blockCount) {
        if (this.file == null) {
            throw Error.error(29);
        }
        try {
            long address = (long)blockAddress * (long)this.lobBlockSize;
            int count = blockCount * this.lobBlockSize;
            byte[] dataBytes = new byte[count];
            this.file.seek(address);
            this.file.read(dataBytes);
            return dataBytes;
        }
        catch (Throwable t) {
            throw Error.error(129, t);
        }
    }

    @Override
    public void setBlockBytes(byte[] dataBytes, int blockAddress, int blockCount) {
        if (this.file == null) {
            this.openFile();
        }
        try {
            long address = (long)blockAddress * (long)this.lobBlockSize;
            int count = blockCount * this.lobBlockSize;
            this.file.seek(address);
            this.file.write(dataBytes, 0, count);
        }
        catch (Throwable t) {
            throw Error.error(129, t);
        }
    }

    @Override
    public void close() {
        try {
            if (this.file != null) {
                this.file.close();
            }
        }
        catch (Throwable t) {
            throw Error.error(129, t);
        }
    }
}

