/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.error.Error;
import org.hsqldb.lib.FileAccess;
import org.hsqldb.lib.FileArchiver;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.lib.StopWatch;
import org.hsqldb.lib.Storage;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.persist.Cache;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.DataFileBlockManager;
import org.hsqldb.persist.DataFileDefrag;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.RAShadowFile;
import org.hsqldb.persist.ScaledRAFile;
import org.hsqldb.rowio.RowInputBinary180;
import org.hsqldb.rowio.RowInputBinaryDecode;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputBinary180;
import org.hsqldb.rowio.RowOutputBinaryEncode;
import org.hsqldb.rowio.RowOutputInterface;
import org.hsqldb.store.BitMap;

public class DataFileCache {
    protected FileAccess fa;
    public static final int FLAG_ISSHADOWED = 1;
    public static final int FLAG_ISSAVED = 2;
    public static final int FLAG_ROWINFO = 3;
    public static final int FLAG_190 = 4;
    static final int LONG_EMPTY_SIZE = 4;
    static final int LONG_FREE_POS_POS = 12;
    static final int LONG_EMPTY_INDEX_POS = 20;
    static final int FLAGS_POS = 28;
    static final int INITIAL_FREE_POS = 32;
    DataFileBlockManager freeBlocks;
    private static final int initIOBufferSize = 256;
    protected String dataFileName;
    protected String backupFileName;
    protected Database database;
    protected boolean fileModified;
    protected int cacheFileScale;
    protected boolean cacheReadonly;
    protected boolean storeOnInsert;
    protected int cachedRowPadding = 8;
    protected boolean hasRowInfo = false;
    protected RowInputInterface rowIn;
    public RowOutputInterface rowOut;
    public long maxDataFileSize;
    boolean is180;
    protected Storage dataFile;
    protected volatile long fileFreePosition;
    protected int maxCacheRows;
    protected long maxCacheBytes;
    protected int maxFreeBlocks;
    protected Cache cache;
    private RAShadowFile shadowFile;
    ReadWriteLock lock = new ReentrantReadWriteLock();
    Lock readLock = this.lock.readLock();
    Lock writeLock = this.lock.writeLock();

    public DataFileCache(Database db, String baseFileName) {
        this.initParams(db, baseFileName);
        this.cache = new Cache(this);
    }

    protected void initParams(Database database, String baseFileName) {
        this.dataFileName = baseFileName + ".data";
        this.backupFileName = baseFileName + ".backup";
        this.database = database;
        this.fa = database.logger.getFileAccess();
        this.cacheFileScale = database.logger.getCacheFileScale();
        this.cachedRowPadding = 8;
        if (this.cacheFileScale > 8) {
            this.cachedRowPadding = this.cacheFileScale;
        }
        this.cacheReadonly = database.logger.propFilesReadOnly;
        this.maxCacheRows = database.logger.propCacheMaxRows;
        this.maxCacheBytes = database.logger.propCacheMaxSize;
        this.maxDataFileSize = Integer.MAX_VALUE * (long)this.cacheFileScale;
        this.maxFreeBlocks = database.logger.propMaxFreeBlocks;
        this.dataFile = null;
        this.shadowFile = null;
    }

    public void open(boolean readonly) {
        this.fileFreePosition = 0L;
        this.database.logger.logInfoEvent("open start");
        try {
            int fileType;
            boolean isNio = this.database.logger.propNioDataFile;
            int n = fileType = isNio ? 1 : 0;
            if (this.database.isFilesInJar()) {
                fileType = 2;
            }
            String cname = this.database.getURLProperties().getProperty("storage_class_name");
            String skey = this.database.getURLProperties().getProperty("storage_key");
            if (readonly || this.database.isFilesInJar()) {
                this.dataFile = ScaledRAFile.newScaledRAFile(this.database, this.dataFileName, readonly, fileType, cname, skey);
                this.initBuffers();
                return;
            }
            boolean preexists = false;
            long freesize = 0L;
            if (this.fa.isStreamElement(this.dataFileName)) {
                preexists = true;
            }
            this.dataFile = ScaledRAFile.newScaledRAFile(this.database, this.dataFileName, readonly, fileType, cname, skey);
            if (preexists) {
                this.dataFile.seek(28L);
                int flags = this.dataFile.readInt();
                boolean isSaved = BitMap.isSet(flags, 2);
                this.database.logger.propIncrementBackup = BitMap.isSet(flags, 1);
                boolean bl = this.is180 = !BitMap.isSet(flags, 4);
                if (!isSaved) {
                    boolean restored = true;
                    this.dataFile.close();
                    if (this.database.logger.propIncrementBackup) {
                        restored = this.restoreBackupIncremental();
                        if (!restored) {
                            this.deleteFile();
                            this.is180 = false;
                        }
                    } else {
                        this.restoreBackup();
                    }
                    this.dataFile = ScaledRAFile.newScaledRAFile(this.database, this.dataFileName, readonly, fileType, cname, skey);
                    if (!restored) {
                        this.initNewFile();
                    }
                }
                this.dataFile.seek(4L);
                freesize = this.dataFile.readLong();
                this.dataFile.seek(12L);
                this.fileFreePosition = this.dataFile.readLong();
                if (this.fileFreePosition < 32L) {
                    this.fileFreePosition = 32L;
                }
                if (this.database.logger.propIncrementBackup && this.fileFreePosition != 32L) {
                    this.shadowFile = new RAShadowFile(this.database, this.dataFile, this.backupFileName, this.fileFreePosition, 16384);
                }
            } else {
                this.initNewFile();
            }
            this.initBuffers();
            this.fileModified = false;
            this.freeBlocks = new DataFileBlockManager(this.maxFreeBlocks, this.cacheFileScale, freesize);
            this.database.logger.logInfoEvent("open end");
        }
        catch (Throwable t) {
            this.database.logger.logSevereEvent("open failed", t);
            this.close(false);
            throw Error.error(t, 29, 210, new Object[]{t.getMessage(), this.dataFileName});
        }
    }

    void initNewFile() throws IOException {
        this.fileFreePosition = 32L;
        this.dataFile.seek(12L);
        this.dataFile.writeLong(32L);
        int flags = 0;
        if (this.database.logger.propIncrementBackup) {
            flags = BitMap.set(flags, 1);
        }
        flags = BitMap.set(flags, 4);
        this.dataFile.seek(28L);
        this.dataFile.writeInt(flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setIncrementBackup(boolean value) {
        this.writeLock.lock();
        try {
            this.dataFile.seek(28L);
            int flags = this.dataFile.readInt();
            flags = value ? BitMap.set(flags, 1) : BitMap.unset(flags, 1);
            this.dataFile.seek(28L);
            this.dataFile.writeInt(flags);
            this.dataFile.synch();
        }
        catch (Throwable t) {
            this.database.logger.logSevereEvent("backupFile failed", t);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private boolean restoreBackup() {
        DataFileCache.deleteOrResetFreePos(this.database, this.dataFileName);
        try {
            FileAccess fa = this.database.logger.getFileAccess();
            if (fa.isStreamElement(this.backupFileName)) {
                FileArchiver.unarchive(this.backupFileName, this.dataFileName, fa, 1);
                return true;
            }
            return false;
        }
        catch (Throwable t) {
            throw Error.error(t, 29, 115, new Object[]{t.getMessage(), this.backupFileName});
        }
    }

    private boolean restoreBackupIncremental() {
        try {
            if (this.fa.isStreamElement(this.backupFileName)) {
                RAShadowFile.restoreFile(this.backupFileName, this.dataFileName);
                this.deleteBackup();
                return true;
            }
            return false;
        }
        catch (IOException e) {
            throw Error.error(29, e);
        }
    }

    public void close(boolean write) {
        try {
            boolean empty;
            if (this.cacheReadonly) {
                if (this.dataFile != null) {
                    this.dataFile.close();
                    this.dataFile = null;
                }
                return;
            }
            StopWatch sw = new StopWatch();
            this.database.logger.logInfoEvent("DataFileCache.close(" + write + ") : start");
            if (write) {
                this.cache.saveAll();
                Error.printSystemOut("saveAll: " + sw.elapsedTime());
                this.database.logger.logInfoEvent("DataFileCache.close() : save data");
                if (this.fileModified || this.freeBlocks.isModified()) {
                    this.dataFile.seek(4L);
                    this.dataFile.writeLong(this.freeBlocks.getLostBlocksSize());
                    this.dataFile.seek(12L);
                    this.dataFile.writeLong(this.fileFreePosition);
                    this.dataFile.seek(28L);
                    int flags = this.dataFile.readInt();
                    flags = BitMap.set(flags, 2);
                    this.dataFile.seek(28L);
                    this.dataFile.writeInt(flags);
                    this.database.logger.logInfoEvent("DataFileCache.close() : flags");
                    this.dataFile.seek(this.fileFreePosition);
                    this.database.logger.logInfoEvent("DataFileCache.close() : seek end");
                    Error.printSystemOut("pos and flags: " + sw.elapsedTime());
                }
            }
            if (this.dataFile != null) {
                this.dataFile.close();
                this.database.logger.logInfoEvent("DataFileCache.close() : close");
                this.dataFile = null;
                Error.printSystemOut("close: " + sw.elapsedTime());
            }
            if (this.shadowFile != null) {
                this.shadowFile.close();
                this.shadowFile = null;
            }
            boolean bl = empty = this.fileFreePosition == 32L;
            if (empty) {
                this.fa.removeElement(this.dataFileName);
                this.fa.removeElement(this.backupFileName);
            }
        }
        catch (Throwable t) {
            this.database.logger.logSevereEvent("Close failed", t);
            throw Error.error(t, 29, 211, new Object[]{t.getMessage(), this.dataFileName});
        }
    }

    protected void initBuffers() {
        if (this.rowOut == null || this.rowOut.getOutputStream().getBuffer().length > 256) {
            this.rowOut = this.is180 ? new RowOutputBinary180(256, this.cachedRowPadding) : new RowOutputBinaryEncode(this.database.logger.getCrypto(), 256, this.cachedRowPadding);
        }
        if (this.rowIn == null || this.rowIn.getBuffer().length > 256) {
            this.rowIn = this.is180 ? new RowInputBinary180(new byte[256]) : new RowInputBinaryDecode(this.database.logger.getCrypto(), new byte[256]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DataFileDefrag defrag() {
        this.writeLock.lock();
        try {
            this.cache.saveAll();
            DataFileDefrag dfd = new DataFileDefrag(this.database, this, this.dataFileName);
            dfd.process();
            this.close(false);
            this.cache.clear();
            this.backupFile();
            this.database.schemaManager.setTempIndexRoots(dfd.getIndexRoots());
            this.database.logger.log.writeScript(false);
            this.database.getProperties().setDBModified(2);
            this.database.logger.log.closeLog();
            this.database.logger.log.deleteLog();
            this.database.logger.log.renameNewScript();
            this.renameDataFile();
            this.renameBackupFile();
            this.database.getProperties().setDBModified(0);
            this.open(false);
            dfd.updateTransactionRowIDs();
            this.database.schemaManager.setIndexRoots(dfd.getIndexRoots());
            if (this.database.logger.log.dbLogWriter != null) {
                this.database.logger.log.openLog();
            }
            this.database.getProperties().setDBModified(1);
            DataFileDefrag dataFileDefrag = dfd;
            return dataFileDefrag;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(int i, PersistentStore store) {
        this.writeLock.lock();
        try {
            CachedObject r = this.release(i);
            if (r != null) {
                int size = r.getStorageSize();
                this.freeBlocks.add(i, size);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void removePersistence(int i) {
    }

    private int setFilePos(CachedObject r) {
        int i;
        int rowSize = r.getStorageSize();
        int n = i = this.freeBlocks == null ? -1 : this.freeBlocks.get(rowSize);
        if (i == -1) {
            i = (int)(this.fileFreePosition / (long)this.cacheFileScale);
            long newFreePosition = this.fileFreePosition + (long)rowSize;
            if (newFreePosition > this.maxDataFileSize) {
                throw Error.error(225);
            }
            this.fileFreePosition = newFreePosition;
        }
        r.setPos(i);
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(CachedObject object) {
        this.writeLock.lock();
        try {
            int i = this.setFilePos(object);
            this.cache.put(i, object);
            if (this.storeOnInsert) {
                this.saveRow(object);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restore(CachedObject object) {
        this.writeLock.lock();
        try {
            int i = object.getPos();
            this.cache.put(i, object);
            if (this.storeOnInsert) {
                this.saveRow(object);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStorageSize(int i) {
        this.readLock.lock();
        try {
            CachedObject value = this.cache.get(i);
            if (value != null) {
                int n = value.getStorageSize();
                return n;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return this.readSize(i);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedObject get(CachedObject object, PersistentStore store, boolean keep) {
        int pos;
        this.readLock.lock();
        try {
            if (object.isInMemory()) {
                if (keep) {
                    object.keepInMemory(true);
                }
                CachedObject cachedObject = object;
                return cachedObject;
            }
            pos = object.getPos();
            if (pos < 0) {
                CachedObject cachedObject = null;
                return cachedObject;
            }
            object = this.cache.get(pos);
            if (object != null) {
                if (keep) {
                    object.keepInMemory(true);
                }
                CachedObject cachedObject = object;
                return cachedObject;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return this.getFromFile(pos, store, keep);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedObject get(int pos, PersistentStore store, boolean keep) {
        if (pos < 0) {
            return null;
        }
        this.readLock.lock();
        try {
            CachedObject object = this.cache.get(pos);
            if (object != null) {
                if (keep) {
                    object.keepInMemory(true);
                }
                CachedObject cachedObject = object;
                return cachedObject;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return this.getFromFile(pos, store, keep);
    }

    private CachedObject getFromFile(int pos, PersistentStore store, boolean keep) {
        CachedObject object = null;
        boolean outOfMemory = false;
        this.writeLock.lock();
        try {
            object = this.cache.get(pos);
            if (object != null) {
                if (keep) {
                    object.keepInMemory(true);
                }
                CachedObject cachedObject = object;
                return cachedObject;
            }
            for (int j = 0; j < 5; ++j) {
                RowInputInterface rowInput;
                block15: {
                    outOfMemory = false;
                    try {
                        rowInput = this.readObject(pos);
                        if (rowInput != null) break block15;
                        CachedObject cachedObject = null;
                        return cachedObject;
                    }
                    catch (OutOfMemoryError err) {
                        this.cache.cleanUp();
                        outOfMemory = true;
                        this.database.logger.logSevereEvent("OOME in getFromFile", err);
                        continue;
                    }
                }
                object = store.get(rowInput);
                break;
            }
            if (outOfMemory) {
                throw Error.error(72);
            }
            pos = object.getPos();
            this.cache.put(pos, object);
            if (keep) {
                object.keepInMemory(true);
            }
            store.set(object);
            CachedObject j = object;
            return j;
        }
        catch (HsqlException e) {
            this.database.logger.logSevereEvent(this.dataFileName + " getFromFile " + pos, e);
            throw e;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RowInputInterface getRaw(int i) {
        this.writeLock.lock();
        try {
            RowInputInterface rowInputInterface = this.readObject(i);
            return rowInputInterface;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected int readSize(int pos) {
        this.writeLock.lock();
        try {
            this.dataFile.seek((long)pos * (long)this.cacheFileScale);
            int n = this.dataFile.readInt();
            return n;
        }
        catch (IOException e) {
            throw Error.error(129, e);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected RowInputInterface readObject(int pos) {
        try {
            this.dataFile.seek((long)pos * (long)this.cacheFileScale);
            int size = this.dataFile.readInt();
            this.rowIn.resetRow(pos, size);
            this.dataFile.read(this.rowIn.getBuffer(), 4, size - 4);
            return this.rowIn;
        }
        catch (IOException e) {
            throw Error.error(129, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedObject release(int pos) {
        this.writeLock.lock();
        try {
            CachedObject cachedObject = this.cache.release(pos);
            return cachedObject;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected void saveRows(CachedObject[] rows, int offset, int count) {
        this.writeLock.lock();
        try {
            this.setFileModified();
            this.copyShadow(rows, offset, count);
            for (int i = offset; i < offset + count; ++i) {
                CachedObject r = rows[i];
                this.saveRowNoLock(r);
                rows[i] = null;
            }
        }
        catch (HsqlException e) {
            this.database.logger.logSevereEvent("saveRows failed", e);
            throw e;
        }
        catch (Throwable e) {
            this.database.logger.logSevereEvent("saveRows failed", e);
            throw Error.error(129, e);
        }
        finally {
            this.initBuffers();
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveRow(CachedObject row) {
        this.writeLock.lock();
        try {
            this.setFileModified();
            this.saveRowNoLock(row);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void saveRowNoLock(CachedObject row) {
        try {
            this.rowOut.reset();
            row.write(this.rowOut);
            this.dataFile.seek((long)row.getPos() * (long)this.cacheFileScale);
            this.dataFile.write(this.rowOut.getOutputStream().getBuffer(), 0, this.rowOut.getOutputStream().size());
        }
        catch (IOException e) {
            throw Error.error(129, e);
        }
    }

    protected void copyShadow(CachedObject[] rows, int offset, int count) throws IOException {
        if (this.shadowFile != null) {
            for (int i = offset; i < offset + count; ++i) {
                CachedObject row = rows[i];
                long seekpos = (long)row.getPos() * (long)this.cacheFileScale;
                this.shadowFile.copy(seekpos, row.getStorageSize());
            }
            this.shadowFile.close();
        }
    }

    void backupFile() {
        this.writeLock.lock();
        try {
            if (this.database.logger.propIncrementBackup) {
                if (this.fa.isStreamElement(this.backupFileName)) {
                    this.fa.removeElement(this.backupFileName);
                }
                return;
            }
            if (this.fa.isStreamElement(this.dataFileName)) {
                FileArchiver.archive(this.dataFileName, this.backupFileName + ".new", this.database.logger.getFileAccess(), 1);
            }
        }
        catch (IOException e) {
            this.database.logger.logSevereEvent("backupFile failed", e);
            throw Error.error(129, e);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void renameBackupFile() {
        this.writeLock.lock();
        try {
            if (this.database.logger.propIncrementBackup) {
                if (this.fa.isStreamElement(this.backupFileName)) {
                    this.fa.removeElement(this.backupFileName);
                }
                return;
            }
            if (this.fa.isStreamElement(this.backupFileName + ".new")) {
                this.fa.removeElement(this.backupFileName);
                this.fa.renameElement(this.backupFileName + ".new", this.backupFileName);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void renameDataFile() {
        this.writeLock.lock();
        try {
            if (this.fa.isStreamElement(this.dataFileName + ".new")) {
                this.deleteFile();
                this.fa.renameElement(this.dataFileName + ".new", this.dataFileName);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteFile() {
        block9: {
            this.writeLock.lock();
            try {
                this.fa.removeElement(this.dataFileName);
                if (this.database.logger.isStoredFileAccess()) {
                    return;
                }
                if (!this.fa.isStreamElement(this.dataFileName)) break block9;
                this.fa.removeElement(this.dataFileName);
                if (!this.fa.isStreamElement(this.dataFileName)) break block9;
                try {
                    File file = new File(this.database.getCanonicalPath());
                    File[] list = file.getParentFile().listFiles();
                    for (int i = 0; i < list.length; ++i) {
                        if (!list[i].getName().endsWith(".old") || !list[i].getName().startsWith(file.getName())) continue;
                        list[i].delete();
                    }
                }
                catch (Throwable t) {
                    // empty catch block
                }
                String oldName = this.dataFileName + ".old";
                this.fa.removeElement(oldName);
                if (this.fa.isStreamElement(oldName)) {
                    String timestamp = StringUtil.toPaddedString(Integer.toHexString((int)System.currentTimeMillis()), 8, '0', true);
                    String discardName = this.dataFileName + "." + timestamp + ".old";
                    this.fa.renameElement(oldName, discardName);
                    File discardFile = new File(discardName);
                    FileUtil.getFileUtil().deleteOnExit(discardFile);
                }
                this.fa.renameElement(this.dataFileName, oldName);
                File oldfile = new File(oldName);
                FileUtil.getFileUtil().deleteOnExit(oldfile);
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteBackup() {
        this.writeLock.lock();
        try {
            this.fa.removeElement(this.backupFileName);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void deleteOrResetFreePos(Database database, String filename) {
        ScaledRAFile raFile = null;
        database.logger.getFileAccess().removeElement(filename);
        if (database.logger.isStoredFileAccess()) {
            return;
        }
        if (!database.logger.getFileAccess().isStreamElement(filename)) {
            return;
        }
        try {
            raFile = new ScaledRAFile(database, filename, false);
            raFile.seek(12L);
            raFile.writeLong(32L);
        }
        catch (IOException e) {
            database.logger.logSevereEvent("deleteOrResetFreePos failed", e);
        }
        finally {
            if (raFile != null) {
                try {
                    raFile.close();
                }
                catch (IOException e) {
                    database.logger.logWarningEvent("Failed to close RA file", e);
                }
            }
        }
    }

    public int capacity() {
        return this.maxCacheRows;
    }

    public long bytesCapacity() {
        return this.maxCacheBytes;
    }

    public long getTotalCachedBlockSize() {
        return this.cache.getTotalCachedBlockSize();
    }

    public int getFreeBlockCount() {
        return this.freeBlocks.size();
    }

    public int getTotalFreeBlockSize() {
        return 0;
    }

    public long getFileFreePos() {
        return this.fileFreePosition;
    }

    public int getCachedObjectCount() {
        return this.cache.size();
    }

    public int getAccessCount() {
        return this.cache.incrementAccessCount();
    }

    public String getFileName() {
        return this.dataFileName;
    }

    public boolean hasRowInfo() {
        return this.hasRowInfo;
    }

    public boolean isFileModified() {
        return this.fileModified;
    }

    public boolean isFileOpen() {
        return this.dataFile != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setFileModified() {
        this.writeLock.lock();
        try {
            if (!this.fileModified) {
                this.dataFile.seek(28L);
                int flags = this.dataFile.readInt();
                flags = BitMap.unset(flags, 2);
                this.dataFile.seek(28L);
                this.dataFile.writeInt(flags);
                this.dataFile.synch();
                this.fileModified = true;
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public boolean isDataReadOnly() {
        return this.cacheReadonly;
    }
}

