/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.navigator;

import java.io.IOException;
import org.hsqldb.HsqlException;
import org.hsqldb.QueryExpression;
import org.hsqldb.QuerySpecification;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.SortAndSlice;
import org.hsqldb.TableBase;
import org.hsqldb.index.Index;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.navigator.RowSetNavigator;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputInterface;
import org.hsqldb.types.Type;

public class RowSetNavigatorData
extends RowSetNavigator {
    final Session session;
    public TableBase table;
    public PersistentStore store;
    RowIterator iterator;
    Row currentRow;
    int maxMemoryRowCount;
    boolean isClosed;
    int visibleColumnCount;
    boolean isAggregate;
    boolean isSimpleAggregate;
    Object[] simpleAggregateData;
    boolean reindexTable;
    private Index mainIndex;
    private Index fullIndex;
    private Index orderIndex;
    private Index groupIndex;

    public RowSetNavigatorData(Session session, QuerySpecification select) {
        this.session = session;
        this.maxMemoryRowCount = session.getResultMemoryRowCount();
        this.visibleColumnCount = select.indexLimitVisible;
        this.table = select.resultTable.duplicate();
        this.table.store = this.store = session.sessionData.getNewResultRowStore(this.table, !select.isAggregated);
        this.isAggregate = select.isAggregated;
        this.isSimpleAggregate = select.isAggregated && !select.isGrouped;
        this.reindexTable = select.isGrouped;
        this.mainIndex = select.mainIndex;
        this.fullIndex = select.fullIndex;
        this.orderIndex = select.orderIndex;
        this.groupIndex = select.groupIndex;
    }

    public RowSetNavigatorData(Session session, QueryExpression queryExpression) {
        this.session = session;
        this.maxMemoryRowCount = session.getResultMemoryRowCount();
        this.table = queryExpression.resultTable.duplicate();
        this.visibleColumnCount = this.table.getColumnCount();
        this.table.store = this.store = session.sessionData.getNewResultRowStore(this.table, true);
        this.mainIndex = queryExpression.mainIndex;
        this.fullIndex = queryExpression.fullIndex;
    }

    public RowSetNavigatorData(Session session, TableBase table) {
        this.session = session;
        this.maxMemoryRowCount = session.getResultMemoryRowCount();
        this.table = table;
        this.visibleColumnCount = table.getColumnCount();
        this.store = session.sessionData.getRowStore(table);
        this.mainIndex = table.getPrimaryIndex();
        this.fullIndex = table.getFullIndex();
        this.size = this.mainIndex.size(this.store);
    }

    public void sortFull() {
        if (this.reindexTable) {
            this.store.indexRows();
        }
        this.mainIndex = this.fullIndex;
        this.reset();
    }

    public void sortOrder() {
        if (this.orderIndex != null) {
            if (this.reindexTable) {
                this.store.indexRows();
            }
            this.mainIndex = this.orderIndex;
            this.reset();
        }
    }

    public void sortUnion(SortAndSlice sortAndSlice) {
        if (sortAndSlice.index != null) {
            this.mainIndex = sortAndSlice.index;
            this.reset();
        }
    }

    public void sortGroup() {
        this.mainIndex = this.groupIndex;
        this.reset();
    }

    @Override
    public void add(Object data) {
        try {
            Row row = (Row)this.store.getNewCachedObject(this.session, data);
            this.store.indexRow(null, row);
            ++this.size;
        }
        catch (HsqlException hsqlException) {
            // empty catch block
        }
    }

    private void addAdjusted(Object[] data, int[] columnMap) {
        try {
            if (columnMap == null) {
                data = (Object[])ArrayUtil.resizeArrayIfDifferent(data, this.table.getColumnCount());
            } else {
                Object[] newData = new Object[this.table.getColumnCount()];
                ArrayUtil.projectRow(data, columnMap, newData);
                data = newData;
            }
            Row row = (Row)this.store.getNewCachedObject(this.session, data);
            this.store.indexRow(null, row);
            ++this.size;
        }
        catch (HsqlException hsqlException) {
            // empty catch block
        }
    }

    @Override
    public void clear() {
        this.table.clearAllData(this.store);
        this.size = 0;
        this.reset();
    }

    @Override
    public Object[] getCurrent() {
        return this.currentRow.getData();
    }

    @Override
    public Row getCurrentRow() {
        return this.currentRow;
    }

    @Override
    public boolean next() {
        boolean result = super.next();
        this.currentRow = this.iterator.getNextRow();
        return result;
    }

    @Override
    public void remove() {
        if (this.currentRow != null) {
            this.iterator.remove();
            this.currentRow = null;
            --this.currentPos;
            --this.size;
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.iterator = this.mainIndex.firstRow(this.store);
    }

    @Override
    public void close() {
        if (this.isClosed) {
            return;
        }
        this.iterator.release();
        this.store.release();
        this.isClosed = true;
    }

    @Override
    public boolean isMemory() {
        return this.store.isMemory();
    }

    @Override
    public void read(RowInputInterface in, ResultMetaData meta) throws IOException {
    }

    @Override
    public void write(RowOutputInterface out, ResultMetaData meta) throws IOException {
        this.reset();
        out.writeLong(this.id);
        out.writeInt(this.size);
        out.writeInt(0);
        out.writeInt(this.size);
        while (this.hasNext()) {
            Object[] data = this.getNext();
            out.writeData(meta.getExtendedColumnCount(), meta.columnTypes, data, null, null);
        }
        this.reset();
    }

    public void copy(RowSetNavigatorData other, int[] rightColumnIndexes) {
        while (other.hasNext()) {
            other.getNext();
            Object[] currentData = other.currentRow.getData();
            this.addAdjusted(currentData, rightColumnIndexes);
        }
        other.close();
    }

    public void union(RowSetNavigatorData other, int[] rightColumnIndexes) {
        this.removeDuplicates();
        this.reset();
        while (other.hasNext()) {
            other.getNext();
            Object[] currentData = other.currentRow.getData();
            RowIterator it = this.fullIndex.findFirstRow(this.session, this.store, currentData, rightColumnIndexes);
            if (it.hasNext()) continue;
            this.addAdjusted(currentData, rightColumnIndexes);
        }
        other.close();
    }

    public void unionAll(RowSetNavigatorData other, int[] rightColumnIndexes) {
        other.reset();
        while (other.hasNext()) {
            other.getNext();
            Object[] currentData = other.currentRow.getData();
            this.addAdjusted(currentData, rightColumnIndexes);
        }
        other.close();
    }

    public void intersect(RowSetNavigatorData other) {
        this.removeDuplicates();
        this.reset();
        other.sortFull();
        while (this.hasNext()) {
            this.getNext();
            Object[] currentData = this.currentRow.getData();
            RowIterator it = other.fullIndex.findFirstRow(this.session, other.store, currentData);
            if (it.hasNext()) continue;
            this.remove();
        }
        other.close();
    }

    public void intersectAll(RowSetNavigatorData other) {
        Object[] compareData = null;
        Row otherRow = null;
        Object[] otherData = null;
        this.sortFull();
        this.reset();
        other.sortFull();
        RowIterator it = other.fullIndex.emptyIterator();
        while (this.hasNext()) {
            boolean newGroup;
            this.getNext();
            Object[] currentData = this.currentRow.getData();
            boolean bl = newGroup = compareData == null || this.fullIndex.compareRowNonUnique(this.session, currentData, compareData, this.fullIndex.getColumnCount()) != 0;
            if (newGroup) {
                compareData = currentData;
                it = other.fullIndex.findFirstRow(this.session, other.store, currentData);
            }
            Object[] objectArray = otherData = (otherRow = it.getNextRow()) == null ? null : otherRow.getData();
            if (otherData != null && this.fullIndex.compareRowNonUnique(this.session, currentData, otherData, this.fullIndex.getColumnCount()) == 0) continue;
            this.remove();
        }
        other.close();
    }

    public void except(RowSetNavigatorData other) {
        this.removeDuplicates();
        this.reset();
        other.sortFull();
        while (this.hasNext()) {
            this.getNext();
            Object[] currentData = this.currentRow.getData();
            RowIterator it = other.fullIndex.findFirstRow(this.session, other.store, currentData);
            if (!it.hasNext()) continue;
            this.remove();
        }
        other.close();
    }

    public void exceptAll(RowSetNavigatorData other) {
        Object[] compareData = null;
        Row otherRow = null;
        Object[] otherData = null;
        this.sortFull();
        this.reset();
        other.sortFull();
        RowIterator it = other.fullIndex.emptyIterator();
        while (this.hasNext()) {
            boolean newGroup;
            this.getNext();
            Object[] currentData = this.currentRow.getData();
            boolean bl = newGroup = compareData == null || this.fullIndex.compareRowNonUnique(this.session, currentData, compareData, this.fullIndex.getColumnCount()) != 0;
            if (newGroup) {
                compareData = currentData;
                it = other.fullIndex.findFirstRow(this.session, other.store, currentData);
            }
            if ((otherData = (otherRow = it.getNextRow()) == null ? null : otherRow.getData()) == null || this.fullIndex.compareRowNonUnique(this.session, currentData, otherData, this.fullIndex.getColumnCount()) != 0) continue;
            this.remove();
        }
        other.close();
    }

    public boolean hasUniqueNotNullRows() {
        this.sortFull();
        this.reset();
        Object[] lastRowData = null;
        while (this.hasNext()) {
            this.getNext();
            Object[] currentData = this.currentRow.getData();
            if (this.hasNull(currentData)) continue;
            if (lastRowData != null && this.equals(lastRowData, currentData)) {
                return false;
            }
            lastRowData = currentData;
        }
        return true;
    }

    public void removeDuplicates() {
        this.sortFull();
        this.reset();
        Object[] lastRowData = null;
        while (this.hasNext()) {
            this.getNext();
            Object[] currentData = this.currentRow.getData();
            if (lastRowData != null && this.equals(lastRowData, currentData)) {
                this.remove();
                continue;
            }
            lastRowData = currentData;
        }
    }

    public void trim(int limitstart, int limitcount) {
        int i;
        if (this.size == 0) {
            return;
        }
        if (limitstart >= this.size) {
            this.clear();
            return;
        }
        if (limitstart != 0) {
            this.reset();
            for (i = 0; i < limitstart; ++i) {
                this.next();
                this.remove();
            }
        }
        if (limitcount == 0 || limitcount >= this.size) {
            return;
        }
        this.reset();
        for (i = 0; i < limitcount; ++i) {
            this.next();
        }
        while (this.hasNext()) {
            this.next();
            this.remove();
        }
    }

    private boolean hasNull(Object[] data) {
        for (int i = 0; i < this.visibleColumnCount; ++i) {
            if (data[i] != null) continue;
            return true;
        }
        return false;
    }

    private boolean equals(Object[] data1, Object[] data2) {
        Type[] types = this.table.getColumnTypes();
        for (int i = 0; i < this.visibleColumnCount; ++i) {
            if (types[i].compare(this.session, data1[i], data2[i]) == 0) continue;
            return false;
        }
        return true;
    }

    public Object[] getGroupData(Object[] data) {
        if (this.isSimpleAggregate) {
            if (this.simpleAggregateData == null) {
                this.simpleAggregateData = data;
                return null;
            }
            return this.simpleAggregateData;
        }
        RowIterator it = this.groupIndex.findFirstRow(this.session, this.store, data);
        if (it.hasNext()) {
            Row row = it.getNextRow();
            if (this.isAggregate) {
                row.setChanged();
            }
            return row.getData();
        }
        return null;
    }
}

