/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib.tar;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.lib.tar.DbBackup;
import org.hsqldb.lib.tar.PIFGenerator;
import org.hsqldb.lib.tar.RB;
import org.hsqldb.lib.tar.TarFileOutputStream;
import org.hsqldb.lib.tar.TarHeaderFields;
import org.hsqldb.lib.tar.TarMalformatException;

public class TarGenerator {
    protected TarFileOutputStream archive;
    protected List entryQueue = new ArrayList();
    protected long paxThreshold = 0x200000000L;

    public static void main(String[] sa) throws IOException, TarMalformatException {
        if (sa.length < 1) {
            System.out.println(RB.singleton.getString(RB.TARGENERATOR_SYNTAX, DbBackup.class.getName()));
            System.exit(0);
        }
        TarGenerator generator = new TarGenerator(new File(sa[0]), true, null);
        if (sa.length == 1) {
            generator.queueEntry("stdin", System.in, 10240);
        } else {
            for (int i = 1; i < sa.length; ++i) {
                generator.queueEntry(new File(sa[i]));
            }
        }
        generator.write();
    }

    public void setPaxThreshold(long paxThreshold) {
        this.paxThreshold = paxThreshold;
    }

    public long getPaxThreshold() {
        return this.paxThreshold;
    }

    public TarGenerator(File inFile, boolean overWrite, Integer blocksPerRecord) throws IOException {
        File archiveFile = inFile.getAbsoluteFile();
        int compression = 0;
        if (archiveFile.getName().endsWith(".tgz") || archiveFile.getName().endsWith(".tar.gz")) {
            compression = 1;
        } else if (!archiveFile.getName().endsWith(".tar")) {
            throw new IllegalArgumentException(RB.singleton.getString(RB.UNSUPPORTED_EXT, this.getClass().getName(), archiveFile.getPath()));
        }
        if (archiveFile.exists()) {
            if (!overWrite) {
                throw new IOException(RB.singleton.getString(RB.DEST_EXISTS, archiveFile.getPath()));
            }
        } else {
            File parentDir = archiveFile.getParentFile();
            if (parentDir.exists()) {
                if (!parentDir.isDirectory()) {
                    throw new IOException(RB.singleton.getString(RB.PARENT_NOT_DIR, parentDir.getPath()));
                }
                if (!parentDir.canWrite()) {
                    throw new IOException(RB.singleton.getString(RB.CANT_WRITE_PARENT, parentDir.getPath()));
                }
            } else if (!parentDir.mkdirs()) {
                throw new IOException(RB.singleton.getString(RB.PARENT_CREATE_FAIL, parentDir.getPath()));
            }
        }
        TarFileOutputStream tarFileOutputStream = this.archive = blocksPerRecord == null ? new TarFileOutputStream(archiveFile, compression) : new TarFileOutputStream(archiveFile, compression, blocksPerRecord);
        if (blocksPerRecord != null && TarFileOutputStream.debug) {
            System.out.println(RB.singleton.getString(RB.BPR_WRITE, blocksPerRecord));
        }
    }

    public void queueEntry(File file) throws FileNotFoundException, TarMalformatException {
        this.queueEntry(null, file);
    }

    public void queueEntry(String entryPath, File file) throws FileNotFoundException, TarMalformatException {
        this.entryQueue.add(new TarEntrySupplicant(entryPath, file, this.archive));
    }

    public void queueEntry(String entryPath, InputStream inStream, int maxBytes) throws IOException, TarMalformatException {
        this.entryQueue.add(new TarEntrySupplicant(entryPath, inStream, maxBytes, '0', this.archive));
    }

    public void write() throws IOException, TarMalformatException {
        if (TarFileOutputStream.debug) {
            System.out.println(RB.singleton.getString(RB.WRITE_QUEUE_REPORT, this.entryQueue.size()));
        }
        try {
            for (int i = 0; i < this.entryQueue.size(); ++i) {
                System.err.print(Integer.toString(i + 1) + " / " + this.entryQueue.size() + ' ');
                TarEntrySupplicant entry = (TarEntrySupplicant)this.entryQueue.get(i);
                System.err.print(entry.getPath() + "... ");
                if (entry.getDataSize() >= this.paxThreshold) {
                    entry.makeXentry().write();
                    System.err.print("x... ");
                }
                entry.write();
                this.archive.assertAtBlockBoundary();
                System.err.println();
            }
            this.archive.finish();
        }
        catch (IOException ioe) {
            System.err.println();
            try {
                for (int i = 0; i < this.entryQueue.size(); ++i) {
                    ((TarEntrySupplicant)this.entryQueue.get(i)).close();
                }
                this.archive.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw ioe;
        }
    }

    protected static class TarEntrySupplicant {
        protected static byte[] HEADER_TEMPLATE = (byte[])TarFileOutputStream.ZERO_BLOCK.clone();
        static Character swapOutDelim = null;
        protected static final byte[] ustarBytes = new byte[]{117, 115, 116, 97, 114};
        protected byte[] rawHeader = (byte[])HEADER_TEMPLATE.clone();
        protected String fileMode = "600";
        protected InputStream inputStream;
        protected String path;
        protected long modTime;
        protected TarFileOutputStream tarStream;
        protected long dataSize;
        protected boolean paxSized = false;
        public static final String DEFAULT_FILE_MODES = "600";

        protected static void writeField(int fieldId, String newValue, byte[] target) throws TarMalformatException {
            byte[] ba;
            int start = TarHeaderFields.getStart(fieldId);
            int stop = TarHeaderFields.getStop(fieldId);
            try {
                ba = newValue.getBytes("ISO-8859-1");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            if (ba.length > stop - start) {
                throw new TarMalformatException(RB.singleton.getString(RB.TAR_FIELD_TOOBIG, TarHeaderFields.toString(fieldId), newValue));
            }
            for (int i = 0; i < ba.length; ++i) {
                target[start + i] = ba[i];
            }
        }

        protected static void clearField(int fieldId, byte[] target) {
            int start = TarHeaderFields.getStart(fieldId);
            int stop = TarHeaderFields.getStop(fieldId);
            for (int i = start; i < stop; ++i) {
                target[i] = 0;
            }
        }

        protected static void writeField(int fieldId, long newValue, byte[] target) throws TarMalformatException {
            TarEntrySupplicant.writeField(fieldId, TarEntrySupplicant.prePaddedOctalString(newValue, TarHeaderFields.getStop(fieldId) - TarHeaderFields.getStart(fieldId)), target);
        }

        public static String prePaddedOctalString(long val, int width) {
            return StringUtil.toPaddedString(Long.toOctalString(val), width, '0', false);
        }

        public String getPath() {
            return this.path;
        }

        public long getDataSize() {
            return this.dataSize;
        }

        protected TarEntrySupplicant(String path, char typeFlag, TarFileOutputStream tarStream) throws TarMalformatException {
            if (path == null) {
                throw new IllegalArgumentException(RB.singleton.getString(RB.MISSING_SUPP_PATH));
            }
            this.path = swapOutDelim == null ? path : path.replace(swapOutDelim.charValue(), '/');
            this.tarStream = tarStream;
            this.writeField(8, typeFlag);
            if (typeFlag == '\u0000' || typeFlag == ' ') {
                TarEntrySupplicant.writeField(10, System.getProperty("user.name"), HEADER_TEMPLATE);
                TarEntrySupplicant.writeField(11, "root", HEADER_TEMPLATE);
            }
        }

        public TarEntrySupplicant makeXentry() throws IOException, TarMalformatException {
            PIFGenerator pif = new PIFGenerator(new File(this.path));
            pif.addRecord("size", this.dataSize);
            this.paxSized = true;
            return new TarEntrySupplicant(pif.getName(), new ByteArrayInputStream(pif.toByteArray()), pif.size(), 'x', this.tarStream);
        }

        public TarEntrySupplicant(String path, File file, TarFileOutputStream tarStream) throws FileNotFoundException, TarMalformatException {
            this(path == null ? file.getPath() : path, '0', tarStream);
            if (!file.isFile()) {
                throw new IllegalArgumentException(RB.singleton.getString(RB.NONFILE_ENTRY));
            }
            if (!file.canRead()) {
                throw new IllegalArgumentException(RB.singleton.getString(RB.READ_DENIED, file.getAbsolutePath()));
            }
            this.modTime = file.lastModified() / 1000L;
            this.fileMode = TarEntrySupplicant.getLameMode(file);
            this.dataSize = file.length();
            this.inputStream = new FileInputStream(file);
        }

        public TarEntrySupplicant(String path, InputStream origStream, int maxBytes, char typeFlag, TarFileOutputStream tarStream) throws IOException, TarMalformatException {
            this(path, typeFlag, tarStream);
            if (maxBytes < 1) {
                throw new IllegalArgumentException(RB.singleton.getString(RB.READ_LT_1));
            }
            PipedOutputStream outPipe = new PipedOutputStream();
            this.inputStream = new PipedInputStream(outPipe);
            try {
                int i;
                while ((i = origStream.read(tarStream.writeBuffer, 0, tarStream.writeBuffer.length)) > 0) {
                    outPipe.write(tarStream.writeBuffer, 0, i);
                }
                outPipe.flush();
                this.dataSize = this.inputStream.available();
                if (TarFileOutputStream.debug) {
                    System.out.println(RB.singleton.getString(RB.STREAM_BUFFER_REPORT, Long.toString(this.dataSize)));
                }
            }
            catch (IOException ioe) {
                this.inputStream.close();
                throw ioe;
            }
            finally {
                outPipe.close();
            }
            this.modTime = new Date().getTime() / 1000L;
        }

        public void close() throws IOException {
            this.inputStream.close();
        }

        protected long headerChecksum() {
            long sum = 0L;
            for (int i = 0; i < this.rawHeader.length; ++i) {
                boolean isInRange = i >= TarHeaderFields.getStart(7) && i < TarHeaderFields.getStop(7);
                sum += isInRange ? 32L : (long)(0xFF & this.rawHeader[i]);
            }
            return sum;
        }

        protected void clearField(int fieldId) {
            TarEntrySupplicant.clearField(fieldId, this.rawHeader);
        }

        protected void writeField(int fieldId, String newValue) throws TarMalformatException {
            TarEntrySupplicant.writeField(fieldId, newValue, this.rawHeader);
        }

        protected void writeField(int fieldId, long newValue) throws TarMalformatException {
            TarEntrySupplicant.writeField(fieldId, newValue, this.rawHeader);
        }

        protected void writeField(int fieldId, char c) throws TarMalformatException {
            TarEntrySupplicant.writeField(fieldId, Character.toString(c), this.rawHeader);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write() throws IOException, TarMalformatException {
            try {
                int i;
                this.writeField(1, this.path);
                this.writeField(2, this.fileMode);
                if (!this.paxSized) {
                    this.writeField(5, this.dataSize);
                }
                this.writeField(6, this.modTime);
                this.writeField(7, TarEntrySupplicant.prePaddedOctalString(this.headerChecksum(), 6) + "\u0000 ");
                this.tarStream.writeBlock(this.rawHeader);
                long dataStart = this.tarStream.getBytesWritten();
                while ((i = this.inputStream.read(this.tarStream.writeBuffer)) > 0) {
                    this.tarStream.write(i);
                }
                if (dataStart + this.dataSize != this.tarStream.getBytesWritten()) {
                    throw new IOException(RB.singleton.getString(RB.DATA_CHANGED, Long.toString(this.dataSize), Long.toString(this.tarStream.getBytesWritten() - dataStart)));
                }
                this.tarStream.padCurrentBlock();
            }
            finally {
                this.close();
            }
        }

        protected static String getLameMode(File file) {
            int umod = 0;
            if (file.canExecute()) {
                umod = 1;
            }
            if (file.canWrite()) {
                umod += 2;
            }
            if (file.canRead()) {
                umod += 4;
            }
            return "0" + umod + "00";
        }

        static {
            char c = System.getProperty("file.separator").charAt(0);
            if (c != '/') {
                swapOutDelim = new Character(c);
            }
            try {
                TarEntrySupplicant.writeField(3, 0L, HEADER_TEMPLATE);
                TarEntrySupplicant.writeField(4, 0L, HEADER_TEMPLATE);
            }
            catch (TarMalformatException tme) {
                throw new RuntimeException(tme);
            }
            int magicStart = TarHeaderFields.getStart(9);
            for (int i = 0; i < ustarBytes.length; ++i) {
                TarEntrySupplicant.HEADER_TEMPLATE[magicStart + i] = ustarBytes[i];
            }
            TarEntrySupplicant.HEADER_TEMPLATE[263] = 48;
            TarEntrySupplicant.HEADER_TEMPLATE[264] = 48;
        }
    }
}

