/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.hsqldb.lib.RefCapablePropertyResourceBundle;

public abstract class ValidatingResourceBundle {
    protected boolean validated = false;
    public static final int THROW_BEHAVIOR = 0;
    public static final int EMPTYSTRING_BEHAVIOR = 1;
    public static final int NOOP_BEHAVIOR = 2;
    protected RefCapablePropertyResourceBundle wrappedRCPRB;
    private int missingPropertyBehavior = 0;
    private int missingPosValueBehavior = 0;

    protected abstract Map getKeyIdToString();

    protected ValidatingResourceBundle(String baseName) {
        this.wrappedRCPRB = RefCapablePropertyResourceBundle.getBundle(baseName, this.getClass().getClassLoader());
    }

    public String getString(int id) {
        return this.wrappedRCPRB.getString((String)this.getKeyIdToString().get(new Integer(id)));
    }

    public String getString(int id, String[] sa) {
        return this.wrappedRCPRB.getString((String)this.getKeyIdToString().get(new Integer(id)), sa, this.missingPosValueBehavior);
    }

    public String getExpandedString(int id) {
        return this.wrappedRCPRB.getExpandedString((String)this.getKeyIdToString().get(new Integer(id)), this.missingPropertyBehavior);
    }

    public String getExpandedString(int id, String[] sa) {
        return this.wrappedRCPRB.getExpandedString((String)this.getKeyIdToString().get(new Integer(id)), sa, this.missingPropertyBehavior, this.missingPosValueBehavior);
    }

    public void setMissingPropertyBehavior(int missingPropertyBehavior) {
        this.missingPropertyBehavior = missingPropertyBehavior;
    }

    public void setMissingPosValueBehavior(int missingPosValueBehavior) {
        this.missingPosValueBehavior = missingPosValueBehavior;
    }

    public int getMissingPropertyBehavior() {
        return this.missingPropertyBehavior;
    }

    public int getMissingPosValueBehavior() {
        return this.missingPosValueBehavior;
    }

    public int getSize() {
        if (!this.validated) {
            throw new RuntimeException("Method SqltoolRB.getSize() may only be called after calling SqltoolRB.validate()");
        }
        return this.getKeyIdToString().size();
    }

    public void validate() {
        if (this.validated) {
            return;
        }
        this.validated = true;
        HashSet allIdStrings = new HashSet(this.getKeyIdToString().values());
        if (allIdStrings.size() < this.getKeyIdToString().values().size()) {
            Collection c = this.getKeyIdToString().values();
            Iterator it = allIdStrings.iterator();
            while (it.hasNext()) {
                c.remove(it.next());
            }
            throw new RuntimeException("Duplicate property key(s) string in keyIdToString map: " + c);
        }
        Enumeration allKeys = this.wrappedRCPRB.getKeys();
        while (allKeys.hasMoreElements()) {
            String val = (String)allKeys.nextElement();
            this.wrappedRCPRB.getString(val);
            allIdStrings.remove(val);
        }
        if (allIdStrings.size() > 0) {
            throw new RuntimeException("Resource Bundle pre-validation failed.  Following property key(s) not mapped.\n" + allIdStrings);
        }
    }

    public String getString(int id, String s1) {
        return this.getString(id, new String[]{s1});
    }

    public String getString(int id, String s1, String s2) {
        return this.getString(id, new String[]{s1, s2});
    }

    public String getString(int id, String s1, String s2, String s3) {
        return this.getString(id, new String[]{s1, s2, s3});
    }

    public String getString(int id, String s1, String s2, String s3, String s4) {
        return this.getString(id, new String[]{s1, s2, s3, s4});
    }

    public String getString(int id, int i1) {
        return this.getString(id, new String[]{Integer.toString(i1)});
    }

    public String getString(int id, int i1, int i2) {
        return this.getString(id, new String[]{Integer.toString(i1), Integer.toString(i2)});
    }

    public String getString(int id, int i1, int i2, int i3) {
        return this.getString(id, new String[]{Integer.toString(i1), Integer.toString(i2), Integer.toString(i3)});
    }

    public String getString(int id, int i1, String s2) {
        return this.getString(id, new String[]{Integer.toString(i1), s2});
    }

    public String getString(int id, String s1, int i2) {
        return this.getString(id, new String[]{s1, Integer.toString(i2)});
    }

    public String getString(int id, int i1, int i2, String s3) {
        return this.getString(id, new String[]{Integer.toString(i1), Integer.toString(i2), s3});
    }

    public String getString(int id, int i1, String s2, int i3) {
        return this.getString(id, new String[]{Integer.toString(i1), s2, Integer.toString(i3)});
    }

    public String getString(int id, String s1, int i2, int i3) {
        return this.getString(id, new String[]{s1, Integer.toString(i2), Integer.toString(i3)});
    }

    public String getString(int id, int i1, String s2, String s3) {
        return this.getString(id, new String[]{Integer.toString(i1), s2, s3});
    }

    public String getString(int id, String s1, String s2, int i3) {
        return this.getString(id, new String[]{s1, s2, Integer.toString(i3)});
    }

    public String getString(int id, String s1, int i2, String s3) {
        return this.getString(id, new String[]{s1, Integer.toString(i2), s3});
    }
}

