/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Writer;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.lib.FileUtil;

public class SimpleLog {
    public static final int LOG_NONE = 0;
    public static final int LOG_ERROR = 1;
    public static final int LOG_NORMAL = 2;
    private PrintWriter writer;
    private int level;
    private boolean isSystem;
    private String filePath;

    public SimpleLog(String path, int level) {
        this.isSystem = path == null;
        this.filePath = path;
        this.setLevel(level);
    }

    private void setupWriter() {
        if (this.level == 0) {
            this.close();
            return;
        }
        if (this.writer == null) {
            if (this.isSystem) {
                this.writer = new PrintWriter(System.out);
            } else {
                File file = new File(this.filePath);
                this.setupLog(file);
            }
        }
    }

    private void setupLog(File file) {
        try {
            FileUtil.getFileUtil().makeParentDirectories(file);
            this.writer = new PrintWriter((Writer)new FileWriter(file.getPath(), true), true);
        }
        catch (Exception e) {
            this.isSystem = true;
            this.writer = new PrintWriter(System.out);
        }
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
        this.setupWriter();
    }

    public PrintWriter getPrintWriter() {
        return this.writer;
    }

    public synchronized void sendLine(int atLevel, String message) {
        if (this.level >= atLevel) {
            this.writer.println(HsqlDateTime.getSytemTimeString() + " " + message);
        }
    }

    public synchronized void logContext(int atLevel, String message) {
        if (this.level < atLevel) {
            return;
        }
        String info = HsqlDateTime.getSytemTimeString();
        Throwable temp = new Throwable();
        StackTraceElement[] elements = temp.getStackTrace();
        if (elements.length > 1) {
            info = info + " " + elements[1].getClassName() + "." + elements[1].getMethodName();
        }
        this.writer.println(info + " " + message);
    }

    public synchronized void logContext(Throwable t, String message) {
        if (this.level == 0) {
            return;
        }
        String info = HsqlDateTime.getSytemTimeString();
        Throwable temp = new Throwable();
        StackTraceElement[] elements = temp.getStackTrace();
        if (elements.length > 1) {
            info = info + " " + elements[1].getClassName() + "." + elements[1].getMethodName();
        }
        if ((elements = t.getStackTrace()).length > 0) {
            info = info + " " + elements[0].getClassName() + "." + elements[0].getMethodName();
        }
        if (message == null) {
            message = "";
        }
        this.writer.println(info + " " + t.toString() + " " + message);
    }

    public void flush() {
        if (this.writer != null) {
            this.writer.flush();
        }
    }

    public void close() {
        if (this.writer != null && !this.isSystem) {
            this.writer.close();
        }
        this.writer = null;
    }
}

