/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlList;

public class OrderedHashSet
extends HashSet
implements HsqlList {
    public OrderedHashSet() {
        super(8);
        this.isList = true;
    }

    @Override
    public boolean remove(Object key) {
        int oldSize = this.size();
        super.removeObject(key, true);
        return oldSize != this.size();
    }

    @Override
    public Object remove(int index) throws IndexOutOfBoundsException {
        this.checkRange(index);
        Object result = this.objectKeyTable[index];
        this.remove(result);
        return result;
    }

    public boolean insert(int index, Object key) throws IndexOutOfBoundsException {
        int i;
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (this.contains(key)) {
            return false;
        }
        if (index == this.size()) {
            return this.add(key);
        }
        Object[] set = this.toArray(new Object[this.size()]);
        super.clear();
        for (i = 0; i < index; ++i) {
            this.add(set[i]);
        }
        this.add(key);
        for (i = index; i < set.length; ++i) {
            this.add(set[i]);
        }
        return true;
    }

    @Override
    public Object set(int index, Object key) throws IndexOutOfBoundsException {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public void add(int index, Object key) throws IndexOutOfBoundsException {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public Object get(int index) throws IndexOutOfBoundsException {
        this.checkRange(index);
        return this.objectKeyTable[index];
    }

    public int getIndex(Object key) {
        return this.getLookup(key, key.hashCode());
    }

    public int getLargestIndex(OrderedHashSet other) {
        int max = -1;
        int size = other.size();
        for (int i = 0; i < size; ++i) {
            int index = this.getIndex(other.get(i));
            if (index <= max) continue;
            max = index;
        }
        return max;
    }

    private void checkRange(int i) {
        if (i < 0 || i >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
    }
}

