/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc.pool;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import org.hsqldb.jdbc.Util;
import org.hsqldb.jdbc.pool.ConnectionDefaults;
import org.hsqldb.jdbc.pool.JDBCConnectionPoolDataSource;
import org.hsqldb.jdbc.pool.SessionConnectionWrapper;

public class ManagedPoolDataSource
implements DataSource,
ConnectionEventListener {
    private static final int DEFAULT_MAX_POOL_SIZE = 8;
    private boolean isPoolClosed = false;
    private int sessionTimeout = 0;
    private JDBCConnectionPoolDataSource connectionPoolDataSource = null;
    private Set connectionsInUse = new HashSet();
    private List connectionsInactive = new ArrayList();
    private Map sessionConnectionWrappers = new HashMap();
    private int maxPoolSize = 8;
    private ConnectionDefaults connectionDefaults = null;
    private boolean initialized = false;
    private int initialSize = 0;
    boolean doResetAutoCommit = false;
    boolean doResetReadOnly = false;
    boolean doResetTransactionIsolation = false;
    boolean doResetCatalog = false;
    boolean isAutoCommit = true;
    boolean isReadOnly = false;
    int transactionIsolation = 2;
    String catalog = null;
    private String validationQuery = null;

    public ManagedPoolDataSource() {
        this.connectionPoolDataSource = new JDBCConnectionPoolDataSource();
    }

    public ManagedPoolDataSource(String url, String user, String password, int maxPoolSize, ConnectionDefaults connectionDefaults) throws SQLException {
        this.connectionPoolDataSource = new JDBCConnectionPoolDataSource(url, user, password, connectionDefaults);
        this.maxPoolSize = maxPoolSize;
    }

    public ManagedPoolDataSource(String url, String user, String password) throws SQLException {
        this(url, user, password, 8, null);
    }

    public ManagedPoolDataSource(String url, String user, String password, ConnectionDefaults connectionDefaults) throws SQLException {
        this(url, user, password, 8, connectionDefaults);
    }

    public ManagedPoolDataSource(String url, String user, String password, int maxPoolSize) throws SQLException {
        this(url, user, password, maxPoolSize, null);
    }

    public ConnectionDefaults getConnectionDefaults() {
        return this.connectionDefaults;
    }

    public synchronized String getUrl() {
        return this.connectionPoolDataSource.getUrl();
    }

    public synchronized void setUrl(String url) {
        this.connectionPoolDataSource.setUrl(url);
    }

    public synchronized String getUser() {
        return this.connectionPoolDataSource.getUser();
    }

    public synchronized void setUser(String user) {
        this.connectionPoolDataSource.setUser(user);
    }

    public synchronized String getPassword() {
        return this.connectionPoolDataSource.getPassword();
    }

    public synchronized void setPassword(String password) {
        this.connectionPoolDataSource.setPassword(password);
    }

    public synchronized int getSessionTimeout() {
        return this.sessionTimeout;
    }

    public synchronized void setSessionTimeout(int sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    public synchronized int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public synchronized void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    @Override
    public synchronized int getLoginTimeout() throws SQLException {
        return this.connectionPoolDataSource.getLoginTimeout();
    }

    @Override
    public synchronized void setLoginTimeout(int seconds) throws SQLException {
        this.connectionPoolDataSource.setLoginTimeout(seconds);
    }

    @Override
    public synchronized PrintWriter getLogWriter() throws SQLException {
        return this.connectionPoolDataSource.getLogWriter();
    }

    @Override
    public synchronized void setLogWriter(PrintWriter out) throws SQLException {
        this.connectionPoolDataSource.setLogWriter(out);
    }

    @Override
    public Connection getConnection(String user, String password) throws SQLException {
        String managedPassword = this.getPassword();
        String managedUser = this.getUsername();
        if (user == null && managedUser != null || user != null && managedUser == null || user != null && !user.equals(managedUser) || password == null && managedPassword != null || password != null && managedPassword == null || password != null && !password.equals(managedPassword)) {
            throw new SQLException("Connection pool manager user/password validation failed");
        }
        return this.getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnection() throws SQLException {
        PooledConnection pooledConnection = null;
        ManagedPoolDataSource managedPoolDataSource = this;
        synchronized (managedPoolDataSource) {
            if (!this.initialized) {
                if (this.initialSize > this.maxPoolSize) {
                    throw new SQLException("Initial size of " + this.initialSize + " exceeds max. pool size of " + this.maxPoolSize);
                }
                this.logInfo("Pre-initializing " + this.initialSize + " physical connections");
                for (int i = 0; i < this.initialSize; ++i) {
                    this.connectionsInactive.add(this.createNewConnection());
                }
                this.initialized = true;
            }
            long loginTimeoutExpiration = this.calculateLoginTimeoutExpiration();
            while (pooledConnection == null) {
                if (this.isPoolClosed) {
                    throw new SQLException("The pool is closed. You cannot get anymore connections from it.");
                }
                pooledConnection = this.dequeueFirstIfAny();
                if (pooledConnection != null) {
                    return this.wrapConnectionAndMarkAsInUse(pooledConnection);
                }
                if (this.poolHasSpaceForNewConnections()) {
                    pooledConnection = this.createNewConnection();
                    return this.wrapConnectionAndMarkAsInUse(pooledConnection);
                }
                if (this.sessionTimeout > 0) {
                    this.reclaimAbandonedConnections();
                    pooledConnection = this.dequeueFirstIfAny();
                    if (pooledConnection != null) {
                        return this.wrapConnectionAndMarkAsInUse(pooledConnection);
                    }
                }
                this.doWait(loginTimeoutExpiration);
            }
            return this.wrapConnectionAndMarkAsInUse(pooledConnection);
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return (T)this;
        }
        throw Util.invalidArgument("iface: " + iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface != null && iface.isAssignableFrom(this.getClass());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doWait(long loginTimeoutExpiration) throws SQLException {
        try {
            if (loginTimeoutExpiration > 0L) {
                long timeToWait = loginTimeoutExpiration - System.currentTimeMillis();
                if (timeToWait <= 0L) throw new SQLException("No connections available within the given login timeout: " + this.getLoginTimeout());
                this.wait(timeToWait);
                return;
            } else {
                this.wait();
            }
            return;
        }
        catch (InterruptedException e) {
            throw new SQLException("Thread was interrupted while waiting for available connection");
        }
    }

    private PooledConnection createNewConnection() throws SQLException {
        this.logInfo("Connection created since no connections available and pool has space for more connections. Pool size: " + this.size());
        PooledConnection pooledConnection = this.connectionPoolDataSource.getPooledConnection();
        pooledConnection.addConnectionEventListener(this);
        return pooledConnection;
    }

    private void reclaimAbandonedConnections() {
        long now = System.currentTimeMillis();
        long sessionTimeoutMillis = (long)this.sessionTimeout * 1000L;
        Iterator iterator = this.connectionsInUse.iterator();
        ArrayList<SessionConnectionWrapper> abandonedConnections = new ArrayList<SessionConnectionWrapper>();
        while (iterator.hasNext()) {
            PooledConnection connectionInUse = (PooledConnection)iterator.next();
            SessionConnectionWrapper sessionWrapper = (SessionConnectionWrapper)this.sessionConnectionWrappers.get(connectionInUse);
            if (!this.isSessionTimedOut(now, sessionWrapper, sessionTimeoutMillis)) continue;
            abandonedConnections.add(sessionWrapper);
        }
        for (SessionConnectionWrapper sessionWrapper : abandonedConnections) {
            this.closeSessionWrapper(sessionWrapper, "Error closing abandoned session connection wrapper.");
        }
        if (abandonedConnections.size() > 1) {
            abandonedConnections.clear();
            this.notifyAll();
        }
    }

    private void closeSessionWrapper(SessionConnectionWrapper sessionWrapper, String logText) {
        try {
            sessionWrapper.close();
        }
        catch (SQLException e) {
            this.logInfo(logText, e);
        }
    }

    private long calculateLoginTimeoutExpiration() throws SQLException {
        long loginTimeoutExpiration = 0L;
        if (this.getLoginTimeout() > 0) {
            loginTimeoutExpiration = 1000L * (long)this.getLoginTimeout();
        }
        return loginTimeoutExpiration;
    }

    private void enqueue(PooledConnection connection) {
        this.connectionsInactive.add(connection);
        this.notifyAll();
    }

    private PooledConnection dequeueFirstIfAny() {
        if (this.connectionsInactive.size() <= 0) {
            return null;
        }
        return (PooledConnection)this.connectionsInactive.remove(0);
    }

    public synchronized int size() {
        return this.connectionsInUse.size() + this.connectionsInactive.size();
    }

    private Connection wrapConnectionAndMarkAsInUse(PooledConnection pooledConnection) throws SQLException {
        pooledConnection = this.assureValidConnection(pooledConnection);
        Connection conn = pooledConnection.getConnection();
        if (this.doResetAutoCommit) {
            conn.setAutoCommit(this.isAutoCommit);
        }
        if (this.doResetReadOnly) {
            conn.setReadOnly(this.isReadOnly);
        }
        if (this.doResetTransactionIsolation) {
            conn.setTransactionIsolation(this.transactionIsolation);
        }
        if (this.doResetCatalog) {
            conn.setCatalog(this.catalog);
        }
        if (this.validationQuery != null) {
            ResultSet rs = null;
            try {
                rs = conn.createStatement().executeQuery(this.validationQuery);
                if (!rs.next()) {
                    throw new SQLException("0 rows returned");
                }
            }
            catch (SQLException se) {
                this.closePhysically(pooledConnection, "Closing non-validating pooledConnection.");
                throw new SQLException("Validation query failed: " + se.getMessage());
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        this.connectionsInUse.add(pooledConnection);
        SessionConnectionWrapper sessionWrapper = new SessionConnectionWrapper(pooledConnection.getConnection());
        this.sessionConnectionWrappers.put(pooledConnection, sessionWrapper);
        return sessionWrapper;
    }

    private PooledConnection assureValidConnection(PooledConnection pooledConnection) throws SQLException {
        if (this.isInvalid(pooledConnection)) {
            this.closePhysically(pooledConnection, "closing invalid pooledConnection.");
            return this.connectionPoolDataSource.getPooledConnection();
        }
        return pooledConnection;
    }

    private boolean isInvalid(PooledConnection pooledConnection) {
        try {
            return pooledConnection.getConnection().isClosed();
        }
        catch (SQLException e) {
            this.logInfo("Error calling pooledConnection.getConnection().isClosed(). Connection will be removed from pool.", e);
            return false;
        }
    }

    private boolean isSessionTimedOut(long now, SessionConnectionWrapper sessionWrapper, long sessionTimeoutMillis) {
        return now - sessionWrapper.getLatestActivityTime() >= sessionTimeoutMillis;
    }

    private boolean poolHasSpaceForNewConnections() {
        return this.maxPoolSize > this.size();
    }

    @Override
    public synchronized void connectionClosed(ConnectionEvent event) {
        PooledConnection connection = (PooledConnection)event.getSource();
        this.connectionsInUse.remove(connection);
        this.sessionConnectionWrappers.remove(connection);
        if (!this.isPoolClosed) {
            this.enqueue(connection);
            this.logInfo("Connection returned to pool.");
        } else {
            this.closePhysically(connection, "closing returned connection.");
            this.logInfo("Connection returned to pool was closed because pool is closed.");
            this.notifyAll();
        }
    }

    @Override
    public synchronized void connectionErrorOccurred(ConnectionEvent event) {
        PooledConnection connection = (PooledConnection)event.getSource();
        connection.removeConnectionEventListener(this);
        this.connectionsInUse.remove(connection);
        this.sessionConnectionWrappers.remove(connection);
        this.logInfo("Fatal exception occurred on pooled connection. Connection is removed from pool: ");
        this.logInfo(event.getSQLException());
        this.closePhysically(connection, "closing invalid, removed connection.");
        this.notifyAll();
    }

    public synchronized void close() {
        this.isPoolClosed = true;
        while (this.connectionsInactive.size() > 0) {
            PooledConnection connection = this.dequeueFirstIfAny();
            if (connection == null) continue;
            this.closePhysically(connection, "closing inactive connection when connection pool was closed.");
        }
    }

    public synchronized void closeAndWait() throws InterruptedException {
        this.close();
        while (this.size() > 0) {
            this.wait();
        }
    }

    public synchronized void closeImmediatedly() {
        this.close();
        for (PooledConnection connection : this.connectionsInUse) {
            SessionConnectionWrapper sessionWrapper = (SessionConnectionWrapper)this.sessionConnectionWrappers.get(connection);
            this.closeSessionWrapper(sessionWrapper, "Error closing session wrapper. Connection pool was shutdown immediatedly.");
        }
    }

    private void closePhysically(PooledConnection source, String logText) {
        try {
            source.close();
        }
        catch (SQLException e) {
            this.logInfo("Error " + logText, e);
        }
    }

    private void logInfo(String message) {
        this.connectionPoolDataSource.logInfo(message);
    }

    private void logInfo(Throwable t) {
        this.connectionPoolDataSource.logInfo(t);
    }

    private void logInfo(String message, Throwable t) {
        this.connectionPoolDataSource.logInfo(message, t);
    }

    public void setDefaultAutoCommit(boolean defaultAutoCommit) {
        this.isAutoCommit = defaultAutoCommit;
        this.doResetAutoCommit = true;
    }

    public void setDefaultReadOnly(boolean defaultReadOnly) {
        this.isReadOnly = defaultReadOnly;
        this.doResetReadOnly = true;
    }

    public void setDefaultTransactionIsolation(int defaultTransactionIsolation) {
        this.transactionIsolation = defaultTransactionIsolation;
        this.doResetTransactionIsolation = true;
    }

    public void setDefaultCatalog(String defaultCatalog) {
        this.catalog = defaultCatalog;
        this.doResetCatalog = true;
    }

    public boolean getDefaultAutoCommit() {
        this.doResetAutoCommit = true;
        return this.isAutoCommit;
    }

    public String getDefaultCatalog() {
        this.doResetCatalog = true;
        return this.catalog;
    }

    public boolean getDefaultReadOnly() {
        this.doResetReadOnly = true;
        return this.isReadOnly;
    }

    public int getDefaultTransactionIsolation() {
        this.doResetTransactionIsolation = true;
        return this.transactionIsolation;
    }

    public void setDriverClassName(String driverClassName) {
        if (driverClassName.equals("org.hsqldb.jdbc.JDBCDriver")) {
            return;
        }
        throw new RuntimeException("This class only supports JDBC driver 'org.hsqldb.jdbc.JDBCDriver'");
    }

    public String getDriverClassName() {
        return "org.hsqldb.jdbc.JDBCDriver";
    }

    public void setInitialSize(int initialSize) {
        this.initialSize = initialSize;
    }

    public int getInitialPoolSize() {
        return this.getInitialSize();
    }

    public void setInitialPoolSize(int initialSize) {
        this.setInitialSize(initialSize);
    }

    public int getInitialSize() {
        return this.initialSize;
    }

    public int getNumActive() {
        return this.connectionsInUse.size();
    }

    public int getNumIdle() {
        return this.connectionsInactive.size();
    }

    public void setUsername(String username) {
        this.setUser(username);
    }

    public String getUsername() {
        return this.getUser();
    }

    public void setMaxActive(int maxActive) {
        this.setMaxPoolSize(maxActive);
    }

    public int getMaxActive() {
        return this.getMaxPoolSize();
    }

    public void setValidationQuery(String validationQuery) {
        this.validationQuery = validationQuery;
    }

    public String getValidationQuery() {
        return this.validationQuery;
    }

    public void addConnectionProperty(String name, String value) {
        this.connectionPoolDataSource.setConnectionProperty(name, value);
    }

    public void removeConnectionProperty(String name) {
        this.connectionPoolDataSource.removeConnectionProperty(name);
    }

    public Properties getConnectionProperties() {
        return this.connectionPoolDataSource.getConnectionProperties();
    }

    public String toString() throws RuntimeException {
        int timeout = 0;
        try {
            timeout = this.getLoginTimeout();
        }
        catch (SQLException se) {
            throw new RuntimeException("Failed to retrieve the Login Timeout value");
        }
        StringBuffer sb = new StringBuffer(ManagedPoolDataSource.class.getName() + " instance:\n    User:  " + this.getUsername() + "\n    Url:  " + this.getUrl() + "\n    Login Timeout:  " + timeout + "\n    Num ACTIVE:  " + this.getNumActive() + "\n    Num IDLE:  " + this.getNumIdle());
        if (this.doResetAutoCommit) {
            sb.append("\n    Default auto-commit: " + this.getDefaultAutoCommit());
        }
        if (this.doResetReadOnly) {
            sb.append("\n    Default read-only: " + this.getDefaultReadOnly());
        }
        if (this.doResetTransactionIsolation) {
            sb.append("\n    Default trans. lvl.: " + this.getDefaultTransactionIsolation());
        }
        if (this.doResetCatalog) {
            sb.append("\n    Default catalog: " + this.getDefaultCatalog());
        }
        return sb.toString() + "\n    Max Active: " + this.getMaxActive() + "\n    Init Size: " + this.getInitialSize() + "\n    Conn Props: " + this.getConnectionProperties() + "\n    Validation Query: " + this.validationQuery + '\n';
    }
}

