/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc.pool;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import org.hsqldb.jdbc.Util;

public abstract class BaseConnectionWrapper
implements Connection {
    protected boolean isClosed = false;

    protected abstract Connection getConnection();

    protected void validate() throws SQLException {
        if (this.isClosed) {
            throw Util.connectionClosedException();
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public int getHoldability() throws SQLException {
        this.validate();
        return this.getConnection().getHoldability();
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.validate();
        return this.getConnection().getTransactionIsolation();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.validate();
        this.getConnection().clearWarnings();
    }

    @Override
    public void commit() throws SQLException {
        this.validate();
        this.getConnection().commit();
    }

    @Override
    public void rollback() throws SQLException {
        this.validate();
        this.getConnection().rollback();
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.getConnection().getAutoCommit();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.validate();
        return this.getConnection().isReadOnly();
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.validate();
        this.getConnection().setHoldability(holdability);
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.validate();
        this.getConnection().setTransactionIsolation(level);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.validate();
        this.getConnection().setAutoCommit(autoCommit);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.validate();
        this.getConnection().setReadOnly(readOnly);
    }

    @Override
    public String getCatalog() throws SQLException {
        this.validate();
        return this.getConnection().getCatalog();
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.validate();
        this.getConnection().setCatalog(catalog);
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.validate();
        return this.getConnection().getMetaData();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.validate();
        return this.getConnection().getWarnings();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.validate();
        return this.getConnection().setSavepoint();
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.validate();
        this.getConnection().releaseSavepoint(savepoint);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.validate();
        this.getConnection().rollback(savepoint);
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.validate();
        return this.getConnection().createStatement();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.validate();
        return this.getConnection().createStatement(resultSetType, resultSetConcurrency);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.validate();
        return this.getConnection().createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public Map getTypeMap() throws SQLException {
        this.validate();
        return this.getConnection().getTypeMap();
    }

    public void setTypeMap(Map map) throws SQLException {
        this.validate();
        this.getConnection().setTypeMap(map);
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.validate();
        return this.getConnection().nativeSQL(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        this.validate();
        return this.getConnection().prepareCall(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.validate();
        return this.getConnection().prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.validate();
        return this.getConnection().prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.validate();
        return this.getConnection().prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.validate();
        return this.getConnection().prepareStatement(sql, autoGeneratedKeys);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.validate();
        return this.getConnection().prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.validate();
        return this.getConnection().prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.validate();
        return this.getConnection().prepareStatement(sql, columnIndexes);
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        this.validate();
        return this.getConnection().setSavepoint(name);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.validate();
        return this.getConnection().prepareStatement(sql, columnNames);
    }

    @Override
    public Clob createClob() throws SQLException {
        this.validate();
        return this.getConnection().createClob();
    }

    @Override
    public Blob createBlob() throws SQLException {
        this.validate();
        return this.getConnection().createBlob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        this.validate();
        return this.getConnection().createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        this.validate();
        return this.getConnection().createSQLXML();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        this.validate();
        return this.getConnection().isValid(timeout);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        try {
            this.validate();
        }
        catch (SQLException e) {
            throw new SQLClientInfoException(e.getMessage(), e.getSQLState(), e.getErrorCode(), null, e);
        }
        this.getConnection().setClientInfo(name, value);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        try {
            this.validate();
        }
        catch (SQLException e) {
            throw new SQLClientInfoException(e.getMessage(), e.getSQLState(), e.getErrorCode(), null, e);
        }
        this.getConnection().setClientInfo(properties);
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        this.validate();
        return this.getConnection().getClientInfo(name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.validate();
        return this.getConnection().getClientInfo();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        this.validate();
        if (this.isWrapperFor(iface)) {
            return (T)this;
        }
        throw Util.invalidArgument("iface: " + iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface != null && iface.isAssignableFrom(this.getClass());
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        this.validate();
        return this.getConnection().createArrayOf(typeName, elements);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        this.validate();
        return this.getConnection().createStruct(typeName, attributes);
    }
}

