/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.SQLInvalidAuthorizationSpecException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLSyntaxErrorException;
import java.sql.SQLTransactionRollbackException;
import java.sql.SQLTransientConnectionException;
import java.sql.SQLWarning;
import org.hsqldb.HsqlException;
import org.hsqldb.error.Error;
import org.hsqldb.result.Result;

public class Util {
    static final void throwError(HsqlException e) throws SQLException {
        throw Util.sqlException(e.getMessage(), e.getSQLState(), e.getErrorCode(), e);
    }

    static final void throwError(Result r) throws SQLException {
        throw Util.sqlException(r.getMainString(), r.getSubString(), r.getErrorCode(), r.getException());
    }

    public static final SQLException sqlException(HsqlException e) {
        return Util.sqlException(e.getMessage(), e.getSQLState(), e.getErrorCode(), e);
    }

    public static final SQLException sqlException(HsqlException e, Throwable cause) {
        return Util.sqlException(e.getMessage(), e.getSQLState(), e.getErrorCode(), cause);
    }

    public static final SQLException sqlException(int id) {
        return Util.sqlException(Error.error(id));
    }

    public static final SQLException sqlExceptionSQL(int id) {
        return Util.sqlException(Error.error(id));
    }

    public static final SQLException sqlException(int id, String message) {
        return Util.sqlException(Error.error(id, message));
    }

    public static final SQLException sqlException(int id, String message, Exception cause) {
        return Util.sqlException(Error.error(id, message), cause);
    }

    public static final SQLException sqlException(int id, int add) {
        return Util.sqlException(Error.error(id, add));
    }

    static final SQLException sqlException(int id, int subId, Object[] add) {
        return Util.sqlException(Error.error(null, id, subId, add));
    }

    static final SQLException notSupported() {
        return Util.sqlException(Error.error(1500));
    }

    static SQLException notUpdatableColumn() {
        return Util.sqlException(2500);
    }

    public static SQLException nullArgument() {
        return Util.sqlException(62);
    }

    static SQLException nullArgument(String name) {
        return Util.sqlException(62, name + ": null");
    }

    public static SQLException invalidArgument() {
        return Util.sqlException(62);
    }

    public static SQLException invalidArgument(String name) {
        return Util.sqlException(62, name);
    }

    public static SQLException outOfRangeArgument() {
        return Util.sqlException(62);
    }

    public static SQLException outOfRangeArgument(String name) {
        return Util.sqlException(62, name);
    }

    public static SQLException connectionClosedException() {
        return Util.sqlException(1303);
    }

    public static SQLWarning sqlWarning(Result r) {
        return new SQLWarning(r.getMainString(), r.getSubString(), r.getErrorCode());
    }

    public static SQLException sqlException(Result r) {
        return new SQLException(r.getMainString(), r.getSubString(), r.getErrorCode(), r.getException());
    }

    public static final SQLException sqlException(String msg, String sqlstate, int code, Throwable cause) {
        if (sqlstate.startsWith("08")) {
            if (!sqlstate.endsWith("3")) {
                return new SQLTransientConnectionException(msg, sqlstate, code, cause);
            }
            return new SQLNonTransientConnectionException(msg, sqlstate, code, cause);
        }
        if (sqlstate.startsWith("22")) {
            return new SQLDataException(msg, sqlstate, code, cause);
        }
        if (sqlstate.startsWith("23")) {
            return new SQLIntegrityConstraintViolationException(msg, sqlstate, code, cause);
        }
        if (sqlstate.startsWith("28")) {
            return new SQLInvalidAuthorizationSpecException(msg, sqlstate, code, cause);
        }
        if (sqlstate.startsWith("42") || sqlstate.startsWith("37") || sqlstate.startsWith("2A")) {
            return new SQLSyntaxErrorException(msg, sqlstate, code, cause);
        }
        if (sqlstate.startsWith("40")) {
            return new SQLTransactionRollbackException(msg, sqlstate, code, cause);
        }
        if (sqlstate.startsWith("0A")) {
            return new SQLFeatureNotSupportedException(msg, sqlstate, code, cause);
        }
        return new SQLException(msg, sqlstate, code, cause);
    }
}

