/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import org.hsqldb.jdbc.JDBCConnection;
import org.hsqldb.jdbc.JDBCResultSet;
import org.hsqldb.jdbc.Util;
import org.hsqldb.result.Result;

class JDBCStatementBase {
    volatile boolean isClosed;
    protected boolean isEscapeProcessing = true;
    protected JDBCConnection connection;
    protected int maxRows;
    protected int fetchSize = 0;
    protected int fetchDirection = 1000;
    protected Result resultIn;
    protected Result errorResult;
    protected Result generatedResult;
    protected int rsScrollability = 1003;
    protected int rsConcurrency = 1007;
    protected int rsHoldability = 1;
    protected Result resultOut;
    protected Result batchResultOut;
    protected JDBCResultSet currentResultSet;
    protected JDBCResultSet generatedResultSet;
    protected SQLWarning rootWarning;
    protected int resultSetCounter;
    protected int queryTimeout;
    static final int CLOSE_CURRENT_RESULT = 1;
    static final int KEEP_CURRENT_RESULT = 2;
    static final int CLOSE_ALL_RESULTS = 3;
    static final int SUCCESS_NO_INFO = -2;
    static final int EXECUTE_FAILED = -3;
    static final int RETURN_GENERATED_KEYS = 1;
    static final int NO_GENERATED_KEYS = 2;

    JDBCStatementBase() {
    }

    public synchronized void close() throws SQLException {
    }

    void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw Util.sqlException(1251);
        }
        if (this.connection.isClosed) {
            this.close();
            throw Util.sqlException(1353);
        }
    }

    void performPostExecute() throws SQLException {
        this.resultOut.clearLobResults();
        this.generatedResult = null;
        if (this.resultIn == null) {
            return;
        }
        Result current = this.resultIn;
        while (current.getChainedResult() != null) {
            if ((current = current.getUnlinkChainedResult()).getType() == 19) {
                SQLWarning w = Util.sqlWarning(current);
                if (this.rootWarning == null) {
                    this.rootWarning = w;
                    continue;
                }
                this.rootWarning.setNextWarning(w);
                continue;
            }
            if (current.getType() == 2) {
                this.errorResult = current;
                continue;
            }
            if (current.getType() != 3) continue;
            this.generatedResult = current;
        }
        this.connection.setWarnings(this.rootWarning);
        if (this.resultIn.isData()) {
            this.currentResultSet = new JDBCResultSet(this.connection.sessionProxy, this, this.resultIn, this.resultIn.metaData, this.connection.connProperties);
        }
    }

    int getUpdateCount() throws SQLException {
        this.checkClosed();
        return this.resultIn == null || this.resultIn.isData() ? -1 : this.resultIn.getUpdateCount();
    }

    ResultSet getResultSet() throws SQLException {
        this.checkClosed();
        JDBCResultSet result = this.currentResultSet;
        this.currentResultSet = null;
        return result;
    }

    boolean getMoreResults() throws SQLException {
        return this.getMoreResults(1);
    }

    boolean getMoreResults(int current) throws SQLException {
        this.checkClosed();
        if (this.resultIn == null || !this.resultIn.isData()) {
            return false;
        }
        if (this.resultSetCounter == 0) {
            ++this.resultSetCounter;
            return true;
        }
        if (this.currentResultSet != null && current != 2) {
            this.currentResultSet.close();
        }
        this.resultIn = null;
        return false;
    }

    ResultSet getGeneratedResultSet() throws SQLException {
        if (this.generatedResultSet != null) {
            this.generatedResultSet.close();
        }
        if (this.generatedResult == null) {
            this.generatedResult = Result.emptyGeneratedResult;
        }
        this.generatedResultSet = new JDBCResultSet(this.connection.sessionProxy, null, this.generatedResult, this.generatedResult.metaData, this.connection.connProperties);
        return this.generatedResultSet;
    }

    void closeResultData() throws SQLException {
        if (this.currentResultSet != null) {
            this.currentResultSet.close();
        }
        if (this.generatedResultSet != null) {
            this.generatedResultSet.close();
        }
        this.generatedResultSet = null;
        this.generatedResult = null;
        this.resultIn = null;
    }
}

