/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.index;

import java.io.IOException;
import org.hsqldb.Row;
import org.hsqldb.RowAVLDisk;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.index.NodeAVL;
import org.hsqldb.lib.IntLookup;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputInterface;

public class NodeAVLDisk
extends NodeAVL {
    final RowAVLDisk row;
    protected NodeAVLDisk nLeft;
    protected NodeAVLDisk nRight;
    protected NodeAVLDisk nParent;
    public int iData;
    private int iLeft = -1;
    private int iRight = -1;
    private int iParent = -1;
    private int iId;
    public static final int SIZE_IN_BYTE = 16;

    public NodeAVLDisk(RowAVLDisk r, RowInputInterface in, int id) throws IOException {
        this.row = r;
        this.iId = id;
        this.iData = r.getPos();
        this.iBalance = in.readInt();
        this.iLeft = in.readInt();
        if (this.iLeft <= 0) {
            this.iLeft = -1;
        }
        this.iRight = in.readInt();
        if (this.iRight <= 0) {
            this.iRight = -1;
        }
        this.iParent = in.readInt();
        if (this.iParent <= 0) {
            this.iParent = -1;
        }
    }

    public NodeAVLDisk(RowAVLDisk r, int id) {
        this.row = r;
        this.iId = id;
        this.iData = r.getPos();
    }

    @Override
    public void delete() {
        this.iLeft = -1;
        this.iRight = -1;
        this.iParent = -1;
        this.nLeft = null;
        this.nRight = null;
        this.nParent = null;
        this.iBalance = 0;
        this.row.setNodesChanged();
    }

    @Override
    public boolean isInMemory() {
        return this.row.isInMemory();
    }

    @Override
    public boolean isMemory() {
        return false;
    }

    @Override
    public int getPos() {
        return this.iData;
    }

    @Override
    Row getRow(PersistentStore store) {
        if (!this.row.isInMemory()) {
            return (RowAVLDisk)store.get(this.row, false);
        }
        this.row.updateAccessCount(store.getAccessCount());
        return this.row;
    }

    @Override
    Object[] getData(PersistentStore store) {
        return this.row.getData();
    }

    private NodeAVLDisk findNode(PersistentStore store, int pos) {
        NodeAVLDisk ret = null;
        RowAVLDisk r = (RowAVLDisk)store.get(pos, false);
        if (r != null) {
            ret = (NodeAVLDisk)r.getNode(this.iId);
        }
        return ret;
    }

    @Override
    boolean isLeft(NodeAVL n) {
        if (n == null) {
            return this.iLeft == -1;
        }
        return this.iLeft == ((NodeAVLDisk)n).getPos();
    }

    @Override
    boolean isRight(NodeAVL n) {
        if (n == null) {
            return this.iRight == -1;
        }
        return this.iRight == ((NodeAVLDisk)n).getPos();
    }

    @Override
    NodeAVL getLeft(PersistentStore store) {
        NodeAVLDisk node = this;
        RowAVLDisk row = this.row;
        if (!row.isInMemory()) {
            row = (RowAVLDisk)store.get(this.row, false);
            node = (NodeAVLDisk)row.getNode(this.iId);
        }
        if (node.iLeft == -1) {
            return null;
        }
        if (node.nLeft == null || !node.nLeft.isInMemory()) {
            node.nLeft = this.findNode(store, node.iLeft);
            node.nLeft.nParent = node;
        }
        return node.nLeft;
    }

    @Override
    NodeAVL getRight(PersistentStore store) {
        NodeAVLDisk node = this;
        RowAVLDisk row = this.row;
        if (!row.isInMemory()) {
            row = (RowAVLDisk)store.get(this.row, false);
            node = (NodeAVLDisk)row.getNode(this.iId);
        }
        if (node.iRight == -1) {
            return null;
        }
        if (node.nRight == null || !node.nRight.isInMemory()) {
            node.nRight = this.findNode(store, node.iRight);
            node.nRight.nParent = node;
        }
        return node.nRight;
    }

    @Override
    NodeAVL getParent(PersistentStore store) {
        NodeAVLDisk node = this;
        RowAVLDisk row = this.row;
        if (!row.isInMemory()) {
            row = (RowAVLDisk)store.get(this.row, false);
            node = (NodeAVLDisk)row.getNode(this.iId);
        }
        if (node.iParent == -1) {
            return null;
        }
        if (node.nParent == null || !node.nParent.isInMemory()) {
            node.nParent = this.findNode(store, this.iParent);
        }
        return node.nParent;
    }

    @Override
    int getBalance(PersistentStore store) {
        NodeAVLDisk node = this;
        RowAVLDisk row = this.row;
        if (!row.isInMemory()) {
            row = (RowAVLDisk)store.get(this.row, false);
            node = (NodeAVLDisk)row.getNode(this.iId);
        }
        return node.iBalance;
    }

    @Override
    boolean isRoot(PersistentStore store) {
        NodeAVLDisk node = this;
        RowAVLDisk row = this.row;
        if (!row.isInMemory()) {
            row = (RowAVLDisk)store.get(this.row, false);
            node = (NodeAVLDisk)row.getNode(this.iId);
        }
        return node.iParent == -1;
    }

    @Override
    boolean isFromLeft(PersistentStore store) {
        NodeAVLDisk node = this;
        RowAVLDisk row = this.row;
        if (!row.isInMemory()) {
            row = (RowAVLDisk)store.get(this.row, false);
            node = (NodeAVLDisk)row.getNode(this.iId);
        }
        if (node.iParent == -1) {
            return true;
        }
        if (node.nParent == null || !node.nParent.isInMemory()) {
            node.nParent = this.findNode(store, this.iParent);
        }
        return this.getPos() == node.nParent.iLeft;
    }

    @Override
    NodeAVL setParent(PersistentStore store, NodeAVL n) {
        NodeAVLDisk node = this;
        RowAVLDisk row = this.row;
        if (!row.keepInMemory(true)) {
            row = (RowAVLDisk)store.get(this.row, true);
            node = (NodeAVLDisk)row.getNode(this.iId);
        }
        if (!row.isInMemory()) {
            throw Error.runtimeError(401, "NodeAVLDisk");
        }
        row.setNodesChanged();
        int n2 = node.iParent = n == null ? -1 : n.getPos();
        if (n != null && !n.isInMemory()) {
            n = this.findNode(store, n.getPos());
        }
        node.nParent = (NodeAVLDisk)n;
        row.keepInMemory(false);
        return node;
    }

    @Override
    public NodeAVL setBalance(PersistentStore store, int b) {
        NodeAVLDisk node = this;
        RowAVLDisk row = this.row;
        if (!row.keepInMemory(true)) {
            row = (RowAVLDisk)store.get(this.row, true);
            node = (NodeAVLDisk)row.getNode(this.iId);
        }
        if (!row.isInMemory()) {
            throw Error.runtimeError(401, "NodeAVLDisk");
        }
        row.setNodesChanged();
        node.iBalance = b;
        row.keepInMemory(false);
        return node;
    }

    @Override
    NodeAVL setLeft(PersistentStore store, NodeAVL n) {
        NodeAVLDisk node = this;
        RowAVLDisk row = this.row;
        if (!row.keepInMemory(true)) {
            row = (RowAVLDisk)store.get(this.row, true);
            node = (NodeAVLDisk)row.getNode(this.iId);
        }
        if (!row.isInMemory()) {
            throw Error.runtimeError(401, "NodeAVLDisk");
        }
        row.setNodesChanged();
        int n2 = node.iLeft = n == null ? -1 : n.getPos();
        if (n != null && !n.isInMemory()) {
            n = this.findNode(store, n.getPos());
        }
        node.nLeft = (NodeAVLDisk)n;
        row.keepInMemory(false);
        return node;
    }

    @Override
    NodeAVL setRight(PersistentStore store, NodeAVL n) {
        NodeAVLDisk node = this;
        RowAVLDisk row = this.row;
        if (!row.keepInMemory(true)) {
            row = (RowAVLDisk)store.get(this.row, true);
            node = (NodeAVLDisk)row.getNode(this.iId);
        }
        if (!row.isInMemory()) {
            throw Error.runtimeError(401, "NodeAVLDisk");
        }
        row.setNodesChanged();
        int n2 = node.iRight = n == null ? -1 : n.getPos();
        if (n != null && !n.isInMemory()) {
            n = this.findNode(store, n.getPos());
        }
        node.nRight = (NodeAVLDisk)n;
        row.keepInMemory(false);
        return node;
    }

    @Override
    public NodeAVL set(PersistentStore store, boolean isLeft, NodeAVL n) {
        NodeAVL x = isLeft ? this.setLeft(store, n) : this.setRight(store, n);
        if (n != null) {
            n.setParent(store, this);
        }
        return x;
    }

    @Override
    public void replace(PersistentStore store, Index index, NodeAVL n) {
        if (this.isRoot(store)) {
            if (n != null) {
                n = n.setParent(store, null);
            }
            store.setAccessor(index, n);
        } else {
            boolean isFromLeft = this.isFromLeft(store);
            this.getParent(store).set(store, isFromLeft, n);
        }
    }

    @Override
    boolean equals(NodeAVL n) {
        return this == n || n != null && this.getPos() == ((NodeAVLDisk)n).getPos();
    }

    @Override
    public int getRealSize(RowOutputInterface out) {
        return 16;
    }

    @Override
    public void setInMemory(boolean in) {
        if (!in) {
            if (this.nLeft != null) {
                this.nLeft.nParent = null;
            }
            if (this.nRight != null) {
                this.nRight.nParent = null;
            }
            if (this.nParent != null) {
                if (this.iData == this.nParent.iLeft) {
                    this.nParent.nLeft = null;
                } else {
                    this.nParent.nRight = null;
                }
            }
            this.nParent = null;
            this.nRight = null;
            this.nLeft = null;
        }
    }

    @Override
    public void write(RowOutputInterface out) {
        out.writeInt(this.iBalance);
        out.writeInt(this.iLeft == -1 ? 0 : this.iLeft);
        out.writeInt(this.iRight == -1 ? 0 : this.iRight);
        out.writeInt(this.iParent == -1 ? 0 : this.iParent);
    }

    public void writeTranslate(RowOutputInterface out, IntLookup lookup) {
        out.writeInt(this.iBalance);
        NodeAVLDisk.writeTranslatePointer(this.iLeft, out, lookup);
        NodeAVLDisk.writeTranslatePointer(this.iRight, out, lookup);
        NodeAVLDisk.writeTranslatePointer(this.iParent, out, lookup);
    }

    private static void writeTranslatePointer(int pointer, RowOutputInterface out, IntLookup lookup) {
        int newPointer = 0;
        if (pointer != -1) {
            newPointer = lookup.lookupFirstEqual(pointer);
        }
        out.writeInt(newPointer);
    }
}

