/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.cmdline.sqltool;

import org.hsqldb.cmdline.sqltool.TokenList;

public class Token {
    public static final int SQL_TYPE = 0;
    public static final int SPECIAL_TYPE = 1;
    public static final int PL_TYPE = 2;
    public static final int EDIT_TYPE = 3;
    public static final int RAW_TYPE = 4;
    public static final int RAWEXEC_TYPE = 5;
    public static final int SYNTAX_ERR_TYPE = 6;
    public static final int UNTERM_TYPE = 7;
    public static final int BUFFER_TYPE = 8;
    public static final int MACRO_TYPE = 9;
    public int line;
    public TokenList nestedBlock = null;
    public String[] typeString = new String[]{"SQL", "SPECIAL", "PL", "EDIT", "RAW", "RAWEXEC", "SYNTAX", "UNTERM", "BUFFER", "MACRO"};
    public char[] typeChar = new char[]{'S', '\\', '*', 'E', 'R', 'X', '!', '<', '>', '/'};
    public String val;
    public int type;

    public String getTypeString() {
        return this.typeString[this.type];
    }

    public char getTypeChar() {
        return this.typeChar[this.type];
    }

    public Token(int inType, String inVal, int inLine) {
        this.val = inVal;
        this.type = inType;
        this.line = inLine + 1;
        switch (inType) {
            case 1: 
            case 2: 
            case 3: 
            case 9: {
                if (this.val == null) {
                    throw new IllegalArgumentException("Null String value for scanner token");
                }
                this.val = this.val.trim();
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                if (this.val != null) break;
                throw new IllegalArgumentException("Null String value for scanner token");
            }
            case 0: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Internal error.  Unexpected scanner token type: " + inType);
            }
        }
    }

    public Token(int inType, StringBuffer inBuf, int inLine) {
        this(inType, inBuf.toString(), inLine);
    }

    public Token(int inType, int inLine) {
        this(inType, (String)null, inLine);
    }

    public String toString() {
        return "@" + this.line + " TYPE=" + this.getTypeString() + ", VALUE=(" + this.val + ')';
    }

    public boolean equals(Token otherToken) {
        if (this.type != otherToken.type) {
            return false;
        }
        if (this.val == null && otherToken.val != null) {
            return false;
        }
        if (this.val != null && otherToken.val == null) {
            return false;
        }
        return this.val == null || this.val.equals(otherToken.val);
    }

    public String reconstitute() {
        return this.reconstitute(false);
    }

    public String reconstitute(boolean semify) {
        if (this.val == null) {
            return "";
        }
        switch (this.type) {
            case 1: 
            case 2: {
                return Character.toString(this.getTypeChar()) + this.val;
            }
            case 0: {
                return this.val + (semify ? ";" : "");
            }
        }
        return "? " + this.val;
    }
}

