/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.cmdline;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.hsqldb.cmdline.SqlFile;
import org.hsqldb.cmdline.SqlToolError;
import org.hsqldb.cmdline.SqltoolRB;
import org.hsqldb.lib.FrameworkLogger;
import org.hsqldb.lib.RCData;

public class SqlTool {
    private static FrameworkLogger logger = FrameworkLogger.getLog(SqlTool.class);
    private static final String DEFAULT_RCFILE = System.getProperty("user.home") + "/sqltool.rc";
    private static String revnum = null;
    public static final int SQLTOOLERR_EXITVAL = 1;
    public static final int SYNTAXERR_EXITVAL = 11;
    public static final int RCERR_EXITVAL = 2;
    public static final int SQLERR_EXITVAL = 3;
    public static final int IOERR_EXITVAL = 4;
    public static final int FILEERR_EXITVAL = 5;
    public static final int INPUTERR_EXITVAL = 6;
    public static final int CONNECTERR_EXITVAL = 7;
    private static String CMDLINE_ID = "cmdline";
    private static SqltoolRB rb = null;
    public static String LS;
    private static BadCmdline bcl;

    private static String promptForPassword(String username) throws PrivateException {
        String password = null;
        try {
            BufferedReader console = new BufferedReader(new InputStreamReader(System.in));
            System.out.print(rb.getString(SqltoolRB.PASSWORDFOR_PROMPT, RCData.expandSysPropVars(username)));
            password = console.readLine();
            password = password == null ? "" : password.trim();
        }
        catch (IOException e) {
            throw new PrivateException(e.getMessage());
        }
        return password;
    }

    private static void varParser(String varString, Map varMap, boolean lowerCaseKeys) throws PrivateException {
        if (varMap == null || varString == null) {
            throw new IllegalArgumentException("varMap or varString are null in SqlTool.varParser call");
        }
        String[] allvars = varString.split("\\s*,\\s*");
        for (int i = 0; i < allvars.length; ++i) {
            int equals = allvars[i].indexOf(61);
            if (equals < 1) {
                throw new PrivateException(rb.getString(SqltoolRB.SQLTOOL_VARSET_BADFORMAT));
            }
            String var = allvars[i].substring(0, equals).trim();
            String val = allvars[i].substring(equals + 1).trim();
            if (var.length() < 1) {
                throw new PrivateException(rb.getString(SqltoolRB.SQLTOOL_VARSET_BADFORMAT));
            }
            if (lowerCaseKeys) {
                var = var.toLowerCase();
            }
            varMap.put(var, val);
        }
    }

    public static void main(String[] args) {
        try {
            SqlTool.objectMain(args);
        }
        catch (SqlToolException fr) {
            if (fr.getMessage() != null) {
                System.err.println(fr.getMessage());
            }
            System.exit(fr.exitValue);
        }
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void objectMain(String[] arg) throws SqlToolException {
        logger.finer("Invoking SqlTool");
        String rcFile = null;
        File tmpFile = null;
        String sqlText = null;
        String driver = null;
        String targetDb = null;
        String varSettings = null;
        boolean debug = false;
        File[] scriptFiles = null;
        int i = -1;
        boolean listMode = false;
        boolean interactive = false;
        boolean noinput = false;
        boolean noautoFile = false;
        boolean autoCommit = false;
        Boolean coeOverride = null;
        Boolean stdinputOverride = null;
        String rcParams = null;
        String rcUrl = null;
        String rcUsername = null;
        String rcPassword = null;
        String rcCharset = null;
        String rcTruststore = null;
        String rcTransIso = null;
        HashMap rcFields = null;
        try {
            while (i + 1 < arg.length && arg[i + 1].startsWith("--") && arg[++i].length() != 2) {
                String parameter = arg[i].substring(2).toLowerCase();
                if (parameter.equals("help")) {
                    System.out.println(rb.getString(SqltoolRB.SQLTOOL_SYNTAX, revnum, "org.hsqldb.jdbc.JDBCDriver"));
                    return;
                }
                if (parameter.equals("abortonerr")) {
                    if (coeOverride != null) {
                        throw new SqlToolException(11, rb.getString(SqltoolRB.SQLTOOL_ABORTCONTINUE_MUTUALLYEXCLUSIVE));
                    }
                    coeOverride = Boolean.FALSE;
                    continue;
                }
                if (parameter.equals("continueonerr")) {
                    if (coeOverride != null) {
                        throw new SqlToolException(11, rb.getString(SqltoolRB.SQLTOOL_ABORTCONTINUE_MUTUALLYEXCLUSIVE));
                    }
                    coeOverride = Boolean.TRUE;
                    continue;
                }
                if (parameter.startsWith("continueonerr=")) {
                    if (coeOverride != null) {
                        throw new SqlToolException(11, rb.getString(SqltoolRB.SQLTOOL_ABORTCONTINUE_MUTUALLYEXCLUSIVE));
                    }
                    coeOverride = Boolean.valueOf(arg[i].substring("--continueonerr=".length()));
                    continue;
                }
                if (parameter.equals("list")) {
                    listMode = true;
                    continue;
                }
                if (parameter.equals("rcfile")) {
                    if (++i == arg.length) {
                        throw bcl;
                    }
                    rcFile = arg[i];
                    continue;
                }
                if (parameter.startsWith("rcfile=")) {
                    rcFile = arg[i].substring("--rcfile=".length());
                    continue;
                }
                if (parameter.equals("setvar")) {
                    if (++i == arg.length) {
                        throw bcl;
                    }
                    varSettings = arg[i];
                    continue;
                }
                if (parameter.startsWith("setvar=")) {
                    varSettings = arg[i].substring("--setvar=".length());
                    continue;
                }
                if (parameter.equals("sql")) {
                    noinput = true;
                    if (++i == arg.length) {
                        throw bcl;
                    }
                    sqlText = arg[i];
                    continue;
                }
                if (parameter.startsWith("sql=")) {
                    noinput = true;
                    sqlText = arg[i].substring("--sql=".length());
                    continue;
                }
                if (parameter.equals("debug")) {
                    debug = true;
                    continue;
                }
                if (parameter.equals("noautofile")) {
                    noautoFile = true;
                    continue;
                }
                if (parameter.equals("autocommit")) {
                    autoCommit = true;
                    continue;
                }
                if (parameter.equals("stdinput")) {
                    noinput = false;
                    stdinputOverride = Boolean.TRUE;
                    continue;
                }
                if (parameter.equals("noinput")) {
                    noinput = true;
                    stdinputOverride = Boolean.FALSE;
                    continue;
                }
                if (parameter.equals("driver")) {
                    if (++i == arg.length) {
                        throw bcl;
                    }
                    driver = arg[i];
                    continue;
                }
                if (parameter.startsWith("driver=")) {
                    driver = arg[i].substring("--driver=".length());
                    continue;
                }
                if (parameter.equals("inlinerc")) {
                    if (++i == arg.length) {
                        throw bcl;
                    }
                    rcParams = arg[i];
                    continue;
                }
                if (parameter.startsWith("inlinerc=")) {
                    rcParams = arg[i].substring("--inlinerc=".length());
                    continue;
                }
                throw bcl;
            }
            if (!listMode && rcParams == null) {
                if (++i == arg.length) {
                    throw bcl;
                }
                targetDb = arg[i];
            }
            int scriptIndex = 0;
            if (sqlText != null) {
                try {
                    tmpFile = File.createTempFile("sqltool-", ".sql");
                    FileWriter fw = new FileWriter(tmpFile);
                    try {
                        fw.write("/* " + new Date() + ".  " + SqlTool.class.getName() + " command-line SQL. */" + LS + LS);
                        fw.write(sqlText + LS);
                        fw.flush();
                    }
                    finally {
                        fw.close();
                    }
                }
                catch (IOException ioe) {
                    throw new SqlToolException(4, rb.getString(SqltoolRB.SQLTEMPFILE_FAIL, ioe.toString()));
                }
            }
            if (stdinputOverride != null) {
                noinput = stdinputOverride == false;
            }
            boolean bl = interactive = !noinput && arg.length <= i + 1;
            if (arg.length == i + 2 && arg[i + 1].equals("-")) {
                if (stdinputOverride == null) {
                    noinput = false;
                }
            } else if (arg.length > i + 1) {
                scriptFiles = new File[arg.length - i - 1 + (stdinputOverride == null || stdinputOverride == false ? 0 : 1)];
                if (debug) {
                    System.err.println("scriptFiles has " + scriptFiles.length + " elements");
                }
                while (i + 1 < arg.length) {
                    scriptFiles[scriptIndex++] = new File(arg[++i]);
                }
                if (stdinputOverride != null && stdinputOverride.booleanValue()) {
                    scriptFiles[scriptIndex++] = null;
                    noinput = true;
                }
            }
        }
        catch (BadCmdline bcle) {
            throw new SqlToolException(11, rb.getString(SqltoolRB.SQLTOOL_SYNTAX, revnum, "org.hsqldb.jdbc.JDBCDriver"));
        }
        RCData conData = null;
        if (rcParams != null) {
            rcFields = new HashMap();
            try {
                SqlTool.varParser(rcParams, rcFields, true);
            }
            catch (PrivateException e) {
                throw new SqlToolException(11, e.getMessage());
            }
            rcUrl = (String)rcFields.remove("url");
            rcUsername = (String)rcFields.remove("user");
            rcCharset = (String)rcFields.remove("charset");
            rcTruststore = (String)rcFields.remove("truststore");
            rcPassword = (String)rcFields.remove("password");
            rcTransIso = (String)rcFields.remove("transiso");
            if (rcUrl == null || rcUrl.length() < 1) {
                throw new SqlToolException(2, rb.getString(SqltoolRB.RCDATA_INLINEURL_MISSING));
            }
            if (rcPassword != null && rcPassword.length() > 0) {
                throw new SqlToolException(2, rb.getString(SqltoolRB.RCDATA_PASSWORD_VISIBLE));
            }
            if (rcFields.size() > 0) {
                throw new SqlToolException(6, rb.getString(SqltoolRB.RCDATA_INLINE_EXTRAVARS, rcFields.keySet().toString()));
            }
            if (rcUsername != null && rcPassword == null) {
                try {
                    rcPassword = SqlTool.promptForPassword(rcUsername);
                }
                catch (PrivateException e) {
                    throw new SqlToolException(6, rb.getString(SqltoolRB.PASSWORD_READFAIL, e.getMessage()));
                }
            }
            try {
                conData = new RCData(CMDLINE_ID, rcUrl, rcUsername, rcPassword, driver, rcCharset, rcTruststore, null, rcTransIso);
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new SqlToolException(2, rb.getString(SqltoolRB.RCDATA_GENFROMVALUES_FAIL, e.getMessage()));
            }
        }
        try {
            conData = new RCData(new File(rcFile == null ? DEFAULT_RCFILE : rcFile), targetDb);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new SqlToolException(2, rb.getString(SqltoolRB.CONNDATA_RETRIEVAL_FAIL, targetDb, e.getMessage()));
        }
        if (listMode) {
            return;
        }
        Connection conn = null;
        try {
            conn = conData.getConnection(driver, System.getProperty("sqlfile.charset"), System.getProperty("javax.net.ssl.trustStore"));
            conn.setAutoCommit(autoCommit);
            DatabaseMetaData md = null;
            if (interactive && (md = conn.getMetaData()) != null) {
                System.out.println(rb.getString(SqltoolRB.JDBC_ESTABLISHED, md.getDatabaseProductName(), md.getDatabaseProductVersion(), md.getUserName(), (conn.isReadOnly() ? "R/O " : "R/W ") + RCData.tiToString(conn.getTransactionIsolation())));
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            if (debug) {
                logger.error(e.getClass().getName(), e);
            }
            String reportUser = conData.username == null ? "<DFLTUSER>" : conData.username;
            throw new SqlToolException(7, rb.getString(SqltoolRB.CONNECTION_FAIL, conData.url, reportUser, e.getMessage()));
        }
        File[] emptyFileArray = new File[]{};
        File[] singleNullFileArray = new File[]{null};
        File autoFile = null;
        if (!(!interactive || noautoFile || (autoFile = new File(System.getProperty("user.home") + "/auto.sql")).isFile() && autoFile.canRead())) {
            autoFile = null;
        }
        if (scriptFiles == null) {
            scriptFiles = noinput ? emptyFileArray : singleNullFileArray;
        }
        int numFiles = scriptFiles.length;
        if (tmpFile != null) {
            ++numFiles;
        }
        if (autoFile != null) {
            ++numFiles;
        }
        SqlFile[] sqlFiles = new SqlFile[numFiles];
        HashMap userVars = new HashMap();
        HashMap macros = new HashMap();
        if (varSettings != null) {
            try {
                SqlTool.varParser(varSettings, userVars, false);
            }
            catch (PrivateException pe) {
                throw new SqlToolException(2, pe.getMessage());
            }
        }
        int interactiveFileIndex = -1;
        try {
            int fileIndex = 0;
            if (autoFile != null) {
                sqlFiles[fileIndex++] = new SqlFile(autoFile, false, userVars, macros);
            }
            if (tmpFile != null) {
                sqlFiles[fileIndex++] = new SqlFile(tmpFile, false, userVars, macros);
            }
            for (int j = 0; j < scriptFiles.length; ++j) {
                if (interactiveFileIndex < 0 && interactive) {
                    interactiveFileIndex = fileIndex;
                }
                sqlFiles[fileIndex++] = new SqlFile(scriptFiles[j], interactive, userVars, macros);
            }
        }
        catch (IOException ioe) {
            try {
                conn.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            throw new SqlToolException(5, ioe.getMessage());
        }
        try {
            for (int j = 0; j < sqlFiles.length; ++j) {
                if (j == interactiveFileIndex) {
                    System.out.print("SqlTool v. " + revnum + ".                        ");
                }
                sqlFiles[j].execute(conn, coeOverride);
            }
        }
        catch (SqlToolError ste) {
            throw new SqlToolException(1);
        }
        catch (SQLException se) {
            throw new SqlToolException(3);
        }
        finally {
            try {
                conn.close();
            }
            catch (Exception e) {}
            if (!debug && tmpFile != null && !tmpFile.delete()) {
                System.err.println(conData.url + rb.getString(SqltoolRB.TEMPFILE_REMOVAL_FAIL, tmpFile.toString()));
            }
        }
    }

    static {
        revnum = "$Revision: 3070 $".substring("$Revision: ".length(), "$Revision: 3070 $".length() - 2);
        try {
            rb = new SqltoolRB();
            rb.validate();
            rb.setMissingPosValueBehavior(2);
            rb.setMissingPropertyBehavior(2);
        }
        catch (RuntimeException re) {
            System.err.println("Failed to initialize resource bundle");
            throw re;
        }
        LS = System.getProperty("line.separator");
        bcl = new BadCmdline();
    }

    public static class SqlToolException
    extends Exception {
        static final long serialVersionUID = 1424909871915188519L;
        int exitValue = 1;

        SqlToolException(String message, int exitValue) {
            super(message);
            this.exitValue = exitValue;
        }

        SqlToolException(int exitValue, String message) {
            this(message, exitValue);
        }

        SqlToolException(int exitValue) {
            this.exitValue = exitValue;
        }
    }

    private static class PrivateException
    extends Exception {
        static final long serialVersionUID = -7765061479594523462L;

        PrivateException() {
        }

        PrivateException(String s) {
            super(s);
        }
    }

    private static class BadCmdline
    extends Exception {
        static final long serialVersionUID = -2134764796788108325L;

        BadCmdline() {
        }
    }
}

