/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Expression;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.RangeVariable;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.Statement;
import org.hsqldb.Table;
import org.hsqldb.Trigger;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HsqlDeque;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.rights.Grantee;

public class TriggerDef
implements Runnable,
SchemaObject {
    static final int OLD_ROW = 0;
    static final int NEW_ROW = 1;
    static final int OLD_TABLE = 2;
    static final int NEW_TABLE = 3;
    static final int NUM_TRIGGER_OPS = 3;
    static final int NUM_TRIGS = 9;
    static final TriggerDef[] emptyArray = new TriggerDef[0];
    Table[] transitions;
    RangeVariable[] rangeVars;
    Expression condition;
    boolean hasTransitionTables;
    boolean hasTransitionRanges;
    String conditionSQL;
    String procedureSQL;
    Statement[] statements = Statement.emptyArray;
    int[] updateColumns;
    HsqlNameManager.HsqlName name;
    String actionTimingString;
    String eventTimingString;
    int operationPrivilegeType;
    boolean forEachRow;
    boolean nowait;
    int maxRowsQueued;
    Table table;
    Trigger trigger;
    String triggerClassName;
    int triggerType;
    Thread thread;
    protected HsqlDeque pendingQueue;
    protected int rowsQueued;
    protected boolean valid = true;
    protected volatile boolean keepGoing = true;

    TriggerDef() {
    }

    public TriggerDef(HsqlNameManager.HsqlName name, String when, String operation, boolean forEach, Table table, Table[] transitions, RangeVariable[] rangeVars, Expression condition, String conditionSQL, int[] updateColumns, String triggerClassName, boolean noWait, int queueSize) {
        this(name, when, operation, forEach, table, transitions, rangeVars, condition, conditionSQL, updateColumns);
        Class<Object> cl;
        this.triggerClassName = triggerClassName;
        this.nowait = noWait;
        this.maxRowsQueued = queueSize;
        this.rowsQueued = 0;
        this.pendingQueue = new HsqlDeque();
        try {
            cl = Class.forName(triggerClassName);
        }
        catch (ClassNotFoundException e) {
            this.valid = false;
            cl = DefaultTrigger.class;
        }
        try {
            this.trigger = (Trigger)cl.newInstance();
        }
        catch (Exception e) {
            this.valid = false;
            this.trigger = new DefaultTrigger();
        }
    }

    public TriggerDef(HsqlNameManager.HsqlName name, String when, String operation, boolean forEachRow, Table table, Table[] transitions, RangeVariable[] rangeVars, Expression condition, String conditionSQL, int[] updateColumns) {
        this.name = name;
        this.actionTimingString = when;
        this.eventTimingString = operation;
        this.forEachRow = forEachRow;
        this.table = table;
        this.transitions = transitions;
        this.rangeVars = rangeVars;
        this.condition = condition == null ? Expression.EXPR_TRUE : condition;
        this.updateColumns = updateColumns;
        this.conditionSQL = conditionSQL;
        this.hasTransitionRanges = transitions[0] != null || transitions[1] != null;
        this.hasTransitionTables = transitions[2] != null || transitions[3] != null;
        this.setUpIndexesAndTypes();
    }

    public boolean isValid() {
        return this.valid;
    }

    @Override
    public int getType() {
        return 8;
    }

    @Override
    public HsqlNameManager.HsqlName getName() {
        return this.name;
    }

    @Override
    public HsqlNameManager.HsqlName getCatalogName() {
        return this.name.schema.schema;
    }

    @Override
    public HsqlNameManager.HsqlName getSchemaName() {
        return this.name.schema;
    }

    @Override
    public Grantee getOwner() {
        return this.name.schema.owner;
    }

    @Override
    public OrderedHashSet getReferences() {
        return new OrderedHashSet();
    }

    @Override
    public OrderedHashSet getComponents() {
        return null;
    }

    @Override
    public void compile(Session session, SchemaObject parentObject) {
    }

    @Override
    public String getSQL() {
        StringBuffer sb = this.getSQLMain();
        if (this.maxRowsQueued != 0) {
            sb.append("QUEUE").append(' ');
            sb.append(this.maxRowsQueued).append(' ');
            if (this.nowait) {
                sb.append("NOWAIT").append(' ');
            }
        }
        sb.append("CALL").append(' ');
        sb.append(StringConverter.toQuotedString(this.triggerClassName, '\"', false));
        return sb.toString();
    }

    public StringBuffer getSQLMain() {
        StringBuffer sb = new StringBuffer(256);
        sb.append("CREATE").append(' ');
        sb.append("TRIGGER").append(' ');
        sb.append(this.name.getSchemaQualifiedStatementName()).append(' ');
        sb.append(this.actionTimingString).append(' ');
        sb.append(this.eventTimingString).append(' ');
        if (this.updateColumns != null) {
            sb.append("OF").append(' ');
            for (int i = 0; i < this.updateColumns.length; ++i) {
                if (i != 0) {
                    sb.append(',');
                }
                HsqlNameManager.HsqlName name = this.table.getColumn(this.updateColumns[i]).getName();
                sb.append(name.statementName);
            }
            sb.append(' ');
        }
        sb.append("ON").append(' ');
        sb.append(this.table.getName().getSchemaQualifiedStatementName()).append(' ');
        if (this.hasTransitionRanges || this.hasTransitionTables) {
            sb.append("REFERENCING").append(' ');
            String separator = "";
            if (this.transitions[0] != null) {
                sb.append("OLD").append(' ').append("ROW");
                sb.append(' ').append("AS").append(' ');
                sb.append(this.transitions[0].getName().statementName);
                separator = ",";
            }
            if (this.transitions[1] != null) {
                sb.append(separator);
                sb.append("NEW").append(' ').append("ROW");
                sb.append(' ').append("AS").append(' ');
                sb.append(this.transitions[1].getName().statementName);
                separator = ",";
            }
            if (this.transitions[2] != null) {
                sb.append(separator);
                sb.append("OLD").append(' ').append("TABLE");
                sb.append(' ').append("AS").append(' ');
                sb.append(this.transitions[2].getName().statementName);
                separator = ",";
            }
            if (this.transitions[3] != null) {
                sb.append(separator);
                sb.append("OLD").append(' ').append("TABLE");
                sb.append(' ').append("AS").append(' ');
                sb.append(this.transitions[3].getName().statementName);
            }
            sb.append(' ');
        }
        if (this.forEachRow) {
            sb.append("FOR").append(' ');
            sb.append("EACH").append(' ');
            sb.append("ROW").append(' ');
        }
        if (this.condition != Expression.EXPR_TRUE) {
            sb.append("WHEN").append(' ');
            sb.append("(").append(this.conditionSQL);
            sb.append(")").append(' ');
        }
        return sb;
    }

    public String getClassName() {
        return this.trigger.getClass().getName();
    }

    public String getActionTimingString() {
        return this.actionTimingString;
    }

    public String getEventTypeString() {
        return this.eventTimingString;
    }

    public boolean isForEachRow() {
        return this.forEachRow;
    }

    public String getConditionSQL() {
        return this.conditionSQL;
    }

    public String getProcedureSQL() {
        return this.procedureSQL;
    }

    public int[] getUpdateColumnIndexes() {
        return this.updateColumns;
    }

    public boolean hasOldTable() {
        return false;
    }

    public boolean hasNewTable() {
        return false;
    }

    public String getOldTransitionRowName() {
        return this.transitions[0] == null ? null : this.transitions[0].getName().name;
    }

    public String getNewTransitionRowName() {
        return this.transitions[1] == null ? null : this.transitions[1].getName().name;
    }

    public String getOldTransitionTableName() {
        return this.transitions[2] == null ? null : this.transitions[2].getName().name;
    }

    public String getNewTransitionTableName() {
        return this.transitions[3] == null ? null : this.transitions[3].getName().name;
    }

    void setUpIndexesAndTypes() {
        this.triggerType = 0;
        if (this.eventTimingString.equals("INSERT")) {
            this.triggerType = 0;
            this.operationPrivilegeType = 4;
        } else if (this.eventTimingString.equals("DELETE")) {
            this.operationPrivilegeType = 2;
            this.triggerType = 1;
        } else if (this.eventTimingString.equals("UPDATE")) {
            this.operationPrivilegeType = 8;
            this.triggerType = 2;
        } else {
            throw Error.runtimeError(401, "TriggerDef");
        }
        if (this.actionTimingString.equals("BEFORE")) {
            this.triggerType += 3;
        }
        this.triggerType = this.triggerType;
        if (this.forEachRow) {
            this.triggerType += 3;
        }
    }

    public int getPrivilegeType() {
        return this.operationPrivilegeType;
    }

    @Override
    public void run() {
        while (this.keepGoing) {
            TriggerData triggerData = this.popPair();
            if (triggerData == null || triggerData.username == null) continue;
            this.trigger.fire(this.triggerType, this.name.name, this.table.getName().name, triggerData.oldRow, triggerData.newRow);
        }
    }

    public synchronized void start() {
        if (this.maxRowsQueued != 0) {
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    public synchronized void terminate() {
        this.keepGoing = false;
        this.notify();
    }

    synchronized TriggerData popPair() {
        if (this.rowsQueued == 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        --this.rowsQueued;
        this.notify();
        if (this.pendingQueue.size() == 0) {
            return null;
        }
        return (TriggerData)this.pendingQueue.removeFirst();
    }

    synchronized void pushPair(Session session, Object[] row1, Object[] row2) {
        if (this.maxRowsQueued == 0) {
            this.trigger.fire(this.triggerType, this.name.name, this.table.getName().name, row1, row2);
            return;
        }
        if (this.rowsQueued >= this.maxRowsQueued) {
            if (this.nowait) {
                this.pendingQueue.removeLast();
            } else {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                ++this.rowsQueued;
            }
        } else {
            ++this.rowsQueued;
        }
        this.pendingQueue.add(new TriggerData(session, row1, row2));
        this.notify();
    }

    public boolean isBusy() {
        return this.rowsQueued != 0;
    }

    public Table getTable() {
        return this.table;
    }

    public String getActionOrientationString() {
        return this.forEachRow ? "ROW" : "STATEMENT";
    }

    static class DefaultTrigger
    implements Trigger {
        DefaultTrigger() {
        }

        @Override
        public void fire(int i, String name, String table, Object[] row1, Object[] row2) {
            throw new RuntimeException("Missing Trigger class!");
        }
    }

    static class TriggerData {
        public Object[] oldRow;
        public Object[] newRow;
        public String username;

        public TriggerData(Session session, Object[] oldRow, Object[] newRow) {
            this.oldRow = oldRow;
            this.newRow = newRow;
            this.username = session.getUsername();
        }
    }
}

