/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.RangeVariable;
import org.hsqldb.types.Type;

public class Token {
    String tokenString = "";
    int tokenType = -1;
    Type dataType;
    Object tokenValue;
    String namePrefix;
    String namePrePrefix;
    String namePrePrePrefix;
    String charsetSchema;
    String charsetName;
    String fullString;
    int lobMultiplierType = -1;
    boolean isDelimiter;
    boolean isDelimitedIdentifier;
    boolean isDelimitedPrefix;
    boolean isDelimitedPrePrefix;
    boolean isDelimitedPrePrePrefix;
    boolean isUndelimitedIdentifier;
    boolean isReservedIdentifier;
    boolean isCoreReservedIdentifier;
    boolean isHostParameter;
    boolean isMalformed;
    int position;
    ExpressionColumn columnExpression;

    void reset() {
        this.tokenString = "";
        this.tokenType = -1;
        this.dataType = null;
        this.tokenValue = null;
        this.namePrefix = null;
        this.namePrePrefix = null;
        this.namePrePrePrefix = null;
        this.charsetSchema = null;
        this.charsetName = null;
        this.fullString = null;
        this.lobMultiplierType = -1;
        this.isDelimiter = false;
        this.isDelimitedIdentifier = false;
        this.isDelimitedPrefix = false;
        this.isDelimitedPrePrefix = false;
        this.isDelimitedPrePrePrefix = false;
        this.isUndelimitedIdentifier = false;
        this.isReservedIdentifier = false;
        this.isCoreReservedIdentifier = false;
        this.isHostParameter = false;
        this.isMalformed = false;
    }

    Token duplicate() {
        Token token = new Token();
        token.tokenString = this.tokenString;
        token.tokenType = this.tokenType;
        token.dataType = this.dataType;
        token.tokenValue = this.tokenValue;
        token.namePrefix = this.namePrefix;
        token.namePrePrefix = this.namePrePrefix;
        token.namePrePrePrefix = this.namePrePrePrefix;
        token.charsetSchema = this.charsetSchema;
        token.charsetName = this.charsetName;
        token.fullString = this.fullString;
        token.lobMultiplierType = this.lobMultiplierType;
        token.isDelimiter = this.isDelimiter;
        token.isDelimitedIdentifier = this.isDelimitedIdentifier;
        token.isDelimitedPrefix = this.isDelimitedPrefix;
        token.isDelimitedPrePrefix = this.isDelimitedPrePrefix;
        token.isDelimitedPrePrePrefix = this.isDelimitedPrePrePrefix;
        token.isUndelimitedIdentifier = this.isUndelimitedIdentifier;
        token.isReservedIdentifier = this.isReservedIdentifier;
        token.isCoreReservedIdentifier = this.isCoreReservedIdentifier;
        token.isHostParameter = this.isHostParameter;
        token.isMalformed = this.isMalformed;
        return token;
    }

    public String getFullString() {
        return this.fullString;
    }

    String getSQL() {
        if (this.namePrefix == null && this.isUndelimitedIdentifier) {
            return this.tokenString;
        }
        if (this.tokenType == 745) {
            return this.dataType.convertToSQLString(this.tokenValue);
        }
        StringBuffer sb = new StringBuffer();
        if (this.tokenType == 681) {
            if (this.columnExpression != null && this.columnExpression.opType == 97 && this.columnExpression.nodes.length > 0) {
                sb.append(' ');
                for (int i = 0; i < this.columnExpression.nodes.length; ++i) {
                    String name;
                    Expression e = this.columnExpression.nodes[i];
                    ColumnSchema c = e.getColumn();
                    if (e.opType == 3) {
                        sb.append(e.getColumnName());
                        continue;
                    }
                    if (e.getRangeVariable().tableAlias == null) {
                        name = c.getName().getSchemaQualifiedStatementName();
                    } else {
                        RangeVariable range = e.getRangeVariable();
                        name = range.tableAlias.getStatementName() + '.' + c.getName().statementName;
                    }
                    if (i > 0) {
                        sb.append(',');
                    }
                    sb.append(name);
                }
            } else {
                return this.tokenString;
            }
            sb.append(' ');
            return sb.toString();
        }
        if (this.namePrePrefix != null) {
            if (this.isDelimitedPrePrefix) {
                sb.append('\"');
                sb.append(this.namePrePrefix);
                sb.append('\"');
            } else {
                sb.append(this.namePrePrefix);
            }
            sb.append('.');
        }
        if (this.namePrefix != null) {
            if (this.isDelimitedPrefix) {
                sb.append('\"');
                sb.append(this.namePrefix);
                sb.append('\"');
            } else {
                sb.append(this.namePrefix);
            }
            sb.append('.');
        }
        if (this.isDelimitedIdentifier) {
            sb.append('\"');
            sb.append(this.tokenString);
            sb.append('\"');
        } else {
            sb.append(this.tokenString);
        }
        return sb.toString();
    }

    static String getSQL(Token[] statement) {
        boolean wasDelimiter = true;
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < statement.length; ++i) {
            if (!statement[i].isDelimiter && !wasDelimiter) {
                sb.append(' ');
            }
            sb.append(statement[i].getSQL());
            wasDelimiter = statement[i].isDelimiter;
        }
        return sb.toString();
    }
}

