/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Constraint;
import org.hsqldb.Database;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionLogical;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.rights.Grantee;

public class TableWorks {
    OrderedHashSet emptySet = new OrderedHashSet();
    private Database database;
    private Table table;
    private Session session;

    public TableWorks(Session session, Table table) {
        this.database = table.database;
        this.table = table;
        this.session = session;
    }

    public Table getTable() {
        return this.table;
    }

    void checkCreateForeignKey(Constraint c) {
        ColumnSchema col;
        int i;
        boolean check;
        if (c.core.mainName == this.table.getName() && ArrayUtil.haveCommonElement(c.core.refCols, c.core.mainCols, c.core.refCols.length)) {
            throw Error.error(5527);
        }
        boolean bl = check = c.core.updateAction == 4 || c.core.deleteAction == 4;
        if (check) {
            for (i = 0; i < c.core.refCols.length; ++i) {
                col = this.table.getColumn(c.core.refCols[i]);
                Expression defExpr = col.getDefaultExpression();
                if (defExpr != null) continue;
                String columnName = col.getName().statementName;
                throw Error.error(5521, columnName);
            }
        }
        boolean bl2 = check = c.core.updateAction == 2 || c.core.deleteAction == 2;
        if (check) {
            for (i = 0; i < c.core.refCols.length; ++i) {
                col = this.table.getColumn(c.core.refCols[i]);
                if (col.isNullable()) continue;
                String columnName = col.getName().statementName;
                throw Error.error(5520, columnName);
            }
        }
        this.database.schemaManager.checkSchemaObjectNotExists(c.getName());
        if (this.table.getConstraint(c.getName().name) != null) {
            throw Error.error(5504, c.getName().statementName);
        }
        if (this.table.getFKConstraintForColumns(c.core.mainTable, c.core.mainCols, c.core.refCols) != null) {
            throw Error.error(5528, c.getName().statementName);
        }
        if (c.core.mainTable.isTemp() != this.table.isTemp()) {
            throw Error.error(5524, c.getName().statementName);
        }
        if (c.core.mainTable.getUniqueConstraintForColumns(c.core.mainCols, c.core.refCols) == null) {
            throw Error.error(5529, c.getMain().getName().statementName);
        }
        c.core.mainTable.checkColumnsMatch(c.core.mainCols, this.table, c.core.refCols);
        boolean[] checkList = c.core.mainTable.getColumnCheckList(c.core.mainCols);
        Grantee grantee = this.session.getGrantee();
        grantee.checkReferences(c.core.mainTable, checkList);
    }

    void addForeignKey(Constraint c) {
        boolean isForward;
        this.checkCreateForeignKey(c);
        Constraint uniqueConstraint = c.core.mainTable.getUniqueConstraintForColumns(c.core.mainCols, c.core.refCols);
        Index mainIndex = uniqueConstraint.getMainIndex();
        uniqueConstraint.checkReferencedRows(this.session, this.table, c.core.refCols);
        int offset = this.database.schemaManager.getTableIndex(this.table);
        boolean bl = isForward = c.core.mainTable.getSchemaName() != this.table.getSchemaName();
        if (offset != -1 && offset < this.database.schemaManager.getTableIndex(c.core.mainTable)) {
            isForward = true;
        }
        HsqlNameManager.HsqlName indexName = this.database.nameManager.newAutoName("IDX", this.table.getSchemaName(), this.table.getName(), 20);
        Index refIndex = this.table.createIndexStructure(indexName, c.core.refCols, null, null, false, true, isForward);
        HsqlNameManager.HsqlName mainName = this.database.nameManager.newAutoName("REF", c.getName().name, this.table.getSchemaName(), this.table.getName(), 20);
        c.core.uniqueName = uniqueConstraint.getName();
        c.core.mainName = mainName;
        c.core.mainIndex = mainIndex;
        c.core.refTable = this.table;
        c.core.refName = c.getName();
        c.core.refIndex = refIndex;
        c.isForward = isForward;
        Table tn = this.table.moveDefinition(this.session, this.table.tableType, null, c, refIndex, -1, 0, this.emptySet, this.emptySet);
        tn.moveData(this.session, this.table, -1, 0);
        c.core.mainTable.addConstraint(new Constraint(mainName, c));
        this.database.schemaManager.addSchemaObject(c);
        this.database.persistentStoreCollection.releaseStore(this.table);
        this.setNewTableInSchema(tn);
        this.updateConstraints(tn, this.emptySet);
        this.database.schemaManager.recompileDependentObjects(tn);
        this.table = tn;
    }

    void checkAddColumn(ColumnSchema col) {
        if (this.table.isText() && !this.table.isEmpty(this.session)) {
            throw Error.error(320);
        }
        if (this.table.findColumn(col.getName().name) != -1) {
            throw Error.error(5504);
        }
        if (col.isPrimaryKey() && this.table.hasPrimaryKey()) {
            throw Error.error(5530);
        }
        if (col.isIdentity() && this.table.hasIdentityColumn()) {
            throw Error.error(5525);
        }
        if (!(this.table.isEmpty(this.session) || col.hasDefault() || col.isNullable() && !col.isPrimaryKey() || col.isIdentity())) {
            throw Error.error(5531);
        }
    }

    void addColumn(ColumnSchema column, int colIndex, HsqlArrayList constraints) {
        Index index = null;
        Table originalTable = this.table;
        Constraint mainConstraint = null;
        boolean addFK = false;
        boolean addUnique = false;
        boolean addCheck = false;
        this.checkAddColumn(column);
        Constraint c = (Constraint)constraints.get(0);
        if (c.getConstraintType() == 4) {
            c.core.mainCols = new int[]{colIndex};
            this.database.schemaManager.checkSchemaObjectNotExists(c.getName());
            if (this.table.hasPrimaryKey()) {
                throw Error.error(5530);
            }
            addUnique = true;
        } else {
            c = null;
        }
        this.table = this.table.moveDefinition(this.session, this.table.tableType, column, c, null, colIndex, 1, this.emptySet, this.emptySet);
        block5: for (int i = 1; i < constraints.size(); ++i) {
            c = (Constraint)constraints.get(i);
            switch (c.constType) {
                case 2: {
                    if (addUnique) {
                        throw Error.error(5522);
                    }
                    addUnique = true;
                    c.core.mainCols = new int[]{colIndex};
                    this.database.schemaManager.checkSchemaObjectNotExists(c.getName());
                    HsqlNameManager.HsqlName indexName = this.database.nameManager.newAutoName("IDX", c.getName().name, this.table.getSchemaName(), this.table.getName(), 20);
                    index = this.table.createAndAddIndexStructure(indexName, c.getMainColumns(), null, null, true, true, false);
                    c.core.mainTable = this.table;
                    c.core.mainIndex = index;
                    this.table.addConstraint(c);
                    continue block5;
                }
                case 0: {
                    boolean isSelf;
                    if (addFK) {
                        throw Error.error(5528);
                    }
                    addFK = true;
                    c.core.refCols = new int[]{colIndex};
                    boolean bl = isSelf = originalTable == c.core.mainTable;
                    if (isSelf) {
                        c.core.mainTable = this.table;
                    }
                    c.setColumnsIndexes(this.table);
                    this.checkCreateForeignKey(c);
                    Constraint uniqueConstraint = c.core.mainTable.getUniqueConstraintForColumns(c.core.mainCols, c.core.refCols);
                    boolean isForward = c.core.mainTable.getSchemaName() != this.table.getSchemaName();
                    int offset = this.database.schemaManager.getTableIndex(originalTable);
                    if (!isSelf && offset < this.database.schemaManager.getTableIndex(c.core.mainTable)) {
                        isForward = true;
                    }
                    HsqlNameManager.HsqlName indexName = this.database.nameManager.newAutoName("IDX", c.getName().name, this.table.getSchemaName(), this.table.getName(), 20);
                    index = this.table.createAndAddIndexStructure(indexName, c.getRefColumns(), null, null, false, true, isForward);
                    c.core.uniqueName = uniqueConstraint.getName();
                    c.core.mainName = this.database.nameManager.newAutoName("REF", c.core.refName.name, this.table.getSchemaName(), this.table.getName(), 20);
                    c.core.mainIndex = uniqueConstraint.getMainIndex();
                    c.core.refIndex = index;
                    c.isForward = isForward;
                    this.table.addConstraint(c);
                    mainConstraint = new Constraint(c.core.mainName, c);
                    continue block5;
                }
                case 3: {
                    if (addCheck) {
                        throw Error.error(5528);
                    }
                    addCheck = true;
                    c.prepareCheckConstraint(this.session, this.table, false);
                    this.table.addConstraint(c);
                    if (!c.isNotNull()) continue block5;
                    column.setNullable(false);
                    this.table.setColumnTypeVars(colIndex);
                }
            }
        }
        this.table.moveData(this.session, originalTable, colIndex, 1);
        if (mainConstraint != null) {
            mainConstraint.getMain().addConstraint(mainConstraint);
        }
        this.registerConstraintNames(constraints);
        this.setNewTableInSchema(this.table);
        this.updateConstraints(this.table, this.emptySet);
        this.database.persistentStoreCollection.releaseStore(originalTable);
        this.database.schemaManager.recompileDependentObjects(this.table);
    }

    void updateConstraints(OrderedHashSet tableSet, OrderedHashSet dropConstraints) {
        for (int i = 0; i < tableSet.size(); ++i) {
            Table t = (Table)tableSet.get(i);
            this.updateConstraints(t, dropConstraints);
        }
    }

    void updateConstraints(Table t, OrderedHashSet dropConstraints) {
        for (int i = t.constraintList.length - 1; i >= 0; --i) {
            Constraint c = t.constraintList[i];
            if (dropConstraints.contains(c.getName())) {
                t.removeConstraint(i);
                continue;
            }
            if (c.getConstraintType() == 0) {
                Table mainT = this.database.schemaManager.getUserTable(this.session, c.core.mainTable.getName());
                Constraint mainC = mainT.getConstraint(c.getMainName().name);
                mainC.core = c.core;
                continue;
            }
            if (c.getConstraintType() != 1) continue;
            Table refT = this.database.schemaManager.getUserTable(this.session, c.core.refTable.getName());
            Constraint refC = refT.getConstraint(c.getRefName().name);
            refC.core = c.core;
        }
    }

    OrderedHashSet makeNewTables(OrderedHashSet tableSet, OrderedHashSet dropConstraintSet, OrderedHashSet dropIndexSet) {
        OrderedHashSet newSet = new OrderedHashSet();
        for (int i = 0; i < tableSet.size(); ++i) {
            Table t = (Table)tableSet.get(i);
            TableWorks tw = new TableWorks(this.session, t);
            tw.makeNewTable(dropConstraintSet, dropIndexSet);
            newSet.add(tw.getTable());
        }
        return newSet;
    }

    void makeNewTable(OrderedHashSet dropConstraintSet, OrderedHashSet dropIndexSet) {
        Table tn = this.table.moveDefinition(this.session, this.table.tableType, null, null, null, -1, 0, dropConstraintSet, dropIndexSet);
        if (tn.indexList.length == this.table.indexList.length) {
            this.database.persistentStoreCollection.releaseStore(tn);
            return;
        }
        tn.moveData(this.session, this.table, -1, 0);
        this.database.persistentStoreCollection.releaseStore(this.table);
        this.table = tn;
    }

    Index addIndex(int[] col, HsqlNameManager.HsqlName name, boolean unique) {
        Index newindex;
        if (this.table.isEmpty(this.session) || this.table.isIndexingMutable()) {
            PersistentStore store = this.session.sessionData.getRowStore(this.table);
            newindex = this.table.createIndex(name, col, null, null, unique, false, false);
        } else {
            newindex = this.table.createIndexStructure(name, col, null, null, unique, false, false);
            Table tn = this.table.moveDefinition(this.session, this.table.tableType, null, null, newindex, -1, 0, this.emptySet, this.emptySet);
            tn.moveData(this.session, this.table, -1, 0);
            this.database.persistentStoreCollection.releaseStore(this.table);
            this.table = tn;
            this.setNewTableInSchema(this.table);
            this.updateConstraints(this.table, this.emptySet);
        }
        this.database.schemaManager.addSchemaObject(newindex);
        this.database.schemaManager.recompileDependentObjects(this.table);
        return newindex;
    }

    void addPrimaryKey(Constraint constraint, HsqlNameManager.HsqlName name) {
        if (this.table.hasPrimaryKey()) {
            throw Error.error(5532);
        }
        this.database.schemaManager.checkSchemaObjectNotExists(name);
        Table tn = this.table.moveDefinition(this.session, this.table.tableType, null, constraint, null, -1, 0, this.emptySet, this.emptySet);
        tn.moveData(this.session, this.table, -1, 0);
        this.database.persistentStoreCollection.releaseStore(this.table);
        this.table = tn;
        this.database.schemaManager.addSchemaObject(constraint);
        this.setNewTableInSchema(this.table);
        this.updateConstraints(this.table, this.emptySet);
        this.database.schemaManager.recompileDependentObjects(this.table);
    }

    void addUniqueConstraint(int[] cols, HsqlNameManager.HsqlName name) {
        this.database.schemaManager.checkSchemaObjectNotExists(name);
        if (this.table.getUniqueConstraintForColumns(cols) != null) {
            throw Error.error(5522);
        }
        HsqlNameManager.HsqlName indexname = this.database.nameManager.newAutoName("IDX", name.name, this.table.getSchemaName(), this.table.getName(), 20);
        Index index = this.table.createIndexStructure(indexname, cols, null, null, true, true, false);
        Constraint constraint = new Constraint(name, this.table, index, 2);
        Table tn = this.table.moveDefinition(this.session, this.table.tableType, null, constraint, index, -1, 0, this.emptySet, this.emptySet);
        tn.moveData(this.session, this.table, -1, 0);
        this.database.persistentStoreCollection.releaseStore(this.table);
        this.table = tn;
        this.database.schemaManager.addSchemaObject(constraint);
        this.setNewTableInSchema(this.table);
        this.updateConstraints(this.table, this.emptySet);
        this.database.schemaManager.recompileDependentObjects(this.table);
    }

    void addCheckConstraint(Constraint c) {
        this.database.schemaManager.checkSchemaObjectNotExists(c.getName());
        c.prepareCheckConstraint(this.session, this.table, true);
        this.table.addConstraint(c);
        if (c.isNotNull()) {
            ColumnSchema column = this.table.getColumn(c.notNullColumnIndex);
            column.setNullable(false);
            this.table.setColumnTypeVars(c.notNullColumnIndex);
        }
        this.database.schemaManager.addSchemaObject(c);
    }

    void dropIndex(String indexName) {
        Index index = this.table.getIndex(indexName);
        if (this.table.isIndexingMutable()) {
            this.table.dropIndex(this.session, indexName);
        } else {
            OrderedHashSet indexSet = new OrderedHashSet();
            indexSet.add(this.table.getIndex(indexName).getName());
            Table tn = this.table.moveDefinition(this.session, this.table.tableType, null, null, null, -1, 0, this.emptySet, indexSet);
            tn.moveData(this.session, this.table, -1, 0);
            this.updateConstraints(tn, this.emptySet);
            this.setNewTableInSchema(tn);
            this.database.persistentStoreCollection.releaseStore(this.table);
            this.table = tn;
        }
        if (!index.isConstraint()) {
            this.database.schemaManager.removeSchemaObject(index.getName());
        }
        this.database.schemaManager.recompileDependentObjects(this.table);
    }

    void dropColumn(int colIndex, boolean cascade) {
        OrderedHashSet constraintNameSet = new OrderedHashSet();
        OrderedHashSet dependentConstraints = this.table.getDependentConstraints(colIndex);
        OrderedHashSet cascadingConstraints = this.table.getContainingConstraints(colIndex);
        OrderedHashSet indexNameSet = this.table.getContainingIndexNames(colIndex);
        HsqlNameManager.HsqlName columnName = this.table.getColumn(colIndex).getName();
        OrderedHashSet referencingObjects = this.database.schemaManager.getReferencingObjects(this.table.getName(), columnName);
        if (this.table.isText() && !this.table.isEmpty(this.session)) {
            throw Error.error(320);
        }
        if (!cascade) {
            int i;
            if (!cascadingConstraints.isEmpty()) {
                Constraint c = (Constraint)cascadingConstraints.get(0);
                HsqlNameManager.HsqlName name = c.getName();
                throw Error.error(5536, name.getSchemaQualifiedStatementName());
            }
            if (!referencingObjects.isEmpty() && (i = 0) < referencingObjects.size()) {
                HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)referencingObjects.get(i);
                throw Error.error(5536, name.getSchemaQualifiedStatementName());
            }
        }
        dependentConstraints.addAll(cascadingConstraints);
        cascadingConstraints.clear();
        OrderedHashSet tableSet = new OrderedHashSet();
        for (int i = 0; i < dependentConstraints.size(); ++i) {
            Constraint c = (Constraint)dependentConstraints.get(i);
            if (c.constType == 0) {
                tableSet.add(c.getMain());
                constraintNameSet.add(c.getMainName());
                constraintNameSet.add(c.getRefName());
                indexNameSet.add(c.getRefIndex().getName());
            }
            if (c.constType == 1) {
                tableSet.add(c.getRef());
                constraintNameSet.add(c.getMainName());
                constraintNameSet.add(c.getRefName());
                indexNameSet.add(c.getRefIndex().getName());
            }
            constraintNameSet.add(c.getName());
        }
        tableSet = this.makeNewTables(tableSet, constraintNameSet, indexNameSet);
        Table tn = this.table.moveDefinition(this.session, this.table.tableType, null, null, null, colIndex, -1, constraintNameSet, indexNameSet);
        tn.moveData(this.session, this.table, colIndex, -1);
        this.database.schemaManager.removeSchemaObjects(referencingObjects);
        this.database.schemaManager.removeSchemaObjects(constraintNameSet);
        this.setNewTableInSchema(tn);
        this.setNewTablesInSchema(tableSet);
        this.updateConstraints(tn, this.emptySet);
        this.updateConstraints(tableSet, constraintNameSet);
        this.database.persistentStoreCollection.releaseStore(this.table);
        this.database.schemaManager.recompileDependentObjects(tableSet);
        this.database.schemaManager.recompileDependentObjects(tn);
        this.table = tn;
    }

    void registerConstraintNames(HsqlArrayList constraints) {
        for (int i = 0; i < constraints.size(); ++i) {
            Constraint c = (Constraint)constraints.get(i);
            switch (c.constType) {
                case 2: 
                case 3: 
                case 4: {
                    this.database.schemaManager.addSchemaObject(c);
                }
            }
        }
    }

    void dropConstraint(String name, boolean cascade) {
        Constraint constraint = this.table.getConstraint(name);
        if (constraint == null) {
            throw Error.error(5501, name);
        }
        switch (constraint.getConstraintType()) {
            case 1: {
                throw Error.error(4002);
            }
            case 2: 
            case 4: {
                OrderedHashSet dependentConstraints = this.table.getDependentConstraints(constraint);
                if (!cascade && !dependentConstraints.isEmpty()) {
                    Constraint c = (Constraint)dependentConstraints.get(0);
                    throw Error.error(5533, c.getName().getSchemaQualifiedStatementName());
                }
                OrderedHashSet tableSet = new OrderedHashSet();
                OrderedHashSet constraintNameSet = new OrderedHashSet();
                OrderedHashSet indexNameSet = new OrderedHashSet();
                for (int i = 0; i < dependentConstraints.size(); ++i) {
                    Constraint c = (Constraint)dependentConstraints.get(i);
                    Table t = c.getMain();
                    if (t != this.table) {
                        tableSet.add(t);
                    }
                    if ((t = c.getRef()) != this.table) {
                        tableSet.add(t);
                    }
                    constraintNameSet.add(c.getMainName());
                    constraintNameSet.add(c.getRefName());
                    indexNameSet.add(c.getRefIndex().getName());
                }
                constraintNameSet.add(constraint.getName());
                if (constraint.getConstraintType() == 2) {
                    indexNameSet.add(constraint.getMainIndex().getName());
                }
                Table tn = this.table.moveDefinition(this.session, this.table.tableType, null, null, null, -1, 0, constraintNameSet, indexNameSet);
                tn.moveData(this.session, this.table, -1, 0);
                tableSet = this.makeNewTables(tableSet, constraintNameSet, indexNameSet);
                if (constraint.getConstraintType() == 4) {
                    int[] cols = constraint.getMainColumns();
                    for (int i = 0; i < cols.length; ++i) {
                        tn.getColumn(cols[i]).setPrimaryKey(false);
                        tn.setColumnTypeVars(cols[i]);
                    }
                }
                this.database.schemaManager.removeSchemaObjects(constraintNameSet);
                this.setNewTableInSchema(tn);
                this.setNewTablesInSchema(tableSet);
                this.updateConstraints(tn, this.emptySet);
                this.updateConstraints(tableSet, constraintNameSet);
                this.database.persistentStoreCollection.releaseStore(this.table);
                this.database.schemaManager.recompileDependentObjects(tableSet);
                this.database.schemaManager.recompileDependentObjects(tn);
                this.table = tn;
                break;
            }
            case 0: {
                OrderedHashSet constraints = new OrderedHashSet();
                Table mainTable = constraint.getMain();
                HsqlNameManager.HsqlName mainName = constraint.getMainName();
                constraints.add(mainName);
                constraints.add(constraint.getRefName());
                OrderedHashSet indexes = new OrderedHashSet();
                indexes.add(constraint.getRefIndex().getName());
                Table tn = this.table.moveDefinition(this.session, this.table.tableType, null, null, null, -1, 0, constraints, indexes);
                tn.moveData(this.session, this.table, -1, 0);
                this.database.schemaManager.removeSchemaObject(constraint.getName());
                this.setNewTableInSchema(tn);
                mainTable.removeConstraint(mainName.name);
                this.updateConstraints(tn, this.emptySet);
                this.database.persistentStoreCollection.releaseStore(this.table);
                this.database.schemaManager.recompileDependentObjects(this.table);
                this.table = tn;
                break;
            }
            case 3: {
                this.database.schemaManager.removeSchemaObject(constraint.getName());
                if (!constraint.isNotNull()) break;
                ColumnSchema column = this.table.getColumn(constraint.notNullColumnIndex);
                column.setNullable(false);
                this.table.setColumnTypeVars(constraint.notNullColumnIndex);
            }
        }
    }

    void retypeColumn(ColumnSchema oldCol, ColumnSchema newCol) {
        boolean allowed = true;
        int oldType = oldCol.getDataType().typeCode;
        int newType = newCol.getDataType().typeCode;
        if (!this.table.isEmpty(this.session) && oldType != newType) {
            allowed = newCol.getDataType().canConvertFrom(oldCol.getDataType());
            switch (oldType) {
                case 30: 
                case 40: 
                case 1111: 
                case 2000: {
                    allowed = false;
                }
            }
        }
        if (!allowed) {
            throw Error.error(5561);
        }
        int colIndex = this.table.getColumnIndex(oldCol.getName().name);
        if (newCol.isIdentity() && this.table.hasIdentityColumn() && this.table.identityColumn != colIndex) {
            throw Error.error(5525);
        }
        if (this.table.getPrimaryKey().length > 1) {
            newCol.setPrimaryKey(oldCol.isPrimaryKey());
            if (ArrayUtil.find(this.table.getPrimaryKey(), colIndex) != -1) {
                // empty if block
            }
        } else if (this.table.hasPrimaryKey()) {
            if (oldCol.isPrimaryKey()) {
                newCol.setPrimaryKey(true);
            } else if (newCol.isPrimaryKey()) {
                throw Error.error(5532);
            }
        } else if (newCol.isPrimaryKey()) {
            throw Error.error(5530);
        }
        boolean meta = newType == oldType;
        meta &= oldCol.isNullable() == newCol.isNullable();
        meta &= oldCol.getDataType().scale == newCol.getDataType().scale;
        meta &= oldCol.isIdentity() == newCol.isIdentity();
        if (meta &= oldCol.getDataType().precision == newCol.getDataType().precision || oldCol.getDataType().precision < newCol.getDataType().precision && (oldType == 12 || oldType == 61)) {
            oldCol.setType(newCol);
            oldCol.setDefaultExpression(newCol.getDefaultExpression());
            if (newCol.isIdentity()) {
                oldCol.setIdentity(newCol.getIdentitySequence());
            }
            this.table.setColumnTypeVars(colIndex);
            this.table.resetDefaultsFlag();
            return;
        }
        this.database.schemaManager.checkColumnIsReferenced(this.table.getName(), this.table.getColumn(colIndex).getName());
        this.table.checkColumnInCheckConstraint(colIndex);
        this.table.checkColumnInFKConstraint(colIndex);
        this.checkConvertColDataType(oldCol, newCol);
        this.retypeColumn(newCol, colIndex);
    }

    void checkConvertColDataType(ColumnSchema oldCol, ColumnSchema newCol) {
        int colIndex = this.table.getColumnIndex(oldCol.getName().name);
        RowIterator it = this.table.rowIterator(this.session);
        while (it.hasNext()) {
            Row row = it.getNextRow();
            Object o = row.getData()[colIndex];
            newCol.getDataType().convertToType(this.session, o, oldCol.getDataType());
        }
    }

    void retypeColumn(ColumnSchema column, int colIndex) {
        if (this.table.isText() && !this.table.isEmpty(this.session)) {
            throw Error.error(320);
        }
        Table tn = this.table.moveDefinition(this.session, this.table.tableType, column, null, null, colIndex, 0, this.emptySet, this.emptySet);
        tn.moveData(this.session, this.table, colIndex, 0);
        this.updateConstraints(tn, this.emptySet);
        this.setNewTableInSchema(tn);
        this.database.persistentStoreCollection.releaseStore(this.table);
        this.database.schemaManager.recompileDependentObjects(this.table);
        this.table = tn;
    }

    void setColNullability(ColumnSchema column, boolean nullable) {
        Constraint c = null;
        int colIndex = this.table.getColumnIndex(column.getName().name);
        if (column.isNullable() == nullable) {
            return;
        }
        if (nullable) {
            if (column.isPrimaryKey()) {
                throw Error.error(5526);
            }
            this.table.checkColumnInFKConstraint(colIndex, 2);
            this.removeColumnNotNullConstraints(colIndex);
        } else {
            HsqlNameManager.HsqlName constName = this.database.nameManager.newAutoName("CT", this.table.getSchemaName(), this.table.getName(), 5);
            c = new Constraint(constName, null, 3);
            c.check = new ExpressionLogical(column);
            c.prepareCheckConstraint(this.session, this.table, true);
            column.setNullable(false);
            this.table.addConstraint(c);
            this.table.setColumnTypeVars(colIndex);
            this.database.schemaManager.addSchemaObject(c);
        }
    }

    void setColDefaultExpression(int colIndex, Expression def) {
        if (def == null) {
            this.table.checkColumnInFKConstraint(colIndex, 4);
        }
        this.table.setDefaultExpression(colIndex, def);
    }

    public boolean setTableType(Session session, int newType) {
        Table tn;
        int currentType = this.table.getTableType();
        if (currentType == newType) {
            return false;
        }
        switch (newType) {
            case 4: {
                break;
            }
            case 3: {
                break;
            }
            default: {
                return false;
            }
        }
        try {
            tn = this.table.moveDefinition(session, newType, null, null, null, -1, 0, this.emptySet, this.emptySet);
            tn.moveData(session, this.table, -1, 0);
            this.updateConstraints(tn, this.emptySet);
        }
        catch (HsqlException e) {
            return false;
        }
        this.setNewTableInSchema(tn);
        this.database.persistentStoreCollection.releaseStore(this.table);
        this.table = tn;
        this.database.schemaManager.recompileDependentObjects(this.table);
        return true;
    }

    void setNewTablesInSchema(OrderedHashSet tableSet) {
        for (int i = 0; i < tableSet.size(); ++i) {
            Table t = (Table)tableSet.get(i);
            this.setNewTableInSchema(t);
        }
    }

    void setNewTableInSchema(Table newTable) {
        int i = this.database.schemaManager.getTableIndex(newTable);
        if (i != -1) {
            this.database.schemaManager.setTable(i, newTable);
        }
    }

    void removeColumnNotNullConstraints(int colIndex) {
        for (int i = this.table.constraintList.length - 1; i >= 0; --i) {
            Constraint c = this.table.constraintList[i];
            if (!c.isNotNull() || c.notNullColumnIndex != colIndex) continue;
            this.database.schemaManager.removeSchemaObject(c.getName());
        }
        ColumnSchema column = this.table.getColumn(colIndex);
        column.setNullable(true);
        this.table.setColumnTypeVars(colIndex);
    }
}

