/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.QueryExpression;
import org.hsqldb.Table;
import org.hsqldb.TableDerived;
import org.hsqldb.TextTable;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.types.Type;

public class TableUtil {
    static Table newTable(Database database, int type, HsqlNameManager.HsqlName tableHsqlName) {
        switch (type) {
            case 5: 
            case 6: {
                return new TextTable(database, tableHsqlName, type);
            }
        }
        return new Table(database, tableHsqlName, type);
    }

    static TableDerived newSubqueryTable(Database database, QueryExpression queryExpression) {
        HsqlNameManager.HsqlName name = database.nameManager.getSubqueryTableName();
        try {
            return new TableDerived(database, name, 1, queryExpression);
        }
        catch (Exception e) {
            return null;
        }
    }

    static Table newLookupTable(Database database) {
        try {
            TableDerived table = TableUtil.newSubqueryTable(database, null);
            ColumnSchema column = new ColumnSchema(HsqlNameManager.getAutoColumnName(0), Type.SQL_INTEGER, false, true, null);
            table.addColumn(column);
            table.createPrimaryKey(new int[]{0});
            return table;
        }
        catch (HsqlException e) {
            return null;
        }
    }

    static void setTableColumnsForSubquery(Table table, QueryExpression queryExpression, boolean fullIndex) {
        table.columnList = queryExpression.getColumns();
        table.columnCount = queryExpression.getColumnCount();
        table.createPrimaryKey();
        if (fullIndex) {
            int[] colIndexes = null;
            colIndexes = table.getNewColumnMap();
            ArrayUtil.fillSequence(colIndexes);
            table.fullIndex = table.createIndexForColumns(colIndexes);
        }
    }

    static void setTableColumnsForSubquery(Table table, Type[] types, boolean fullIndex) {
        TableUtil.addAutoColumns(table, types);
        table.createPrimaryKey();
        if (fullIndex) {
            int[] colIndexes = null;
            colIndexes = table.getNewColumnMap();
            ArrayUtil.fillSequence(colIndexes);
            table.fullIndex = table.createIndexForColumns(colIndexes);
        }
    }

    public static void addAutoColumns(Table table, Type[] colTypes) {
        for (int i = 0; i < colTypes.length; ++i) {
            ColumnSchema column = new ColumnSchema(HsqlNameManager.getAutoColumnName(i), colTypes[i], true, false, null);
            table.addColumnNoCheck(column);
        }
    }

    public static void setColumnsInSchemaTable(Table table, HsqlNameManager.HsqlName[] columnNames, Type[] columnTypes) {
        for (int i = 0; i < columnNames.length; ++i) {
            HsqlNameManager.HsqlName columnName = columnNames[i];
            columnName = table.database.nameManager.newColumnSchemaHsqlName(table.getName(), columnName);
            ColumnSchema column = new ColumnSchema(columnName, columnTypes[i], true, false, null);
            table.addColumn(column);
        }
        table.setColumnStructures();
    }
}

