/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Constraint;
import org.hsqldb.Database;
import org.hsqldb.DatabaseURL;
import org.hsqldb.Expression;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.ParserDQL;
import org.hsqldb.RangeVariable;
import org.hsqldb.Row;
import org.hsqldb.Scanner;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.SqlInvariants;
import org.hsqldb.TableBase;
import org.hsqldb.TextTable;
import org.hsqldb.TriggerDef;
import org.hsqldb.TriggerDefSQL;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.index.IndexAVL;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.OrderedIntHashSet;
import org.hsqldb.lib.Set;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.navigator.RowSetNavigator;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.result.Result;
import org.hsqldb.rights.Grantee;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.LobData;
import org.hsqldb.types.Type;

public class Table
extends TableBase
implements SchemaObject {
    public static final Table[] emptyArray = new Table[0];
    protected HsqlNameManager.HsqlName tableName;
    public HashMappedList columnList;
    int identityColumn;
    NumberSequence identitySequence;
    Constraint[] constraintList;
    Constraint[] fkPath;
    Constraint[] fkConstraints;
    Constraint[] fkMainConstraints;
    Constraint[] checkConstraints;
    TriggerDef[] triggerList;
    TriggerDef[][] triggerLists;
    Expression[] colDefaults;
    boolean[] colGenerated;
    protected int[] defaultColumnMap;
    private boolean hasDefaultValues;
    RangeVariable[] defaultRanges;

    public Table(Database database, HsqlNameManager.HsqlName name, int type) {
        this.database = database;
        this.tableName = name;
        this.persistenceId = database.persistentStoreCollection.getNextId();
        switch (type) {
            case 1: {
                this.persistenceScope = 11;
                this.isSessionBased = true;
                break;
            }
            case 0: {
                this.persistenceScope = 14;
                this.isSchemaBased = true;
                break;
            }
            case 4: {
                if (DatabaseURL.isFileBasedDatabaseType(database.getType())) {
                    this.persistenceScope = 14;
                    this.isSchemaBased = true;
                    this.isCached = true;
                    this.isLogged = !database.isFilesReadOnly();
                    break;
                }
                type = 3;
            }
            case 3: {
                this.persistenceScope = 14;
                this.isSchemaBased = true;
                this.isLogged = !database.isFilesReadOnly();
                break;
            }
            case 2: {
                this.persistenceScope = 12;
                this.isTemp = true;
                this.isSchemaBased = true;
                this.isSessionBased = true;
                break;
            }
            case 5: {
                this.persistenceScope = 13;
                if (!DatabaseURL.isFileBasedDatabaseType(database.getType())) {
                    throw Error.error(63);
                }
                this.isSchemaBased = true;
                this.isSessionBased = true;
                this.isTemp = true;
                this.isText = true;
                this.isReadOnly = true;
                break;
            }
            case 6: {
                this.persistenceScope = 14;
                if (!DatabaseURL.isFileBasedDatabaseType(database.getType())) {
                    throw Error.error(63);
                }
                this.isSchemaBased = true;
                this.isText = true;
                break;
            }
            case 7: {
                this.persistenceScope = 11;
                this.isSchemaBased = true;
                this.isSessionBased = true;
                this.isView = true;
                break;
            }
            case 8: {
                this.persistenceScope = 13;
                this.isSessionBased = true;
                break;
            }
            default: {
                throw Error.runtimeError(401, "Table");
            }
        }
        this.tableType = type;
        this.primaryKeyCols = null;
        this.primaryKeyTypes = null;
        this.identityColumn = -1;
        this.columnList = new HashMappedList();
        this.indexList = Index.emptyArray;
        this.constraintList = Constraint.emptyArray;
        this.fkPath = Constraint.emptyArray;
        this.fkConstraints = Constraint.emptyArray;
        this.fkMainConstraints = Constraint.emptyArray;
        this.checkConstraints = Constraint.emptyArray;
        this.triggerList = TriggerDef.emptyArray;
        this.triggerLists = new TriggerDef[9][];
        for (int i = 0; i < 9; ++i) {
            this.triggerLists[i] = TriggerDef.emptyArray;
        }
        if (database.isFilesReadOnly() && this.isFileBased()) {
            this.isReadOnly = true;
        }
        if (!this.isTemp) {
            this.createDefaultStore();
        }
    }

    public Table(Table table, HsqlNameManager.HsqlName name) {
        this.persistenceScope = 11;
        name.schema = SqlInvariants.SYSTEM_SCHEMA_HSQLNAME;
        this.tableName = name;
        this.database = table.database;
        this.tableType = 8;
        this.columnList = table.columnList;
        this.columnCount = table.columnCount;
        this.indexList = Index.emptyArray;
        this.constraintList = Constraint.emptyArray;
        this.createPrimaryKey();
    }

    public void createDefaultStore() {
        this.store = this.database.logger.newStore(null, this.database.persistentStoreCollection, this, true);
    }

    @Override
    public int getType() {
        return 3;
    }

    @Override
    public final HsqlNameManager.HsqlName getName() {
        return this.tableName;
    }

    @Override
    public HsqlNameManager.HsqlName getCatalogName() {
        return this.database.getCatalogName();
    }

    @Override
    public HsqlNameManager.HsqlName getSchemaName() {
        return this.tableName.schema;
    }

    @Override
    public Grantee getOwner() {
        return this.tableName.schema.owner;
    }

    @Override
    public OrderedHashSet getReferences() {
        OrderedHashSet set = new OrderedHashSet();
        for (int i = 0; i < this.colTypes.length; ++i) {
            if (!this.colTypes[i].isDomainType() && !this.colTypes[i].isDistinctType()) continue;
            HsqlNameManager.HsqlName name = this.colTypes[i].getName();
            set.add(name);
        }
        return set;
    }

    @Override
    public OrderedHashSet getComponents() {
        OrderedHashSet set = new OrderedHashSet();
        set.addAll(this.constraintList);
        set.addAll(this.triggerList);
        for (int i = 0; i < this.indexList.length; ++i) {
            if (this.indexList[i].isConstraint()) continue;
            set.add(this.indexList[i]);
        }
        return set;
    }

    @Override
    public void compile(Session session, SchemaObject parentObject) {
        for (int i = 0; i < this.columnCount; ++i) {
            ColumnSchema column = this.getColumn(i);
            column.compile(session, this);
        }
    }

    String[] getSQL(OrderedHashSet resolved, OrderedHashSet unresolved) {
        for (int i = 0; i < this.constraintList.length; ++i) {
            Constraint c = this.constraintList[i];
            if (c.isForward) {
                unresolved.add(c);
                continue;
            }
            if (c.getConstraintType() != 2 && c.getConstraintType() != 4) continue;
            resolved.add(c.getName());
        }
        HsqlArrayList list = new HsqlArrayList();
        list.add(this.getSQL());
        if (!this.isTemp && !this.isText && this.hasIdentityColumn()) {
            list.add(NumberSequence.getRestartSQL(this));
        }
        for (int i = 0; i < this.indexList.length; ++i) {
            if (this.indexList[i].isConstraint()) continue;
            list.add(this.indexList[i].getSQL());
        }
        String[] array = new String[list.size()];
        list.toArray(array);
        return array;
    }

    String[] getSQLForTextSource(boolean withHeader) {
        if (this.isText()) {
            String dataSource;
            HsqlArrayList list = new HsqlArrayList();
            boolean readonly = this.isDataReadOnly();
            if (readonly) {
                StringBuffer sb = new StringBuffer(64);
                sb.append("SET").append(' ').append("TABLE").append(' ');
                sb.append(this.getName().getSchemaQualifiedStatementName());
                sb.append(' ').append("READ").append(' ');
                sb.append("ONLY");
                list.add(sb.toString());
            }
            if ((dataSource = ((TextTable)this).getDataSourceDDL()) != null) {
                list.add(dataSource);
            }
            String header = ((TextTable)this).getDataSourceHeader();
            if (withHeader && header != null && !readonly) {
                list.add(header);
            }
            String[] array = new String[list.size()];
            list.toArray(array);
            return array;
        }
        return null;
    }

    String[] getTriggerSQL() {
        String[] array = new String[this.triggerList.length];
        for (int i = 0; i < this.triggerList.length; ++i) {
            array[i] = this.triggerList[i].getSQL();
        }
        return array;
    }

    @Override
    public String getSQL() {
        StringBuffer sb = new StringBuffer();
        sb.append("CREATE").append(' ');
        if (this.isTemp()) {
            sb.append("GLOBAL").append(' ');
            sb.append("TEMPORARY").append(' ');
        } else if (this.isText()) {
            sb.append("TEXT").append(' ');
        } else if (this.isCached()) {
            sb.append("CACHED").append(' ');
        } else {
            sb.append("MEMORY").append(' ');
        }
        sb.append("TABLE").append(' ');
        sb.append(this.getName().getSchemaQualifiedStatementName());
        sb.append('(');
        int columns = this.getColumnCount();
        int[] pk = this.getPrimaryKey();
        Constraint pkConst = this.getPrimaryConstraint();
        for (int j = 0; j < columns; ++j) {
            ColumnSchema column = this.getColumn(j);
            String colname = column.getName().statementName;
            Type type = column.getDataType();
            if (j > 0) {
                sb.append(',');
            }
            sb.append(colname);
            sb.append(' ');
            sb.append(type.getTypeDefinition());
            String defaultString = column.getDefaultSQL();
            if (defaultString != null) {
                sb.append(' ').append("DEFAULT").append(' ');
                sb.append(defaultString);
            }
            if (column.isIdentity()) {
                sb.append(' ').append(column.getIdentitySequence().getSQL());
            }
            if (!column.isNullable()) {
                Constraint c = this.getNotNullConstraintForColumn(j);
                if (c != null && !c.getName().isReservedName()) {
                    sb.append(' ').append("CONSTRAINT").append(' ').append(c.getName().statementName);
                }
                sb.append(' ').append("NOT").append(' ').append("NULL");
            }
            if (column.isGenerated()) {
                sb.append(' ').append("GENERATED").append(' ');
                sb.append("ALWAYS").append(' ').append("AS").append("(");
                sb.append(column.getGeneratingExpression().getSQL());
                sb.append(")");
            }
            if (pk.length != 1 || j != pk[0] || !pkConst.getName().isReservedName()) continue;
            sb.append(' ').append("PRIMARY").append(' ').append("KEY");
        }
        for (Constraint c : this.getConstraints()) {
            String d;
            if (c.isForward || (d = c.getSQL()).length() <= 0) continue;
            sb.append(',');
            sb.append(d);
        }
        sb.append(')');
        if (this.onCommitPreserve()) {
            sb.append(' ').append("ON").append(' ');
            sb.append("COMMIT").append(' ').append("PRESERVE");
            sb.append(' ').append("ROWS");
        }
        return sb.toString();
    }

    public String getIndexRootsSQL(int[] roots) {
        StringBuffer sb = new StringBuffer(128);
        sb.append("SET").append(' ').append("TABLE").append(' ');
        sb.append(this.getName().getSchemaQualifiedStatementName());
        sb.append(' ').append("INDEX").append(' ').append('\'');
        sb.append(Table.getIndexRoots(roots));
        sb.append('\'');
        return sb.toString();
    }

    @Override
    public int getId() {
        return this.tableName.hashCode();
    }

    public final boolean isText() {
        return this.isText;
    }

    public final boolean isTemp() {
        return this.isTemp;
    }

    public final boolean isReadOnly() {
        return this.isReadOnly;
    }

    public final boolean isView() {
        return this.isView;
    }

    public boolean isCached() {
        return this.isCached;
    }

    public boolean isDataReadOnly() {
        return this.isReadOnly;
    }

    final boolean isIndexingMutable() {
        return !this.isIndexCached();
    }

    boolean isIndexCached() {
        return this.isCached;
    }

    void checkDataReadOnly() {
        if (this.isReadOnly) {
            throw Error.error(32);
        }
    }

    public void setDataReadOnly(boolean value) {
        if (!value && this.database.isFilesReadOnly() && this.isFileBased()) {
            throw Error.error(32);
        }
        this.isReadOnly = value;
    }

    public boolean isFileBased() {
        return this.isCached || this.isText;
    }

    public void addConstraint(Constraint c) {
        int index = c.getConstraintType() == 4 ? 0 : this.constraintList.length;
        this.constraintList = (Constraint[])ArrayUtil.toAdjustedArray(this.constraintList, c, index, 1);
        this.updateConstraintLists();
    }

    void updateConstraintPath() {
        if (this.fkMainConstraints.length == 0) {
            return;
        }
        OrderedHashSet list = new OrderedHashSet();
        this.getConstraintPath(this.defaultColumnMap, list);
        if (list.size() == 0) {
            return;
        }
        this.fkPath = new Constraint[list.size()];
        list.toArray(this.fkPath);
        this.verifyConstraintsIntegrity();
    }

    void updateConstraintLists() {
        int i;
        int fkCount = 0;
        int mainCount = 0;
        int checkCount = 0;
        block10: for (i = 0; i < this.constraintList.length; ++i) {
            switch (this.constraintList[i].getConstraintType()) {
                case 0: {
                    ++fkCount;
                    continue block10;
                }
                case 1: {
                    ++mainCount;
                    continue block10;
                }
                case 3: {
                    if (this.constraintList[i].isNotNull()) continue block10;
                    ++checkCount;
                }
            }
        }
        this.fkConstraints = fkCount == 0 ? Constraint.emptyArray : new Constraint[fkCount];
        fkCount = 0;
        this.fkMainConstraints = mainCount == 0 ? Constraint.emptyArray : new Constraint[mainCount];
        mainCount = 0;
        this.checkConstraints = checkCount == 0 ? Constraint.emptyArray : new Constraint[checkCount];
        checkCount = 0;
        block11: for (i = 0; i < this.constraintList.length; ++i) {
            switch (this.constraintList[i].getConstraintType()) {
                case 0: {
                    this.fkConstraints[fkCount] = this.constraintList[i];
                    ++fkCount;
                    continue block11;
                }
                case 1: {
                    this.fkMainConstraints[mainCount] = this.constraintList[i];
                    ++mainCount;
                    continue block11;
                }
                case 3: {
                    if (this.constraintList[i].isNotNull()) continue block11;
                    this.checkConstraints[checkCount] = this.constraintList[i];
                    ++checkCount;
                }
            }
        }
    }

    void verifyConstraintsIntegrity() {
        for (int i = 0; i < this.constraintList.length; ++i) {
            Constraint c = this.constraintList[i];
            if (c.getConstraintType() == 3) continue;
            if (c.getMain() != null && c.getMain() != this.database.schemaManager.getUserTable(null, c.getMain().getName())) {
                throw Error.runtimeError(401, "table constraint");
            }
            if (c.getRef() == null || c.getRef() == this.database.schemaManager.getUserTable(null, c.getRef().getName())) continue;
            throw Error.runtimeError(401, "table constraint");
        }
    }

    public Constraint[] getConstraints() {
        return this.constraintList;
    }

    public Constraint getPrimaryConstraint() {
        return this.primaryKeyCols.length == 0 ? null : this.constraintList[0];
    }

    void getConstraintPath(int[] columnMap, OrderedHashSet list) {
        for (int i = 0; i < this.constraintList.length; ++i) {
            int[] mainColumns;
            if (!this.constraintList[i].hasTriggeredAction() || ArrayUtil.countCommonElements(columnMap, mainColumns = this.constraintList[i].getMainColumns()) <= 0 || !list.add(this.constraintList[i])) continue;
            this.constraintList[i].getRef().getConstraintPath(this.constraintList[i].getRefColumns(), list);
        }
    }

    Constraint getNotNullConstraintForColumn(int colIndex) {
        for (Constraint c : this.constraintList) {
            if (!c.isNotNull() || c.notNullColumnIndex != colIndex) continue;
            return c;
        }
        return null;
    }

    Constraint getUniqueConstraintForColumns(int[] cols) {
        for (Constraint c : this.constraintList) {
            if (!c.isUniqueWithColumns(cols)) continue;
            return c;
        }
        return null;
    }

    Constraint getUniqueConstraintForColumns(int[] mainTableCols, int[] refTableCols) {
        for (Constraint c : this.constraintList) {
            int j;
            int[] constraintCols;
            int type = c.getConstraintType();
            if (type != 2 && type != 4 || (constraintCols = c.getMainColumns()).length != mainTableCols.length) continue;
            if (ArrayUtil.areEqual(constraintCols, mainTableCols, mainTableCols.length, true)) {
                return c;
            }
            if (!ArrayUtil.areEqualSets(constraintCols, mainTableCols)) continue;
            int[] newRefTableCols = new int[mainTableCols.length];
            for (j = 0; j < mainTableCols.length; ++j) {
                int pos = ArrayUtil.find(constraintCols, mainTableCols[j]);
                newRefTableCols[pos] = refTableCols[j];
            }
            for (j = 0; j < mainTableCols.length; ++j) {
                refTableCols[j] = newRefTableCols[j];
            }
            return c;
        }
        return null;
    }

    Constraint getFKConstraintForColumns(Table tableMain, int[] mainCols, int[] refCols) {
        for (Constraint c : this.constraintList) {
            if (!c.isEquivalent(tableMain, mainCols, this, refCols)) continue;
            return c;
        }
        return null;
    }

    public Constraint getUniqueOrPKConstraintForIndex(Index index) {
        for (Constraint c : this.constraintList) {
            if (c.getMainIndex() != index || c.getConstraintType() != 2 && c.getConstraintType() != 4) continue;
            return c;
        }
        return null;
    }

    int getNextConstraintIndex(int from, int type) {
        int size = this.constraintList.length;
        for (int i = from; i < size; ++i) {
            Constraint c = this.constraintList[i];
            if (c.getConstraintType() != type) continue;
            return i;
        }
        return -1;
    }

    public void addColumn(ColumnSchema column) {
        String name = column.getName().name;
        if (this.findColumn(name) >= 0) {
            throw Error.error(5504, name);
        }
        if (column.isIdentity()) {
            if (this.identityColumn != -1) {
                throw Error.error(5525, name);
            }
            this.identityColumn = this.getColumnCount();
            this.identitySequence = column.getIdentitySequence();
        }
        this.addColumnNoCheck(column);
    }

    public void addColumnNoCheck(ColumnSchema column) {
        if (this.primaryKeyCols != null) {
            throw Error.runtimeError(401, "Table");
        }
        this.columnList.add(column.getName().name, column);
        ++this.columnCount;
        if (column.getDataType().isLobType()) {
            this.hasLobColumn = true;
        }
    }

    public boolean hasIdentityColumn() {
        return this.identityColumn != -1;
    }

    public long getNextIdentity() {
        return this.identitySequence.peek();
    }

    void checkColumnsMatch(int[] col, Table other, int[] othercol) {
        for (int i = 0; i < col.length; ++i) {
            Type type = this.colTypes[col[i]];
            Type otherType = other.colTypes[othercol[i]];
            if (type.typeComparisonGroup == otherType.typeComparisonGroup) continue;
            throw Error.error(5562);
        }
    }

    void checkColumnsMatch(ColumnSchema column, int colIndex) {
        Type type = this.colTypes[colIndex];
        Type otherType = column.getDataType();
        if (type.typeComparisonGroup != otherType.typeComparisonGroup) {
            throw Error.error(5562);
        }
    }

    Table moveDefinition(Session session, int newType, ColumnSchema column, Constraint constraint, Index index, int colIndex, int adjust, OrderedHashSet dropConstraints, OrderedHashSet dropIndexes) {
        boolean newPK = false;
        if (constraint != null && constraint.constType == 4) {
            newPK = true;
        }
        Table tn = new Table(this.database, this.tableName, newType);
        if (this.tableType == 2) {
            tn.persistenceScope = this.persistenceScope;
        }
        for (int i = 0; i < this.getColumnCount(); ++i) {
            ColumnSchema col = (ColumnSchema)this.columnList.get(i);
            if (i == colIndex) {
                if (column != null) {
                    tn.addColumn(column);
                }
                if (adjust <= 0) continue;
            }
            tn.addColumn(col);
        }
        if (this.getColumnCount() == colIndex) {
            tn.addColumn(column);
        }
        int[] pkCols = null;
        if (this.hasPrimaryKey() && !dropConstraints.contains(this.getPrimaryConstraint().getName())) {
            pkCols = this.primaryKeyCols;
            pkCols = ArrayUtil.toAdjustedColumnArray(pkCols, colIndex, adjust);
        } else if (newPK) {
            pkCols = constraint.getMainColumns();
        }
        tn.createPrimaryKey(this.getIndex(0).getName(), pkCols, false);
        for (int i = 1; i < this.indexList.length; ++i) {
            Index idx = this.indexList[i];
            if (dropIndexes.contains(idx.getName())) continue;
            int[] colarr = ArrayUtil.toAdjustedColumnArray(idx.getColumns(), colIndex, adjust);
            idx = tn.createIndexStructure(idx.getName(), colarr, idx.getColumnDesc(), null, idx.isUnique(), idx.isConstraint(), idx.isForward());
            tn.addIndex(idx);
        }
        if (index != null) {
            tn.addIndex(index);
        }
        HsqlArrayList newList = new HsqlArrayList();
        if (newPK) {
            constraint.core.mainIndex = tn.indexList[0];
            constraint.core.mainTable = tn;
            constraint.core.mainTableName = tn.tableName;
            newList.add(constraint);
        }
        for (int i = 0; i < this.constraintList.length; ++i) {
            Constraint c = this.constraintList[i];
            if (dropConstraints.contains(c.getName())) continue;
            c = c.duplicate();
            c.updateTable(session, this, tn, colIndex, adjust);
            newList.add(c);
        }
        if (!newPK && constraint != null) {
            constraint.updateTable(session, this, tn, -1, 0);
            newList.add(constraint);
        }
        tn.constraintList = new Constraint[newList.size()];
        newList.toArray(tn.constraintList);
        tn.updateConstraintLists();
        tn.setBestRowIdentifiers();
        tn.triggerList = this.triggerList;
        tn.triggerLists = this.triggerLists;
        return tn;
    }

    void checkColumnInCheckConstraint(int colIndex) {
        for (Constraint c : this.constraintList) {
            if (c.constType != 3 || c.isNotNull() || !c.hasColumn(colIndex)) continue;
            HsqlNameManager.HsqlName name = c.getName();
            throw Error.error(5502, name.getSchemaQualifiedStatementName());
        }
    }

    void checkColumnInFKConstraint(int colIndex) {
        for (Constraint c : this.constraintList) {
            if (!c.hasColumn(colIndex) || c.getConstraintType() != 1 && c.getConstraintType() != 0) continue;
            HsqlNameManager.HsqlName name = c.getName();
            throw Error.error(5533, name.getSchemaQualifiedStatementName());
        }
    }

    OrderedHashSet getDependentConstraints(int colIndex) {
        OrderedHashSet set = new OrderedHashSet();
        for (Constraint c : this.constraintList) {
            if (!c.hasColumnOnly(colIndex)) continue;
            set.add(c);
        }
        return set;
    }

    OrderedHashSet getContainingConstraints(int colIndex) {
        OrderedHashSet set = new OrderedHashSet();
        for (Constraint c : this.constraintList) {
            if (!c.hasColumnPlus(colIndex)) continue;
            set.add(c);
        }
        return set;
    }

    OrderedHashSet getContainingIndexNames(int colIndex) {
        OrderedHashSet set = new OrderedHashSet();
        for (Index index : this.indexList) {
            if (ArrayUtil.find(index.getColumns(), colIndex) == -1) continue;
            set.add(index.getName());
        }
        return set;
    }

    OrderedHashSet getDependentConstraints(Constraint constraint) {
        OrderedHashSet set = new OrderedHashSet();
        for (Constraint c : this.constraintList) {
            if (c.getConstraintType() != 1 || c.core.uniqueName != constraint.getName()) continue;
            set.add(c);
        }
        return set;
    }

    public OrderedHashSet getDependentExternalConstraints() {
        OrderedHashSet set = new OrderedHashSet();
        for (Constraint c : this.constraintList) {
            if (c.getConstraintType() != 1 && c.getConstraintType() != 0 || c.core.mainTable == c.core.refTable) continue;
            set.add(c);
        }
        return set;
    }

    void checkColumnInFKConstraint(int colIndex, int actionType) {
        for (Constraint c : this.constraintList) {
            if (c.getConstraintType() != 0 || !c.hasColumn(colIndex) || actionType != c.getUpdateAction() && actionType != c.getDeleteAction()) continue;
            HsqlNameManager.HsqlName name = c.getName();
            throw Error.error(5533, name.getSchemaQualifiedStatementName());
        }
    }

    int getIdentityColumnIndex() {
        return this.identityColumn;
    }

    public int getColumnIndex(String name) {
        int i = this.findColumn(name);
        if (i == -1) {
            throw Error.error(5501, name);
        }
        return i;
    }

    public int findColumn(String name) {
        int index = this.columnList.getIndex(name);
        return index;
    }

    void setDefaultExpression(int columnIndex, Expression def) {
        ColumnSchema column = this.getColumn(columnIndex);
        column.setDefaultExpression(def);
        this.setColumnTypeVars(columnIndex);
    }

    void resetDefaultsFlag() {
        this.hasDefaultValues = false;
        for (int i = 0; i < this.colDefaults.length; ++i) {
            this.hasDefaultValues = this.hasDefaultValues || this.colDefaults[i] != null;
        }
    }

    public int[] getBestRowIdentifiers() {
        return this.bestRowIdentifierCols;
    }

    public boolean isBestRowIdentifiersStrict() {
        return this.bestRowIdentifierStrict;
    }

    Index getIndexForColumn(int col) {
        int i = this.bestIndexForColumn[col];
        return i == -1 ? null : this.indexList[i];
    }

    boolean isIndexed(int colIndex) {
        return this.bestIndexForColumn[colIndex] != -1;
    }

    int[] getUniqueNotNullColumnGroup(boolean[] usedColumns) {
        for (Constraint constraint : this.constraintList) {
            int[] indexCols;
            if (!(constraint.constType == 2 ? ArrayUtil.areIntIndexesInBooleanArray(indexCols = constraint.getMainColumns(), this.colNotNull) && ArrayUtil.areIntIndexesInBooleanArray(indexCols, usedColumns) : constraint.constType == 4 && ArrayUtil.areIntIndexesInBooleanArray(indexCols = constraint.getMainColumns(), usedColumns))) continue;
            return indexCols;
        }
        return null;
    }

    boolean areColumnsNotNull(int[] indexes) {
        return ArrayUtil.areIntIndexesInBooleanArray(indexes, this.colNotNull);
    }

    void createPrimaryKey(int[] cols) {
        this.createPrimaryKey(null, cols, false);
    }

    public void createPrimaryKey() {
        this.createPrimaryKey(null, null, false);
    }

    public void createPrimaryKey(HsqlNameManager.HsqlName indexName, int[] columns, boolean columnsNotNull) {
        if (this.primaryKeyCols != null) {
            throw Error.runtimeError(401, "Table");
        }
        if (columns == null) {
            columns = ValuePool.emptyIntArray;
        } else {
            for (int i = 0; i < columns.length; ++i) {
                this.getColumn(columns[i]).setPrimaryKey(true);
            }
        }
        this.primaryKeyCols = columns;
        this.setColumnStructures();
        this.primaryKeyTypes = new Type[this.primaryKeyCols.length];
        ArrayUtil.projectRow(this.colTypes, this.primaryKeyCols, this.primaryKeyTypes);
        this.primaryKeyColsSequence = new int[this.primaryKeyCols.length];
        ArrayUtil.fillSequence(this.primaryKeyColsSequence);
        HsqlNameManager.HsqlName name = indexName;
        if (name == null) {
            name = this.database.nameManager.newAutoName("IDX", this.getSchemaName(), this.getName(), 20);
        }
        this.createPrimaryIndex(this.primaryKeyCols, this.primaryKeyTypes, name);
        this.setBestRowIdentifiers();
    }

    void setColumnStructures() {
        this.colTypes = new Type[this.columnCount];
        this.colDefaults = new Expression[this.columnCount];
        this.colNotNull = new boolean[this.columnCount];
        this.colGenerated = new boolean[this.columnCount];
        this.defaultColumnMap = new int[this.columnCount];
        for (int i = 0; i < this.columnCount; ++i) {
            this.setColumnTypeVars(i);
        }
        this.resetDefaultsFlag();
        this.defaultRanges = new RangeVariable[]{new RangeVariable(this, 1)};
    }

    void setColumnTypeVars(int i) {
        ColumnSchema column = this.getColumn(i);
        this.colTypes[i] = column.getDataType();
        this.colNotNull[i] = column.isPrimaryKey() || !column.isNullable();
        this.defaultColumnMap[i] = i;
        if (column.isIdentity()) {
            this.identitySequence = column.getIdentitySequence();
            this.identityColumn = i;
        } else if (this.identityColumn == i) {
            this.identityColumn = -1;
        }
        this.colDefaults[i] = column.getDefaultExpression();
        this.colGenerated[i] = column.isGenerated();
        this.resetDefaultsFlag();
    }

    int[] getColumnMap() {
        return this.defaultColumnMap;
    }

    int[] getNewColumnMap() {
        return new int[this.getColumnCount()];
    }

    boolean[] getColumnCheckList(int[] columnIndexes) {
        boolean[] columnCheckList = new boolean[this.getColumnCount()];
        for (int i = 0; i < columnIndexes.length; ++i) {
            int index = columnIndexes[i];
            if (index <= -1) continue;
            columnCheckList[index] = true;
        }
        return columnCheckList;
    }

    int[] getColumnIndexes(OrderedHashSet set) {
        int[] cols = new int[set.size()];
        for (int i = 0; i < cols.length; ++i) {
            cols[i] = this.getColumnIndex((String)set.get(i));
        }
        return cols;
    }

    int[] getColumnIndexes(HashMappedList list) {
        int[] cols = new int[list.size()];
        for (int i = 0; i < cols.length; ++i) {
            cols[i] = (Integer)list.get(i);
        }
        return cols;
    }

    public ColumnSchema getColumn(int i) {
        return (ColumnSchema)this.columnList.get(i);
    }

    public OrderedHashSet getColumnNameSet(int[] columnIndexes) {
        OrderedHashSet set = new OrderedHashSet();
        for (int i = 0; i < columnIndexes.length; ++i) {
            set.add(((ColumnSchema)this.columnList.get(i)).getName());
        }
        return set;
    }

    public OrderedHashSet getColumnNameSet(boolean[] columnCheckList) {
        OrderedHashSet set = new OrderedHashSet();
        for (int i = 0; i < columnCheckList.length; ++i) {
            if (!columnCheckList[i]) continue;
            set.add(this.columnList.get(i));
        }
        return set;
    }

    public void getColumnNames(boolean[] columnCheckList, Set set) {
        for (int i = 0; i < columnCheckList.length; ++i) {
            if (!columnCheckList[i]) continue;
            set.add(((ColumnSchema)this.columnList.get(i)).getName());
        }
    }

    public OrderedHashSet getColumnNameSet() {
        OrderedHashSet set = new OrderedHashSet();
        for (int i = 0; i < this.getColumnCount(); ++i) {
            set.add(((ColumnSchema)this.columnList.get(i)).getName());
        }
        return set;
    }

    Object[] getNewRowData(Session session) {
        Object[] data = new Object[this.getColumnCount()];
        if (this.hasDefaultValues) {
            for (int i = 0; i < this.getColumnCount(); ++i) {
                Expression def = this.colDefaults[i];
                if (def == null) continue;
                data[i] = def.getValue(session, this.colTypes[i]);
            }
        }
        return data;
    }

    boolean hasTrigger(int trigVecIndex) {
        return this.triggerLists[trigVecIndex].length != 0;
    }

    void addTrigger(TriggerDef td, HsqlNameManager.HsqlName otherName) {
        int pos;
        int index = this.triggerList.length;
        if (otherName != null && (pos = this.getTriggerIndex(otherName.name)) != -1) {
            index = pos + 1;
        }
        this.triggerList = (TriggerDef[])ArrayUtil.toAdjustedArray(this.triggerList, td, index, 1);
        TriggerDef[] list = this.triggerLists[td.triggerType];
        index = list.length;
        if (otherName != null) {
            for (int i = 0; i < list.length; ++i) {
                TriggerDef trigger = list[i];
                if (!trigger.name.name.equals(otherName.name)) continue;
                index = i + 1;
                break;
            }
        }
        list = (TriggerDef[])ArrayUtil.toAdjustedArray(list, td, index, 1);
        this.triggerLists[td.triggerType] = list;
    }

    TriggerDef getTrigger(String name) {
        for (int i = this.triggerList.length - 1; i >= 0; --i) {
            if (!this.triggerList[i].name.name.equals(name)) continue;
            return this.triggerList[i];
        }
        return null;
    }

    public int getTriggerIndex(String name) {
        for (int i = 0; i < this.triggerList.length; ++i) {
            if (!this.triggerList[i].name.name.equals(name)) continue;
            return i;
        }
        return -1;
    }

    void removeTrigger(String name) {
        TriggerDef td = null;
        for (int i = 0; i < this.triggerList.length; ++i) {
            td = this.triggerList[i];
            if (!td.name.name.equals(name)) continue;
            td.terminate();
            this.triggerList = (TriggerDef[])ArrayUtil.toAdjustedArray(this.triggerList, null, i, -1);
            break;
        }
        if (td == null) {
            return;
        }
        int index = td.triggerType;
        for (int j = 0; j < this.triggerLists[index].length; ++j) {
            td = this.triggerLists[index][j];
            if (!td.name.name.equals(name)) continue;
            td.terminate();
            this.triggerLists[index] = (TriggerDef[])ArrayUtil.toAdjustedArray(this.triggerLists[index], null, j, -1);
            break;
        }
    }

    void releaseTriggers() {
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < this.triggerLists[i].length; ++j) {
                this.triggerLists[i][j].terminate();
            }
            this.triggerLists[i] = TriggerDef.emptyArray;
        }
    }

    int getIndexIndex(String indexName) {
        Index[] indexes = this.indexList;
        for (int i = 0; i < indexes.length; ++i) {
            if (!indexName.equals(indexes[i].getName().name)) continue;
            return i;
        }
        return -1;
    }

    Index getIndex(String indexName) {
        Index[] indexes = this.indexList;
        int i = this.getIndexIndex(indexName);
        return i == -1 ? null : indexes[i];
    }

    int getConstraintIndex(String constraintName) {
        int size = this.constraintList.length;
        for (int i = 0; i < size; ++i) {
            if (!this.constraintList[i].getName().name.equals(constraintName)) continue;
            return i;
        }
        return -1;
    }

    public Constraint getConstraint(String constraintName) {
        int i = this.getConstraintIndex(constraintName);
        return i < 0 ? null : this.constraintList[i];
    }

    void removeConstraint(String name) {
        int index = this.getConstraintIndex(name);
        if (index != -1) {
            this.removeConstraint(index);
        }
    }

    void removeConstraint(int index) {
        this.constraintList = (Constraint[])ArrayUtil.toAdjustedArray(this.constraintList, null, index, -1);
        this.updateConstraintLists();
    }

    void renameColumn(ColumnSchema column, String newName, boolean isquoted) {
        String oldname = column.getName().name;
        int i = this.getColumnIndex(oldname);
        this.columnList.setKey(i, newName);
        column.getName().rename(newName, isquoted);
    }

    void renameColumn(ColumnSchema column, HsqlNameManager.HsqlName newName) {
        String oldname = column.getName().name;
        int i = this.getColumnIndex(oldname);
        if (this.findColumn(newName.name) != -1) {
            throw Error.error(5504);
        }
        this.columnList.setKey(i, newName.name);
        column.getName().rename(newName);
    }

    public TriggerDef[] getTriggers() {
        return this.triggerList;
    }

    public boolean isWritable() {
        return !this.isReadOnly && !this.database.databaseReadOnly && (!this.database.isFilesReadOnly() || !this.isCached && !this.isText);
    }

    public boolean isInsertable() {
        return this.isWritable();
    }

    public boolean isUpdatable() {
        return this.isWritable();
    }

    public int[] getUpdatableColumns() {
        return this.defaultColumnMap;
    }

    public Table getBaseTable() {
        return this;
    }

    public int[] getBaseTableColumnMap() {
        return this.defaultColumnMap;
    }

    Index createIndexForColumns(int[] columns) {
        HsqlNameManager.HsqlName indexName = this.database.nameManager.newAutoName("IDX_T", this.getSchemaName(), this.getName(), 20);
        try {
            Index index = this.createAndAddIndexStructure(indexName, columns, null, null, false, false, false);
            return index;
        }
        catch (Throwable t) {
            return null;
        }
    }

    void fireTriggers(Session session, int trigVecIndex, HashMappedList rowSet) {
        for (TriggerDef td : this.triggerLists[trigVecIndex]) {
            boolean sqlTrigger = td instanceof TriggerDefSQL;
            if (td.isForEachRow()) {
                for (int j = 0; j < rowSet.size(); ++j) {
                    Object[] oldData = ((Row)rowSet.getKey(j)).getData();
                    Object[] newData = (Object[])rowSet.get(j);
                    switch (td.triggerType) {
                        case 5: {
                            if (sqlTrigger) break;
                            oldData = (Object[])ArrayUtil.duplicateArray(oldData);
                            newData = (Object[])ArrayUtil.duplicateArray(newData);
                        }
                    }
                    td.pushPair(session, oldData, newData);
                }
                continue;
            }
            td.pushPair(session, null, null);
        }
    }

    void fireTriggers(Session session, int trigVecIndex, RowSetNavigator rowSet) {
        if (!this.database.isReferentialIntegrity()) {
            return;
        }
        for (TriggerDef td : this.triggerLists[trigVecIndex]) {
            boolean sqlTrigger = td instanceof TriggerDefSQL;
            if (td.hasOldTable()) {
                // empty if block
            }
            if (td.isForEachRow()) {
                while (rowSet.hasNext()) {
                    Object[] oldData = null;
                    Object[] newData = null;
                    switch (td.triggerType) {
                        case 4: 
                        case 7: {
                            oldData = rowSet.getNext();
                            if (sqlTrigger) break;
                            oldData = (Object[])ArrayUtil.duplicateArray(oldData);
                            break;
                        }
                        case 3: 
                        case 6: {
                            newData = rowSet.getNext();
                            if (sqlTrigger) break;
                            newData = (Object[])ArrayUtil.duplicateArray(newData);
                        }
                    }
                    td.pushPair(session, oldData, newData);
                }
                rowSet.beforeFirst();
                continue;
            }
            td.pushPair(session, null, null);
        }
    }

    void fireTriggers(Session session, int trigVecIndex, Object[] oldData, Object[] newData, int[] cols) {
        if (!this.database.isReferentialIntegrity()) {
            return;
        }
        for (TriggerDef td : this.triggerLists[trigVecIndex]) {
            boolean sqlTrigger = td instanceof TriggerDefSQL;
            if (cols != null && td.getUpdateColumnIndexes() != null && !ArrayUtil.haveCommonElement(td.getUpdateColumnIndexes(), cols, cols.length)) continue;
            if (td.isForEachRow()) {
                switch (td.triggerType) {
                    case 6: {
                        break;
                    }
                    case 3: {
                        if (sqlTrigger) break;
                        newData = (Object[])ArrayUtil.duplicateArray(newData);
                        break;
                    }
                    case 5: {
                        if (sqlTrigger) break;
                        oldData = (Object[])ArrayUtil.duplicateArray(oldData);
                        newData = (Object[])ArrayUtil.duplicateArray(newData);
                        break;
                    }
                    case 4: 
                    case 7: 
                    case 8: {
                        if (sqlTrigger) break;
                        oldData = (Object[])ArrayUtil.duplicateArray(oldData);
                    }
                }
                td.pushPair(session, oldData, newData);
                continue;
            }
            td.pushPair(session, null, null);
        }
    }

    void enforceRowConstraints(Session session, Object[] data) {
        for (int i = 0; i < this.defaultColumnMap.length; ++i) {
            Type type = this.colTypes[i];
            data[i] = type.convertToTypeLimits(session, data[i]);
            if (type.isDomainType()) {
                Constraint[] constraints = type.userTypeModifier.getConstraints();
                for (int j = 0; j < constraints.length; ++j) {
                    constraints[j].checkCheckConstraint(session, this, data[i]);
                }
            }
            if (data[i] != null || !this.colNotNull[i]) continue;
            Constraint c = this.getNotNullConstraintForColumn(i);
            if (c == null) {
                c = this.getPrimaryConstraint();
            }
            Object[] info = new String[]{c.getName().name, this.tableName.name};
            throw Error.error(null, 10, 2, info);
        }
    }

    Index getIndexForColumns(int[] cols) {
        int i = this.bestIndexForColumn[cols[0]];
        if (i > -1) {
            return this.indexList[i];
        }
        switch (this.tableType) {
            case 0: 
            case 1: 
            case 2: 
            case 7: {
                Index index = this.createIndexForColumns(cols);
                return index;
            }
        }
        return null;
    }

    Index getIndexForColumns(OrderedIntHashSet set) {
        int maxMatchCount = 0;
        Index selected = null;
        if (set.isEmpty()) {
            return null;
        }
        int count = this.indexList.length;
        for (int i = 0; i < count; ++i) {
            Index currentindex = this.getIndex(i);
            int[] indexcols = currentindex.getColumns();
            int matchCount = set.getOrderedMatchCount(indexcols);
            if (matchCount == 0) continue;
            if (matchCount == indexcols.length) {
                return currentindex;
            }
            if (matchCount <= maxMatchCount) continue;
            maxMatchCount = matchCount;
            selected = currentindex;
        }
        if (selected != null) {
            return selected;
        }
        switch (this.tableType) {
            case 0: 
            case 1: 
            case 2: 
            case 7: {
                selected = this.createIndexForColumns(set.toArray());
            }
        }
        return selected;
    }

    public final int[] getIndexRootsArray() {
        PersistentStore store = this.database.persistentStoreCollection.getStore(this);
        int[] roots = new int[this.getIndexCount()];
        for (int i = 0; i < this.getIndexCount(); ++i) {
            CachedObject accessor = store.getAccessor(this.indexList[i]);
            roots[i] = accessor == null ? -1 : accessor.getPos();
        }
        return roots;
    }

    static String getIndexRoots(int[] rootsArray) {
        String roots = StringUtil.getList(rootsArray, " ", "");
        StringBuffer s = new StringBuffer(roots);
        return s.toString();
    }

    public void setIndexRoots(int[] roots) {
        if (!this.isCached) {
            throw Error.error(5501, this.tableName.name);
        }
        PersistentStore store = this.database.persistentStoreCollection.getStore(this);
        for (int i = 0; i < this.getIndexCount(); ++i) {
            store.setAccessor(this.indexList[i], roots[i]);
        }
    }

    void setIndexRoots(Session session, String s) {
        if (!this.isCached) {
            throw Error.error(5501, this.tableName.name);
        }
        ParserDQL p = new ParserDQL(session, new Scanner(s));
        int[] roots = new int[this.getIndexCount()];
        p.read();
        for (int i = 0; i < this.getIndexCount(); ++i) {
            int v;
            roots[i] = v = p.readInteger();
        }
        this.setIndexRoots(roots);
    }

    public void dropIndex(Session session, String indexname) {
        int todrop = this.getIndexIndex(indexname);
        this.indexList = (Index[])ArrayUtil.toAdjustedArray(this.indexList, null, todrop, -1);
        for (int i = 0; i < this.indexList.length; ++i) {
            this.indexList[i].setPosition(i);
        }
        this.setBestRowIdentifiers();
        if (this.store != null) {
            this.store.resetAccessorKeys(this.indexList);
        }
    }

    void moveData(Session session, Table from, int colindex, int adjust) {
        Object colvalue = null;
        ColumnSchema column = null;
        if (adjust >= 0 && colindex != -1) {
            column = this.getColumn(colindex);
            colvalue = column.getDefaultValue(session);
        }
        PersistentStore store = session.sessionData.getRowStore(this);
        try {
            RowIterator it = from.rowIterator(session);
            while (it.hasNext()) {
                Row row = it.getNextRow();
                Object[] o = row.getData();
                Object[] data = this.getEmptyRowData();
                if (adjust == 0 && colindex != -1) {
                    colvalue = column.getDataType().convertToType(session, o[colindex], from.getColumn(colindex).getDataType());
                }
                ArrayUtil.copyAdjustArray(o, data, colvalue, colindex, adjust);
                this.systemSetIdentityColumn(session, data);
                this.enforceRowConstraints(session, data);
                Row newrow = (Row)store.getNewCachedObject(null, data);
                if (row.rowAction != null) {
                    newrow.rowAction = row.rowAction.duplicate(newrow.getPos());
                }
                store.indexRow(null, newrow);
            }
        }
        catch (Throwable t) {
            store.release();
            if (t instanceof HsqlException) {
                throw (HsqlException)t;
            }
            throw new HsqlException(t, "", 0);
        }
    }

    void insertRow(Session session, PersistentStore store, Object[] data) {
        this.setIdentityColumn(session, data);
        this.fireTriggers(session, 6, null, data, null);
        this.setGeneratedColumns(session, data);
        if (this.isView) {
            return;
        }
        this.enforceRowConstraints(session, data);
        if (this.database.isReferentialIntegrity()) {
            int size = this.constraintList.length;
            for (int i = 0; i < size; ++i) {
                this.constraintList[i].checkInsert(session, this, data);
            }
        }
        this.insertNoCheck(session, store, data);
        this.fireTriggers(session, 3, null, data, null);
    }

    void insertIntoTable(Session session, Result result) {
        PersistentStore store = session.sessionData.getRowStore(this);
        RowSetNavigator nav = result.initialiseNavigator();
        while (nav.hasNext()) {
            Object[] data = nav.getNext();
            Object[] newData = (Object[])ArrayUtil.resizeArrayIfDifferent(data, this.getColumnCount());
            this.insertData(store, newData);
        }
    }

    private Row insertNoCheck(Session session, PersistentStore store, Object[] data) {
        Row row = (Row)store.getNewCachedObject(session, data);
        store.indexRow(session, row);
        session.addInsertAction(this, row);
        return row;
    }

    public void insertNoCheckFromLog(Session session, Object[] data) {
        this.systemUpdateIdentityValue(data);
        PersistentStore store = session.sessionData.getRowStore(this);
        Row row = (Row)store.getNewCachedObject(session, data);
        store.indexRow(session, row);
        session.addInsertAction(this, row);
    }

    public int insertSys(PersistentStore store, Result ins) {
        RowSetNavigator nav = ins.getNavigator();
        int count = 0;
        while (nav.hasNext()) {
            this.insertSys(store, nav.getNext());
            ++count;
        }
        return count;
    }

    void insertResult(PersistentStore store, Result ins) {
        RowSetNavigator nav = ins.initialiseNavigator();
        while (nav.hasNext()) {
            Object[] data = nav.getNext();
            Object[] newData = (Object[])ArrayUtil.resizeArrayIfDifferent(data, this.getColumnCount());
            this.insertData(store, newData);
        }
    }

    public void insertFromScript(PersistentStore store, Object[] data) {
        this.systemUpdateIdentityValue(data);
        this.insertData(store, data);
    }

    public void insertData(PersistentStore store, Object[] data) {
        Row row = (Row)store.getNewCachedObject(null, data);
        store.indexRow(null, row);
    }

    public void insertSys(PersistentStore store, Object[] data) {
        Row row = (Row)store.getNewCachedObject(null, data);
        store.indexRow(null, row);
    }

    protected void setIdentityColumn(Session session, Object[] data) {
        if (this.identityColumn != -1) {
            Number id = (Number)data[this.identityColumn];
            if (id == null) {
                id = (Number)this.identitySequence.getValueObject();
                data[this.identityColumn] = id;
            } else {
                this.identitySequence.userUpdate(id.longValue());
            }
            if (session != null) {
                session.setLastIdentity(id);
            }
        }
    }

    protected void setGeneratedColumns(Session session, Object[] data) {
        for (int i = 0; i < this.colGenerated.length; ++i) {
            if (!this.colGenerated[i]) continue;
            Expression e = this.getColumn(i).getGeneratingExpression();
            RangeVariable.RangeIteratorBase range = session.sessionContext.getCheckIterator(this.defaultRanges[0]);
            range.currentData = data;
            data[i] = e.getValue(session, this.colTypes[i]);
        }
    }

    protected void systemSetIdentityColumn(Session session, Object[] data) {
        if (this.identityColumn != -1) {
            Number id = (Number)data[this.identityColumn];
            if (id == null) {
                id = (Number)this.identitySequence.getValueObject();
                data[this.identityColumn] = id;
            } else {
                this.identitySequence.userUpdate(id.longValue());
            }
        }
    }

    protected void systemUpdateIdentityValue(Object[] data) {
        Number id;
        if (this.identityColumn != -1 && (id = (Number)data[this.identityColumn]) != null) {
            this.identitySequence.systemUpdate(id.longValue());
        }
    }

    void deleteRowAsTriggeredAction(Session session, Row row) {
        this.deleteNoCheck(session, row);
    }

    void deleteNoRefCheck(Session session, Row row) {
        Object[] data = row.getData();
        this.fireTriggers(session, 7, data, null, null);
        if (this.isView) {
            return;
        }
        this.deleteNoCheck(session, row);
    }

    private void deleteNoCheck(Session session, Row row) {
        if (row.isDeleted(session)) {
            return;
        }
        session.addDeleteAction(this, row);
    }

    public void deleteNoCheckFromLog(Session session, Object[] data) {
        Row row = null;
        PersistentStore store = session.sessionData.getRowStore(this);
        if (this.hasPrimaryKey()) {
            RowIterator it = this.getPrimaryIndex().findFirstRow(session, store, data, this.primaryKeyColsSequence);
            row = it.getNextRow();
        } else if (this.bestIndex == null) {
            RowIterator it = this.rowIterator(session);
            while ((row = it.getNextRow()) != null && IndexAVL.compareRows(session, row.getData(), data, this.defaultColumnMap, this.colTypes) != 0) {
            }
        } else {
            RowIterator it = this.bestIndex.findFirstRow(session, store, data);
            while ((row = it.getNextRow()) != null) {
                Object[] rowdata = row.getData();
                if (this.bestIndex.compareRowNonUnique(session, data, this.bestIndex.getColumns(), rowdata) != 0) {
                    row = null;
                    break;
                }
                if (IndexAVL.compareRows(session, rowdata, data, this.defaultColumnMap, this.colTypes) != 0) continue;
                break;
            }
        }
        if (row == null) {
            return;
        }
        this.deleteNoCheck(session, row);
    }

    void updateRowSet(Session session, HashMappedList rowSet, int[] cols, boolean isTriggeredSet) {
        Row row;
        int i;
        PersistentStore store = session.sessionData.getRowStore(this);
        for (i = 0; i < rowSet.size(); ++i) {
            row = (Row)rowSet.getKey(i);
            if (!row.isDeleted(session)) continue;
            if (isTriggeredSet) {
                rowSet.remove(i);
                --i;
                continue;
            }
            throw Error.error(3900);
        }
        for (i = 0; i < rowSet.size(); ++i) {
            row = (Row)rowSet.getKey(i);
            Object[] data = (Object[])rowSet.get(i);
            this.checkRowData(session, data, cols);
            this.deleteNoCheck(session, row);
        }
        for (i = 0; i < rowSet.size(); ++i) {
            Object[] data = (Object[])rowSet.get(i);
            this.insertNoCheck(session, store, data);
        }
    }

    void addLobUsageCount(Session session, Object[] data) {
        if (!this.hasLobColumn) {
            return;
        }
        for (int j = 0; j < this.columnCount; ++j) {
            Object value;
            if (!this.colTypes[j].isLobType() || (value = data[j]) == null) continue;
            session.sessionData.addLobUsageCount(((LobData)value).getId());
        }
    }

    void removeLobUsageCount(Session session, Object[] data) {
        if (!this.hasLobColumn) {
            return;
        }
        for (int j = 0; j < this.columnCount; ++j) {
            Object value;
            if (!this.colTypes[j].isLobType() || (value = data[j]) == null) continue;
            session.sessionData.removeUsageCount(((LobData)value).getId());
        }
    }

    void checkRowData(Session session, Object[] data, int[] cols) {
        this.enforceRowConstraints(session, data);
        for (int i = 0; i < this.checkConstraints.length; ++i) {
            this.checkConstraints[i].checkCheckConstraint(session, this, data);
        }
    }

    @Override
    public void clearAllData(Session session) {
        super.clearAllData(session);
        if (this.identitySequence != null) {
            this.identitySequence.reset();
        }
    }

    @Override
    public void clearAllData(PersistentStore store) {
        super.clearAllData(store);
        if (this.identitySequence != null) {
            this.identitySequence.reset();
        }
    }
}

